DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}frmt_form_entry ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}frmt_form_entry (
  `entry_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) NOT NULL,
  `draft_id` varchar(12) DEFAULT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `entry_is_spam` (`is_spam`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}frmt_form_entry DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}frmt_form_entry ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes VALUES (1,'Reduced rate','reduced-rate');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes VALUES (2,'Zero rate','zero-rate');
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_tax_rate_classes ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_product_lookup ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_product_lookup (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_product_lookup DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_product_lookup ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}comments ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}comments (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}comments DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}comments ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_api_keys ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_api_keys (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_api_keys DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_api_keys ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}fusion_forms ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}fusion_forms (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT 0,
  `submissions_count` bigint(20) DEFAULT 0,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}fusion_forms DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}fusion_forms ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_tax_rates ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_tax_rates (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_tax_rates DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_tax_rates ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}fusion_form_submissions ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}fusion_form_submissions (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `ip` varchar(512) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) NOT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}fusion_form_submissions DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}fusion_form_submissions ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_orders ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_orders (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_orders DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_orders ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=204302 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (202246,67424,'action created','2025-05-22 04:24:05','2025-05-21 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (202245,67098,'action complete via WP Cron','2025-05-22 04:24:05','2025-05-21 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (202244,67098,'action started via WP Cron','2025-05-22 04:24:05','2025-05-21 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204130,68052,'action created','2025-05-24 06:00:37','2025-05-23 23:00:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204129,68049,'action complete via Async Request','2025-05-24 06:00:37','2025-05-23 23:00:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (203407,67811,'action created','2025-05-23 09:54:05','2025-05-23 02:54:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183970,61332,'action created','2025-05-03 02:24:05','2025-05-02 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183969,61014,'action complete via WP Cron','2025-05-03 02:24:05','2025-05-02 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183968,61014,'action started via WP Cron','2025-05-03 02:24:05','2025-05-02 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (187846,62624,'action created','2025-05-07 02:45:07','2025-05-06 19:45:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (187845,62301,'action complete via WP Cron','2025-05-07 02:45:07','2025-05-06 19:45:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (187844,62301,'action started via WP Cron','2025-05-07 02:45:07','2025-05-06 19:45:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (189699,62941,'action complete via WP Cron','2025-05-09 02:54:05','2025-05-08 19:54:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (189700,63242,'action created','2025-05-09 02:54:05','2025-05-08 19:54:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (189698,62941,'action started via WP Cron','2025-05-09 02:54:05','2025-05-08 19:54:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (195439,65155,'action created','2025-05-15 03:45:09','2025-05-14 20:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (195438,64848,'action complete via WP Cron','2025-05-15 03:45:09','2025-05-14 20:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (195437,64848,'action started via WP Cron','2025-05-15 03:45:09','2025-05-14 20:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (191629,63885,'action created','2025-05-11 03:15:08','2025-05-10 20:15:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (182047,60691,'action created','2025-05-01 02:24:05','2025-04-30 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (182046,60374,'action complete via WP Cron','2025-05-01 02:24:05','2025-04-30 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (182045,60374,'action started via WP Cron','2025-05-01 02:24:05','2025-04-30 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (191628,63565,'action complete via WP Cron','2025-05-11 03:15:08','2025-05-10 20:15:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (191627,63565,'action started via WP Cron','2025-05-11 03:15:08','2025-05-10 20:15:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (177229,59085,'action created','2025-04-26 02:15:09','2025-04-25 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (177228,58762,'action complete via WP Cron','2025-04-26 02:15:09','2025-04-25 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201553,67193,'action complete via WP Cron','2025-05-21 11:25:26','2025-05-21 04:25:26');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (197392,65806,'action created','2025-05-17 03:54:07','2025-05-16 20:54:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (197391,65483,'action complete via WP Cron','2025-05-17 03:54:07','2025-05-16 20:54:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (197390,65483,'action started via WP Cron','2025-05-17 03:54:07','2025-05-16 20:54:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201552,67193,'action started via WP Cron','2025-05-21 11:24:05','2025-05-21 04:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201551,67193,'action created','2025-05-21 11:15:12','2025-05-21 04:15:12');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (199321,66449,'action created','2025-05-19 04:15:09','2025-05-18 21:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (199320,66129,'action complete via WP Cron','2025-05-19 04:15:09','2025-05-18 21:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (199319,66129,'action started via WP Cron','2025-05-19 04:15:09','2025-05-18 21:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (177227,58762,'action started via WP Cron','2025-04-26 02:15:09','2025-04-25 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (193552,64526,'action created','2025-05-13 03:24:05','2025-05-12 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (193551,64205,'action complete via WP Cron','2025-05-13 03:24:05','2025-05-12 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (184930,61652,'action created','2025-05-04 02:24:05','2025-05-03 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (184929,61332,'action complete via WP Cron','2025-05-04 02:24:05','2025-05-03 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (184928,61332,'action started via WP Cron','2025-05-04 02:24:05','2025-05-03 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (193550,64205,'action started via WP Cron','2025-05-13 03:24:05','2025-05-12 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186694,62237,'action complete via Async Request','2025-05-05 21:32:09','2025-05-05 14:32:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186693,62237,'action started via Async Request','2025-05-05 21:32:09','2025-05-05 14:32:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186692,62236,'action complete via Async Request','2025-05-05 21:32:09','2025-05-05 14:32:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (179146,59724,'action created','2025-04-28 02:15:10','2025-04-27 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (179145,59406,'action complete via WP Cron','2025-04-28 02:15:10','2025-04-27 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (179144,59406,'action started via WP Cron','2025-04-28 02:15:10','2025-04-27 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186691,62236,'action started via Async Request','2025-05-05 21:32:09','2025-05-05 14:32:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186877,62301,'action created','2025-05-06 02:24:09','2025-05-05 19:24:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186876,61979,'action complete via WP Cron','2025-05-06 02:24:09','2025-05-05 19:24:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (176260,58762,'action created','2025-04-25 02:15:09','2025-04-24 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (176259,58444,'action complete via WP Cron','2025-04-25 02:15:09','2025-04-24 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (176258,58444,'action started via WP Cron','2025-04-25 02:15:09','2025-04-24 19:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186875,61979,'action started via WP Cron','2025-05-06 02:24:09','2025-05-05 19:24:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204128,68049,'action started via Async Request','2025-05-24 06:00:37','2025-05-23 23:00:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204127,68051,'action created','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201268,67098,'action created','2025-05-21 04:24:05','2025-05-20 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201267,66777,'action complete via WP Cron','2025-05-21 04:24:05','2025-05-20 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (194518,64848,'action created','2025-05-14 03:24:05','2025-05-13 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (201266,66777,'action started via WP Cron','2025-05-21 04:24:05','2025-05-20 21:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (174334,58120,'action created','2025-04-23 01:54:03','2025-04-22 18:54:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204126,68048,'action complete via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (194517,64526,'action complete via WP Cron','2025-05-14 03:24:05','2025-05-13 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (194516,64526,'action started via WP Cron','2025-05-14 03:24:05','2025-05-13 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204125,68048,'action started via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204124,68050,'action created','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (190669,63565,'action created','2025-05-10 02:54:10','2025-05-09 19:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (190668,63242,'action complete via WP Cron','2025-05-10 02:54:10','2025-05-09 19:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204123,68047,'action complete via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (190667,63242,'action started via WP Cron','2025-05-10 02:54:10','2025-05-09 19:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204122,68047,'action started via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204121,68049,'action created','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204120,68046,'action complete via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204119,68046,'action started via Async Request','2025-05-24 05:58:37','2025-05-23 22:58:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204118,68048,'action created','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (198361,66129,'action created','2025-05-18 03:54:09','2025-05-17 20:54:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204117,68045,'action complete via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (198360,65806,'action complete via WP Cron','2025-05-18 03:54:09','2025-05-17 20:54:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186681,62237,'action created','2025-05-05 21:32:04','2025-05-05 14:32:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (198359,65806,'action started via WP Cron','2025-05-18 03:54:09','2025-05-17 20:54:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204116,68045,'action started via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (186680,62236,'action created','2025-05-05 21:32:02','2025-05-05 14:32:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204115,68047,'action created','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204114,68044,'action complete via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204113,68044,'action started via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204112,68046,'action created','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204111,68043,'action complete via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (203194,67740,'action created','2025-05-23 04:45:09','2025-05-22 21:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (203193,67424,'action complete via WP Cron','2025-05-23 04:45:09','2025-05-22 21:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (185911,61979,'action created','2025-05-05 02:24:06','2025-05-04 19:24:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (185910,61652,'action complete via WP Cron','2025-05-05 02:24:06','2025-05-04 19:24:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (181096,60374,'action created','2025-04-30 02:24:05','2025-04-29 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (203192,67424,'action started via WP Cron','2025-05-23 04:45:09','2025-05-22 21:45:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (196423,65483,'action created','2025-05-16 03:54:04','2025-05-15 20:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (196422,65155,'action complete via WP Cron','2025-05-16 03:54:04','2025-05-15 20:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (181095,60052,'action complete via WP Cron','2025-04-30 02:24:05','2025-04-29 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (181094,60052,'action started via WP Cron','2025-04-30 02:24:05','2025-04-29 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183016,61014,'action created','2025-05-02 02:24:05','2025-05-01 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183015,60691,'action complete via WP Cron','2025-05-02 02:24:05','2025-05-01 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (183014,60691,'action started via WP Cron','2025-05-02 02:24:05','2025-05-01 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (196421,65155,'action started via WP Cron','2025-05-16 03:54:04','2025-05-15 20:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (178190,59085,'action started via WP Cron','2025-04-27 02:15:10','2025-04-26 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204110,68043,'action started via Async Request','2025-05-24 05:56:37','2025-05-23 22:56:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204109,68045,'action created','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (178192,59406,'action created','2025-04-27 02:15:10','2025-04-26 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (178191,59085,'action complete via WP Cron','2025-04-27 02:15:10','2025-04-26 19:15:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (175305,58120,'action complete via WP Cron','2025-04-24 01:54:10','2025-04-23 18:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (175306,58444,'action created','2025-04-24 01:54:10','2025-04-23 18:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (175304,58120,'action started via WP Cron','2025-04-24 01:54:10','2025-04-23 18:54:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (185909,61652,'action started via WP Cron','2025-05-05 02:24:06','2025-05-04 19:24:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204108,68042,'action complete via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (188797,62941,'action created','2025-05-08 02:45:11','2025-05-07 19:45:11');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (180130,60052,'action created','2025-04-29 02:24:05','2025-04-28 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (180129,59724,'action complete via WP Cron','2025-04-29 02:24:05','2025-04-28 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (180128,59724,'action started via WP Cron','2025-04-29 02:24:05','2025-04-28 19:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204107,68042,'action started via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204106,68044,'action created','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204105,68041,'action complete via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204104,68041,'action started via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204103,68043,'action created','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (188795,62624,'action started via WP Cron','2025-05-08 02:45:11','2025-05-07 19:45:11');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204102,68040,'action complete via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (188796,62624,'action complete via WP Cron','2025-05-08 02:45:11','2025-05-07 19:45:11');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204101,68040,'action started via WP Cron','2025-05-24 05:54:04','2025-05-23 22:54:04');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204100,68042,'action created','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (200305,66777,'action created','2025-05-20 04:15:14','2025-05-19 21:15:14');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (200304,66449,'action complete via WP Cron','2025-05-20 04:15:14','2025-05-19 21:15:14');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (200303,66449,'action started via WP Cron','2025-05-20 04:15:14','2025-05-19 21:15:14');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204099,68037,'action complete via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204098,68037,'action started via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204097,68041,'action created','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204096,68036,'action complete via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (192589,64205,'action created','2025-05-12 03:24:05','2025-05-11 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (192588,63885,'action complete via WP Cron','2025-05-12 03:24:05','2025-05-11 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (192587,63885,'action started via WP Cron','2025-05-12 03:24:05','2025-05-11 20:24:05');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204025,68017,'action created','2025-05-24 01:15:09','2025-05-23 18:15:09');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204095,68036,'action started via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204094,68040,'action created','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204093,68035,'action complete via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204076,68034,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204092,68035,'action started via Async Request','2025-05-24 05:52:56','2025-05-23 22:52:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204091,68039,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204079,68035,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204090,67740,'action complete via Async Request','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204089,67740,'action started via Async Request','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204082,68036,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204088,68038,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204087,68017,'action complete via Async Request','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204085,68037,'action created','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204086,68017,'action started via Async Request','2025-05-24 05:51:03','2025-05-23 22:51:03');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204131,68050,'action started via Async Request','2025-05-24 06:00:37','2025-05-23 23:00:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204132,68050,'action complete via Async Request','2025-05-24 06:00:37','2025-05-23 23:00:37');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204133,68053,'action created','2025-05-24 06:00:38','2025-05-23 23:00:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204134,68051,'action started via Async Request','2025-05-24 06:00:38','2025-05-23 23:00:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204135,68051,'action complete via Async Request','2025-05-24 06:00:38','2025-05-23 23:00:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204136,68054,'action created','2025-05-24 06:00:38','2025-05-23 23:00:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204137,68052,'action started via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204138,68052,'action complete via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204139,68055,'action created','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204140,68053,'action started via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204141,68053,'action complete via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204142,68056,'action created','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204143,68054,'action started via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204144,68054,'action complete via Async Request','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204145,68057,'action created','2025-05-24 06:02:39','2025-05-23 23:02:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204146,68055,'action started via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204147,68055,'action complete via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204148,68058,'action created','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204149,68056,'action started via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204150,68056,'action complete via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204151,68059,'action created','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204152,68057,'action started via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204153,68057,'action complete via Async Request','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204154,68060,'action created','2025-05-24 06:04:39','2025-05-23 23:04:39');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204155,68058,'action started via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204156,68058,'action complete via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204157,68061,'action created','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204158,68059,'action started via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204159,68059,'action complete via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204160,68062,'action created','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204161,68060,'action started via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204162,68060,'action complete via Async Request','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204163,68063,'action created','2025-05-24 06:06:44','2025-05-23 23:06:44');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204164,68061,'action started via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204165,68061,'action complete via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204166,68064,'action created','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204167,68062,'action started via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204168,68062,'action complete via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204169,68065,'action created','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204170,68063,'action started via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204171,68063,'action complete via Async Request','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204172,68066,'action created','2025-05-24 06:08:43','2025-05-23 23:08:43');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204173,68064,'action started via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204174,68064,'action complete via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204175,68067,'action created','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204176,68065,'action started via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204177,68065,'action complete via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204178,68068,'action created','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204179,68066,'action started via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204180,68066,'action complete via Async Request','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204181,68069,'action created','2025-05-24 06:10:45','2025-05-23 23:10:45');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204182,68070,'action created','2025-05-24 06:11:18','2025-05-23 23:11:18');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204183,68071,'action created','2025-05-24 06:11:23','2025-05-23 23:11:23');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204184,68072,'action created','2025-05-24 06:11:23','2025-05-23 23:11:23');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204185,68070,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204186,68070,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204187,68071,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204188,68071,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204189,68072,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204190,68072,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204191,68067,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204192,68067,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204193,68073,'action created','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204194,68068,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204195,68068,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204196,68074,'action created','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204197,68069,'action started via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204198,68069,'action complete via WP Cron','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204199,68075,'action created','2025-05-24 06:15:06','2025-05-23 23:15:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204200,68073,'action started via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204201,68073,'action complete via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204202,68076,'action created','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204203,68074,'action started via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204204,68074,'action complete via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204205,68077,'action created','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204206,68075,'action started via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204207,68075,'action complete via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204208,68078,'action created','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204209,68034,'action started via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204210,68034,'action complete via Async Request','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204211,68079,'action created','2025-05-24 06:54:30','2025-05-23 23:54:30');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204212,68076,'action started via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204213,68076,'action complete via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204214,68080,'action created','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204215,68077,'action started via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204216,68077,'action complete via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204217,68081,'action created','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204218,68078,'action started via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204219,68078,'action complete via Async Request','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204220,68082,'action created','2025-05-24 06:55:38','2025-05-23 23:55:38');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204221,68080,'action started via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204222,68080,'action complete via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204223,68083,'action created','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204224,68081,'action started via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204225,68081,'action complete via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204226,68084,'action created','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204227,68082,'action started via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204228,68082,'action complete via Async Request','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204229,68085,'action created','2025-05-24 06:56:41','2025-05-23 23:56:41');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204230,68083,'action started via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204231,68083,'action complete via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204232,68086,'action created','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204233,68084,'action started via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204234,68084,'action complete via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204235,68087,'action created','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204236,68085,'action started via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204237,68085,'action complete via Async Request','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204238,68088,'action created','2025-05-24 06:57:42','2025-05-23 23:57:42');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204239,68086,'action started via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204240,68086,'action complete via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204241,68089,'action created','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204242,68087,'action started via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204243,68087,'action complete via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204244,68090,'action created','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204245,68088,'action started via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204246,68088,'action complete via Async Request','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204247,68091,'action created','2025-05-24 07:04:06','2025-05-24 00:04:06');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204248,68089,'action started via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204249,68089,'action complete via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204250,68092,'action created','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204251,68090,'action started via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204252,68090,'action complete via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204253,68093,'action created','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204254,68091,'action started via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204255,68091,'action complete via Async Request','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204256,68094,'action created','2025-05-24 07:05:10','2025-05-24 00:05:10');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204257,68092,'action started via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204258,68092,'action complete via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204259,68095,'action created','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204260,68093,'action started via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204261,68093,'action complete via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204262,68096,'action created','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204263,68094,'action started via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204264,68094,'action complete via Async Request','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204265,68097,'action created','2025-05-24 07:06:56','2025-05-24 00:06:56');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204266,68095,'action started via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204267,68095,'action complete via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204268,68098,'action created','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204269,68096,'action started via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204270,68096,'action complete via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204271,68099,'action created','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204272,68097,'action started via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204273,68097,'action complete via Async Request','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204274,68100,'action created','2025-05-24 07:08:01','2025-05-24 00:08:01');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204275,68098,'action started via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204276,68098,'action complete via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204277,68101,'action created','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204278,68099,'action started via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204279,68099,'action complete via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204280,68102,'action created','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204281,68100,'action started via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204282,68100,'action complete via Async Request','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204283,68103,'action created','2025-05-24 07:09:02','2025-05-24 00:09:02');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204284,68101,'action started via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204285,68101,'action complete via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204286,68104,'action created','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204287,68102,'action started via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204288,68102,'action complete via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204289,68105,'action created','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204290,68103,'action started via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204291,68103,'action complete via Async Request','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204292,68106,'action created','2025-05-24 07:10:07','2025-05-24 00:10:07');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204293,68104,'action started via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204294,68104,'action complete via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204295,68107,'action created','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204296,68105,'action started via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204297,68105,'action complete via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204298,68108,'action created','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204299,68106,'action started via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204300,68106,'action complete via Async Request','2025-05-24 07:11:08','2025-05-24 00:11:08');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs VALUES (204301,68109,'action created','2025-05-24 07:11:08','2025-05-24 00:11:08');
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_logs ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}links ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}links (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}links DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}links ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_product_attributes_lookup ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_product_attributes_lookup (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_product_attributes_lookup DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_product_attributes_lookup ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_stats ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_stats (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_stats DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_stats ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_log ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_log (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_log DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_log ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_addresses ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_addresses (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_addresses DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_addresses ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}term_relationships ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}term_relationships (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}term_relationships DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}term_relationships VALUES (156,16,0);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}term_relationships VALUES (157,17,0);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}term_relationships VALUES (161,18,0);
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}term_relationships ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}frmt_form_entry_meta ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}frmt_form_entry_meta (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}frmt_form_entry_meta DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}frmt_form_entry_meta ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_methods ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_methods (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_methods DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_methods ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_coupon_lookup ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_order_coupon_lookup (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_coupon_lookup DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_order_coupon_lookup ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21275 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (1,1,'notify-refund-returns-page','Edit page','https://thrillrebels.com/wp-admin/post.php?post=9&action=edit','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21179,2,'wayflyer_bnpl_q4_2021','Level up with funding','https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21180,3,'wc_shipping_mobile_app_usps_q4_2021','Get WooCommerce Shipping','https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21181,4,'learn-more','Learn more','https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21182,5,'optimizing-the-checkout-flow','Learn more','https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21183,6,'qualitative-feedback-from-new-users','Share feedback','https://automattic.survey.fm/woopayments-new-user-feedback','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21184,7,'share-feedback','Share feedback','http://automattic.survey.fm/paypal-feedback','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21185,8,'get-started','Get started','https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21186,9,'update-wc-subscriptions-3-0-15','View latest version','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/&page=wc-addons&section=helper','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21187,10,'update-wc-core-5-4-0','How to update WooCommerce','https://docs.woocommerce.com/document/how-to-update-woocommerce/','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21188,13,'ppxo-pps-install-paypal-payments-1','View upgrade guide','https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21189,14,'ppxo-pps-install-paypal-payments-2','View upgrade guide','https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21190,15,'learn-more','Learn more','https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21192,16,'learn-more','Learn more','https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21194,17,'learn-more','Learn more','https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21196,18,'learn-more','Learn more','https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21198,19,'share-feedback','Share feedback','https://automattic.survey.fm/store-management','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21200,20,'woocommerce-core-paypal-march-2022-dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21199,20,'learn-more','Learn more','https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21201,21,'learn-more','Learn more','https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21203,22,'pinterest_03_2022_update','Update Instructions','https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21204,23,'store_setup_survey_survey_q2_2022_share_your_thoughts','Tell us how it’s going','https://automattic.survey.fm/store-setup-survey-2022','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21206,24,'needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21205,24,'needs-update-eway-payment-gateway-rin-action-button-2022-12-20','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21208,25,'updated-eway-payment-gateway-rin-dismiss-button-2022-12-20','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21207,25,'updated-eway-payment-gateway-rin-action-button-2022-12-20','See all updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21209,26,'share-navigation-survey-feedback','Share feedback','https://automattic.survey.fm/new-ecommerce-plan-navigation','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21211,27,'woopay-beta-merchantrecruitment-activate-learnmore-04MAY23','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21213,28,'woocommerce-wcpay-march-2023-update-needed-dismiss-button','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21212,28,'woocommerce-wcpay-march-2023-update-needed-button','See Blog Post','https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21214,29,'tap_to_pay_iphone_q2_2023_no_wcpay','Simplify my payments','https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21215,30,'extension-settings','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21218,31,'woopay-beta-merchantrecruitment-update-activate-04MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21219,32,'woopay-beta-existingmerchants-noaction-documentation-27APR23','Documentation','https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21220,33,'woopay-beta-existingmerchants-update-WCPay-27APR23','Update WooCommerce Payments','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21222,34,'woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21221,34,'woopay-beta-merchantrecruitment-short-activate-04MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21226,36,'woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21228,37,'woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21232,39,'woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2059,62,'learn-more','Learn more','https://woocommerce.com/payments/?utm_medium=product','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21234,40,'woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21238,42,'woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21237,42,'woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21240,43,'woocommerce-WCReturnsWarranty-June-2023-updated-needed','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21239,43,'woocommerce-WCReturnsWarranty-June-2023-updated-needed','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21242,44,'woocommerce-WCOPC-June-2023-updated-needed','Dismiss','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21241,44,'woocommerce-WCOPC-June-2023-updated-needed','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21244,45,'woocommerce-WCGC-July-2023-update-needed','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21243,45,'woocommerce-WCGC-July-2023-update-needed','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21245,46,'learn-more','Learn more','https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21247,47,'dismiss','Dismiss','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-admin','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21246,47,'plugin-list','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21248,48,'woocommerce-WCStripe-Aug-2023-update-needed','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php?','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21250,49,'dismiss','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21251,50,'dismiss','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21252,51,'avalara_q3-2023_noAvaTax','Automate my sales tax','https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21254,52,'dismiss','Dismiss','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21253,52,'woocommerce-usermeta-Sept2023-productvendors','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21255,53,'woocommerce-STRIPE-Oct-2023-update-needed','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21258,54,'amazon-mcf-support-button-2023-12-07','Request support','https://woocommerce.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21257,54,'amazon-mcf-review-button-2023-12-07','Leave a review','https://woocommerce.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21259,55,'view_docs','Learn about Deposit schedules','https://woocommerce.com/document/woopayments/deposits/deposit-schedule/?utm_source=inbox_note&utm_medium=product&utm_campaign=view_docs#available-funds','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2055,56,'stripe_securityupdate_q4_2024_click','Review and update','https://woocommerce.com/document/stripe/admin-experience/updated-requirements-for-stripe-plugin-mid-2024/?utm_source=inbox_note&utm_medium=product&utm_campaign=stripe_securityupdate_q4_2024_click','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2060,62,'get-started','Get started','http://thrillrebels.com/wp-admin/admin.php?page=wc-admin&action=setup-woocommerce-payments','actioned','','setup-woocommerce-payments','');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21230,38,'woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC','Learn More','https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (1891,60,'view-payment-gateways','Learn more','https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?utm_medium=product','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (1643,58,'add-first-product','Add a product','https://thrillrebels.com/wp-admin/admin.php?page=wc-admin&task=products','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (1644,59,'learn-more','Learn more','https://woocommerce.com/mobile/?utm_medium=product','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2056,61,'tracking-opt-in','Activate usage tracking','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2472,63,'paypal_cta_q3_2024_v2','Get PayPal Payments','https://woocommerce.com/products/woocommerce-paypal-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=paypal_cta_q3_2024_v2','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (4020,65,'Renewal_notification_emails_Woosubscriptions_button_Nov2024','Set up automatic subscription reminders','https://woocommerce.com/document/subscriptions/subscriptions-notifications/?utm_source=inbox_note&utm_medium=product&utm_campaign=Renewal_notification_emails_Woosubscriptions_button_Nov2024','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (4833,67,'paypal_promo_Q4_2024','Add PayPal today','https://woocommerce.com/products/woocommerce-paypal-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=paypal_promo_Q4_2024','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (2636,64,'mollie_q4_2024','Get paid with Mollie','https://woocommerce.com/products/mollie-payments-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=mollie_q4_2024','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (11493,75,'new-woo-brand-announcement-feb4-2025-button','Read the blog','https://woocommerce.com/posts/introducing-the-new-woo-brand/?utm_source=inbox_note&utm_medium=product&utm_campaign=new-woo-brand-announcement-feb4-2025-button','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21262,72,'woocommerce-analytics-order-attribution-promotions-december-2024-find-out-more','Find out more','https://wordpress.org/plugins/woocommerce-analytics','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (9787,73,'learn-more','Learn more','https://woocommerce.com/mobile/?utm_source=inbox&utm_medium=product','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21261,68,'sirt-woo-2024-11-xss-admin','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21260,68,'sirt-woo-2024-11-xss-admin','See available updates','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/update-core.php?','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (6932,69,'usps-mail-service-to-canada-suspended-dec-2024','Stay up to date','https://about.usps.com/newsroom/service-alerts/international/canada-suspension.htm','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (6195,70,'Announce-UPS-WCShipping-button-Dec2024','Ship with UPS on WooCommerce','https://woocommerce.com/ups-and-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=Announce-UPS-WCShipping-button-Dec2024','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (7184,71,'account-creation-after-checkout-button-dec2024','Enable it today','https://woocommerce.com/document/woocommerce-store-editing/customizing-order-confirmation-page/?utm_source=inbox_note&utm_medium=product&utm_campaign=account-creation-after-checkout-button-dec2024','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (12938,77,'stripe_stripetax_q1_2025_click','Automate my taxes with Stripe','https://woocommerce.com/products/stripe-tax/?utm_source=inbox_note&utm_medium=product&utm_campaign=stripe_stripetax_q1_2025_click','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (10977,74,'affirm_promo_Q1_2025','Save with Affirm','https://woocommerce.com/products/woocommerce-gateway-affirm/?utm_source=inbox_note&utm_medium=product&utm_campaign=affirm_promo_Q1_2025','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (12085,76,'paypal_bnpl_au_promo_Q1_2025_button','Enable “Pay in 4” now','https://woocommerce.com/document/woocommerce-paypal-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=paypal_bnpl_au_promo_Q1_2025_button#pay-later-tab','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (15594,80,'woo-marketplace-two-year-subscriptions-rin-2025-03-17','Browse the Marketplace','https://woocommerce.com/products/?utm_source=inbox_note&utm_medium=product&utm_campaign=woo-marketplace-two-year-subscriptions-rin-2025-03-17','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (18381,83,'WooCommerce-Stripe-Gateway-Update-April-2025','See available updates','https://thrillrebels.com/wp-admin/update-core.php?','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (18382,84,'WooCommerce-Stripe-Gateway-Update-Info-April-2025','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21274,66,'update-db_learn-more','Learn more about updates','https://woocommerce.com/document/how-to-update-woocommerce/','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (13617,78,'printful_promo_q1_2025','Get started for free','https://woocommerce.com/products/printful/?utm_source=inbox_note&utm_medium=product&utm_campaign=printful_promo_q1_2025','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (17852,85,'learn-more','Learn more','https://woocommerce.com/mobile/?utm_source=inbox&utm_medium=product','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21263,79,'paypal-braintree-sdk-depreciation-2025-02-20-button','Upgrade now','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/wp-admin/plugins.php','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (16799,81,'viva_wallet_migration_q1_2025_click','Get Viva.com Smart Checkout','https://woocommerce.com/it/products/viva-com-smart-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=viva_wallet_migration_q1_2025_click','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (18206,82,'stripe_nocapture_q2_2025_click','Update now','https://woocommerce.com/products/woocommerce-order-status-manager/?utm_source=inbox_note&utm_medium=product&utm_campaign=stripe_nocapture_q2_2025_click','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21264,87,'uk-vat-notice-button-2025-04-30','Learn more about this extension','https://wordpress.org/plugins/eu-vat-for-woocommerce/','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (20028,86,'klaviyo_q2_2025','Try Klaviyo today','https://woocommerce.com/products/klaviyo-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=klaviyo_q2_2025','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21266,89,'paypal_q2_2025','Activate messaging','https://woocommerce.com/products/woocommerce-paypal-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=paypal_q2_2025','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21265,88,'payson-retirement-2025','Explore alternative payment methods','https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?categoryIds=28680&collections=product&page=1&country=Sweden&utm_source=inbox_note&utm_medium=product&utm_campaign=payson-retirement-2025','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21210,27,'woopay-beta-merchantrecruitment-activate-04MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21217,31,'woopay-beta-merchantrecruitment-update-WCPay-04MAY23','Update WooCommerce Payments','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21223,35,'woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23','Update WooCommerce Payments','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21224,35,'woopay-beta-merchantrecruitment-short-update-activate-04MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21225,36,'woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA','Activate WooPay Test A','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21227,37,'woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB','Activate WooPay Test B','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21229,38,'woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC','Activate WooPay Test C','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21231,39,'woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD','Activate WooPay Test D','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21233,40,'woopay-beta-merchantrecruitment-short-activate-button-09MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21235,41,'woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23','Update WooCommerce Payments','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/plugins.php?plugin_status=all','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21236,41,'woopay-beta-merchantrecruitment-short-update-activate-09MAY23','Activate WooPay','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout','unactioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21273,66,'update-db_run','Update WooCommerce Database','{{SHIPPER_URL_WITH_SCHEME}}/wp-admin/?do_update_woocommerce=true&return_url={{SHIPPER_URL_WITH_SCHEME}}/wp-admin/admin.php?page=shipper-packages&start=true','unactioned','wc_db_update','wc_db_update','wc_db_update_nonce');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21191,15,'dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21193,16,'dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21195,17,'dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21197,18,'dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21202,21,'dismiss','Dismiss','','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21216,30,'dismiss','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21249,48,'dismiss','Dismiss','#','actioned','',NULL,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions VALUES (21256,53,'dismiss','Dismiss','#','actioned','',NULL,NULL);
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}wc_admin_note_actions ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=68110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (67098,'woocommerce_cleanup_draft_orders','complete','2025-05-22 04:24:05','2025-05-21 21:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-22 04:24:05','2025-05-21 21:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68052,'forminator_send_export','complete','2025-05-24 06:01:37','2025-05-23 23:01:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:02:39','2025-05-23 23:02:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (65155,'woocommerce_cleanup_draft_orders','complete','2025-05-16 03:45:09','2025-05-15 20:45:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-16 03:54:04','2025-05-15 20:54:04',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (63565,'woocommerce_cleanup_draft_orders','complete','2025-05-11 02:54:10','2025-05-10 19:54:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-11 03:15:08','2025-05-10 20:15:08',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (63242,'woocommerce_cleanup_draft_orders','complete','2025-05-10 02:54:05','2025-05-09 19:54:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-10 02:54:10','2025-05-09 19:54:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (63885,'woocommerce_cleanup_draft_orders','complete','2025-05-12 03:15:08','2025-05-11 20:15:08',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-12 03:24:05','2025-05-11 20:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (58762,'woocommerce_cleanup_draft_orders','complete','2025-04-26 02:15:09','2025-04-25 19:15:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-26 02:15:09','2025-04-25 19:15:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68051,'forminator_process_report','complete','2025-05-24 05:59:37','2025-05-23 22:59:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:00:38','2025-05-23 23:00:38',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68050,'forminator_process_report','complete','2025-05-24 05:59:37','2025-05-23 22:59:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:00:37','2025-05-23 23:00:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68049,'forminator_send_export','complete','2025-05-24 05:59:37','2025-05-23 22:59:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:00:37','2025-05-23 23:00:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (58120,'woocommerce_cleanup_draft_orders','complete','2025-04-24 01:54:03','2025-04-23 18:54:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-24 01:54:10','2025-04-23 18:54:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (60374,'woocommerce_cleanup_draft_orders','complete','2025-05-01 02:24:05','2025-04-30 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-01 02:24:05','2025-04-30 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (59406,'woocommerce_cleanup_draft_orders','complete','2025-04-28 02:15:10','2025-04-27 19:15:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-28 02:15:10','2025-04-27 19:15:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (59085,'woocommerce_cleanup_draft_orders','complete','2025-04-27 02:15:09','2025-04-26 19:15:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-27 02:15:10','2025-04-26 19:15:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (60052,'woocommerce_cleanup_draft_orders','complete','2025-04-30 02:24:05','2025-04-29 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-30 02:24:05','2025-04-29 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (61332,'woocommerce_cleanup_draft_orders','complete','2025-05-04 02:24:05','2025-05-03 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-04 02:24:05','2025-05-03 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (60691,'woocommerce_cleanup_draft_orders','complete','2025-05-02 02:24:05','2025-05-01 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-02 02:24:05','2025-05-01 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (67193,'defender/async_scan','complete','2025-05-21 11:15:12','2025-05-21 11:15:12',10,'{\"type\":\"report\"}','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',5,1,'2025-05-21 11:25:26','2025-05-21 04:25:26',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68058,'forminator_send_export','complete','2025-05-24 06:05:39','2025-05-23 23:05:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:06:44','2025-05-23 23:06:44',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68048,'forminator_process_report','complete','2025-05-24 05:57:37','2025-05-23 22:57:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:58:37','2025-05-23 22:58:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68047,'forminator_process_report','complete','2025-05-24 05:57:37','2025-05-23 22:57:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:58:37','2025-05-23 22:58:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68046,'forminator_send_export','complete','2025-05-24 05:57:37','2025-05-23 22:57:37',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:58:37','2025-05-23 22:58:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (67811,'forminator_daily_cron','pending','2025-05-24 09:54:05','2025-05-24 02:54:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (67740,'woocommerce_cleanup_draft_orders','complete','2025-05-24 04:45:09','2025-05-23 21:45:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-24 05:51:03','2025-05-23 22:51:03',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (62941,'woocommerce_cleanup_draft_orders','complete','2025-05-09 02:45:11','2025-05-08 19:45:11',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-09 02:54:05','2025-05-08 19:54:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (62236,'fetch_patterns','complete','2025-05-05 21:32:02','2025-05-05 14:32:02',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-05 21:32:09','2025-05-05 14:32:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (64526,'woocommerce_cleanup_draft_orders','complete','2025-05-14 03:24:05','2025-05-13 20:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-14 03:24:05','2025-05-13 20:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (64848,'woocommerce_cleanup_draft_orders','complete','2025-05-15 03:24:05','2025-05-14 20:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-15 03:45:09','2025-05-14 20:45:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (64205,'woocommerce_cleanup_draft_orders','complete','2025-05-13 03:24:05','2025-05-12 20:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-13 03:24:05','2025-05-12 20:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (66449,'woocommerce_cleanup_draft_orders','complete','2025-05-20 04:15:09','2025-05-19 21:15:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-20 04:15:14','2025-05-19 21:15:14',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (65806,'woocommerce_cleanup_draft_orders','complete','2025-05-18 03:54:07','2025-05-17 20:54:07',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-18 03:54:09','2025-05-17 20:54:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (66129,'woocommerce_cleanup_draft_orders','complete','2025-05-19 03:54:09','2025-05-18 20:54:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-19 04:15:09','2025-05-18 21:15:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68056,'forminator_process_report','complete','2025-05-24 06:03:39','2025-05-23 23:03:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:04:39','2025-05-23 23:04:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68053,'forminator_process_report','complete','2025-05-24 06:01:38','2025-05-23 23:01:38',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:02:39','2025-05-23 23:02:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68054,'forminator_process_report','complete','2025-05-24 06:01:38','2025-05-23 23:01:38',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:02:39','2025-05-23 23:02:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68055,'forminator_send_export','complete','2025-05-24 06:03:39','2025-05-23 23:03:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:04:39','2025-05-23 23:04:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (67424,'woocommerce_cleanup_draft_orders','complete','2025-05-23 04:24:05','2025-05-22 21:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-23 04:45:09','2025-05-22 21:45:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (66777,'woocommerce_cleanup_draft_orders','complete','2025-05-21 04:15:14','2025-05-20 21:15:14',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-21 04:24:05','2025-05-20 21:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68057,'forminator_process_report','complete','2025-05-24 06:03:39','2025-05-23 23:03:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:04:39','2025-05-23 23:04:39',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68045,'forminator_process_report','complete','2025-05-24 05:55:04','2025-05-23 22:55:04',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:56:37','2025-05-23 22:56:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (58444,'woocommerce_cleanup_draft_orders','complete','2025-04-25 01:54:10','2025-04-24 18:54:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-25 02:15:09','2025-04-24 19:15:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (59724,'woocommerce_cleanup_draft_orders','complete','2025-04-29 02:15:10','2025-04-28 19:15:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-04-29 02:24:05','2025-04-28 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (61014,'woocommerce_cleanup_draft_orders','complete','2025-05-03 02:24:05','2025-05-02 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-03 02:24:05','2025-05-02 19:24:05',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (61652,'woocommerce_cleanup_draft_orders','complete','2025-05-05 02:24:05','2025-05-04 19:24:05',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-05 02:24:06','2025-05-04 19:24:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (61979,'woocommerce_cleanup_draft_orders','complete','2025-05-06 02:24:06','2025-05-05 19:24:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-06 02:24:09','2025-05-05 19:24:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (62624,'woocommerce_cleanup_draft_orders','complete','2025-05-08 02:45:07','2025-05-07 19:45:07',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-08 02:45:11','2025-05-07 19:45:11',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (62237,'woocommerce_run_on_woocommerce_admin_updated','complete','2025-05-05 21:32:04','2025-05-05 14:32:04',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',1,1,'2025-05-05 21:32:09','2025-05-05 14:32:09',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (62301,'woocommerce_cleanup_draft_orders','complete','2025-05-07 02:24:09','2025-05-06 19:24:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-07 02:45:07','2025-05-06 19:45:07',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68017,'forminator_action_scheduler_cleanup','complete','2025-05-24 03:15:09','2025-05-23 20:15:09',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:51:03','2025-05-23 22:51:03',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68039,'woocommerce_cleanup_draft_orders','pending','2025-05-25 05:51:03','2025-05-24 22:51:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68040,'forminator_send_export','complete','2025-05-24 05:53:56','2025-05-23 22:53:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:54:04','2025-05-23 22:54:04',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68041,'forminator_process_report','complete','2025-05-24 05:53:56','2025-05-23 22:53:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:54:04','2025-05-23 22:54:04',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68042,'forminator_process_report','complete','2025-05-24 05:53:56','2025-05-23 22:53:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:54:04','2025-05-23 22:54:04',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68043,'forminator_send_export','complete','2025-05-24 05:55:04','2025-05-23 22:55:04',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:56:37','2025-05-23 22:56:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68044,'forminator_process_report','complete','2025-05-24 05:55:04','2025-05-23 22:55:04',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:56:37','2025-05-23 22:56:37',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (65483,'woocommerce_cleanup_draft_orders','complete','2025-05-17 03:54:04','2025-05-16 20:54:04',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-17 03:54:07','2025-05-16 20:54:07',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68034,'forminator_general_data_protection_cleanup','complete','2025-05-24 06:51:03','2025-05-23 23:51:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:54:30','2025-05-23 23:54:30',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68035,'forminator_send_export','complete','2025-05-24 05:52:03','2025-05-23 22:52:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:52:56','2025-05-23 22:52:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68036,'forminator_process_report','complete','2025-05-24 05:52:03','2025-05-23 22:52:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:52:56','2025-05-23 22:52:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68037,'forminator_process_report','complete','2025-05-24 05:52:03','2025-05-23 22:52:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 05:52:56','2025-05-23 22:52:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68038,'forminator_action_scheduler_cleanup','pending','2025-05-24 07:51:03','2025-05-24 00:51:03',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68059,'forminator_process_report','complete','2025-05-24 06:05:39','2025-05-23 23:05:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:06:44','2025-05-23 23:06:44',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68060,'forminator_process_report','complete','2025-05-24 06:05:39','2025-05-23 23:05:39',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:06:44','2025-05-23 23:06:44',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68064,'forminator_send_export','complete','2025-05-24 06:09:43','2025-05-23 23:09:43',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:10:45','2025-05-23 23:10:45',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68061,'forminator_send_export','complete','2025-05-24 06:07:44','2025-05-23 23:07:44',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:08:43','2025-05-23 23:08:43',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68062,'forminator_process_report','complete','2025-05-24 06:07:44','2025-05-23 23:07:44',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:08:43','2025-05-23 23:08:43',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68063,'forminator_process_report','complete','2025-05-24 06:07:44','2025-05-23 23:07:44',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:08:43','2025-05-23 23:08:43',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68065,'forminator_process_report','complete','2025-05-24 06:09:43','2025-05-23 23:09:43',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:10:45','2025-05-23 23:10:45',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68066,'forminator_process_report','complete','2025-05-24 06:09:43','2025-05-23 23:09:43',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:10:45','2025-05-23 23:10:45',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68067,'forminator_send_export','complete','2025-05-24 06:11:45','2025-05-23 23:11:45',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68068,'forminator_process_report','complete','2025-05-24 06:11:45','2025-05-23 23:11:45',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68070,'fetch_patterns','complete','2025-05-24 06:11:18','2025-05-23 23:11:18',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',3,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68069,'forminator_process_report','complete','2025-05-24 06:11:45','2025-05-23 23:11:45',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68071,'woocommerce_run_on_woocommerce_admin_updated','complete','2025-05-24 06:11:23','2025-05-23 23:11:23',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',1,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68072,'woocommerce_run_on_woocommerce_admin_updated','complete','2025-05-24 06:11:23','2025-05-23 23:11:23',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',1,1,'2025-05-24 06:15:06','2025-05-23 23:15:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68073,'forminator_send_export','complete','2025-05-24 06:16:06','2025-05-23 23:16:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:54:30','2025-05-23 23:54:30',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68074,'forminator_process_report','complete','2025-05-24 06:16:06','2025-05-23 23:16:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:54:30','2025-05-23 23:54:30',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68075,'forminator_process_report','complete','2025-05-24 06:16:06','2025-05-23 23:16:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:54:30','2025-05-23 23:54:30',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68080,'forminator_send_export','complete','2025-05-24 06:56:38','2025-05-23 23:56:38',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:56:41','2025-05-23 23:56:41',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68076,'forminator_send_export','complete','2025-05-24 06:55:30','2025-05-23 23:55:30',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:55:38','2025-05-23 23:55:38',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68077,'forminator_process_report','complete','2025-05-24 06:55:30','2025-05-23 23:55:30',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:55:38','2025-05-23 23:55:38',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68078,'forminator_process_report','complete','2025-05-24 06:55:30','2025-05-23 23:55:30',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:55:38','2025-05-23 23:55:38',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68079,'forminator_general_data_protection_cleanup','pending','2025-05-24 07:54:30','2025-05-24 00:54:30',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68081,'forminator_process_report','complete','2025-05-24 06:56:38','2025-05-23 23:56:38',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:56:41','2025-05-23 23:56:41',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68082,'forminator_process_report','complete','2025-05-24 06:56:38','2025-05-23 23:56:38',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:56:41','2025-05-23 23:56:41',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68086,'forminator_send_export','complete','2025-05-24 06:58:42','2025-05-23 23:58:42',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:04:06','2025-05-24 00:04:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68083,'forminator_send_export','complete','2025-05-24 06:57:41','2025-05-23 23:57:41',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:57:42','2025-05-23 23:57:42',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68084,'forminator_process_report','complete','2025-05-24 06:57:41','2025-05-23 23:57:41',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:57:42','2025-05-23 23:57:42',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68085,'forminator_process_report','complete','2025-05-24 06:57:41','2025-05-23 23:57:41',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 06:57:42','2025-05-23 23:57:42',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68087,'forminator_process_report','complete','2025-05-24 06:58:42','2025-05-23 23:58:42',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:04:06','2025-05-24 00:04:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68088,'forminator_process_report','complete','2025-05-24 06:58:42','2025-05-23 23:58:42',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:04:06','2025-05-24 00:04:06',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68092,'forminator_send_export','complete','2025-05-24 07:06:10','2025-05-24 00:06:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:06:56','2025-05-24 00:06:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68089,'forminator_send_export','complete','2025-05-24 07:05:06','2025-05-24 00:05:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:05:10','2025-05-24 00:05:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68090,'forminator_process_report','complete','2025-05-24 07:05:06','2025-05-24 00:05:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:05:10','2025-05-24 00:05:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68091,'forminator_process_report','complete','2025-05-24 07:05:06','2025-05-24 00:05:06',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:05:10','2025-05-24 00:05:10',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68093,'forminator_process_report','complete','2025-05-24 07:06:10','2025-05-24 00:06:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:06:56','2025-05-24 00:06:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68094,'forminator_process_report','complete','2025-05-24 07:06:10','2025-05-24 00:06:10',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:06:56','2025-05-24 00:06:56',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68098,'forminator_send_export','complete','2025-05-24 07:09:01','2025-05-24 00:09:01',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:09:02','2025-05-24 00:09:02',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68095,'forminator_send_export','complete','2025-05-24 07:07:56','2025-05-24 00:07:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:08:01','2025-05-24 00:08:01',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68096,'forminator_process_report','complete','2025-05-24 07:07:56','2025-05-24 00:07:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:08:01','2025-05-24 00:08:01',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68097,'forminator_process_report','complete','2025-05-24 07:07:56','2025-05-24 00:07:56',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:08:01','2025-05-24 00:08:01',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68099,'forminator_process_report','complete','2025-05-24 07:09:01','2025-05-24 00:09:01',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:09:02','2025-05-24 00:09:02',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68100,'forminator_process_report','complete','2025-05-24 07:09:01','2025-05-24 00:09:01',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:09:02','2025-05-24 00:09:02',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68104,'forminator_send_export','complete','2025-05-24 07:11:07','2025-05-24 00:11:07',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:11:08','2025-05-24 00:11:08',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68101,'forminator_send_export','complete','2025-05-24 07:10:02','2025-05-24 00:10:02',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:10:07','2025-05-24 00:10:07',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68102,'forminator_process_report','complete','2025-05-24 07:10:02','2025-05-24 00:10:02',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:10:07','2025-05-24 00:10:07',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68103,'forminator_process_report','complete','2025-05-24 07:10:02','2025-05-24 00:10:02',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:10:07','2025-05-24 00:10:07',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68105,'forminator_process_report','complete','2025-05-24 07:11:07','2025-05-24 00:11:07',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:11:08','2025-05-24 00:11:08',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68106,'forminator_process_report','complete','2025-05-24 07:11:07','2025-05-24 00:11:07',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,1,'2025-05-24 07:11:08','2025-05-24 00:11:08',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68107,'forminator_send_export','pending','2025-05-24 07:12:08','2025-05-24 00:12:08',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68108,'forminator_process_report','pending','2025-05-24 07:12:08','2025-05-24 00:12:08',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions VALUES (68109,'forminator_process_report','pending','2025-05-24 07:12:08','2025-05-24 00:12:08',10,'[]','{{SHIPPER_JSON_START}}{}{{SHIPPER_JSON_END}}',4,0,'0000-00-00 00:00:00','0000-00-00 00:00:00',0,NULL);
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_actions ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_attribute_taxonomies ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_attribute_taxonomies (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_attribute_taxonomies DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_attribute_taxonomies ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (1,'woocommerce-remote-inbox-engine');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (2,'action-scheduler-migration');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (3,'');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (4,'forminator');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (5,'defender');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups VALUES (6,'woocommerce-db-updates');
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}actionscheduler_groups ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_locations ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_locations (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_locations DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zone_locations ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_payment_tokenmeta ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_payment_tokenmeta (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_payment_tokenmeta DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_payment_tokenmeta ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zones ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zones (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zones DISABLE KEYS;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}woocommerce_shipping_zones ENABLE KEYS;

DROP TABLE IF EXISTS {{SHIPPER_TABLE_PREFIX}}options ;
CREATE TABLE IF NOT EXISTS {{SHIPPER_TABLE_PREFIX}}options (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=115817 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
ALTER TABLE {{SHIPPER_TABLE_PREFIX}}options DISABLE KEYS;
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (1,'cron','{{SHIPPER_JSON_START}}{\"1748066699\":{\"wphb_get_delay_js_exclusion\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748066714\":{\"wpdef_firewall_fetch_trusted_proxy_preset_ips\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"wpdef_log_rotational_delete\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"wpdef_fetch_global_ip_list\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748066724\":{\"firewall_clean_up_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748066725\":{\"hustle_general_data_protection_cleanup\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748066729\":{\"wpdef_firewall_send_compact_logs_to_api\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748066754\":{\"snapshot4_clean_log_files\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"snapshot4_add_empty_index\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748066888\":{\"audit_clean_up_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748066903\":{\"audit_sync_events\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748066938\":{\"snapshot_delete_old_user_action_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748067047\":{\"smush_check_for_conflicts\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":false,\"args\":[]}}},\"1748067364\":{\"action_scheduler_run_queue\":{\"0d04ed39571b55704c122d726248bbac\":{\"schedule\":\"every_minute\",\"args\":[\"WP Cron\"],\"interval\":60}}},\"1748068200\":{\"wdf_maybe_send_report\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"thirty_minutes\",\"args\":[],\"interval\":1800}}},\"1748069644\":{\"woocommerce_cancel_unpaid_orders\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":false,\"args\":[]}}},\"1748069826\":{\"wphb_minify_clear_files\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748070000\":{\"woocommerce_scheduled_sales\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748070031\":{\"wp_privacy_delete_old_export_files\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748070063\":{\"jetpack_clean_nonces\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748070064\":{\"wc_admin_process_orders_milestone\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748070076\":{\"wc_admin_unsnooze_admin_notes\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"hourly\",\"args\":[],\"interval\":3600}}},\"1748070302\":{\"wphb_clear_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748070315\":{\"wp_defender_clear_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748074350\":{\"woocommerce_marketplace_cron_fetch_promotions\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748082258\":{\"wpdef_firewall_whitelist_server_public_ip\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748100724\":{\"woocommerce_cleanup_sessions\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748109627\":{\"wp_update_themes\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748109631\":{\"wp_version_check\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}},\"wp_update_plugins\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748109671\":{\"wp_update_user_counts\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748109806\":{\"wpmudev_scheduled_jobs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"twicedaily\",\"args\":[],\"interval\":43200}}},\"1748122334\":{\"woocommerce_cleanup_personal_data\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"woocommerce_tracker_send_event\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748128137\":{\"wp_smush_daily_cron\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748131200\":{\"wdev_logger_clear_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748133124\":{\"woocommerce_cleanup_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"woocommerce_cleanup_rate_limits\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748152827\":{\"recovery_mode_clean_expired_keys\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748152863\":{\"jetpack_v2_heartbeat\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748152865\":{\"wc_admin_daily\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748152871\":{\"wp_scheduled_delete\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}},\"delete_expired_transients\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748152872\":{\"wp_scheduled_auto_draft_delete\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"daily\",\"args\":[],\"interval\":86400}}},\"1748412162\":{\"wp_delete_temp_updater_backups\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748412314\":{\"wpdef_clear_scan_logs\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748412324\":{\"wpdef_firewall_clean_up_lockout\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748412334\":{\"wpdef_firewall_clean_up_unlockout\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748412930\":{\"wpdef_smart_ip_detection_ping\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748476800\":{\"wpdef_update_geoip\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1748498427\":{\"wp_site_health_scheduled_check\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"weekly\",\"args\":[],\"interval\":604800}}},\"1749072784\":{\"woocommerce_geoip_updater\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"fifteendays\",\"args\":[],\"interval\":1296000}}},\"1750399514\":{\"wpdef_sec_key_gen\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"sixty_days\",\"args\":[],\"interval\":5184000}},\"wpdef_quarantine_delete_expired\":{\"40cd750bba9870f18aada2478b24840a\":{\"schedule\":\"thirty_days\",\"args\":[],\"interval\":2592000}}},\"version\":2}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (2,'siteurl','{{SHIPPER_URL_WITH_SCHEME}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (3,'home','{{SHIPPER_URL_WITH_SCHEME}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (4,'blogname','Thrill Rebels','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (5,'blogdescription','At Thrill Rebels, we celebrate the spirit of adventure in every individual. We believe in the adrenaline rush, the thrill of the unknown, and the joy of discovery. We&#039;re more than just a lifestyle brand; we&#039;re a community. This is space where passion meets purpose.','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (6,'users_can_register','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (7,'admin_email','hello@bryant.design','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (8,'start_of_week','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (9,'use_balanceTags','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (10,'use_smilies','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (11,'require_name_email','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (12,'comments_notify','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (13,'posts_per_rss','10','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (14,'rss_use_excerpt','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (15,'mailserver_url','mail.example.com','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (16,'mailserver_login','login@example.com','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (17,'mailserver_pass','password','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (18,'mailserver_port','110','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (19,'default_category','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (20,'default_comment_status','open','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (21,'default_ping_status','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (22,'default_pingback_flag','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (23,'posts_per_page','10','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (24,'date_format','F j, Y','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (25,'time_format','g:i a','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26,'links_updated_date_format','F j, Y g:i a','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (27,'comment_moderation','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (28,'moderation_notify','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (29,'permalink_structure','/%year%/%monthnum%/%day%/%postname%/','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (30,'rewrite_rules','{{SHIPPER_JSON_START}}{\"^wc-auth\\/v([1]{1})\\/(.*)?\":\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\",\"^wc\\/file\\/transient\\/?$\":\"index.php?wc-transient-file-name=\",\"^wc\\/file\\/transient\\/(.+)$\":\"index.php?wc-transient-file-name=$matches[1]\",\"^wc-api\\/v([1-3]{1})\\/?$\":\"index.php?wc-api-version=$matches[1]&wc-api-route=\\/\",\"^wc-api\\/v([1-3]{1})(.*)?\":\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\",\"shop\\/?$\":\"index.php?post_type=product\",\"shop\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=product&feed=$matches[1]\",\"shop\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=product&feed=$matches[1]\",\"shop\\/page\\/([0-9]{1,})\\/?$\":\"index.php?post_type=product&paged=$matches[1]\",\"^wp-json\\/?$\":\"index.php?rest_route=\\/\",\"^wp-json\\/(.*)?\":\"index.php?rest_route=\\/$matches[1]\",\"^index.php\\/wp-json\\/?$\":\"index.php?rest_route=\\/\",\"^index.php\\/wp-json\\/(.*)?\":\"index.php?rest_route=\\/$matches[1]\",\"^wp-sitemap\\\\.xml$\":\"index.php?sitemap=index\",\"^wp-sitemap\\\\.xsl$\":\"index.php?sitemap-stylesheet=sitemap\",\"^wp-sitemap-index\\\\.xsl$\":\"index.php?sitemap-stylesheet=index\",\"^wp-sitemap-([a-z]+?)-([a-z\\\\d_-]+?)-(\\\\d+?)\\\\.xml$\":\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\",\"^wp-sitemap-([a-z]+?)-(\\\\d+?)\\\\.xml$\":\"index.php?sitemap=$matches[1]&paged=$matches[2]\",\"portfolio-items\\/?$\":\"index.php?post_type=avada_portfolio\",\"portfolio-items\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=avada_portfolio&feed=$matches[1]\",\"portfolio-items\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=avada_portfolio&feed=$matches[1]\",\"portfolio-items\\/page\\/([0-9]{1,})\\/?$\":\"index.php?post_type=avada_portfolio&paged=$matches[1]\",\"faq-items\\/?$\":\"index.php?post_type=avada_faq\",\"faq-items\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=avada_faq&feed=$matches[1]\",\"faq-items\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_type=avada_faq&feed=$matches[1]\",\"faq-items\\/page\\/([0-9]{1,})\\/?$\":\"index.php?post_type=avada_faq&paged=$matches[1]\",\"^entries\\/([^\\/]+)\\/?\":\"index.php?entries=$matches[1]\",\"archives\\/(\\\\d+)(?:\\/(\\\\d+))?\\/entries\\/(\\\\d+)\\/?$\":\"index.php?p=$matches[1]&page=$matches[2]&entries=$matches[3]\",\"(.?.+?)(?:\\/([0-9]+))?\\/entries\\/(\\\\d+)\\/?$\":\"index.php?pagename=$matches[1]&page=$matches[2]&entries=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([^\\/]+)(?:\\/([0-9]+))?\\/entries\\/(\\\\d+)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&page=$matches[4]&entries=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)(?:\\/([0-9]+))?\\/entries\\/(\\\\d+)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]&entries=$matches[6]\",\"(.?.+?)\\/entries(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&entries=$matches[3]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_tb_layout\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&embed=true\",\"fusion_tb_layout\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&tb=1\",\"fusion_tb_layout\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\",\"fusion_tb_layout\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\",\"fusion_tb_layout\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_layout\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_layout\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&wdf-2fa=$matches[3]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_layout\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_layout\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_tb_layout\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_tb_section\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_tb_section=$matches[1]&embed=true\",\"fusion_tb_section\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?fusion_tb_section=$matches[1]&tb=1\",\"fusion_tb_section\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\",\"fusion_tb_section\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\",\"fusion_tb_section\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?fusion_tb_section=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_section\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?fusion_tb_section=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_section\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?fusion_tb_section=$matches[1]&wdf-2fa=$matches[3]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_section\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_tb_section\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_tb_section\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_tb_category\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\",\"fusion_tb_category\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\",\"fusion_tb_category\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_tb_category=$matches[1]&embed=true\",\"fusion_tb_category\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_tb_category=$matches[1]&paged=$matches[2]\",\"fusion_tb_category\\/([^\\/]+)\\/?$\":\"index.php?fusion_tb_category=$matches[1]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_form\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_form=$matches[1]&embed=true\",\"fusion_form\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?fusion_form=$matches[1]&tb=1\",\"fusion_form\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_form=$matches[1]&paged=$matches[2]\",\"fusion_form\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\",\"fusion_form\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?fusion_form=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_form\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?fusion_form=$matches[1]&wc-api=$matches[3]\",\"fusion_form\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?fusion_form=$matches[1]&wdf-2fa=$matches[3]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_form\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_form\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?fusion_form=$matches[1]&page=$matches[2]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_form\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"category\\/(.+?)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?category_name=$matches[1]&feed=$matches[2]\",\"category\\/(.+?)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?category_name=$matches[1]&feed=$matches[2]\",\"category\\/(.+?)\\/embed\\/?$\":\"index.php?category_name=$matches[1]&embed=true\",\"category\\/(.+?)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?category_name=$matches[1]&paged=$matches[2]\",\"category\\/(.+?)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?category_name=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"category\\/(.+?)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?category_name=$matches[1]&wc-api=$matches[3]\",\"category\\/(.+?)\\/?$\":\"index.php?category_name=$matches[1]\",\"tag\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?tag=$matches[1]&feed=$matches[2]\",\"tag\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?tag=$matches[1]&feed=$matches[2]\",\"tag\\/([^\\/]+)\\/embed\\/?$\":\"index.php?tag=$matches[1]&embed=true\",\"tag\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?tag=$matches[1]&paged=$matches[2]\",\"tag\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?tag=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"tag\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?tag=$matches[1]&wc-api=$matches[3]\",\"tag\\/([^\\/]+)\\/?$\":\"index.php?tag=$matches[1]\",\"type\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_format=$matches[1]&feed=$matches[2]\",\"type\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?post_format=$matches[1]&feed=$matches[2]\",\"type\\/([^\\/]+)\\/embed\\/?$\":\"index.php?post_format=$matches[1]&embed=true\",\"type\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?post_format=$matches[1]&paged=$matches[2]\",\"type\\/([^\\/]+)\\/?$\":\"index.php?post_format=$matches[1]\",\"brand\\/(.+?)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_brand=$matches[1]&feed=$matches[2]\",\"brand\\/(.+?)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_brand=$matches[1]&feed=$matches[2]\",\"brand\\/(.+?)\\/embed\\/?$\":\"index.php?product_brand=$matches[1]&embed=true\",\"brand\\/(.+?)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?product_brand=$matches[1]&paged=$matches[2]\",\"brand\\/(.+?)\\/?$\":\"index.php?product_brand=$matches[1]\",\"product-category\\/(.+?)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_cat=$matches[1]&feed=$matches[2]\",\"product-category\\/(.+?)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_cat=$matches[1]&feed=$matches[2]\",\"product-category\\/(.+?)\\/embed\\/?$\":\"index.php?product_cat=$matches[1]&embed=true\",\"product-category\\/(.+?)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?product_cat=$matches[1]&paged=$matches[2]\",\"product-category\\/(.+?)\\/?$\":\"index.php?product_cat=$matches[1]\",\"product-tag\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_tag=$matches[1]&feed=$matches[2]\",\"product-tag\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product_tag=$matches[1]&feed=$matches[2]\",\"product-tag\\/([^\\/]+)\\/embed\\/?$\":\"index.php?product_tag=$matches[1]&embed=true\",\"product-tag\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?product_tag=$matches[1]&paged=$matches[2]\",\"product-tag\\/([^\\/]+)\\/?$\":\"index.php?product_tag=$matches[1]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"product\\/([^\\/]+)\\/embed\\/?$\":\"index.php?product=$matches[1]&embed=true\",\"product\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?product=$matches[1]&tb=1\",\"product\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product=$matches[1]&feed=$matches[2]\",\"product\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?product=$matches[1]&feed=$matches[2]\",\"product\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?product=$matches[1]&paged=$matches[2]\",\"product\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?product=$matches[1]&cpage=$matches[2]\",\"product\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?product=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"product\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?product=$matches[1]&wc-api=$matches[3]\",\"product\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?product=$matches[1]&wdf-2fa=$matches[3]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"product\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"product\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?product=$matches[1]&page=$matches[2]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"product\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"product\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"portfolio-items\\/([^\\/]+)\\/embed\\/?$\":\"index.php?avada_portfolio=$matches[1]&embed=true\",\"portfolio-items\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?avada_portfolio=$matches[1]&tb=1\",\"portfolio-items\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\",\"portfolio-items\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\",\"portfolio-items\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?avada_portfolio=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"portfolio-items\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?avada_portfolio=$matches[1]&wc-api=$matches[3]\",\"portfolio-items\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?avada_portfolio=$matches[1]&wdf-2fa=$matches[3]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"portfolio-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"portfolio-items\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"portfolio-items\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"portfolio_category\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\",\"portfolio_category\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\",\"portfolio_category\\/([^\\/]+)\\/embed\\/?$\":\"index.php?portfolio_category=$matches[1]&embed=true\",\"portfolio_category\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\",\"portfolio_category\\/([^\\/]+)\\/?$\":\"index.php?portfolio_category=$matches[1]\",\"portfolio_skills\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\",\"portfolio_skills\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\",\"portfolio_skills\\/([^\\/]+)\\/embed\\/?$\":\"index.php?portfolio_skills=$matches[1]&embed=true\",\"portfolio_skills\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\",\"portfolio_skills\\/([^\\/]+)\\/?$\":\"index.php?portfolio_skills=$matches[1]\",\"portfolio_tags\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\",\"portfolio_tags\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\",\"portfolio_tags\\/([^\\/]+)\\/embed\\/?$\":\"index.php?portfolio_tags=$matches[1]&embed=true\",\"portfolio_tags\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\",\"portfolio_tags\\/([^\\/]+)\\/?$\":\"index.php?portfolio_tags=$matches[1]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"faq-items\\/([^\\/]+)\\/embed\\/?$\":\"index.php?avada_faq=$matches[1]&embed=true\",\"faq-items\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?avada_faq=$matches[1]&tb=1\",\"faq-items\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?avada_faq=$matches[1]&feed=$matches[2]\",\"faq-items\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?avada_faq=$matches[1]&feed=$matches[2]\",\"faq-items\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?avada_faq=$matches[1]&paged=$matches[2]\",\"faq-items\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\",\"faq-items\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?avada_faq=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"faq-items\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?avada_faq=$matches[1]&wc-api=$matches[3]\",\"faq-items\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?avada_faq=$matches[1]&wdf-2fa=$matches[3]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"faq-items\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"faq-items\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?avada_faq=$matches[1]&page=$matches[2]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"faq-items\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"faq_category\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?faq_category=$matches[1]&feed=$matches[2]\",\"faq_category\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?faq_category=$matches[1]&feed=$matches[2]\",\"faq_category\\/([^\\/]+)\\/embed\\/?$\":\"index.php?faq_category=$matches[1]&embed=true\",\"faq_category\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?faq_category=$matches[1]&paged=$matches[2]\",\"faq_category\\/([^\\/]+)\\/?$\":\"index.php?faq_category=$matches[1]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_template\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_template=$matches[1]&embed=true\",\"fusion_template\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?fusion_template=$matches[1]&tb=1\",\"fusion_template\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_template=$matches[1]&paged=$matches[2]\",\"fusion_template\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\",\"fusion_template\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?fusion_template=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_template\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?fusion_template=$matches[1]&wc-api=$matches[3]\",\"fusion_template\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?fusion_template=$matches[1]&wdf-2fa=$matches[3]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_template\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_template\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?fusion_template=$matches[1]&page=$matches[2]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_template\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"fusion_element\\/([^\\/]+)\\/embed\\/?$\":\"index.php?fusion_element=$matches[1]&embed=true\",\"fusion_element\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?fusion_element=$matches[1]&tb=1\",\"fusion_element\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?fusion_element=$matches[1]&paged=$matches[2]\",\"fusion_element\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\",\"fusion_element\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?fusion_element=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_element\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?fusion_element=$matches[1]&wc-api=$matches[3]\",\"fusion_element\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?fusion_element=$matches[1]&wdf-2fa=$matches[3]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_element\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"fusion_element\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?fusion_element=$matches[1]&page=$matches[2]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"fusion_element\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"element_category\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?element_category=$matches[1]&feed=$matches[2]\",\"element_category\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?element_category=$matches[1]&feed=$matches[2]\",\"element_category\\/([^\\/]+)\\/embed\\/?$\":\"index.php?element_category=$matches[1]&embed=true\",\"element_category\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?element_category=$matches[1]&paged=$matches[2]\",\"element_category\\/([^\\/]+)\\/?$\":\"index.php?element_category=$matches[1]\",\"template_category\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?template_category=$matches[1]&feed=$matches[2]\",\"template_category\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?template_category=$matches[1]&feed=$matches[2]\",\"template_category\\/([^\\/]+)\\/embed\\/?$\":\"index.php?template_category=$matches[1]&embed=true\",\"template_category\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?template_category=$matches[1]&paged=$matches[2]\",\"template_category\\/([^\\/]+)\\/?$\":\"index.php?template_category=$matches[1]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"slide\\/([^\\/]+)\\/embed\\/?$\":\"index.php?slide=$matches[1]&embed=true\",\"slide\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?slide=$matches[1]&tb=1\",\"slide\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?slide=$matches[1]&paged=$matches[2]\",\"slide\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?slide=$matches[1]&cpage=$matches[2]\",\"slide\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?slide=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"slide\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?slide=$matches[1]&wc-api=$matches[3]\",\"slide\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?slide=$matches[1]&wdf-2fa=$matches[3]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"slide\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"slide\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?slide=$matches[1]&page=$matches[2]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"slide\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"slide-page\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?slide-page=$matches[1]&feed=$matches[2]\",\"slide-page\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?slide-page=$matches[1]&feed=$matches[2]\",\"slide-page\\/([^\\/]+)\\/embed\\/?$\":\"index.php?slide-page=$matches[1]&embed=true\",\"slide-page\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?slide-page=$matches[1]&paged=$matches[2]\",\"slide-page\\/([^\\/]+)\\/?$\":\"index.php?slide-page=$matches[1]\",\"robots\\\\.txt$\":\"index.php?robots=1\",\"favicon\\\\.ico$\":\"index.php?favicon=1\",\"sitemap\\\\.xml\":\"index.php??sitemap=index\",\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\\\.php$\":\"index.php?feed=old\",\".*wp-app\\\\.php(\\/.*)?$\":\"index.php?error=403\",\".*wp-register.php$\":\"index.php?register=true\",\"feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?&feed=$matches[1]\",\"(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?&feed=$matches[1]\",\"embed\\/?$\":\"index.php?&embed=true\",\"page\\/?([0-9]{1,})\\/?$\":\"index.php?&paged=$matches[1]\",\"comment-page-([0-9]{1,})\\/?$\":\"index.php?&page_id=78&cpage=$matches[1]\",\"wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?&wc\\/file\\/transient=$matches[2]\",\"wc-api(\\/(.*))?\\/?$\":\"index.php?&wc-api=$matches[2]\",\"comments\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?&feed=$matches[1]&withcomments=1\",\"comments\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?&feed=$matches[1]&withcomments=1\",\"comments\\/embed\\/?$\":\"index.php?&embed=true\",\"comments\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?&wc\\/file\\/transient=$matches[2]\",\"comments\\/wc-api(\\/(.*))?\\/?$\":\"index.php?&wc-api=$matches[2]\",\"search\\/(.+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?s=$matches[1]&feed=$matches[2]\",\"search\\/(.+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?s=$matches[1]&feed=$matches[2]\",\"search\\/(.+)\\/embed\\/?$\":\"index.php?s=$matches[1]&embed=true\",\"search\\/(.+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?s=$matches[1]&paged=$matches[2]\",\"search\\/(.+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?s=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"search\\/(.+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?s=$matches[1]&wc-api=$matches[3]\",\"search\\/(.+)\\/?$\":\"index.php?s=$matches[1]\",\"author\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?author_name=$matches[1]&feed=$matches[2]\",\"author\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?author_name=$matches[1]&feed=$matches[2]\",\"author\\/([^\\/]+)\\/embed\\/?$\":\"index.php?author_name=$matches[1]&embed=true\",\"author\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?author_name=$matches[1]&paged=$matches[2]\",\"author\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?author_name=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"author\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?author_name=$matches[1]&wc-api=$matches[3]\",\"author\\/([^\\/]+)\\/?$\":\"index.php?author_name=$matches[1]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/embed\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc\\/file\\/transient=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/wc-api(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/embed\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\",\"([0-9]{4})\\/([0-9]{1,2})\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&wc\\/file\\/transient=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/wc-api(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]\",\"([0-9]{4})\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&feed=$matches[2]\",\"([0-9]{4})\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&feed=$matches[2]\",\"([0-9]{4})\\/embed\\/?$\":\"index.php?year=$matches[1]&embed=true\",\"([0-9]{4})\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&paged=$matches[2]\",\"([0-9]{4})\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"([0-9]{4})\\/wc-api(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&wc-api=$matches[3]\",\"([0-9]{4})\\/?$\":\"index.php?year=$matches[1]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/embed\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc\\/file\\/transient=$matches[6]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wdf-2fa=$matches[6]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/([^\\/]+)(?:\\/([0-9]+))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\"[0-9]{4}\\/[0-9]{1,2}\\/[0-9]{1,2}\\/[^\\/]+\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\",\"([0-9]{4})\\/([0-9]{1,2})\\/([0-9]{1,2})\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wdf-2fa=$matches[5]\",\"([0-9]{4})\\/([0-9]{1,2})\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\",\"([0-9]{4})\\/([0-9]{1,2})\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&monthnum=$matches[2]&wdf-2fa=$matches[4]\",\"([0-9]{4})\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?year=$matches[1]&cpage=$matches[2]\",\"([0-9]{4})\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?year=$matches[1]&wdf-2fa=$matches[3]\",\".?.+?\\/attachment\\/([^\\/]+)\\/?$\":\"index.php?attachment=$matches[1]\",\".?.+?\\/attachment\\/([^\\/]+)\\/trackback\\/?$\":\"index.php?attachment=$matches[1]&tb=1\",\".?.+?\\/attachment\\/([^\\/]+)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\".?.+?\\/attachment\\/([^\\/]+)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?attachment=$matches[1]&feed=$matches[2]\",\".?.+?\\/attachment\\/([^\\/]+)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?attachment=$matches[1]&cpage=$matches[2]\",\".?.+?\\/attachment\\/([^\\/]+)\\/embed\\/?$\":\"index.php?attachment=$matches[1]&embed=true\",\"(.?.+?)\\/embed\\/?$\":\"index.php?pagename=$matches[1]&embed=true\",\"(.?.+?)\\/trackback\\/?$\":\"index.php?pagename=$matches[1]&tb=1\",\"(.?.+?)\\/feed\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?pagename=$matches[1]&feed=$matches[2]\",\"(.?.+?)\\/(feed|rdf|rss|rss2|atom)\\/?$\":\"index.php?pagename=$matches[1]&feed=$matches[2]\",\"(.?.+?)\\/page\\/?([0-9]{1,})\\/?$\":\"index.php?pagename=$matches[1]&paged=$matches[2]\",\"(.?.+?)\\/comment-page-([0-9]{1,})\\/?$\":\"index.php?pagename=$matches[1]&cpage=$matches[2]\",\"(.?.+?)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&wc\\/file\\/transient=$matches[3]\",\"(.?.+?)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&wc-api=$matches[3]\",\"(.?.+?)\\/order-pay(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&order-pay=$matches[3]\",\"(.?.+?)\\/order-received(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&order-received=$matches[3]\",\"(.?.+?)\\/orders(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&orders=$matches[3]\",\"(.?.+?)\\/view-order(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&view-order=$matches[3]\",\"(.?.+?)\\/downloads(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&downloads=$matches[3]\",\"(.?.+?)\\/edit-account(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&edit-account=$matches[3]\",\"(.?.+?)\\/edit-address(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&edit-address=$matches[3]\",\"(.?.+?)\\/payment-methods(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\",\"(.?.+?)\\/lost-password(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&lost-password=$matches[3]\",\"(.?.+?)\\/customer-logout(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\",\"(.?.+?)\\/add-payment-method(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\",\"(.?.+?)\\/delete-payment-method(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\",\"(.?.+?)\\/set-default-payment-method(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\",\"(.?.+?)\\/wdf-2fa(\\/(.*))?\\/?$\":\"index.php?pagename=$matches[1]&wdf-2fa=$matches[3]\",\".?.+?\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\".?.+?\\/attachment\\/([^\\/]+)\\/wc\\/file\\/transient(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc\\/file\\/transient=$matches[3]\",\".?.+?\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\".?.+?\\/attachment\\/([^\\/]+)\\/wc-api(\\/(.*))?\\/?$\":\"index.php?attachment=$matches[1]&wc-api=$matches[3]\",\"(.?.+?)(?:\\/([0-9]+))?\\/?$\":\"index.php?pagename=$matches[1]&page=$matches[2]\"}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (31,'hack_file','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (32,'blog_charset','UTF-8','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (33,'moderation_keys','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (34,'active_plugins','{{SHIPPER_JSON_START}}[\"classic-editor\\/classic-editor.php\",\"forminator-addons-geolocation\\/forminator-geolocation.php\",\"forminator-addons-pdf\\/forminator-addons-pdf.php\",\"forminator-stripe\\/forminator-stripe.php\",\"forminator\\/forminator.php\",\"fusion-builder\\/fusion-builder.php\",\"fusion-core\\/fusion-core.php\",\"gosmtp\\/gosmtp.php\",\"hustle\\/opt-in.php\",\"nginx-helper\\/nginx-helper.php\",\"shipper\\/shipper.php\",\"snapshot-backups\\/snapshot-backups.php\",\"svg-support\\/svg-support.php\",\"ultimate-branding\\/ultimate-branding.php\",\"woocommerce\\/woocommerce.php\",\"wp-defender\\/wp-defender.php\",\"wp-hummingbird\\/wp-hummingbird.php\",\"wp-smush-pro\\/wp-smush.php\",\"wpmudev-updates\\/update-notifications.php\"]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (35,'category_base','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (36,'ping_sites','http://rpc.pingomatic.com/','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (37,'comment_max_links','2','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (38,'gmt_offset','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (39,'default_email_category','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (40,'recently_edited','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (41,'template','Avada','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (42,'stylesheet','Avada-Child-Theme','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (43,'comment_registration','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44,'html_type','text/html','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (45,'use_trackback','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (46,'default_role','subscriber','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (47,'db_version','58975','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (48,'uploads_use_yearmonth_folders','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (49,'upload_path','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (50,'blog_public','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (51,'default_link_category','2','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (52,'show_on_front','page','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (53,'tag_base','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (54,'show_avatars','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (55,'avatar_rating','G','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (56,'upload_url_path','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (57,'thumbnail_size_w','150','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (58,'thumbnail_size_h','150','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (59,'thumbnail_crop','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (60,'medium_size_w','300','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (61,'medium_size_h','300','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (62,'avatar_default','mystery','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (63,'large_size_w','1024','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (64,'large_size_h','1024','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (65,'image_default_link_type','none','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (66,'image_default_size','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (67,'image_default_align','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (68,'close_comments_for_old_posts','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (69,'close_comments_days_old','14','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (70,'thread_comments','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (71,'thread_comments_depth','5','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (72,'page_comments','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (73,'comments_per_page','50','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (74,'default_comments_page','newest','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (75,'comment_order','asc','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (76,'sticky_posts','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (77,'widget_categories','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (78,'widget_text','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (79,'widget_rss','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (80,'uninstall_plugins','{{SHIPPER_JSON_START}}{\"wpmudev-updates\\/update-notifications.php\":[\"WPMUDEV_Dashboard\",\"uninstall_plugin\"],\"ultimate-branding\\/ultimate-branding.php\":\"branda_register_uninstall_hook\",\"shipper\\/shipper.php\":[\"Shipper_Controller_Setup_Uninstall\",\"uninstall\"]}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (81,'timezone_string','America/Los_Angeles','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (82,'page_for_posts','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (83,'page_on_front','78','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (84,'default_post_format','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (85,'link_manager_enabled','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (86,'finished_splitting_shared_terms','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (87,'site_icon','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (88,'medium_large_size_w','768','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (89,'medium_large_size_h','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (90,'wp_page_for_privacy_policy','3','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (91,'show_comments_cookies_opt_in','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (92,'admin_email_lifespan','1745215227','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (93,'disallowed_keys','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (94,'comment_previously_approved','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (95,'auto_plugin_theme_update_emails','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (96,'auto_update_core_dev','enabled','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (97,'auto_update_core_minor','enabled','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (98,'auto_update_core_major','enabled','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (99,'wp_force_deactivated_plugins','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (100,'wp_attachment_pages_enabled','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (101,'initial_db_version','57155','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (102,'{{SHIPPER_TABLE_PREFIX}}user_roles','{{SHIPPER_JSON_START}}{\"administrator\":{\"name\":\"Administrator\",\"capabilities\":{\"switch_themes\":true,\"edit_themes\":true,\"activate_plugins\":true,\"edit_plugins\":true,\"edit_users\":true,\"edit_files\":true,\"manage_options\":true,\"moderate_comments\":true,\"manage_categories\":true,\"manage_links\":true,\"upload_files\":true,\"import\":true,\"unfiltered_html\":true,\"edit_posts\":true,\"edit_others_posts\":true,\"edit_published_posts\":true,\"publish_posts\":true,\"edit_pages\":true,\"read\":true,\"level_10\":true,\"level_9\":true,\"level_8\":true,\"level_7\":true,\"level_6\":true,\"level_5\":true,\"level_4\":true,\"level_3\":true,\"level_2\":true,\"level_1\":true,\"level_0\":true,\"edit_others_pages\":true,\"edit_published_pages\":true,\"publish_pages\":true,\"delete_pages\":true,\"delete_others_pages\":true,\"delete_published_pages\":true,\"delete_posts\":true,\"delete_others_posts\":true,\"delete_published_posts\":true,\"delete_private_posts\":true,\"edit_private_posts\":true,\"read_private_posts\":true,\"delete_private_pages\":true,\"edit_private_pages\":true,\"read_private_pages\":true,\"delete_users\":true,\"create_users\":true,\"unfiltered_upload\":true,\"edit_dashboard\":true,\"update_plugins\":true,\"delete_plugins\":true,\"install_plugins\":true,\"update_themes\":true,\"install_themes\":true,\"update_core\":true,\"list_users\":true,\"remove_users\":true,\"promote_users\":true,\"edit_theme_options\":true,\"delete_themes\":true,\"export\":true,\"manage_woocommerce\":true,\"view_woocommerce_reports\":true,\"edit_product\":true,\"read_product\":true,\"delete_product\":true,\"edit_products\":true,\"edit_others_products\":true,\"publish_products\":true,\"read_private_products\":true,\"delete_products\":true,\"delete_private_products\":true,\"delete_published_products\":true,\"delete_others_products\":true,\"edit_private_products\":true,\"edit_published_products\":true,\"manage_product_terms\":true,\"edit_product_terms\":true,\"delete_product_terms\":true,\"assign_product_terms\":true,\"edit_shop_order\":true,\"read_shop_order\":true,\"delete_shop_order\":true,\"edit_shop_orders\":true,\"edit_others_shop_orders\":true,\"publish_shop_orders\":true,\"read_private_shop_orders\":true,\"delete_shop_orders\":true,\"delete_private_shop_orders\":true,\"delete_published_shop_orders\":true,\"delete_others_shop_orders\":true,\"edit_private_shop_orders\":true,\"edit_published_shop_orders\":true,\"manage_shop_order_terms\":true,\"edit_shop_order_terms\":true,\"delete_shop_order_terms\":true,\"assign_shop_order_terms\":true,\"edit_shop_coupon\":true,\"read_shop_coupon\":true,\"delete_shop_coupon\":true,\"edit_shop_coupons\":true,\"edit_others_shop_coupons\":true,\"publish_shop_coupons\":true,\"read_private_shop_coupons\":true,\"delete_shop_coupons\":true,\"delete_private_shop_coupons\":true,\"delete_published_shop_coupons\":true,\"delete_others_shop_coupons\":true,\"edit_private_shop_coupons\":true,\"edit_published_shop_coupons\":true,\"manage_shop_coupon_terms\":true,\"edit_shop_coupon_terms\":true,\"delete_shop_coupon_terms\":true,\"assign_shop_coupon_terms\":true,\"hustle_menu\":true,\"hustle_edit_module\":true,\"hustle_create\":true,\"hustle_edit_integrations\":true,\"hustle_access_emails\":true,\"hustle_edit_settings\":true,\"hustle_analytics\":true,\"manage_forminator\":true}},\"editor\":{\"name\":\"Editor\",\"capabilities\":{\"moderate_comments\":true,\"manage_categories\":true,\"manage_links\":true,\"upload_files\":true,\"unfiltered_html\":true,\"edit_posts\":true,\"edit_others_posts\":true,\"edit_published_posts\":true,\"publish_posts\":true,\"edit_pages\":true,\"read\":true,\"level_7\":true,\"level_6\":true,\"level_5\":true,\"level_4\":true,\"level_3\":true,\"level_2\":true,\"level_1\":true,\"level_0\":true,\"edit_others_pages\":true,\"edit_published_pages\":true,\"publish_pages\":true,\"delete_pages\":true,\"delete_others_pages\":true,\"delete_published_pages\":true,\"delete_posts\":true,\"delete_others_posts\":true,\"delete_published_posts\":true,\"delete_private_posts\":true,\"edit_private_posts\":true,\"read_private_posts\":true,\"delete_private_pages\":true,\"edit_private_pages\":true,\"read_private_pages\":true}},\"author\":{\"name\":\"Author\",\"capabilities\":{\"upload_files\":true,\"edit_posts\":true,\"edit_published_posts\":true,\"publish_posts\":true,\"read\":true,\"level_2\":true,\"level_1\":true,\"level_0\":true,\"delete_posts\":true,\"delete_published_posts\":true}},\"contributor\":{\"name\":\"Contributor\",\"capabilities\":{\"edit_posts\":true,\"read\":true,\"level_1\":true,\"level_0\":true,\"delete_posts\":true}},\"subscriber\":{\"name\":\"Subscriber\",\"capabilities\":{\"read\":true,\"level_0\":true}},\"customer\":{\"name\":\"Customer\",\"capabilities\":{\"read\":true}},\"shop_manager\":{\"name\":\"Shop manager\",\"capabilities\":{\"level_9\":true,\"level_8\":true,\"level_7\":true,\"level_6\":true,\"level_5\":true,\"level_4\":true,\"level_3\":true,\"level_2\":true,\"level_1\":true,\"level_0\":true,\"read\":true,\"read_private_pages\":true,\"read_private_posts\":true,\"edit_posts\":true,\"edit_pages\":true,\"edit_published_posts\":true,\"edit_published_pages\":true,\"edit_private_pages\":true,\"edit_private_posts\":true,\"edit_others_posts\":true,\"edit_others_pages\":true,\"publish_posts\":true,\"publish_pages\":true,\"delete_posts\":true,\"delete_pages\":true,\"delete_private_pages\":true,\"delete_private_posts\":true,\"delete_published_pages\":true,\"delete_published_posts\":true,\"delete_others_posts\":true,\"delete_others_pages\":true,\"manage_categories\":true,\"manage_links\":true,\"moderate_comments\":true,\"upload_files\":true,\"export\":true,\"import\":true,\"list_users\":true,\"edit_theme_options\":true,\"manage_woocommerce\":true,\"view_woocommerce_reports\":true,\"edit_product\":true,\"read_product\":true,\"delete_product\":true,\"edit_products\":true,\"edit_others_products\":true,\"publish_products\":true,\"read_private_products\":true,\"delete_products\":true,\"delete_private_products\":true,\"delete_published_products\":true,\"delete_others_products\":true,\"edit_private_products\":true,\"edit_published_products\":true,\"manage_product_terms\":true,\"edit_product_terms\":true,\"delete_product_terms\":true,\"assign_product_terms\":true,\"edit_shop_order\":true,\"read_shop_order\":true,\"delete_shop_order\":true,\"edit_shop_orders\":true,\"edit_others_shop_orders\":true,\"publish_shop_orders\":true,\"read_private_shop_orders\":true,\"delete_shop_orders\":true,\"delete_private_shop_orders\":true,\"delete_published_shop_orders\":true,\"delete_others_shop_orders\":true,\"edit_private_shop_orders\":true,\"edit_published_shop_orders\":true,\"manage_shop_order_terms\":true,\"edit_shop_order_terms\":true,\"delete_shop_order_terms\":true,\"assign_shop_order_terms\":true,\"edit_shop_coupon\":true,\"read_shop_coupon\":true,\"delete_shop_coupon\":true,\"edit_shop_coupons\":true,\"edit_others_shop_coupons\":true,\"publish_shop_coupons\":true,\"read_private_shop_coupons\":true,\"delete_shop_coupons\":true,\"delete_private_shop_coupons\":true,\"delete_published_shop_coupons\":true,\"delete_others_shop_coupons\":true,\"edit_private_shop_coupons\":true,\"edit_published_shop_coupons\":true,\"manage_shop_coupon_terms\":true,\"edit_shop_coupon_terms\":true,\"delete_shop_coupon_terms\":true,\"assign_shop_coupon_terms\":true}}}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (103,'fresh_site','0','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (104,'user_count','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (105,'widget_block','{{SHIPPER_JSON_START}}{\"2\":{\"content\":\"<!-- wp:search \\/-->\"},\"3\":{\"content\":\"<!-- wp:group --><div class=\\\"wp-block-group\\\"><!-- wp:heading --><h2>Recent Posts<\\/h2><!-- \\/wp:heading --><!-- wp:latest-posts \\/--><\\/div><!-- \\/wp:group -->\"},\"4\":{\"content\":\"<!-- wp:group --><div class=\\\"wp-block-group\\\"><!-- wp:heading --><h2>Recent Comments<\\/h2><!-- \\/wp:heading --><!-- wp:latest-comments {\\\"displayAvatar\\\":false,\\\"displayDate\\\":false,\\\"displayExcerpt\\\":false} \\/--><\\/div><!-- \\/wp:group -->\"},\"5\":{\"content\":\"<!-- wp:group --><div class=\\\"wp-block-group\\\"><!-- wp:heading --><h2>Archives<\\/h2><!-- \\/wp:heading --><!-- wp:archives \\/--><\\/div><!-- \\/wp:group -->\"},\"6\":{\"content\":\"<!-- wp:group --><div class=\\\"wp-block-group\\\"><!-- wp:heading --><h2>Categories<\\/h2><!-- \\/wp:heading --><!-- wp:categories \\/--><\\/div><!-- \\/wp:group -->\"},\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (106,'sidebars_widgets','{{SHIPPER_JSON_START}}{\"wp_inactive_widgets\":[],\"avada-blog-sidebar\":[\"block-2\",\"block-3\",\"block-4\"],\"avada-footer-widget-1\":[\"block-5\",\"block-6\"],\"avada-footer-widget-2\":[],\"avada-footer-widget-3\":[],\"avada-footer-widget-4\":[],\"avada-slidingbar-widget-1\":[],\"avada-slidingbar-widget-2\":[],\"avada-slidingbar-widget-3\":[],\"avada-slidingbar-widget-4\":[],\"array_version\":3}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (107,'widget_pages','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (108,'widget_calendar','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (109,'widget_archives','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (110,'widget_media_audio','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (111,'widget_media_image','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (112,'widget_media_gallery','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (113,'widget_media_video','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (114,'widget_meta','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115,'widget_search','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (116,'widget_recent-posts','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (117,'widget_recent-comments','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (118,'widget_tag_cloud','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (119,'widget_nav_menu','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (120,'widget_custom_html','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (121,'recovery_keys','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (122,'theme_mods_twentytwentyfour','{{SHIPPER_JSON_START}}{\"custom_css_post_id\":-1,\"sidebars_widgets\":{\"time\":1729665898,\"data\":{\"wp_inactive_widgets\":[],\"sidebar-1\":[\"block-2\",\"block-3\",\"block-4\"],\"sidebar-2\":[\"block-5\",\"block-6\"]}}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (123,'gosmtp_version','1.1.1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (124,'_transient_wp_core_block_css_files','{{SHIPPER_JSON_START}}{\"version\":\"6.6.2\",\"files\":[\"archives\\/editor-rtl.css\",\"archives\\/editor-rtl.min.css\",\"archives\\/editor.css\",\"archives\\/editor.min.css\",\"archives\\/style-rtl.css\",\"archives\\/style-rtl.min.css\",\"archives\\/style.css\",\"archives\\/style.min.css\",\"audio\\/editor-rtl.css\",\"audio\\/editor-rtl.min.css\",\"audio\\/editor.css\",\"audio\\/editor.min.css\",\"audio\\/style-rtl.css\",\"audio\\/style-rtl.min.css\",\"audio\\/style.css\",\"audio\\/style.min.css\",\"audio\\/theme-rtl.css\",\"audio\\/theme-rtl.min.css\",\"audio\\/theme.css\",\"audio\\/theme.min.css\",\"avatar\\/editor-rtl.css\",\"avatar\\/editor-rtl.min.css\",\"avatar\\/editor.css\",\"avatar\\/editor.min.css\",\"avatar\\/style-rtl.css\",\"avatar\\/style-rtl.min.css\",\"avatar\\/style.css\",\"avatar\\/style.min.css\",\"button\\/editor-rtl.css\",\"button\\/editor-rtl.min.css\",\"button\\/editor.css\",\"button\\/editor.min.css\",\"button\\/style-rtl.css\",\"button\\/style-rtl.min.css\",\"button\\/style.css\",\"button\\/style.min.css\",\"buttons\\/editor-rtl.css\",\"buttons\\/editor-rtl.min.css\",\"buttons\\/editor.css\",\"buttons\\/editor.min.css\",\"buttons\\/style-rtl.css\",\"buttons\\/style-rtl.min.css\",\"buttons\\/style.css\",\"buttons\\/style.min.css\",\"calendar\\/style-rtl.css\",\"calendar\\/style-rtl.min.css\",\"calendar\\/style.css\",\"calendar\\/style.min.css\",\"categories\\/editor-rtl.css\",\"categories\\/editor-rtl.min.css\",\"categories\\/editor.css\",\"categories\\/editor.min.css\",\"categories\\/style-rtl.css\",\"categories\\/style-rtl.min.css\",\"categories\\/style.css\",\"categories\\/style.min.css\",\"code\\/editor-rtl.css\",\"code\\/editor-rtl.min.css\",\"code\\/editor.css\",\"code\\/editor.min.css\",\"code\\/style-rtl.css\",\"code\\/style-rtl.min.css\",\"code\\/style.css\",\"code\\/style.min.css\",\"code\\/theme-rtl.css\",\"code\\/theme-rtl.min.css\",\"code\\/theme.css\",\"code\\/theme.min.css\",\"columns\\/editor-rtl.css\",\"columns\\/editor-rtl.min.css\",\"columns\\/editor.css\",\"columns\\/editor.min.css\",\"columns\\/style-rtl.css\",\"columns\\/style-rtl.min.css\",\"columns\\/style.css\",\"columns\\/style.min.css\",\"comment-content\\/style-rtl.css\",\"comment-content\\/style-rtl.min.css\",\"comment-content\\/style.css\",\"comment-content\\/style.min.css\",\"comment-template\\/style-rtl.css\",\"comment-template\\/style-rtl.min.css\",\"comment-template\\/style.css\",\"comment-template\\/style.min.css\",\"comments-pagination-numbers\\/editor-rtl.css\",\"comments-pagination-numbers\\/editor-rtl.min.css\",\"comments-pagination-numbers\\/editor.css\",\"comments-pagination-numbers\\/editor.min.css\",\"comments-pagination\\/editor-rtl.css\",\"comments-pagination\\/editor-rtl.min.css\",\"comments-pagination\\/editor.css\",\"comments-pagination\\/editor.min.css\",\"comments-pagination\\/style-rtl.css\",\"comments-pagination\\/style-rtl.min.css\",\"comments-pagination\\/style.css\",\"comments-pagination\\/style.min.css\",\"comments-title\\/editor-rtl.css\",\"comments-title\\/editor-rtl.min.css\",\"comments-title\\/editor.css\",\"comments-title\\/editor.min.css\",\"comments\\/editor-rtl.css\",\"comments\\/editor-rtl.min.css\",\"comments\\/editor.css\",\"comments\\/editor.min.css\",\"comments\\/style-rtl.css\",\"comments\\/style-rtl.min.css\",\"comments\\/style.css\",\"comments\\/style.min.css\",\"cover\\/editor-rtl.css\",\"cover\\/editor-rtl.min.css\",\"cover\\/editor.css\",\"cover\\/editor.min.css\",\"cover\\/style-rtl.css\",\"cover\\/style-rtl.min.css\",\"cover\\/style.css\",\"cover\\/style.min.css\",\"details\\/editor-rtl.css\",\"details\\/editor-rtl.min.css\",\"details\\/editor.css\",\"details\\/editor.min.css\",\"details\\/style-rtl.css\",\"details\\/style-rtl.min.css\",\"details\\/style.css\",\"details\\/style.min.css\",\"embed\\/editor-rtl.css\",\"embed\\/editor-rtl.min.css\",\"embed\\/editor.css\",\"embed\\/editor.min.css\",\"embed\\/style-rtl.css\",\"embed\\/style-rtl.min.css\",\"embed\\/style.css\",\"embed\\/style.min.css\",\"embed\\/theme-rtl.css\",\"embed\\/theme-rtl.min.css\",\"embed\\/theme.css\",\"embed\\/theme.min.css\",\"file\\/editor-rtl.css\",\"file\\/editor-rtl.min.css\",\"file\\/editor.css\",\"file\\/editor.min.css\",\"file\\/style-rtl.css\",\"file\\/style-rtl.min.css\",\"file\\/style.css\",\"file\\/style.min.css\",\"footnotes\\/style-rtl.css\",\"footnotes\\/style-rtl.min.css\",\"footnotes\\/style.css\",\"footnotes\\/style.min.css\",\"freeform\\/editor-rtl.css\",\"freeform\\/editor-rtl.min.css\",\"freeform\\/editor.css\",\"freeform\\/editor.min.css\",\"gallery\\/editor-rtl.css\",\"gallery\\/editor-rtl.min.css\",\"gallery\\/editor.css\",\"gallery\\/editor.min.css\",\"gallery\\/style-rtl.css\",\"gallery\\/style-rtl.min.css\",\"gallery\\/style.css\",\"gallery\\/style.min.css\",\"gallery\\/theme-rtl.css\",\"gallery\\/theme-rtl.min.css\",\"gallery\\/theme.css\",\"gallery\\/theme.min.css\",\"group\\/editor-rtl.css\",\"group\\/editor-rtl.min.css\",\"group\\/editor.css\",\"group\\/editor.min.css\",\"group\\/style-rtl.css\",\"group\\/style-rtl.min.css\",\"group\\/style.css\",\"group\\/style.min.css\",\"group\\/theme-rtl.css\",\"group\\/theme-rtl.min.css\",\"group\\/theme.css\",\"group\\/theme.min.css\",\"heading\\/style-rtl.css\",\"heading\\/style-rtl.min.css\",\"heading\\/style.css\",\"heading\\/style.min.css\",\"html\\/editor-rtl.css\",\"html\\/editor-rtl.min.css\",\"html\\/editor.css\",\"html\\/editor.min.css\",\"image\\/editor-rtl.css\",\"image\\/editor-rtl.min.css\",\"image\\/editor.css\",\"image\\/editor.min.css\",\"image\\/style-rtl.css\",\"image\\/style-rtl.min.css\",\"image\\/style.css\",\"image\\/style.min.css\",\"image\\/theme-rtl.css\",\"image\\/theme-rtl.min.css\",\"image\\/theme.css\",\"image\\/theme.min.css\",\"latest-comments\\/style-rtl.css\",\"latest-comments\\/style-rtl.min.css\",\"latest-comments\\/style.css\",\"latest-comments\\/style.min.css\",\"latest-posts\\/editor-rtl.css\",\"latest-posts\\/editor-rtl.min.css\",\"latest-posts\\/editor.css\",\"latest-posts\\/editor.min.css\",\"latest-posts\\/style-rtl.css\",\"latest-posts\\/style-rtl.min.css\",\"latest-posts\\/style.css\",\"latest-posts\\/style.min.css\",\"list\\/style-rtl.css\",\"list\\/style-rtl.min.css\",\"list\\/style.css\",\"list\\/style.min.css\",\"media-text\\/editor-rtl.css\",\"media-text\\/editor-rtl.min.css\",\"media-text\\/editor.css\",\"media-text\\/editor.min.css\",\"media-text\\/style-rtl.css\",\"media-text\\/style-rtl.min.css\",\"media-text\\/style.css\",\"media-text\\/style.min.css\",\"more\\/editor-rtl.css\",\"more\\/editor-rtl.min.css\",\"more\\/editor.css\",\"more\\/editor.min.css\",\"navigation-link\\/editor-rtl.css\",\"navigation-link\\/editor-rtl.min.css\",\"navigation-link\\/editor.css\",\"navigation-link\\/editor.min.css\",\"navigation-link\\/style-rtl.css\",\"navigation-link\\/style-rtl.min.css\",\"navigation-link\\/style.css\",\"navigation-link\\/style.min.css\",\"navigation-submenu\\/editor-rtl.css\",\"navigation-submenu\\/editor-rtl.min.css\",\"navigation-submenu\\/editor.css\",\"navigation-submenu\\/editor.min.css\",\"navigation\\/editor-rtl.css\",\"navigation\\/editor-rtl.min.css\",\"navigation\\/editor.css\",\"navigation\\/editor.min.css\",\"navigation\\/style-rtl.css\",\"navigation\\/style-rtl.min.css\",\"navigation\\/style.css\",\"navigation\\/style.min.css\",\"nextpage\\/editor-rtl.css\",\"nextpage\\/editor-rtl.min.css\",\"nextpage\\/editor.css\",\"nextpage\\/editor.min.css\",\"page-list\\/editor-rtl.css\",\"page-list\\/editor-rtl.min.css\",\"page-list\\/editor.css\",\"page-list\\/editor.min.css\",\"page-list\\/style-rtl.css\",\"page-list\\/style-rtl.min.css\",\"page-list\\/style.css\",\"page-list\\/style.min.css\",\"paragraph\\/editor-rtl.css\",\"paragraph\\/editor-rtl.min.css\",\"paragraph\\/editor.css\",\"paragraph\\/editor.min.css\",\"paragraph\\/style-rtl.css\",\"paragraph\\/style-rtl.min.css\",\"paragraph\\/style.css\",\"paragraph\\/style.min.css\",\"post-author\\/style-rtl.css\",\"post-author\\/style-rtl.min.css\",\"post-author\\/style.css\",\"post-author\\/style.min.css\",\"post-comments-form\\/editor-rtl.css\",\"post-comments-form\\/editor-rtl.min.css\",\"post-comments-form\\/editor.css\",\"post-comments-form\\/editor.min.css\",\"post-comments-form\\/style-rtl.css\",\"post-comments-form\\/style-rtl.min.css\",\"post-comments-form\\/style.css\",\"post-comments-form\\/style.min.css\",\"post-content\\/editor-rtl.css\",\"post-content\\/editor-rtl.min.css\",\"post-content\\/editor.css\",\"post-content\\/editor.min.css\",\"post-date\\/style-rtl.css\",\"post-date\\/style-rtl.min.css\",\"post-date\\/style.css\",\"post-date\\/style.min.css\",\"post-excerpt\\/editor-rtl.css\",\"post-excerpt\\/editor-rtl.min.css\",\"post-excerpt\\/editor.css\",\"post-excerpt\\/editor.min.css\",\"post-excerpt\\/style-rtl.css\",\"post-excerpt\\/style-rtl.min.css\",\"post-excerpt\\/style.css\",\"post-excerpt\\/style.min.css\",\"post-featured-image\\/editor-rtl.css\",\"post-featured-image\\/editor-rtl.min.css\",\"post-featured-image\\/editor.css\",\"post-featured-image\\/editor.min.css\",\"post-featured-image\\/style-rtl.css\",\"post-featured-image\\/style-rtl.min.css\",\"post-featured-image\\/style.css\",\"post-featured-image\\/style.min.css\",\"post-navigation-link\\/style-rtl.css\",\"post-navigation-link\\/style-rtl.min.css\",\"post-navigation-link\\/style.css\",\"post-navigation-link\\/style.min.css\",\"post-template\\/editor-rtl.css\",\"post-template\\/editor-rtl.min.css\",\"post-template\\/editor.css\",\"post-template\\/editor.min.css\",\"post-template\\/style-rtl.css\",\"post-template\\/style-rtl.min.css\",\"post-template\\/style.css\",\"post-template\\/style.min.css\",\"post-terms\\/style-rtl.css\",\"post-terms\\/style-rtl.min.css\",\"post-terms\\/style.css\",\"post-terms\\/style.min.css\",\"post-title\\/style-rtl.css\",\"post-title\\/style-rtl.min.css\",\"post-title\\/style.css\",\"post-title\\/style.min.css\",\"preformatted\\/style-rtl.css\",\"preformatted\\/style-rtl.min.css\",\"preformatted\\/style.css\",\"preformatted\\/style.min.css\",\"pullquote\\/editor-rtl.css\",\"pullquote\\/editor-rtl.min.css\",\"pullquote\\/editor.css\",\"pullquote\\/editor.min.css\",\"pullquote\\/style-rtl.css\",\"pullquote\\/style-rtl.min.css\",\"pullquote\\/style.css\",\"pullquote\\/style.min.css\",\"pullquote\\/theme-rtl.css\",\"pullquote\\/theme-rtl.min.css\",\"pullquote\\/theme.css\",\"pullquote\\/theme.min.css\",\"query-pagination-numbers\\/editor-rtl.css\",\"query-pagination-numbers\\/editor-rtl.min.css\",\"query-pagination-numbers\\/editor.css\",\"query-pagination-numbers\\/editor.min.css\",\"query-pagination\\/editor-rtl.css\",\"query-pagination\\/editor-rtl.min.css\",\"query-pagination\\/editor.css\",\"query-pagination\\/editor.min.css\",\"query-pagination\\/style-rtl.css\",\"query-pagination\\/style-rtl.min.css\",\"query-pagination\\/style.css\",\"query-pagination\\/style.min.css\",\"query-title\\/style-rtl.css\",\"query-title\\/style-rtl.min.css\",\"query-title\\/style.css\",\"query-title\\/style.min.css\",\"query\\/editor-rtl.css\",\"query\\/editor-rtl.min.css\",\"query\\/editor.css\",\"query\\/editor.min.css\",\"quote\\/style-rtl.css\",\"quote\\/style-rtl.min.css\",\"quote\\/style.css\",\"quote\\/style.min.css\",\"quote\\/theme-rtl.css\",\"quote\\/theme-rtl.min.css\",\"quote\\/theme.css\",\"quote\\/theme.min.css\",\"read-more\\/style-rtl.css\",\"read-more\\/style-rtl.min.css\",\"read-more\\/style.css\",\"read-more\\/style.min.css\",\"rss\\/editor-rtl.css\",\"rss\\/editor-rtl.min.css\",\"rss\\/editor.css\",\"rss\\/editor.min.css\",\"rss\\/style-rtl.css\",\"rss\\/style-rtl.min.css\",\"rss\\/style.css\",\"rss\\/style.min.css\",\"search\\/editor-rtl.css\",\"search\\/editor-rtl.min.css\",\"search\\/editor.css\",\"search\\/editor.min.css\",\"search\\/style-rtl.css\",\"search\\/style-rtl.min.css\",\"search\\/style.css\",\"search\\/style.min.css\",\"search\\/theme-rtl.css\",\"search\\/theme-rtl.min.css\",\"search\\/theme.css\",\"search\\/theme.min.css\",\"separator\\/editor-rtl.css\",\"separator\\/editor-rtl.min.css\",\"separator\\/editor.css\",\"separator\\/editor.min.css\",\"separator\\/style-rtl.css\",\"separator\\/style-rtl.min.css\",\"separator\\/style.css\",\"separator\\/style.min.css\",\"separator\\/theme-rtl.css\",\"separator\\/theme-rtl.min.css\",\"separator\\/theme.css\",\"separator\\/theme.min.css\",\"shortcode\\/editor-rtl.css\",\"shortcode\\/editor-rtl.min.css\",\"shortcode\\/editor.css\",\"shortcode\\/editor.min.css\",\"site-logo\\/editor-rtl.css\",\"site-logo\\/editor-rtl.min.css\",\"site-logo\\/editor.css\",\"site-logo\\/editor.min.css\",\"site-logo\\/style-rtl.css\",\"site-logo\\/style-rtl.min.css\",\"site-logo\\/style.css\",\"site-logo\\/style.min.css\",\"site-tagline\\/editor-rtl.css\",\"site-tagline\\/editor-rtl.min.css\",\"site-tagline\\/editor.css\",\"site-tagline\\/editor.min.css\",\"site-title\\/editor-rtl.css\",\"site-title\\/editor-rtl.min.css\",\"site-title\\/editor.css\",\"site-title\\/editor.min.css\",\"site-title\\/style-rtl.css\",\"site-title\\/style-rtl.min.css\",\"site-title\\/style.css\",\"site-title\\/style.min.css\",\"social-link\\/editor-rtl.css\",\"social-link\\/editor-rtl.min.css\",\"social-link\\/editor.css\",\"social-link\\/editor.min.css\",\"social-links\\/editor-rtl.css\",\"social-links\\/editor-rtl.min.css\",\"social-links\\/editor.css\",\"social-links\\/editor.min.css\",\"social-links\\/style-rtl.css\",\"social-links\\/style-rtl.min.css\",\"social-links\\/style.css\",\"social-links\\/style.min.css\",\"spacer\\/editor-rtl.css\",\"spacer\\/editor-rtl.min.css\",\"spacer\\/editor.css\",\"spacer\\/editor.min.css\",\"spacer\\/style-rtl.css\",\"spacer\\/style-rtl.min.css\",\"spacer\\/style.css\",\"spacer\\/style.min.css\",\"table\\/editor-rtl.css\",\"table\\/editor-rtl.min.css\",\"table\\/editor.css\",\"table\\/editor.min.css\",\"table\\/style-rtl.css\",\"table\\/style-rtl.min.css\",\"table\\/style.css\",\"table\\/style.min.css\",\"table\\/theme-rtl.css\",\"table\\/theme-rtl.min.css\",\"table\\/theme.css\",\"table\\/theme.min.css\",\"tag-cloud\\/style-rtl.css\",\"tag-cloud\\/style-rtl.min.css\",\"tag-cloud\\/style.css\",\"tag-cloud\\/style.min.css\",\"template-part\\/editor-rtl.css\",\"template-part\\/editor-rtl.min.css\",\"template-part\\/editor.css\",\"template-part\\/editor.min.css\",\"template-part\\/theme-rtl.css\",\"template-part\\/theme-rtl.min.css\",\"template-part\\/theme.css\",\"template-part\\/theme.min.css\",\"term-description\\/style-rtl.css\",\"term-description\\/style-rtl.min.css\",\"term-description\\/style.css\",\"term-description\\/style.min.css\",\"text-columns\\/editor-rtl.css\",\"text-columns\\/editor-rtl.min.css\",\"text-columns\\/editor.css\",\"text-columns\\/editor.min.css\",\"text-columns\\/style-rtl.css\",\"text-columns\\/style-rtl.min.css\",\"text-columns\\/style.css\",\"text-columns\\/style.min.css\",\"verse\\/style-rtl.css\",\"verse\\/style-rtl.min.css\",\"verse\\/style.css\",\"verse\\/style.min.css\",\"video\\/editor-rtl.css\",\"video\\/editor-rtl.min.css\",\"video\\/editor.css\",\"video\\/editor.min.css\",\"video\\/style-rtl.css\",\"video\\/style-rtl.min.css\",\"video\\/style.css\",\"video\\/style.min.css\",\"video\\/theme-rtl.css\",\"video\\/theme-rtl.min.css\",\"video\\/theme.css\",\"video\\/theme.min.css\"]}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115742,'_site_transient_timeout_theme_roots','1748071468','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115743,'_site_transient_theme_roots','{{SHIPPER_JSON_START}}{\"Avada-Child-Theme\":\"\\/themes\",\"Avada\":\"\\/themes\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (114309,'_site_transient_timeout_php_check_1ad0acda4da6c4fcb37046d1f090be2c','1748499314','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (2548,'_transient_health-check-site-status-result','{\"good\":20,\"recommended\":2,\"critical\":1}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (849,'_transient_timeout_avada_demos','1729752303','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (132,'rt_wp_nginx_helper_options','{{SHIPPER_JSON_START}}{\"log_level\":\"INFO\",\"log_filesize\":5,\"enable_purge\":1,\"enable_map\":0,\"enable_log\":0,\"enable_stamp\":0,\"purge_homepage_on_new\":1,\"purge_homepage_on_edit\":1,\"purge_homepage_on_del\":1,\"purge_archive_on_new\":1,\"purge_archive_on_edit\":1,\"purge_archive_on_del\":1,\"purge_archive_on_new_comment\":0,\"purge_archive_on_deleted_comment\":0,\"purge_page_on_mod\":1,\"purge_page_on_new_comment\":1,\"purge_page_on_deleted_comment\":1,\"purge_method\":\"get_request\"}{{SHIPPER_JSON_END}}','yes');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (138,'wc_blocks_version','11.8.0-dev','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (139,'woocommerce_maxmind_geolocation_settings','{{SHIPPER_JSON_START}}{\"database_prefix\":\"EDd4LAoy0fsuIzDVb5pAuWKX5AQFzRUZ\"}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (140,'_transient_woocommerce_webhook_ids_status_active','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (141,'widget_woocommerce_widget_cart','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (142,'widget_woocommerce_layered_nav_filters','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (143,'widget_woocommerce_layered_nav','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (144,'widget_woocommerce_price_filter','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (145,'widget_woocommerce_product_categories','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (146,'widget_woocommerce_product_search','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (147,'widget_woocommerce_product_tag_cloud','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (148,'widget_woocommerce_products','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (149,'widget_woocommerce_recently_viewed_products','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (150,'widget_woocommerce_top_rated_products','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (151,'widget_woocommerce_recent_reviews','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (152,'widget_woocommerce_rating_filter','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (153,'action_scheduler_hybrid_store_demarkation','4','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (154,'schema-ActionScheduler_StoreSchema','7.0.1729663264','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (155,'schema-ActionScheduler_LoggerSchema','3.0.1729663264','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (156,'woocommerce_admin_install_timestamp','1729663264','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (157,'woocommerce_permalinks','{{SHIPPER_JSON_START}}{\"product_base\":\"product\",\"category_base\":\"product-category\",\"tag_base\":\"product-tag\",\"attribute_base\":\"\",\"use_verbose_page_rules\":false}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (164,'woocommerce_schema_version','920','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (159,'current_theme_supports_woocommerce','yes','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (160,'woocommerce_queue_flush_rewrite_rules','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (295,'woocommerce_inbox_variant_assignment','7','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (296,'woocommerce_remote_variant_assignment','48','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (163,'woocommerce_newly_installed','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (165,'woocommerce_store_address','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (166,'woocommerce_store_address_2','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (167,'woocommerce_store_city','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (168,'woocommerce_default_country','US:CA','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (169,'woocommerce_store_postcode','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (170,'woocommerce_allowed_countries','all','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (171,'woocommerce_all_except_countries','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (172,'woocommerce_specific_allowed_countries','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (173,'woocommerce_ship_to_countries','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (174,'woocommerce_specific_ship_to_countries','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (175,'woocommerce_default_customer_address','base','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (176,'woocommerce_calc_taxes','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (177,'woocommerce_enable_coupons','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (178,'woocommerce_calc_discounts_sequentially','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (179,'woocommerce_currency','USD','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (180,'woocommerce_currency_pos','left','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (181,'woocommerce_price_thousand_sep',',','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (182,'woocommerce_price_decimal_sep','.','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (183,'woocommerce_price_num_decimals','2','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (184,'woocommerce_shop_page_id','5','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (185,'woocommerce_cart_redirect_after_add','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (186,'woocommerce_enable_ajax_add_to_cart','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (187,'woocommerce_placeholder_image','4','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (188,'woocommerce_weight_unit','kg','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (189,'woocommerce_dimension_unit','cm','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (190,'woocommerce_enable_reviews','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (191,'woocommerce_review_rating_verification_label','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (192,'woocommerce_review_rating_verification_required','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (193,'woocommerce_enable_review_rating','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (194,'woocommerce_review_rating_required','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (195,'woocommerce_manage_stock','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (196,'woocommerce_hold_stock_minutes','60','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (197,'woocommerce_notify_low_stock','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (198,'woocommerce_notify_no_stock','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (199,'woocommerce_stock_email_recipient','hello@bryant.design','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (200,'woocommerce_notify_low_stock_amount','2','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (201,'woocommerce_notify_no_stock_amount','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (202,'woocommerce_hide_out_of_stock_items','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (203,'woocommerce_stock_format','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (204,'woocommerce_file_download_method','force','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (205,'woocommerce_downloads_redirect_fallback_allowed','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (206,'woocommerce_downloads_require_login','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (207,'woocommerce_downloads_grant_access_after_payment','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (208,'woocommerce_downloads_deliver_inline','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (209,'woocommerce_downloads_add_hash_to_filename','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (210,'woocommerce_downloads_count_partial','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115680,'woocommerce_attribute_lookup_enabled','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (212,'woocommerce_attribute_lookup_direct_updates','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (213,'woocommerce_attribute_lookup_optimized_updates','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (214,'woocommerce_product_match_featured_image_by_sku','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (215,'woocommerce_prices_include_tax','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (216,'woocommerce_tax_based_on','shipping','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (217,'woocommerce_shipping_tax_class','inherit','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (218,'woocommerce_tax_round_at_subtotal','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (219,'woocommerce_tax_classes','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (220,'woocommerce_tax_display_shop','excl','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (221,'woocommerce_tax_display_cart','excl','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (222,'woocommerce_price_display_suffix','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (223,'woocommerce_tax_total_display','itemized','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (224,'woocommerce_enable_shipping_calc','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (225,'woocommerce_shipping_cost_requires_address','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (226,'woocommerce_ship_to_destination','billing','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (227,'woocommerce_shipping_debug_mode','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (228,'woocommerce_enable_guest_checkout','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (229,'woocommerce_enable_checkout_login_reminder','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (230,'woocommerce_enable_signup_and_login_from_checkout','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (231,'woocommerce_enable_myaccount_registration','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (232,'woocommerce_registration_generate_username','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (233,'woocommerce_registration_generate_password','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (234,'woocommerce_erasure_request_removes_order_data','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (235,'woocommerce_erasure_request_removes_download_data','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (236,'woocommerce_allow_bulk_remove_personal_data','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (237,'woocommerce_registration_privacy_policy_text','Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (238,'woocommerce_checkout_privacy_policy_text','Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (239,'woocommerce_delete_inactive_accounts','{{SHIPPER_JSON_START}}{\"number\":\"\",\"unit\":\"months\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (240,'woocommerce_trash_pending_orders','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (241,'woocommerce_trash_failed_orders','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (242,'woocommerce_trash_cancelled_orders','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (243,'woocommerce_anonymize_completed_orders','{{SHIPPER_JSON_START}}{\"number\":\"\",\"unit\":\"months\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (244,'woocommerce_email_from_name','Thrill Rebels','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (245,'woocommerce_email_from_address','hello@bryant.design','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (246,'woocommerce_email_header_image','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (247,'woocommerce_email_base_color','#720eec','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (248,'woocommerce_email_background_color','#f7f7f7','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (249,'woocommerce_email_body_background_color','#ffffff','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (250,'woocommerce_email_text_color','#3c3c3c','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (251,'woocommerce_email_footer_text','{site_title} &mdash; Built with {WooCommerce}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (252,'woocommerce_email_footer_text_color','#3c3c3c','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (253,'woocommerce_merchant_email_notifications','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (254,'woocommerce_cart_page_id','6','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (255,'woocommerce_checkout_page_id','7','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (256,'woocommerce_myaccount_page_id','8','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (257,'woocommerce_terms_page_id','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (258,'woocommerce_checkout_pay_endpoint','order-pay','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (259,'woocommerce_checkout_order_received_endpoint','order-received','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (260,'woocommerce_myaccount_add_payment_method_endpoint','add-payment-method','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (261,'woocommerce_myaccount_delete_payment_method_endpoint','delete-payment-method','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (262,'woocommerce_myaccount_set_default_payment_method_endpoint','set-default-payment-method','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (263,'woocommerce_myaccount_orders_endpoint','orders','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (264,'woocommerce_myaccount_view_order_endpoint','view-order','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (265,'woocommerce_myaccount_downloads_endpoint','downloads','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (266,'woocommerce_myaccount_edit_account_endpoint','edit-account','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (267,'woocommerce_myaccount_edit_address_endpoint','edit-address','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (268,'woocommerce_myaccount_payment_methods_endpoint','payment-methods','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (269,'woocommerce_myaccount_lost_password_endpoint','lost-password','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (270,'woocommerce_logout_endpoint','customer-logout','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (271,'woocommerce_api_enabled','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (272,'woocommerce_allow_tracking','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (273,'woocommerce_show_marketplace_suggestions','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (274,'woocommerce_custom_orders_table_created','yes','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (275,'woocommerce_custom_orders_table_enabled','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (276,'woocommerce_analytics_enabled','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (277,'woocommerce_feature_order_attribution_enabled','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (278,'woocommerce_feature_product_block_editor_enabled','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (279,'woocommerce_hpos_fts_index_enabled','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (280,'woocommerce_single_image_width','700','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (281,'woocommerce_thumbnail_image_width','500','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (282,'woocommerce_checkout_highlight_required_fields','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (283,'woocommerce_demo_store','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (284,'wc_downloads_approved_directories_mode','enabled','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (285,'product_cat_children','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (286,'default_product_cat','15','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (310,'woocommerce_hooked_blocks_version','9.3.0','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (288,'woocommerce_refund_returns_page_id','9','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (335,'_transient_woocommerce_reports-transient-version','1729663311','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (291,'woocommerce_paypal_settings','{{SHIPPER_JSON_START}}{\"enabled\":\"no\",\"title\":\"PayPal\",\"description\":\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\",\"email\":\"hello@bryant.design\",\"advanced\":\"\",\"testmode\":\"no\",\"debug\":\"no\",\"ipn_notification\":\"yes\",\"receiver_email\":\"hello@bryant.design\",\"identity_token\":\"\",\"invoice_prefix\":\"WC-\",\"send_shipping\":\"yes\",\"address_override\":\"no\",\"paymentaction\":\"sale\",\"image_url\":\"\",\"api_details\":\"\",\"api_username\":\"\",\"api_password\":\"\",\"api_signature\":\"\",\"sandbox_api_username\":\"\",\"sandbox_api_password\":\"\",\"sandbox_api_signature\":\"\",\"_should_load\":\"no\"}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (292,'woocommerce_version','9.8.5','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (293,'woocommerce_db_version','9.8.3','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (294,'woocommerce_store_id','f125eb26-8d82-4a52-ae42-8fad059d0787','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (787,'_transient_wc_count_comments','O:8:\"stdClass\":7:{s:14:\"total_comments\";i:0;s:3:\"all\";i:0;s:9:\"moderated\";i:0;s:8:\"approved\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (307,'wcpay_was_in_use','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (311,'woocommerce_coming_soon','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (312,'woocommerce_initial_installed_version','9.3.0','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (313,'wc_blocks_db_schema_version','260','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (314,'wc_remote_inbox_notifications_stored_state','O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (321,'_transient_product_query-transient-version','1748066005','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (324,'_transient_jetpack_autoloader_plugin_paths','{{SHIPPER_JSON_START}}[\"{{WP_PLUGIN_DIR}}\\/woocommerce\"]{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (325,'action_scheduler_lock_async-request-runner','6831710b7016c9.21101709|1748070727','no');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (326,'woocommerce_admin_notices','{{SHIPPER_JSON_START}}[\"update\",\"template_files\"]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44563,'woocommerce_feature_rate_limit_checkout_enabled','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44564,'woocommerce_feature_remote_logging_enabled','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44565,'woocommerce_feature_email_improvements_enabled','no','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (332,'wc_remote_inbox_notifications_wca_updated','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (333,'_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs','1748672107','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (334,'_transient_woocommerce_admin_remote_inbox_notifications_specs','a:1:{s:5:\"en_US\";a:60:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test A\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 00:01:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test B\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 20:58:43\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test C\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:03:33\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test D\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:32:09\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:169:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:125:\"https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:131:\"https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:29:\"amazon-mcf-reviews-2023-12-07\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"amazon-mcf-reviews-2023-12-07\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Enjoying Amazon MCF for WooCommerce?\";s:7:\"content\";s:292:\"We\'re Never Settle, the developers behind Amazon MCF for WooCommerce, and would be deeply honored to have your review. Reviews help immensely as other users can learn how MCF can solve their needs too! Not happy or need help? Please reach out for support and we’d love to make things right!\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"amazon-mcf-review-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Leave a review\";}}s:3:\"url\";s:161:\"https://woocommerce.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"amazon-mcf-support-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Request support\";}}s:3:\"url\";s:142:\"https://woocommerce.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-06 15:21:27\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-amazon-fulfillment\";}}}}s:30:\"remove_estimated_deposits_2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"remove_estimated_deposits_2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:33:\"Estimated deposits are going away\";s:7:\"content\";s:267:\"To provide more accurate deposit information and support the expansion of instant deposits, estimated deposit details will no longer be available in WooPayments. We recommend upgrading to the latest version of WooPayments for more detailed balance status information.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"view_docs\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Learn about Deposit schedules\";}}s:3:\"url\";s:151:\"https://woocommerce.com/document/woopayments/deposits/deposit-schedule/?utm_source=inbox_note&utm_medium=product&utm_campaign=view_docs#available-funds\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"6.9\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-01-21 08:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2024-01-31 23:59:59\";}}}s:26:\"sirt-woo-2024-11-xss-admin\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"sirt-woo-2024-11-xss-admin\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"An important update is required for WooCommerce\";s:7:\"content\";s:353:\"This update addresses a security vulnerability that could allow unauthorized access to administrative privileges on your site. <a href=\"https://developer.woocommerce.com/2024/12/03/woocommerce-9-4-3-and-woocommerce-9-3-4-available-now/\">Learn more</a>.\r\n<br><br>\r\n<strong>Please ensure your site is updated to the latest version to stay secure.</strong>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-12-04 02:07:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"8.4.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"9.4.3\";}}}s:64:\"woocommerce-analytics-order-attribution-promotions-december-2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:64:\"woocommerce-analytics-order-attribution-promotions-december-2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Discover what drives your sales\";s:7:\"content\";s:216:\"Use our powerful <strong>Order Attribution</strong> extension to understand what truly drives your revenue. Track your sales journey, identify your most effective marketing channels, and optimize your sales strategy.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:78:\"woocommerce-analytics-order-attribution-promotions-december-2024-find-out-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:51:\"https://wordpress.org/plugins/woocommerce-analytics\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-12-23 09:56:01\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:21:\"woocommerce-analytics\";}}}}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:12;}s:7:\"default\";i:0;s:9:\"operation\";s:5:\"range\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";}}}s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Update required for your PayPal Braintree extension\";s:7:\"content\";s:253:\"To continue securely accepting payments, you must update your PayPal Braintree extension to version 3.2.4 or newer before June 30, 2025. Your current extension version will not support payment processing after this date due to an SSL certificate update.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:51:\"paypal-braintree-sdk-depreciation-2025-02-20-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Upgrade now\";}}s:3:\"url\";s:21:\"/wp-admin/plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-03-03 19:49:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:47:\"woocommerce-gateway-paypal-powered-by-braintree\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"3.2.3\";}}}s:24:\"uk-vat-notice-2025-04-30\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"uk-vat-notice-2025-04-30\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"UK VAT numbers are no longer supported\";s:7:\"content\";s:322:\"Due to recent HM Revenue &amp; Customs (HMRC) VAT API changes, your EU VAT Number for WooCommerce extension can no longer validate UK VAT numbers. HMRC now requires merchants to register an API key, which this extension does not currently support. We recommend EU/UK VAT Validation Manager for WooCommerce as a replacement\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:31:\"uk-vat-notice-button-2025-04-30\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:31:\"Learn more about this extension\";}}s:3:\"url\";s:53:\"https://wordpress.org/plugins/eu-vat-for-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-eu-vat-number\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-05 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-05-15 00:00:00\";}}}s:22:\"payson-retirement-2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:22:\"payson-retirement-2025\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:22:\"Payson Form Retirement\";s:7:\"content\";s:208:\"Svea Bank is discontinuing the Payson service; the last date for transactions is August 31, 2025. As a result, the Payson Form extension has been removed from WooCommerce.com. Documentation remains available.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"payson-retirement-2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:35:\"Explore alternative payment methods\";}}s:3:\"url\";s:218:\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?categoryIds=28680&collections=product&page=1&country=Sweden&utm_source=inbox_note&utm_medium=product&utm_campaign=payson-retirement-2025\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-13 01:35:31\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-12-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-payson\";}}}}s:14:\"paypal_q2_2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:14:\"paypal_q2_2025\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Power up sales with Pay Later messaging\";s:7:\"content\";s:240:\"Help increase your sales and grow cart sizes by letting customers know they have flexible payment options. Merchants see up to an 11% sales lift when they add Pay Later messaging — plus, it integrates seamlessly with your PayPal checkout.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"paypal_q2_2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"Activate messaging\";}}s:3:\"url\";s:130:\"https://woocommerce.com/products/woocommerce-paypal-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=paypal_q2_2025\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-22 00:18:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-05-27 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:25;s:9:\"operation\";s:1:\">\";}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}}}}}}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (839,'shop_catalog_image_size','{{SHIPPER_JSON_START}}{\"width\":500,\"height\":\"\",\"0\":0}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (840,'shop_single_image_size','{{SHIPPER_JSON_START}}{\"width\":700,\"height\":\"\",\"0\":0}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (841,'shop_thumbnail_image_size','{{SHIPPER_JSON_START}}{\"width\":120,\"height\":\"\",\"0\":0}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (842,'woocommerce_thumbnail_cropping','uncropped','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (843,'fusion_dynamic_css_posts','{{SHIPPER_JSON_START}}{\"78\":true,\"204\":false,\"205\":false,\"global\":true,\"206\":false,\"207\":false,\"208\":false,\"209\":false,\"210\":false,\"211\":false,\"212\":false,\"213\":false,\"214\":false,\"215\":false,\"216\":false,\"217\":false,\"218\":false,\"219\":false,\"220\":false,\"221\":false,\"222\":false,\"223\":false,\"224\":false,\"225\":false,\"226\":false,\"227\":false,\"228\":false,\"229\":false,\"230\":false,\"231\":false,\"232\":false,\"233\":false,\"234\":false,\"235\":false,\"236\":false,\"237\":false,\"238\":false,\"239\":false,\"240\":false,\"241\":false,\"242\":false,\"243\":false,\"244\":false,\"245\":false,\"246\":false,\"247\":false,\"248\":false,\"250\":false,\"252\":false,\"255\":false,\"257\":false,\"259\":false,\"261\":false,\"263\":false,\"266\":false,\"268\":false,\"269\":false,\"271\":false,\"273\":false,\"275\":false,\"278\":false,\"279\":false,\"283\":false,\"286\":false,\"289\":false,\"290\":false,\"292\":false,\"295\":false,\"296\":false,\"298\":false,\"301\":false,\"302\":false,\"305\":false,\"306\":false,\"308\":false,\"310\":false,\"312\":false,\"314\":false,\"316\":false,\"317\":false,\"319\":false,\"321\":false,\"323\":false,\"326\":false,\"328\":false,\"331\":false,\"333\":false,\"335\":false,\"336\":false,\"338\":false,\"340\":false,\"342\":false,\"345\":false,\"347\":false,\"348\":false,\"351\":false,\"353\":false,\"354\":false,\"357\":false,\"359\":false,\"361\":false,\"362\":false,\"364\":false,\"365\":false,\"367\":false,\"369\":false,\"371\":false,\"373\":false,\"376\":false,\"378\":false,\"381\":false,\"383\":false,\"384\":false,\"385\":false,\"387\":false,\"389\":false,\"392\":false,\"394\":false,\"395\":false,\"396\":false,\"397\":false,\"398\":false,\"399\":false,\"401\":false,\"402\":false,\"404\":false,\"406\":false,\"407\":false,\"410\":false,\"412\":false,\"414\":false,\"415\":false,\"418\":false,\"419\":false,\"420\":false,\"423\":false,\"424\":false,\"426\":false,\"428\":false,\"430\":false,\"432\":false,\"433\":false,\"436\":false,\"438\":false,\"440\":false,\"441\":false,\"443\":false,\"446\":false,\"447\":false,\"450\":false,\"452\":false,\"454\":false,\"457\":false,\"459\":false,\"460\":false,\"462\":false,\"464\":false,\"466\":false,\"468\":false,\"470\":false,\"472\":false,\"474\":false,\"476\":false,\"479\":false,\"480\":false,\"482\":false,\"484\":false,\"486\":false,\"487\":false,\"489\":false,\"491\":false,\"493\":false,\"495\":false,\"496\":false,\"498\":false,\"500\":false,\"501\":false,\"502\":false,\"504\":false,\"505\":false,\"508\":false,\"510\":false,\"512\":false,\"513\":false,\"515\":false,\"517\":false,\"520\":false,\"522\":false,\"524\":false,\"526\":false,\"527\":false,\"530\":false,\"532\":false,\"533\":false,\"536\":false,\"538\":false,\"539\":false,\"542\":false,\"543\":false,\"545\":false,\"547\":false,\"548\":false,\"550\":false,\"552\":false,\"554\":false,\"556\":false,\"558\":false,\"560\":false,\"563\":false,\"565\":false,\"567\":false,\"569\":false,\"571\":false,\"573\":false,\"575\":false,\"577\":false,\"579\":false,\"581\":false,\"583\":false,\"585\":false,\"587\":false,\"590\":false,\"592\":false,\"594\":false,\"596\":false,\"597\":false,\"598\":false,\"600\":false,\"601\":false,\"604\":false,\"606\":false,\"607\":false,\"611\":false,\"613\":false,\"615\":false,\"616\":false,\"617\":false,\"620\":false,\"621\":false,\"623\":false,\"626\":false,\"627\":false,\"629\":false,\"632\":false,\"633\":false,\"636\":false,\"637\":false,\"640\":false,\"641\":false,\"643\":false,\"644\":false,\"647\":false,\"648\":false,\"651\":false,\"652\":false,\"655\":false,\"657\":false,\"659\":false,\"660\":false,\"662\":false,\"665\":false,\"666\":false,\"669\":false,\"671\":false,\"672\":false,\"675\":false,\"676\":false,\"679\":false,\"682\":false,\"683\":false,\"685\":false,\"687\":false,\"688\":false,\"691\":false,\"693\":false,\"695\":false,\"696\":false,\"699\":false,\"701\":false,\"702\":false,\"704\":false,\"707\":false,\"710\":false,\"713\":false,\"715\":false,\"717\":false,\"719\":false,\"721\":false,\"722\":false,\"725\":false,\"726\":false,\"729\":false,\"731\":false,\"732\":false,\"733\":false,\"734\":false,\"735\":false,\"736\":false,\"737\":false,\"738\":false,\"739\":false,\"740\":false,\"741\":false,\"742\":false,\"743\":false,\"744\":false,\"745\":false,\"746\":false,\"747\":false,\"748\":false,\"749\":false,\"750\":false,\"751\":false,\"752\":false,\"753\":false,\"754\":false,\"755\":false,\"756\":false,\"757\":false,\"758\":false,\"759\":false,\"760\":false,\"761\":false,\"762\":false,\"763\":false,\"764\":false,\"765\":false,\"766\":false,\"767\":false,\"768\":false,\"769\":false,\"770\":false,\"771\":false,\"772\":false,\"773\":false,\"774\":false,\"775\":false,\"776\":false,\"777\":false,\"778\":false,\"779\":false,\"780\":false,\"781\":false,\"782\":false,\"783\":false,\"784\":false,\"785\":false,\"786\":false,\"787\":false,\"788\":false,\"789\":false,\"790\":false,\"791\":false,\"792\":false,\"793\":false,\"794\":false,\"795\":false,\"796\":false,\"797\":false,\"798\":false,\"799\":false,\"800\":false,\"801\":false,\"802\":false,\"803\":false,\"804\":false,\"805\":false,\"806\":false,\"807\":false,\"808\":false,\"809\":false,\"810\":false,\"811\":false,\"812\":false,\"813\":false,\"814\":false,\"815\":false,\"816\":false,\"817\":false,\"818\":false,\"819\":false,\"820\":false,\"821\":false,\"822\":false,\"823\":false,\"824\":false,\"825\":false,\"826\":false,\"827\":false,\"828\":false,\"829\":false,\"830\":false,\"831\":false,\"832\":false,\"833\":false,\"834\":false,\"835\":false,\"836\":false,\"837\":false,\"838\":false,\"839\":false,\"840\":false,\"841\":false,\"842\":false,\"843\":false,\"844\":false,\"845\":false,\"846\":false,\"847\":false,\"848\":false,\"849\":false,\"850\":false,\"851\":false,\"852\":false,\"853\":false,\"854\":false,\"855\":false,\"856\":false,\"857\":false,\"858\":false,\"859\":false,\"860\":false,\"861\":false,\"862\":false,\"863\":false,\"864\":false,\"865\":false,\"866\":false,\"867\":false,\"868\":false,\"869\":false,\"870\":false,\"871\":false,\"872\":false,\"873\":false,\"874\":false,\"875\":false,\"876\":false,\"877\":false,\"878\":false,\"879\":false,\"880\":false,\"881\":false,\"882\":false,\"883\":false,\"884\":false,\"885\":false,\"886\":false,\"887\":false,\"888\":false,\"889\":false,\"890\":false,\"891\":false,\"892\":false,\"893\":false,\"894\":false,\"895\":false,\"896\":false,\"897\":false,\"898\":false,\"899\":false,\"900\":false,\"901\":false,\"902\":false,\"903\":false,\"904\":false,\"905\":false,\"906\":false,\"907\":false,\"908\":false,\"909\":false,\"910\":false,\"911\":false,\"912\":false,\"913\":false,\"914\":false,\"915\":false,\"916\":false,\"917\":false,\"918\":false,\"919\":false,\"920\":false,\"921\":false,\"922\":false,\"923\":false,\"924\":false,\"925\":false,\"926\":false,\"927\":false,\"928\":false,\"929\":false,\"930\":false,\"931\":false,\"932\":false,\"933\":false,\"934\":false,\"935\":false,\"936\":false,\"937\":false,\"938\":false,\"939\":false,\"940\":false,\"941\":false,\"942\":false,\"943\":false,\"944\":false,\"945\":false,\"946\":false,\"947\":false,\"948\":false,\"949\":false,\"950\":false,\"951\":false,\"952\":false,\"953\":false,\"954\":false,\"955\":false,\"956\":false,\"957\":false,\"958\":false,\"959\":false,\"960\":false,\"961\":false,\"962\":false,\"963\":false,\"964\":false,\"965\":false,\"966\":false,\"967\":false,\"968\":false,\"969\":false,\"970\":false,\"971\":false,\"972\":false,\"973\":false,\"974\":false,\"975\":false,\"976\":false,\"977\":false,\"978\":false,\"979\":false,\"980\":false,\"981\":false,\"982\":false,\"983\":false,\"984\":false,\"985\":false,\"986\":false,\"987\":false,\"988\":false,\"989\":false,\"990\":false,\"991\":false,\"992\":false,\"993\":false,\"994\":false,\"995\":false,\"996\":false,\"997\":false,\"998\":false,\"999\":false,\"1000\":false,\"1001\":false,\"1002\":false,\"1003\":false,\"1004\":false,\"1005\":false,\"1006\":false,\"1007\":false,\"1008\":false,\"1009\":false,\"1010\":false,\"1011\":false,\"1012\":false,\"1013\":false,\"1014\":false,\"1015\":false,\"1016\":false,\"1017\":false,\"1018\":false,\"1019\":false,\"1020\":false,\"1021\":false,\"1022\":false,\"1023\":false,\"1024\":false,\"1025\":false,\"1026\":false,\"1027\":false,\"1028\":false,\"1029\":false,\"1030\":false,\"1031\":false,\"1032\":false,\"1033\":false,\"1034\":false,\"1035\":false,\"1036\":false,\"1037\":false,\"1038\":false,\"1039\":false,\"1040\":false,\"1041\":false,\"1042\":false,\"1043\":false,\"1044\":false,\"1045\":false,\"1046\":false,\"1047\":false,\"1048\":false,\"1049\":false,\"1050\":false,\"1051\":false,\"1052\":false,\"1053\":false,\"1054\":false,\"1055\":false,\"1056\":false,\"1057\":false,\"1058\":false,\"1059\":false,\"1060\":false,\"1061\":false,\"1062\":false,\"1063\":false,\"1064\":false,\"1065\":false,\"1066\":false,\"1067\":false,\"1068\":false,\"1069\":false,\"1070\":false,\"1071\":false,\"1072\":false,\"1073\":false,\"1074\":false,\"1075\":false,\"1076\":false,\"1077\":false,\"1078\":false,\"1079\":false,\"1080\":false,\"1081\":false,\"1082\":false,\"1083\":false,\"1084\":false,\"1085\":false,\"1086\":false,\"1087\":false,\"1088\":false,\"1089\":false,\"1090\":false,\"1091\":false,\"1092\":false,\"1093\":false,\"1094\":false,\"1095\":false,\"1096\":false,\"1097\":false,\"1098\":false,\"1099\":false,\"1100\":false,\"1101\":false,\"1102\":false,\"1103\":false,\"1104\":false,\"1105\":false,\"1106\":false,\"1107\":false,\"1108\":false,\"1109\":false,\"1110\":false,\"1111\":false,\"1112\":false,\"1113\":false,\"1114\":false,\"1115\":false,\"1116\":false,\"1117\":false,\"1118\":false,\"1119\":false,\"1120\":false,\"1121\":false,\"1122\":false,\"1123\":false,\"1124\":false,\"1125\":false,\"1126\":false,\"1127\":false,\"1128\":false,\"1129\":false,\"1130\":false,\"1131\":false,\"1132\":false,\"1133\":false,\"1134\":false,\"1135\":false,\"1136\":false,\"1137\":false,\"1138\":false,\"1139\":false,\"1140\":false,\"1141\":false,\"1142\":false,\"1143\":false,\"1145\":false,\"1147\":false,\"1149\":false,\"1152\":false,\"1154\":false,\"1155\":false,\"1157\":false,\"1159\":false,\"1160\":false,\"1163\":false,\"1164\":false,\"1167\":false,\"1169\":false,\"1170\":false,\"1173\":false,\"1175\":false,\"1176\":false,\"1179\":false,\"1181\":false,\"1184\":false,\"1185\":false,\"1188\":false,\"1190\":false,\"1191\":false,\"1194\":false,\"1196\":false,\"1197\":false,\"1200\":false,\"1202\":false,\"1203\":false,\"1205\":false,\"1207\":false,\"1210\":false,\"1211\":false,\"1214\":false,\"1215\":false,\"1217\":false,\"1218\":false,\"1221\":false,\"1223\":false,\"1225\":false,\"1226\":false,\"1227\":false,\"1229\":false,\"1231\":false,\"1232\":false,\"1235\":false,\"1237\":false,\"1239\":false,\"1241\":false,\"1243\":false,\"1244\":false,\"1246\":false,\"1248\":false,\"1250\":false,\"1253\":false,\"1256\":false,\"1258\":false,\"1261\":false,\"1262\":false,\"1264\":false,\"1267\":false,\"1268\":false,\"1270\":false,\"1273\":false,\"1274\":false,\"1277\":false,\"1279\":false,\"1280\":false,\"1281\":false,\"1283\":false,\"1285\":false,\"1288\":false,\"1290\":false,\"1291\":false,\"1292\":false,\"1294\":false,\"1296\":false,\"1297\":false,\"1298\":false,\"1299\":false,\"1302\":false,\"1304\":false,\"1306\":false,\"1308\":false,\"1310\":false,\"1313\":false,\"1314\":false,\"1316\":false,\"1319\":false,\"1320\":false,\"1322\":false,\"1325\":false,\"1326\":false,\"1329\":false,\"1330\":false,\"1333\":false,\"1335\":false,\"1336\":false,\"1339\":false,\"1341\":false,\"1342\":false,\"1343\":false,\"1346\":false,\"1347\":false,\"1350\":false,\"1352\":false,\"1355\":false,\"1356\":false,\"1359\":false,\"1360\":false,\"1361\":false,\"1364\":false,\"1367\":false,\"1368\":false,\"1371\":false,\"1373\":false,\"1375\":false,\"1378\":false,\"1379\":false,\"1382\":false,\"1383\":false,\"1386\":false,\"1388\":false,\"1390\":false,\"1391\":false,\"1393\":false,\"1396\":false,\"1397\":false,\"1398\":false,\"1400\":false,\"1403\":false,\"1406\":false,\"1408\":false,\"1409\":false,\"1412\":false,\"1414\":false,\"1415\":false,\"1418\":false,\"1420\":false,\"1421\":false,\"1424\":false,\"1427\":false,\"1428\":false,\"1431\":false,\"1433\":false,\"1435\":false,\"1436\":false,\"1437\":false,\"1438\":false,\"1440\":false,\"1442\":false,\"1445\":false,\"1448\":false,\"1451\":false,\"1454\":false,\"1455\":false,\"1458\":false,\"1460\":false,\"1461\":false,\"1463\":false,\"1466\":false,\"1467\":false,\"1470\":false,\"1471\":false,\"1474\":false,\"1476\":false,\"1478\":false,\"1479\":false,\"1480\":false,\"1482\":false,\"1484\":false,\"1485\":false,\"1486\":false,\"1487\":false,\"1488\":false,\"1489\":false,\"1490\":false,\"1491\":false,\"1492\":false,\"1493\":false,\"1494\":false,\"1495\":false,\"1496\":false,\"1497\":false,\"1498\":false,\"1499\":false,\"1500\":false,\"1501\":false,\"1502\":false,\"1503\":false,\"1505\":false,\"1506\":false,\"1508\":false,\"1510\":false,\"1511\":false,\"1512\":false,\"1514\":false,\"1516\":false,\"1518\":false,\"1520\":false,\"1524\":false,\"1526\":false,\"1529\":false,\"1531\":false,\"1532\":false,\"1533\":false,\"1534\":false,\"1536\":false,\"1537\":false,\"1539\":false,\"1541\":false,\"1543\":false,\"1545\":false,\"1547\":false,\"1549\":false,\"1551\":false,\"1554\":false,\"1555\":false,\"1557\":false,\"1559\":false,\"1560\":false,\"1562\":false,\"1564\":false,\"1566\":false,\"1568\":false,\"1570\":false,\"1572\":false,\"1574\":false,\"1576\":false,\"1577\":false,\"1580\":false,\"1582\":false,\"1584\":false,\"1585\":false,\"1588\":false,\"1590\":false,\"1592\":false,\"1595\":false,\"1596\":false,\"1598\":false,\"1600\":false,\"1602\":false,\"1605\":false,\"1607\":false,\"1608\":false,\"1610\":false,\"1613\":false,\"1614\":false,\"1617\":false,\"1618\":false,\"1621\":false,\"1623\":false,\"1625\":false,\"1626\":false,\"1629\":false,\"1631\":false,\"1634\":false,\"1636\":false,\"1637\":false,\"1639\":false,\"1643\":false,\"1644\":false,\"1647\":false,\"1649\":false,\"1650\":false,\"1652\":false,\"1654\":false,\"1656\":false,\"1657\":false,\"1660\":false,\"1662\":false,\"1664\":false,\"1666\":false,\"1667\":false,\"1670\":false,\"1672\":false,\"1673\":false,\"1675\":false,\"1678\":false,\"1679\":false,\"1681\":false,\"1683\":false,\"1685\":false,\"1688\":false,\"1690\":false,\"1691\":false,\"1693\":false,\"1695\":false,\"1697\":false,\"1698\":false,\"1700\":false,\"1702\":false,\"1704\":false,\"1706\":false,\"1708\":false,\"1710\":false,\"1712\":false,\"1714\":false,\"1716\":false,\"1718\":false,\"1720\":false,\"1721\":false,\"1724\":false,\"1726\":false,\"1730\":false,\"1732\":false,\"1735\":false,\"1737\":false,\"1739\":false,\"1741\":false,\"1743\":false,\"1744\":false,\"1745\":false,\"1747\":false,\"1749\":false,\"1750\":false,\"1751\":false,\"1752\":false,\"1754\":false,\"1756\":false,\"1758\":false,\"1759\":false,\"1760\":false,\"1763\":false,\"1766\":false,\"1767\":false,\"1768\":false,\"1772\":false,\"1774\":false,\"1776\":false,\"1779\":false,\"1781\":false,\"1782\":false,\"1784\":false,\"1786\":false,\"1789\":false,\"1790\":false,\"1793\":false,\"1795\":false,\"1796\":false,\"1798\":false,\"1801\":false,\"1802\":false,\"1804\":false,\"1807\":false,\"1809\":false,\"1812\":false,\"1814\":false,\"1815\":false,\"1817\":false,\"1819\":false,\"1822\":false,\"1824\":false,\"1826\":false,\"1827\":false,\"1830\":false,\"1832\":false,\"1833\":false,\"1836\":false,\"1838\":false,\"1840\":false,\"1843\":false,\"1845\":false,\"1847\":false,\"1850\":false,\"1852\":false,\"1854\":false,\"1856\":false,\"1858\":false,\"1859\":false,\"1862\":false,\"1863\":false,\"1865\":false,\"1867\":false,\"1869\":false,\"1870\":false,\"1873\":false,\"1875\":false,\"1878\":false,\"1881\":false,\"1883\":false,\"1884\":false,\"1885\":false,\"1886\":false,\"1887\":false,\"1888\":false,\"1889\":false,\"1890\":false,\"1891\":false,\"1892\":false,\"1893\":false,\"1894\":false,\"1895\":false,\"1896\":false,\"1897\":false,\"1898\":false,\"1901\":false,\"1903\":false,\"1906\":false,\"1907\":false,\"1908\":false,\"1909\":false,\"1910\":false,\"1913\":false,\"1916\":false,\"1918\":false,\"1919\":false,\"1922\":false,\"1924\":false,\"1925\":false,\"1927\":false,\"1930\":false,\"1931\":false,\"1934\":false,\"1935\":false,\"1938\":false,\"1940\":false,\"1941\":false,\"1943\":false,\"1945\":false,\"1948\":false,\"1950\":false,\"1952\":false,\"1954\":false,\"1956\":false,\"1957\":false,\"1960\":false,\"1961\":false,\"1963\":false,\"1966\":false,\"1967\":false,\"1970\":false,\"1973\":false,\"1975\":false,\"1978\":false,\"1980\":false,\"1981\":false,\"1984\":false,\"1987\":false,\"1988\":false,\"1991\":false,\"1992\":false,\"1995\":false,\"1998\":false,\"2000\":false,\"2002\":false,\"2005\":false,\"2006\":false,\"2008\":false,\"2011\":false,\"2012\":false,\"2015\":false,\"2017\":false,\"2019\":false,\"2021\":false,\"2023\":false,\"2025\":false,\"2027\":false,\"2029\":false,\"2032\":false,\"2035\":false,\"2037\":false,\"2038\":false,\"2041\":false,\"2044\":false,\"2045\":false,\"2048\":false,\"2049\":false,\"2051\":false,\"2053\":false,\"2056\":false,\"2059\":false,\"2062\":false,\"2063\":false,\"2066\":false,\"2068\":false,\"2069\":false,\"2072\":false,\"2073\":false,\"2074\":false,\"2077\":false,\"2079\":false,\"2081\":false,\"2083\":false,\"2086\":false,\"2089\":false,\"2092\":false,\"2094\":false,\"2097\":false,\"2099\":false,\"2101\":false,\"2103\":false,\"2105\":false,\"2107\":false,\"2109\":false,\"2111\":false,\"2113\":false,\"2115\":false,\"2118\":false,\"2120\":false,\"2122\":false,\"2124\":false,\"2126\":false,\"2128\":false,\"2130\":false,\"2132\":false,\"2134\":false,\"2136\":false,\"2138\":false,\"2141\":false,\"2142\":false,\"2144\":false,\"2146\":false,\"2148\":false,\"2150\":false,\"2152\":false,\"2154\":false,\"2156\":false,\"2158\":false,\"2160\":false,\"2162\":false,\"2164\":false,\"2166\":false,\"2168\":false,\"2170\":false,\"2172\":false,\"2174\":false,\"2176\":false,\"2178\":false,\"2179\":false,\"2182\":false,\"2184\":false,\"2187\":false,\"2190\":false,\"2192\":false,\"2195\":false,\"2198\":false,\"2200\":false,\"2203\":false,\"2204\":false,\"2206\":false,\"2209\":false,\"2210\":false,\"2213\":false,\"2215\":false,\"2217\":false,\"2219\":false,\"2221\":false,\"2222\":false,\"2225\":false,\"2228\":false,\"2230\":false,\"2232\":false,\"2234\":false,\"2236\":false,\"2238\":false,\"2240\":false,\"2241\":false,\"2244\":false,\"2245\":false,\"2247\":false,\"2250\":false,\"2252\":false,\"2254\":false,\"2255\":false,\"2258\":false,\"2260\":false,\"2261\":false,\"2264\":false,\"2265\":false,\"2268\":false,\"2270\":false,\"2272\":false,\"2274\":false,\"2276\":false,\"2278\":false,\"2279\":false,\"2281\":false,\"2283\":false,\"2286\":false,\"2288\":false,\"2290\":false,\"2292\":false,\"2293\":false,\"2297\":false,\"2299\":false,\"2301\":false,\"2302\":false,\"2305\":false,\"2308\":false,\"2310\":false,\"2312\":false,\"2314\":false,\"2316\":false,\"2318\":false,\"2321\":false,\"2322\":false,\"2324\":false,\"2326\":false,\"2328\":false,\"2331\":false,\"2332\":false,\"2335\":false,\"2337\":false,\"2338\":false,\"2341\":false,\"2343\":false,\"2345\":false,\"2346\":false,\"2349\":false,\"2351\":false,\"2352\":false,\"2355\":false,\"2356\":false,\"2359\":false,\"2361\":false,\"2363\":false,\"2365\":false,\"2367\":false,\"2369\":false,\"2370\":false,\"2373\":false,\"2375\":false,\"2376\":false,\"2379\":false,\"2381\":false,\"2382\":false,\"2384\":false,\"2386\":false,\"2388\":false,\"2390\":false,\"2392\":false,\"2394\":false,\"2397\":false,\"2398\":false,\"2401\":false,\"2403\":false,\"2405\":false,\"2406\":false,\"2408\":false,\"2409\":false,\"2410\":false,\"2411\":false,\"2412\":false,\"2413\":false,\"2414\":false,\"2415\":false,\"2416\":false,\"2417\":false,\"2418\":false,\"2419\":false,\"2420\":false,\"2421\":false,\"2422\":false,\"2423\":false,\"2424\":false,\"2425\":false,\"2426\":false,\"2427\":false,\"2428\":false,\"2429\":false,\"2430\":false,\"2431\":false,\"2432\":false,\"2433\":false,\"2434\":false,\"2435\":false,\"2436\":false,\"2437\":false,\"2438\":false,\"2439\":false,\"2440\":false,\"2441\":false,\"2442\":false,\"2443\":false,\"2444\":false,\"2445\":false,\"2446\":false,\"2447\":false,\"2448\":false,\"2449\":false,\"2450\":false,\"2451\":false,\"2452\":false,\"2453\":false,\"2454\":false,\"2455\":false,\"2456\":false,\"2457\":false,\"2458\":false,\"2459\":false,\"2460\":false,\"2461\":false,\"2462\":false,\"2463\":false,\"2464\":false,\"2465\":false,\"2466\":false,\"2467\":false,\"2468\":false,\"2469\":false,\"2470\":false,\"2471\":false,\"2472\":false,\"2473\":false,\"2474\":false,\"2475\":false,\"2476\":false,\"2477\":false,\"2478\":false,\"2479\":false,\"2480\":false,\"2481\":false,\"2482\":false,\"2483\":false,\"2484\":false,\"2485\":false,\"2486\":false,\"2487\":false,\"2488\":false,\"2489\":false,\"2490\":false,\"2491\":false,\"2492\":false,\"2493\":false,\"2494\":false,\"2495\":false,\"2496\":false,\"2497\":false,\"2498\":false,\"2499\":false,\"2500\":false,\"2501\":false,\"2502\":false,\"2503\":false,\"2504\":false,\"2505\":false,\"2506\":false,\"2507\":false,\"2508\":false,\"2509\":false,\"2510\":false,\"2511\":false,\"2512\":false,\"2513\":false,\"2514\":false,\"2515\":false,\"2516\":false,\"2517\":false,\"2518\":false,\"2519\":false,\"2520\":false,\"2521\":false,\"2522\":false,\"2523\":false,\"2524\":false,\"2525\":false,\"2526\":false,\"2527\":false,\"2528\":false,\"2529\":false,\"2530\":false,\"2531\":false,\"2532\":false,\"2533\":false,\"2534\":false,\"2535\":false,\"2536\":false,\"2537\":false,\"2538\":false,\"2539\":false,\"2540\":false,\"2541\":false,\"2542\":false,\"2543\":false,\"2544\":false,\"2545\":false,\"2546\":false,\"2547\":false,\"2548\":false,\"2549\":false,\"2550\":false,\"2551\":false,\"2552\":false,\"2553\":false,\"2554\":false,\"2555\":false,\"2556\":false,\"2557\":false,\"2558\":false,\"2559\":false,\"2560\":false,\"2561\":false,\"2562\":false,\"2563\":false,\"2564\":false,\"2565\":false,\"2566\":false,\"2567\":false,\"2568\":false,\"2569\":false,\"2570\":false,\"2571\":false,\"2572\":false,\"2573\":false,\"2574\":false,\"2575\":false,\"2576\":false,\"2577\":false,\"2578\":false,\"2579\":false,\"2580\":false,\"2581\":false,\"2582\":false,\"2583\":false,\"2584\":false,\"2585\":false,\"2586\":false,\"2587\":false,\"2588\":false,\"2589\":false,\"2590\":false,\"2591\":false,\"2592\":false,\"2593\":false,\"2594\":false,\"2595\":false,\"2596\":false,\"2597\":false,\"2598\":false,\"2599\":false,\"2600\":false,\"2601\":false,\"2602\":false,\"2603\":false,\"2604\":false,\"2605\":false,\"2606\":false,\"2607\":false,\"2608\":false,\"2609\":false,\"2610\":false,\"2611\":false,\"2612\":false,\"2613\":false,\"2614\":false,\"2615\":false,\"2616\":false,\"2617\":false,\"2618\":false,\"2619\":false,\"2620\":false,\"2621\":false,\"2622\":false,\"2623\":false,\"2624\":false,\"2625\":false,\"2626\":false,\"2627\":false,\"2628\":false,\"2629\":false,\"2630\":false,\"2631\":false,\"2632\":false,\"2633\":false,\"2634\":false,\"2635\":false,\"2636\":false,\"2637\":false,\"2638\":false,\"2639\":false,\"2640\":false,\"2641\":false,\"2642\":false,\"2643\":false,\"2644\":false,\"2645\":false,\"2646\":false,\"2647\":false,\"2648\":false,\"2649\":false,\"2650\":false,\"2651\":false,\"2652\":false,\"2653\":false,\"2654\":false,\"2655\":false,\"2656\":false,\"2657\":false,\"2658\":false,\"2659\":false,\"2660\":false,\"2661\":false,\"2662\":false,\"2663\":false,\"2664\":false,\"2665\":false,\"2666\":false,\"2667\":false,\"2668\":false,\"2669\":false,\"2670\":false,\"2671\":false,\"2672\":false,\"2673\":false,\"2674\":false,\"2675\":false,\"2676\":false,\"2677\":false,\"2678\":false,\"2679\":false,\"2680\":false,\"2681\":false,\"2682\":false,\"2683\":false,\"2684\":false,\"2685\":false,\"2686\":false,\"2687\":false,\"2688\":false,\"2689\":false,\"2690\":false,\"2691\":false,\"2692\":false,\"2693\":false,\"2694\":false,\"2695\":false,\"2696\":false,\"2697\":false,\"2698\":false,\"2699\":false,\"2700\":false,\"2701\":false,\"2702\":false,\"2703\":false,\"2704\":false,\"2705\":false,\"2706\":false,\"2707\":false,\"2708\":false,\"2709\":false,\"2710\":false,\"2711\":false,\"2712\":false,\"2713\":false,\"2714\":false,\"2715\":false,\"2716\":false,\"2717\":false,\"2718\":false,\"2719\":false,\"2720\":false,\"2721\":false,\"2722\":false,\"2723\":false,\"2724\":false,\"2725\":false,\"2726\":false,\"2727\":false,\"2728\":false,\"2729\":false,\"2730\":false,\"2731\":false,\"2732\":false,\"2733\":false,\"2734\":false,\"2735\":false,\"2736\":false,\"2737\":false,\"2738\":false,\"2739\":false,\"2740\":false,\"2741\":false,\"2742\":false,\"2743\":false,\"2744\":false,\"2745\":false,\"2746\":false,\"2747\":false,\"2748\":false,\"2749\":false,\"2750\":false,\"2751\":false,\"2752\":false,\"2753\":false,\"2754\":false,\"2755\":false,\"2756\":false,\"2757\":false,\"2758\":false,\"2759\":false,\"2760\":false,\"2761\":false,\"2762\":false,\"2763\":false,\"2764\":false,\"2765\":false,\"2766\":false,\"2767\":false,\"2768\":false,\"2769\":false,\"2770\":false,\"2771\":false,\"2772\":false,\"2773\":false,\"2774\":false,\"2775\":false,\"2776\":false,\"2777\":false,\"2778\":false,\"2779\":false,\"2780\":false,\"2781\":false,\"2782\":false,\"2783\":false,\"2784\":false,\"2785\":false,\"2786\":false,\"2787\":false,\"2788\":false,\"2789\":false,\"2790\":false,\"2791\":false,\"2792\":false,\"2793\":false,\"2794\":false,\"2795\":false,\"2796\":false,\"2797\":false,\"2798\":false,\"2799\":false,\"2800\":false,\"2801\":false,\"2802\":false,\"2803\":false,\"2804\":false,\"2805\":false,\"2806\":false,\"2807\":false,\"2808\":false,\"2809\":false,\"2810\":false,\"2811\":false,\"2812\":false,\"2813\":false,\"2814\":false,\"2815\":false,\"2816\":false,\"2817\":false,\"2818\":false,\"2819\":false,\"2820\":false,\"2821\":false,\"2822\":false,\"2823\":false,\"2824\":false,\"2825\":false,\"2826\":false,\"2827\":false,\"2828\":false,\"2829\":false,\"2830\":false,\"2831\":false,\"2832\":false,\"2833\":false,\"2834\":false,\"2835\":false,\"2836\":false,\"2837\":false,\"2838\":false,\"2839\":false,\"2840\":false,\"2841\":false,\"2842\":false,\"2843\":false,\"2844\":false,\"2845\":false,\"2846\":false,\"2847\":false,\"2848\":false,\"2849\":false,\"2850\":false,\"2851\":false,\"2852\":false,\"2853\":false,\"2854\":false,\"2855\":false,\"2856\":false,\"2857\":false,\"2858\":false,\"2859\":false,\"2860\":false,\"2861\":false,\"2862\":false,\"2863\":false,\"2864\":false,\"2865\":false,\"2866\":false,\"2867\":false,\"2868\":false,\"2869\":false,\"2870\":false,\"2871\":false,\"2872\":false,\"2873\":false,\"2874\":false,\"2875\":false,\"2876\":false,\"2877\":false,\"2878\":false,\"2879\":false,\"2880\":false,\"2881\":false,\"2882\":false,\"2883\":false,\"2884\":false,\"2885\":false,\"2886\":false,\"2887\":false,\"2888\":false,\"2889\":false,\"2890\":false,\"2891\":false,\"2892\":false,\"2893\":false,\"2894\":false,\"2895\":false,\"2896\":false,\"2897\":false,\"2898\":false,\"2899\":false,\"2900\":false,\"2901\":false,\"2902\":false,\"2903\":false,\"2904\":false,\"2905\":false,\"2906\":false,\"2907\":false,\"2908\":false,\"2909\":false,\"2910\":false,\"2911\":false,\"2912\":false,\"2913\":false,\"2914\":false,\"2915\":false,\"2916\":false,\"2917\":false,\"2918\":false,\"2919\":false,\"2920\":false,\"2921\":false,\"2922\":false,\"2923\":false,\"2924\":false,\"2925\":false,\"2926\":false,\"2927\":false,\"2928\":false,\"2929\":false,\"2930\":false,\"2931\":false,\"2932\":false,\"2933\":false,\"2934\":false,\"2935\":false,\"2936\":false,\"2937\":false,\"2938\":false,\"2939\":false,\"2940\":false,\"2941\":false,\"2942\":false,\"2943\":false,\"2944\":false,\"2945\":false,\"2946\":false,\"2947\":false,\"2948\":false,\"2949\":false,\"2950\":false,\"2951\":false,\"2952\":false,\"2953\":false,\"2954\":false,\"2955\":false,\"2956\":false,\"2957\":false,\"2958\":false,\"2959\":false,\"2960\":false,\"2961\":false,\"2962\":false,\"2963\":false,\"2964\":false,\"2965\":false,\"2966\":false,\"2967\":false,\"2968\":false,\"2969\":false,\"2970\":false,\"2971\":false,\"2972\":false,\"2973\":false,\"2974\":false,\"2975\":false,\"2976\":false,\"2977\":false,\"2978\":false,\"2979\":false,\"2980\":false,\"2981\":false,\"2982\":false,\"2983\":false,\"2984\":false,\"2985\":false,\"2986\":false,\"2987\":false,\"2988\":false,\"2989\":false,\"2990\":false,\"2991\":false,\"2992\":false,\"2993\":false,\"2994\":false,\"2995\":false,\"2996\":false,\"2997\":false,\"2998\":false,\"2999\":false,\"3000\":false,\"3001\":false,\"3002\":false,\"3003\":false,\"3004\":false,\"3005\":false,\"3006\":false,\"3007\":false,\"3008\":false,\"3009\":false,\"3010\":false,\"3011\":false,\"3012\":false,\"3013\":false,\"3014\":false,\"3015\":false,\"3016\":false,\"3017\":false,\"3018\":false,\"3019\":false,\"3020\":false,\"3021\":false,\"3022\":false,\"3023\":false,\"3024\":false,\"3025\":false,\"3026\":false,\"3027\":false,\"3028\":false,\"3029\":false,\"3030\":false,\"3031\":false,\"3032\":false,\"3033\":false,\"3034\":false,\"3035\":false,\"3036\":false,\"3037\":false,\"3038\":false,\"3039\":false,\"3040\":false,\"3041\":false,\"3042\":false,\"3043\":false,\"3044\":false,\"3045\":false,\"3046\":false,\"3047\":false,\"3048\":false,\"3049\":false,\"3050\":false,\"3051\":false,\"3052\":false,\"3053\":false,\"3054\":false,\"3055\":false,\"3056\":false,\"3057\":false,\"3058\":false,\"3059\":false,\"3060\":false,\"3061\":false,\"3062\":false,\"3063\":false,\"3064\":false,\"3065\":false,\"3066\":false,\"3067\":false,\"3068\":false,\"3069\":false,\"3070\":false,\"3071\":false,\"3072\":false,\"3073\":false,\"3074\":false,\"3075\":false,\"3076\":false,\"3077\":false,\"3078\":false,\"3079\":false,\"3080\":false,\"3081\":false,\"3082\":false,\"3083\":false,\"3084\":false,\"3085\":false,\"3086\":false,\"3087\":false,\"3088\":false,\"3089\":false,\"3090\":false,\"3091\":false,\"3092\":false,\"3093\":false,\"3094\":false,\"3095\":false,\"3096\":false,\"3097\":false,\"3098\":false,\"3099\":false,\"3100\":false,\"3101\":false,\"3102\":false,\"3103\":false,\"3104\":false,\"3105\":false,\"3106\":false,\"3107\":false,\"3108\":false,\"3109\":false,\"3110\":false,\"3111\":false,\"3112\":false,\"3113\":false,\"3114\":false,\"3115\":false,\"3116\":false,\"3117\":false,\"3118\":false,\"3119\":false,\"3120\":false,\"3121\":false,\"3122\":false,\"3123\":false,\"3124\":false,\"3125\":false,\"3126\":false,\"3127\":false,\"3128\":false,\"3129\":false,\"3130\":false,\"3131\":false,\"3132\":false,\"3133\":false,\"3134\":false,\"3135\":false,\"3136\":false,\"3137\":false,\"3138\":false,\"3139\":false,\"3140\":false,\"3141\":false,\"3142\":false,\"3143\":false,\"3144\":false,\"3145\":false,\"3146\":false,\"3147\":false,\"3148\":false,\"3149\":false,\"3150\":false,\"3151\":false,\"3152\":false,\"3153\":false,\"3154\":false,\"3155\":false,\"3156\":false,\"3157\":false,\"3158\":false,\"3159\":false,\"3160\":false,\"3161\":false,\"3162\":false,\"3163\":false,\"3164\":false,\"3165\":false,\"3166\":false,\"3167\":false,\"3168\":false,\"3169\":false,\"3170\":false,\"3171\":false,\"3172\":false,\"3173\":false,\"3174\":false,\"3175\":false,\"3176\":false,\"3177\":false,\"3178\":false,\"3179\":false,\"3180\":false,\"3181\":false,\"3182\":false,\"3183\":false,\"3184\":false,\"3185\":false,\"3186\":false,\"3187\":false,\"3188\":false,\"3189\":false,\"3190\":false,\"3191\":false,\"3192\":false,\"3193\":false,\"3194\":false,\"3195\":false,\"3196\":false,\"3197\":false,\"3198\":false,\"3199\":false,\"3200\":false,\"3201\":false,\"3202\":false,\"3203\":false,\"3204\":false,\"3205\":false,\"3206\":false,\"3207\":false,\"3208\":false,\"3209\":false,\"3210\":false,\"3211\":false,\"3212\":false,\"3213\":false,\"3214\":false,\"3215\":false,\"3216\":false,\"3217\":false,\"3218\":false,\"3219\":false,\"3220\":false,\"3221\":false,\"3222\":false,\"3223\":false,\"3224\":false,\"3225\":false,\"3226\":false,\"3227\":false,\"3228\":false,\"3229\":false,\"3230\":false,\"3231\":false,\"3232\":false,\"3233\":false,\"3234\":false,\"3235\":false,\"3236\":false,\"3237\":false,\"3238\":false,\"3239\":false,\"3240\":false,\"3241\":false,\"3242\":false,\"3243\":false,\"3244\":false,\"3245\":false,\"3246\":false,\"3247\":false,\"3248\":false,\"3249\":false,\"3250\":false,\"3251\":false,\"3252\":false,\"3253\":false,\"3254\":false,\"3256\":false,\"3257\":false,\"3259\":false,\"3261\":false,\"3262\":false,\"3265\":false,\"3267\":false,\"3269\":false,\"3271\":false,\"3273\":false,\"3275\":false,\"3277\":false,\"3279\":false,\"3281\":false,\"3282\":false,\"3285\":false,\"3286\":false,\"3289\":false,\"3291\":false,\"3292\":false,\"3296\":false,\"3298\":false,\"3299\":false,\"3300\":false,\"3301\":false,\"3302\":false,\"3305\":false,\"3307\":false,\"3309\":false,\"3312\":false,\"3313\":false,\"3316\":false,\"3319\":false,\"3321\":false,\"3324\":false,\"3326\":false,\"3327\":false,\"3329\":false,\"3331\":false,\"3332\":false,\"3334\":false,\"3335\":false,\"3338\":false,\"3341\":false,\"3343\":false,\"3345\":false,\"3347\":false,\"3349\":false,\"3352\":false,\"3353\":false,\"3357\":false,\"3359\":false,\"3361\":false,\"3363\":false,\"3365\":false,\"3366\":false,\"3367\":false,\"3368\":false,\"3369\":false,\"3372\":false,\"3375\":false,\"3377\":false,\"3380\":false,\"3382\":false,\"3384\":false,\"3386\":false,\"3388\":false,\"3389\":false,\"3392\":false,\"3394\":false,\"3396\":false,\"3398\":false,\"3400\":false,\"3403\":false,\"3405\":false,\"3407\":false,\"3410\":false,\"3412\":false,\"3415\":false,\"3416\":false,\"3419\":false,\"3421\":false,\"3422\":false,\"3425\":false,\"3427\":false,\"3428\":false,\"3431\":false,\"3433\":false,\"3435\":false,\"3436\":false,\"3437\":false,\"3439\":false,\"3441\":false,\"3442\":false,\"3445\":false,\"3446\":false,\"3449\":false,\"3452\":false,\"3453\":false,\"3455\":false,\"3457\":false,\"3458\":false,\"3461\":false,\"3463\":false,\"3465\":false,\"3466\":false,\"3469\":false,\"3471\":false,\"3472\":false,\"3475\":false,\"3476\":false,\"3481\":false,\"3482\":false,\"3486\":false,\"3489\":false,\"3490\":false,\"3492\":false,\"3495\":false,\"3496\":false,\"3498\":false,\"3501\":false,\"3502\":false,\"3505\":false,\"3506\":false,\"3508\":false,\"3510\":false,\"3512\":false,\"3514\":false,\"3516\":false,\"3517\":false,\"3520\":false,\"3521\":false,\"3524\":false,\"3526\":false,\"3528\":false,\"3529\":false,\"3530\":false,\"3531\":false,\"3532\":false,\"3533\":false,\"3534\":false,\"3535\":false,\"3536\":false,\"3537\":false,\"3538\":false,\"3539\":false,\"3540\":false,\"3541\":false,\"3542\":false,\"3543\":false,\"3544\":false,\"3545\":false,\"3546\":false,\"3547\":false,\"3548\":false,\"3549\":false,\"3550\":false,\"3551\":false,\"3552\":false,\"3553\":false,\"3554\":false,\"3555\":false,\"3556\":false,\"3557\":false,\"3558\":false,\"3559\":false,\"3560\":false,\"3561\":false,\"3562\":false,\"3563\":false,\"3564\":false,\"3565\":false,\"3566\":false,\"3567\":false,\"3568\":false,\"3569\":false,\"3570\":false,\"3571\":false,\"3572\":false,\"3573\":false,\"3574\":false,\"3575\":false,\"3576\":false,\"3577\":false,\"3578\":false,\"3579\":false,\"3580\":false,\"3581\":false,\"3582\":false,\"3583\":false,\"3584\":false,\"3585\":false,\"3586\":false,\"3587\":false,\"3588\":false,\"3589\":false,\"3590\":false,\"3591\":false,\"3592\":false,\"3593\":false,\"3594\":false,\"3595\":false,\"3596\":false,\"3597\":false,\"3598\":false,\"3599\":false,\"3600\":false,\"3601\":false,\"3602\":false,\"3603\":false,\"3604\":false,\"3605\":false,\"3606\":false,\"3607\":false,\"3608\":false,\"3609\":false,\"3610\":false,\"3611\":false,\"3612\":false,\"3613\":false,\"3614\":false,\"3615\":false,\"3616\":false,\"3617\":false,\"3618\":false,\"3619\":false,\"3620\":false,\"3621\":false,\"3622\":false,\"3623\":false,\"3624\":false,\"3625\":false,\"3626\":false,\"3627\":false,\"3628\":false,\"3629\":false,\"3630\":false,\"3631\":false,\"3632\":false,\"3633\":false,\"3634\":false,\"3635\":false,\"3636\":false,\"3637\":false,\"3638\":false,\"3639\":false,\"3640\":false,\"3641\":false,\"3642\":false,\"3643\":false,\"3644\":false,\"3645\":false,\"3646\":false,\"3647\":false,\"3648\":false,\"3649\":false,\"3650\":false,\"3651\":false,\"3652\":false,\"3653\":false,\"3654\":false,\"3655\":false,\"3656\":false,\"3657\":false,\"3658\":false,\"3659\":false,\"3660\":false,\"3661\":false,\"3662\":false,\"3663\":false,\"3664\":false,\"3665\":false,\"3666\":false,\"3667\":false,\"3668\":false,\"3669\":false,\"3670\":false,\"3671\":false,\"3672\":false,\"3673\":false,\"3674\":false,\"3675\":false,\"3676\":false,\"3677\":false,\"3678\":false,\"3679\":false,\"3680\":false,\"3681\":false,\"3682\":false,\"3683\":false,\"3684\":false,\"3685\":false,\"3686\":false,\"3687\":false,\"3688\":false,\"3689\":false,\"3690\":false,\"3691\":false,\"3692\":false,\"3693\":false,\"3694\":false,\"3695\":false,\"3696\":false,\"3697\":false,\"3698\":false,\"3699\":false,\"3700\":false,\"3701\":false,\"3702\":false,\"3703\":false,\"3704\":false,\"3705\":false,\"3706\":false,\"3707\":false,\"3708\":false,\"3709\":false,\"3710\":false,\"3711\":false,\"3712\":false,\"3713\":false,\"3714\":false,\"3715\":false,\"3716\":false,\"3717\":false,\"3718\":false,\"3719\":false,\"3720\":false,\"3721\":false,\"3722\":false,\"3723\":false,\"3724\":false,\"3725\":false,\"3726\":false,\"3727\":false,\"3728\":false,\"3729\":false,\"3730\":false,\"3731\":false,\"3732\":false,\"3733\":false,\"3734\":false,\"3735\":false,\"3736\":false,\"3737\":false,\"3738\":false,\"3739\":false,\"3740\":false,\"3741\":false,\"3742\":false,\"3743\":false,\"3744\":false,\"3745\":false,\"3746\":false,\"3747\":false,\"3748\":false,\"3749\":false,\"3750\":false,\"3751\":false,\"3752\":false,\"3753\":false,\"3754\":false,\"3755\":false,\"3756\":false,\"3757\":false,\"3758\":false,\"3759\":false,\"3760\":false,\"3761\":false,\"3762\":false,\"3763\":false,\"3764\":false,\"3765\":false,\"3766\":false,\"3767\":false,\"3768\":false,\"3769\":false,\"3770\":false,\"3771\":false,\"3772\":false,\"3773\":false,\"3774\":false,\"3775\":false,\"3776\":false,\"3777\":false,\"3778\":false,\"3779\":false,\"3780\":false,\"3781\":false,\"3782\":false,\"3783\":false,\"3784\":false,\"3785\":false,\"3786\":false,\"3787\":false,\"3788\":false,\"3789\":false,\"3790\":false,\"3791\":false,\"3792\":false,\"3793\":false,\"3794\":false,\"3795\":false,\"3796\":false,\"3797\":false,\"3798\":false,\"3799\":false,\"3800\":false,\"3801\":false,\"3802\":false,\"3803\":false,\"3804\":false,\"3805\":false,\"3806\":false,\"3807\":false,\"3808\":false,\"3809\":false,\"3810\":false,\"3811\":false,\"3812\":false,\"3813\":false,\"3814\":false,\"3815\":false,\"3816\":false,\"3817\":false,\"3818\":false,\"3819\":false,\"3820\":false,\"3821\":false,\"3822\":false,\"3823\":false,\"3824\":false,\"3825\":false,\"3826\":false,\"3827\":false,\"3828\":false,\"3829\":false,\"3830\":false,\"3831\":false,\"3833\":false,\"3834\":false,\"3835\":false,\"3836\":false,\"3837\":false,\"3838\":false,\"3839\":false,\"3840\":false,\"3841\":false,\"3842\":false,\"3843\":false,\"3844\":false,\"3845\":false,\"3846\":false,\"3847\":false,\"3848\":false,\"3849\":false,\"3850\":false,\"3851\":false,\"3852\":false,\"3853\":false,\"3854\":false,\"3855\":false,\"3856\":false,\"3857\":false,\"3858\":false,\"3859\":false,\"3860\":false,\"3861\":false,\"3862\":false,\"3863\":false,\"3864\":false,\"3865\":false,\"3866\":false,\"3867\":false,\"3868\":false,\"3869\":false,\"3870\":false,\"3871\":false,\"3872\":false,\"3873\":false,\"3874\":false,\"3876\":false,\"3879\":false,\"3882\":false,\"3885\":false,\"3887\":false,\"3888\":false,\"3889\":false,\"3891\":false,\"3892\":false,\"3896\":false,\"3898\":false,\"3900\":false,\"3901\":false,\"3903\":false,\"3904\":false,\"3909\":false,\"3910\":false,\"3915\":false,\"3916\":false,\"3919\":false,\"3921\":false,\"3922\":false,\"3927\":false,\"3929\":false,\"3930\":false,\"3933\":false,\"3934\":false,\"3936\":false,\"3937\":false,\"3940\":false,\"3942\":false,\"3944\":false,\"3945\":false,\"3947\":false,\"3950\":false,\"3951\":false,\"3952\":false,\"3954\":false,\"3955\":false,\"3959\":false,\"3962\":false,\"3963\":false,\"3967\":false,\"3969\":false,\"3971\":false,\"3972\":false,\"3974\":false,\"3978\":false,\"3980\":false,\"3981\":false,\"3983\":false,\"3984\":false,\"3985\":false,\"3986\":false,\"3987\":false,\"3988\":false,\"3989\":false,\"3990\":false,\"3991\":false,\"3992\":false,\"3993\":false,\"3994\":false,\"3995\":false,\"3996\":false,\"3997\":false,\"3998\":false,\"3999\":false,\"4000\":false,\"4001\":false,\"4002\":false,\"4003\":false,\"4004\":false,\"4005\":false,\"4006\":false,\"4007\":false,\"4008\":false,\"4009\":false,\"4010\":false,\"4011\":false,\"4012\":false,\"4013\":false,\"4014\":false,\"4015\":false,\"4016\":false,\"4017\":false,\"4018\":false,\"4019\":false,\"4020\":false,\"4021\":false,\"4022\":false,\"4023\":false,\"4024\":false,\"4025\":false,\"4026\":false,\"4027\":false,\"4028\":false,\"4029\":false,\"4030\":false,\"4031\":false,\"4032\":false,\"4033\":false,\"4034\":false,\"4035\":false,\"4036\":false,\"4037\":false,\"4038\":false,\"4039\":false,\"4040\":false,\"4041\":false,\"4042\":false,\"4043\":false,\"4044\":false,\"4045\":false,\"4046\":false,\"4047\":false,\"4048\":false,\"4049\":false,\"4050\":false,\"4051\":false,\"4052\":false,\"4053\":false,\"4054\":false,\"4056\":false,\"4057\":false,\"4058\":false,\"4059\":false,\"4060\":false,\"4061\":false,\"4062\":false,\"4063\":false,\"4064\":false,\"4065\":false,\"4066\":false,\"4067\":false,\"4068\":false,\"4069\":false,\"4070\":false,\"4071\":false,\"4072\":false,\"4073\":false,\"4074\":false,\"4075\":false,\"4076\":false,\"4077\":false,\"4078\":false,\"4079\":false,\"4080\":false,\"4081\":false,\"4082\":false,\"4083\":false,\"4084\":false,\"4085\":false,\"4086\":false,\"4087\":false,\"4088\":false,\"4089\":false,\"4090\":false,\"4091\":false,\"4092\":false,\"4093\":false,\"4094\":false,\"4095\":false,\"4096\":false,\"4097\":false,\"4098\":false,\"4099\":false,\"4100\":false,\"4101\":false,\"4102\":false,\"4103\":false,\"4104\":false,\"4105\":false,\"4106\":false,\"4107\":false,\"4108\":false,\"4109\":false,\"4110\":false,\"4111\":false,\"4112\":false,\"4113\":false,\"4114\":false,\"4115\":false,\"4116\":false,\"4117\":false,\"4118\":false,\"4119\":false,\"4120\":false,\"4121\":false,\"4122\":false,\"4123\":false,\"4124\":false,\"4125\":false,\"4126\":false,\"4127\":false,\"4128\":false,\"4129\":false,\"4130\":false,\"4131\":false,\"4132\":false,\"4133\":false,\"4134\":false,\"4135\":false,\"4136\":false,\"4137\":false,\"4138\":false,\"4139\":false,\"4140\":false,\"4141\":false,\"4142\":false,\"4143\":false,\"4144\":false,\"4145\":false,\"4146\":false,\"4147\":false,\"4148\":false,\"4149\":false,\"4150\":false,\"4151\":false,\"4152\":false,\"4153\":false,\"4154\":false,\"4155\":false,\"4156\":false,\"4157\":false,\"4158\":false,\"4159\":false,\"4160\":false,\"4161\":false,\"4162\":false,\"4163\":false,\"4164\":false,\"4165\":false,\"4166\":false,\"4167\":false,\"4168\":false,\"4169\":false,\"4170\":false,\"4171\":false,\"4172\":false,\"4173\":false,\"4174\":false,\"4175\":false,\"4176\":false,\"4177\":false,\"4178\":false,\"4179\":false,\"4180\":false,\"4181\":false,\"4182\":false,\"4183\":false,\"4184\":false,\"4185\":false,\"4186\":false,\"4187\":false,\"4188\":false,\"4189\":false,\"4190\":false,\"4191\":false,\"4192\":false,\"4194\":false,\"4195\":false,\"4196\":false,\"4197\":false,\"4198\":false,\"4199\":false,\"4200\":false,\"4201\":false,\"4202\":false,\"4203\":false,\"4204\":false,\"4205\":false,\"4206\":false,\"4207\":false,\"4208\":false,\"4209\":false,\"4210\":false,\"4211\":false,\"4212\":false,\"4213\":false,\"4214\":false,\"4215\":false,\"4216\":false,\"4217\":false,\"4218\":false,\"4219\":false,\"4220\":false,\"4221\":false,\"4222\":false,\"4223\":false,\"4224\":false,\"4225\":false,\"4226\":false,\"4227\":false,\"4228\":false,\"4229\":false,\"4230\":false,\"4231\":false,\"4232\":false,\"4233\":false,\"4234\":false,\"4235\":false,\"4236\":false,\"4237\":false,\"4238\":false,\"4239\":false,\"4240\":false,\"4241\":false,\"4242\":false,\"4243\":false,\"4244\":false,\"4245\":false,\"4246\":false,\"4247\":false,\"4248\":false,\"4249\":false,\"4250\":false,\"4251\":false,\"4252\":false,\"4253\":false,\"4254\":false,\"4255\":false,\"4256\":false,\"4257\":false,\"4258\":false,\"4259\":false,\"4260\":false,\"4261\":false,\"4262\":false,\"4263\":false,\"4264\":false,\"4265\":false,\"4266\":false,\"4267\":false,\"4268\":false,\"4269\":false,\"4270\":false,\"4271\":false,\"4272\":false,\"4273\":false,\"4274\":false,\"4275\":false,\"4276\":false,\"4277\":false,\"4278\":false,\"4279\":false,\"4280\":false,\"4281\":false,\"4282\":false,\"4283\":false,\"4284\":false,\"4285\":false,\"4286\":false,\"4287\":false,\"4288\":false,\"4289\":false,\"4290\":false,\"4291\":false,\"4292\":false,\"4293\":false,\"4294\":false,\"4295\":false,\"4296\":false,\"4297\":false,\"4298\":false,\"4299\":false,\"4300\":false,\"4301\":false,\"4302\":false,\"4303\":false,\"4304\":false,\"4305\":false,\"4306\":false,\"4307\":false,\"4308\":false,\"4309\":false,\"4310\":false,\"4311\":false,\"4312\":false,\"4313\":false,\"4314\":false,\"4315\":false,\"4316\":false,\"4317\":false,\"4318\":false,\"4319\":false,\"4320\":false,\"4321\":false,\"4322\":false,\"4323\":false,\"4324\":false,\"4325\":false,\"4326\":false,\"4327\":false,\"4328\":false,\"4329\":false,\"4330\":false,\"4331\":false,\"4332\":false,\"4333\":false,\"4334\":false,\"4335\":false,\"4336\":false,\"4337\":false,\"4338\":false,\"4339\":false,\"4340\":false,\"4341\":false,\"4342\":false,\"4343\":false,\"4344\":false,\"4345\":false,\"4346\":false,\"4347\":false,\"4348\":false,\"4349\":false,\"4350\":false,\"4351\":false,\"4352\":false,\"4353\":false,\"4354\":false,\"4355\":false,\"4356\":false,\"4357\":false,\"4358\":false,\"4359\":false,\"4360\":false,\"4361\":false,\"4362\":false,\"4363\":false,\"4364\":false,\"4365\":false,\"4366\":false,\"4367\":false,\"4368\":false,\"4369\":false,\"4370\":false,\"4371\":false,\"4372\":false,\"4373\":false,\"4374\":false,\"4375\":false,\"4376\":false,\"4377\":false,\"4378\":false,\"4379\":false,\"4380\":false,\"4381\":false,\"4382\":false,\"4383\":false,\"4384\":false,\"4385\":false,\"4386\":false,\"4387\":false,\"4388\":false,\"4389\":false,\"4390\":false,\"4391\":false,\"4392\":false,\"4393\":false,\"4394\":false,\"4395\":false,\"4396\":false,\"4397\":false,\"4398\":false,\"4399\":false,\"4400\":false,\"4401\":false,\"4402\":false,\"4403\":false,\"4404\":false,\"4405\":false,\"4406\":false,\"4407\":false,\"4408\":false,\"4409\":false,\"4410\":false,\"4411\":false,\"4412\":false,\"4413\":false,\"4414\":false,\"4415\":false,\"4416\":false,\"4417\":false,\"4418\":false,\"4419\":false,\"4420\":false,\"4421\":false,\"4422\":false,\"4423\":false,\"4424\":false,\"4425\":false,\"4426\":false,\"4427\":false,\"4428\":false,\"4429\":false,\"4430\":false,\"4431\":false,\"4432\":false,\"4433\":false,\"4434\":false,\"4435\":false,\"4436\":false,\"4437\":false,\"4438\":false,\"4439\":false,\"4440\":false,\"4441\":false,\"4445\":false,\"4448\":false,\"4450\":false,\"4451\":false,\"4454\":false,\"4455\":false,\"4458\":false,\"4459\":false,\"4460\":false,\"4462\":false,\"4465\":false,\"4466\":false,\"4468\":false,\"4471\":false,\"4472\":false,\"4474\":false,\"4477\":false,\"4478\":false,\"4480\":false,\"4481\":false,\"4482\":false,\"4483\":false,\"4484\":false,\"4485\":false,\"4486\":false,\"4487\":false,\"4488\":false,\"4489\":false,\"4490\":false,\"4491\":false,\"4492\":false,\"4493\":false,\"4494\":false,\"4495\":false,\"4496\":false,\"4497\":false,\"4498\":false,\"4499\":false,\"4500\":false,\"4501\":false,\"4502\":false,\"4503\":false,\"4504\":false,\"4505\":false,\"4506\":false,\"4507\":false,\"4508\":false,\"4509\":false,\"4510\":false,\"4511\":false,\"4512\":false,\"4513\":false,\"4514\":false,\"4515\":false,\"4516\":false,\"4517\":false,\"4518\":false,\"4519\":false,\"4520\":false,\"4521\":false,\"4522\":false,\"4523\":false,\"4524\":false,\"4525\":false,\"4526\":false,\"4527\":false,\"4528\":false,\"4529\":false,\"4530\":false,\"4531\":false,\"4532\":false,\"4533\":false,\"4534\":false,\"4535\":false,\"4536\":false,\"4537\":false,\"4538\":false,\"4539\":false,\"4540\":false,\"4541\":false,\"4542\":false,\"4543\":false,\"4544\":false,\"4545\":false,\"4546\":false,\"4547\":false,\"4548\":false,\"4549\":false,\"4550\":false,\"4551\":false,\"4552\":false,\"4553\":false,\"4554\":false,\"4555\":false,\"4556\":false,\"4557\":false,\"4558\":false,\"4559\":false,\"4560\":false,\"4561\":false,\"4562\":false,\"4563\":false,\"4564\":false,\"4565\":false,\"4566\":false,\"4567\":false,\"4568\":false,\"4569\":false,\"4570\":false,\"4571\":false,\"4572\":false,\"4573\":false,\"4574\":false,\"4575\":false,\"4576\":false,\"4577\":false,\"4578\":false,\"4579\":false,\"4580\":false,\"4581\":false,\"4582\":false,\"4583\":false,\"4584\":false,\"4585\":false,\"4586\":false,\"4587\":false,\"4588\":false,\"4589\":false,\"4590\":false,\"4591\":false,\"4592\":false,\"4593\":false,\"4594\":false,\"4595\":false,\"4596\":false,\"4597\":false,\"4598\":false,\"4599\":false,\"4600\":false,\"4601\":false,\"4602\":false,\"4603\":false,\"4604\":false,\"4605\":false,\"4606\":false,\"4607\":false,\"4608\":false,\"4609\":false,\"4610\":false,\"4611\":false,\"4612\":false,\"4613\":false,\"4614\":false,\"4615\":false,\"4616\":false,\"4617\":false,\"4618\":false,\"4619\":false,\"4620\":false,\"4621\":false,\"4622\":false,\"4623\":false,\"4624\":false,\"4625\":false,\"4626\":false,\"4627\":false,\"4628\":false,\"4629\":false,\"4630\":false,\"4631\":false,\"4632\":false,\"4633\":false,\"4634\":false,\"4635\":false,\"4636\":false,\"4637\":false,\"4638\":false,\"4639\":false,\"4640\":false,\"4641\":false,\"4642\":false,\"4643\":false,\"4644\":false,\"4645\":false,\"4646\":false,\"4647\":false,\"4648\":false,\"4649\":false,\"4650\":false,\"4651\":false,\"4652\":false,\"4653\":false,\"4654\":false,\"4655\":false,\"4656\":false,\"4657\":false,\"4658\":false,\"4659\":false,\"4660\":false,\"4661\":false,\"4662\":false,\"4663\":false,\"4664\":false,\"4665\":false,\"4666\":false,\"4667\":false,\"4668\":false,\"4669\":false,\"4670\":false,\"4671\":false,\"4672\":false,\"4673\":false,\"4674\":false,\"4675\":false,\"4676\":false,\"4677\":false,\"4678\":false,\"4679\":false,\"4680\":false,\"4681\":false,\"4682\":false,\"4683\":false,\"4684\":false,\"4685\":false,\"4686\":false,\"4687\":false,\"4688\":false,\"4689\":false,\"4690\":false,\"4691\":false,\"4692\":false,\"4693\":false,\"4694\":false,\"4695\":false,\"4696\":false,\"4697\":false,\"4698\":false,\"4699\":false,\"4700\":false,\"4701\":false,\"4702\":false,\"4703\":false,\"4704\":false,\"4705\":false,\"4706\":false,\"4707\":false,\"4708\":false,\"4709\":false,\"4710\":false,\"4711\":false,\"4712\":false,\"4713\":false,\"4714\":false,\"4715\":false,\"4716\":false,\"4717\":false,\"4718\":false,\"4719\":false,\"4720\":false,\"4721\":false,\"4722\":false,\"4723\":false,\"4724\":false,\"4725\":false,\"4726\":false,\"4727\":false,\"4728\":false,\"4729\":false,\"4730\":false,\"4731\":false,\"4732\":false,\"4733\":false,\"4734\":false,\"4735\":false,\"4736\":false,\"4737\":false,\"4738\":false,\"4739\":false,\"4740\":false,\"4741\":false,\"4742\":false,\"4743\":false,\"4744\":false,\"4745\":false,\"4746\":false,\"4747\":false,\"4748\":false,\"4749\":false,\"4750\":false,\"4751\":false,\"4752\":false,\"4753\":false,\"4754\":false,\"4755\":false,\"4756\":false,\"4757\":false,\"4758\":false,\"4759\":false,\"4760\":false,\"4761\":false,\"4762\":false,\"4763\":false,\"4764\":false,\"4765\":false,\"4766\":false,\"4767\":false,\"4768\":false,\"4769\":false,\"4770\":false,\"4771\":false,\"4772\":false,\"4773\":false,\"4774\":false,\"4775\":false,\"4776\":false,\"4777\":false,\"4778\":false,\"4779\":false,\"4780\":false,\"4781\":false,\"4782\":false,\"4783\":false,\"4784\":false,\"4785\":false,\"4786\":false,\"4787\":false,\"4788\":false,\"4789\":false,\"4790\":false,\"4791\":false,\"4792\":false,\"4793\":false,\"4794\":false,\"4795\":false,\"4796\":false,\"4797\":false,\"4798\":false,\"4799\":false,\"4800\":false,\"4801\":false,\"4802\":false,\"4803\":false,\"4804\":false,\"4805\":false,\"4806\":false,\"4807\":false,\"4808\":false,\"4811\":false,\"4814\":false,\"4816\":false,\"4817\":false,\"4819\":false,\"4821\":false,\"4822\":false,\"4824\":false,\"4826\":false,\"4828\":false,\"4829\":false,\"4833\":false,\"4835\":false,\"4837\":false,\"4838\":false,\"4841\":false,\"4842\":false,\"4845\":false,\"4847\":false,\"4848\":false,\"4851\":false,\"4853\":false,\"4854\":false,\"4857\":false,\"4859\":false,\"4860\":false,\"4863\":false,\"4866\":false,\"4867\":false,\"4869\":false,\"4872\":false,\"4873\":false,\"4874\":false,\"4875\":false,\"4876\":false,\"4877\":false,\"4878\":false,\"4881\":false,\"4883\":false,\"4887\":false,\"4888\":false,\"4890\":false,\"4892\":false,\"4895\":false,\"4897\":false,\"4899\":false,\"4901\":false,\"4904\":false,\"4905\":false,\"4908\":false,\"4909\":false,\"4911\":false,\"4913\":false,\"4915\":false,\"4917\":false,\"4919\":false,\"4920\":false,\"4923\":false,\"4924\":false,\"4927\":false,\"4929\":false,\"4930\":false,\"4935\":false,\"4937\":false,\"4938\":false,\"4939\":false,\"4942\":false,\"4943\":false,\"4944\":false,\"4946\":false,\"4948\":false,\"4949\":false,\"4950\":false,\"4952\":false,\"4954\":false,\"4957\":false,\"4958\":false,\"4961\":false,\"4963\":false,\"4965\":false,\"4966\":false,\"4968\":false,\"4970\":false,\"4971\":false,\"4972\":false,\"4974\":false,\"4975\":false,\"4978\":false,\"4980\":false,\"4981\":false,\"4984\":false,\"4986\":false,\"4988\":false,\"4989\":false,\"4992\":false,\"4995\":false,\"4996\":false,\"4997\":false,\"5000\":false,\"5003\":false,\"5004\":false,\"5007\":false,\"5008\":false,\"5010\":false,\"5011\":false,\"5013\":false,\"5015\":false,\"5016\":false,\"5019\":false,\"5020\":false,\"5022\":false,\"5024\":false,\"5025\":false,\"5028\":false,\"5029\":false,\"5031\":false,\"5032\":false,\"5035\":false,\"5037\":false,\"5038\":false,\"5039\":false,\"5042\":false,\"5045\":false,\"5046\":false,\"5048\":false,\"5052\":false,\"5054\":false,\"5057\":false,\"5058\":false,\"5061\":false,\"5062\":false,\"5063\":false,\"5066\":false,\"5069\":false,\"5071\":false,\"5073\":false,\"5074\":false,\"5076\":false,\"5077\":false,\"5080\":false,\"5083\":false,\"5084\":false,\"5085\":false,\"5086\":false,\"5087\":false,\"5088\":false,\"5089\":false,\"5090\":false,\"5091\":false,\"5092\":false,\"5093\":false,\"5094\":false,\"5095\":false,\"5096\":false,\"5097\":false,\"5098\":false,\"5099\":false,\"5100\":false,\"5101\":false,\"5102\":false,\"5103\":false,\"5104\":false,\"5105\":false,\"5106\":false,\"5107\":false,\"5108\":false,\"5109\":false,\"5110\":false,\"5111\":false,\"5112\":false,\"5113\":false,\"5114\":false,\"5115\":false,\"5116\":false,\"5117\":false,\"5118\":false,\"5119\":false,\"5120\":false,\"5121\":false,\"5122\":false,\"5123\":false,\"5124\":false,\"5125\":false,\"5126\":false,\"5127\":false,\"5128\":false,\"5129\":false,\"5130\":false,\"5131\":false,\"5132\":false,\"5133\":false,\"5134\":false,\"5135\":false,\"5136\":false,\"5137\":false,\"5138\":false,\"5139\":false,\"5140\":false,\"5141\":false,\"5142\":false,\"5143\":false,\"5144\":false,\"5145\":false,\"5146\":false,\"5147\":false,\"5148\":false,\"5149\":false,\"5150\":false,\"5151\":false,\"5152\":false,\"5153\":false,\"5154\":false,\"5155\":false,\"5156\":false,\"5157\":false,\"5158\":false,\"5159\":false,\"5160\":false,\"5161\":false,\"5162\":false,\"5163\":false,\"5164\":false,\"5165\":false,\"5166\":false,\"5167\":false,\"5168\":false,\"5172\":false,\"5175\":false,\"5178\":false,\"5180\":false,\"5179\":false,\"5181\":false,\"5182\":false,\"5183\":false,\"5184\":false,\"5185\":false,\"5186\":false,\"5187\":false,\"5188\":false,\"5189\":false,\"5190\":false,\"5191\":false,\"5192\":false,\"5193\":false,\"5194\":false,\"5195\":false,\"5196\":false,\"5197\":false,\"5198\":false,\"5199\":false,\"5200\":false,\"5201\":false,\"5202\":false,\"5203\":false,\"5204\":false,\"5205\":false,\"5206\":false,\"5207\":false,\"5208\":false,\"5209\":false,\"5210\":false,\"5211\":false,\"5212\":false,\"5213\":false,\"5214\":false,\"5215\":false,\"5216\":false,\"5217\":false,\"5218\":false,\"5219\":false,\"5220\":false,\"5221\":false,\"5222\":false,\"5223\":false,\"5224\":false,\"5225\":false,\"5226\":false,\"5227\":false,\"5228\":false,\"5229\":false,\"5230\":false,\"5231\":false,\"5232\":false,\"5233\":false,\"5234\":false,\"5235\":false,\"5236\":false,\"5237\":false,\"5238\":false,\"5239\":false,\"5240\":false,\"5241\":false,\"5242\":false,\"5243\":false,\"5244\":false,\"5245\":false,\"5246\":false,\"5247\":false,\"5248\":false,\"5249\":false,\"5250\":false,\"5251\":false,\"5252\":false,\"5253\":false,\"5254\":false,\"5255\":false,\"5256\":false,\"5257\":false,\"5258\":false,\"5259\":false,\"5260\":false,\"5261\":false,\"5262\":false,\"5263\":false,\"5264\":false,\"5265\":false,\"5266\":false,\"5267\":false,\"5268\":false,\"5269\":false,\"5270\":false,\"5271\":false,\"5272\":false,\"5273\":false,\"5274\":false,\"5275\":false,\"5276\":false,\"5277\":false,\"5278\":false,\"5279\":false,\"5280\":false,\"5281\":false,\"5282\":false,\"5283\":false,\"5284\":false,\"5285\":false,\"5286\":false,\"5287\":false,\"5288\":false,\"5289\":false,\"5290\":false,\"5291\":false,\"5292\":false,\"5293\":false,\"5294\":false,\"5295\":false,\"5296\":false,\"5297\":false,\"5298\":false,\"5299\":false,\"5300\":false,\"5301\":false,\"5302\":false,\"5303\":false,\"5304\":false,\"5305\":false,\"5306\":false,\"5307\":false,\"5308\":false,\"5309\":false,\"5310\":false,\"5311\":false,\"5312\":false,\"5313\":false,\"5314\":false,\"5315\":false,\"5316\":false,\"5317\":false,\"5318\":false,\"5319\":false,\"5320\":false,\"5321\":false,\"5322\":false,\"5323\":false,\"5324\":false,\"5325\":false,\"5326\":false,\"5327\":false,\"5328\":false,\"5329\":false,\"5330\":false,\"5331\":false,\"5332\":false,\"5333\":false,\"5334\":false,\"5335\":false,\"5336\":false,\"5337\":false,\"5338\":false,\"5339\":false,\"5340\":false,\"5341\":false,\"5342\":false,\"5343\":false,\"5344\":false,\"5345\":false,\"5346\":false,\"5347\":false,\"5348\":false,\"5349\":false,\"5350\":false,\"5351\":false,\"5352\":false,\"5353\":false,\"5354\":false,\"5355\":false,\"5356\":false,\"5357\":false,\"5358\":false,\"5359\":false,\"5360\":false,\"5361\":false,\"5362\":false,\"5363\":false,\"5364\":false,\"5365\":false,\"5366\":false,\"5367\":false,\"5368\":false,\"5369\":false,\"5370\":false,\"5371\":false,\"5372\":false,\"5373\":false,\"5374\":false,\"5375\":false,\"5376\":false,\"5377\":false,\"5378\":false,\"5379\":false,\"5380\":false,\"5381\":false,\"5382\":false,\"5383\":false,\"5384\":false,\"5385\":false,\"5386\":false,\"5387\":false,\"5388\":false,\"5389\":false,\"5390\":false,\"5391\":false,\"5392\":false,\"5393\":false,\"5394\":false,\"5395\":false,\"5396\":false,\"5397\":false,\"5398\":false,\"5399\":false,\"5400\":false,\"5401\":false,\"5402\":false,\"5403\":false,\"5404\":false,\"5405\":false,\"5406\":false,\"5407\":false,\"5408\":false,\"5409\":false,\"5410\":false,\"5411\":false,\"5412\":false,\"5413\":false,\"5414\":false,\"5415\":false,\"5416\":false,\"5417\":false,\"5418\":false,\"5419\":false,\"5420\":false,\"5421\":false,\"5422\":false,\"5423\":false,\"5424\":false,\"5425\":false,\"5426\":false,\"5427\":false,\"5428\":false,\"5429\":false,\"5430\":false,\"5431\":false,\"5432\":false,\"5433\":false,\"5434\":false,\"5435\":false,\"5436\":false,\"5437\":false,\"5438\":false,\"5439\":false,\"5440\":false,\"5441\":false,\"5442\":false,\"5443\":false,\"5444\":false,\"5445\":false,\"5446\":false,\"5447\":false,\"5448\":false,\"5449\":false,\"5450\":false,\"5451\":false,\"5452\":false,\"5453\":false,\"5454\":false,\"5455\":false,\"5456\":false,\"5457\":false,\"5458\":false,\"5459\":false,\"5460\":false,\"5461\":false,\"5462\":false,\"5463\":false,\"5464\":false,\"5465\":false,\"5466\":false,\"5467\":false,\"5468\":false,\"5469\":false,\"5470\":false,\"5471\":false,\"5472\":false,\"5473\":false,\"5474\":false,\"5475\":false,\"5476\":false,\"5477\":false,\"5478\":false,\"5479\":false,\"5480\":false,\"5481\":false,\"5482\":false,\"5483\":false,\"5484\":false,\"5485\":false,\"5486\":false,\"5487\":false,\"5488\":false,\"5489\":false,\"5490\":false,\"5491\":false,\"5492\":false,\"5493\":false,\"5494\":false,\"5495\":false,\"5496\":false,\"5497\":false,\"5498\":false,\"5499\":false,\"5500\":false,\"5501\":false,\"5502\":false,\"5503\":false,\"5504\":false,\"5505\":false,\"5506\":false,\"5507\":false,\"5508\":false,\"5509\":false,\"5510\":false,\"5511\":false,\"5512\":false,\"5513\":false,\"5514\":false,\"5515\":false,\"5516\":false,\"5517\":false,\"5518\":false,\"5519\":false,\"5520\":false,\"5521\":false,\"5522\":false,\"5523\":false,\"5524\":false,\"5525\":false,\"5526\":false,\"5527\":false,\"5528\":false,\"5529\":false,\"5530\":false,\"5531\":false,\"5532\":false,\"5533\":false,\"5534\":false,\"5535\":false,\"5536\":false,\"5537\":false,\"5538\":false,\"5539\":false,\"5540\":false,\"5541\":false,\"5542\":false,\"5543\":false,\"5544\":false,\"5545\":false,\"5546\":false,\"5547\":false,\"5548\":false,\"5549\":false,\"5550\":false,\"5551\":false,\"5552\":false,\"5553\":false,\"5554\":false,\"5555\":false,\"5556\":false,\"5557\":false,\"5558\":false,\"5559\":false,\"5560\":false,\"5561\":false,\"5562\":false,\"5563\":false,\"5564\":false,\"5565\":false,\"5566\":false,\"5567\":false,\"5568\":false,\"5569\":false,\"5570\":false,\"5571\":false,\"5572\":false,\"5573\":false,\"5574\":false,\"5575\":false,\"5576\":false,\"5577\":false,\"5578\":false,\"5579\":false,\"5580\":false,\"5581\":false,\"5582\":false,\"5583\":false,\"5584\":false,\"5585\":false,\"5586\":false,\"5587\":false,\"5588\":false,\"5589\":false,\"5590\":false,\"5591\":false,\"5592\":false,\"5593\":false,\"5594\":false,\"5595\":false,\"5596\":false,\"5597\":false,\"5598\":false,\"5599\":false,\"5600\":false,\"5601\":false,\"5602\":false,\"5603\":false,\"5604\":false,\"5605\":false,\"5606\":false,\"5607\":false,\"5608\":false,\"5609\":false,\"5610\":false,\"5611\":false,\"5612\":false,\"5613\":false,\"5614\":false,\"5615\":false,\"5616\":false,\"5617\":false,\"5618\":false,\"5619\":false,\"5620\":false,\"5621\":false,\"5622\":false,\"5623\":false,\"5624\":false,\"5625\":false,\"5626\":false,\"5627\":false,\"5628\":false,\"5629\":false,\"5630\":false,\"5631\":false,\"5632\":false,\"5633\":false,\"5634\":false,\"5635\":false,\"5636\":false,\"5637\":false,\"5638\":false,\"5639\":false,\"5640\":false,\"5641\":false,\"5642\":false,\"5643\":false,\"5644\":false,\"5645\":false,\"5646\":false,\"5647\":false,\"5648\":false,\"5649\":false,\"5650\":false,\"5651\":false,\"5652\":false,\"5653\":false,\"5654\":false,\"5655\":false,\"5656\":false,\"5657\":false,\"5658\":false,\"5659\":false,\"5660\":false,\"5661\":false,\"5662\":false,\"5663\":false,\"5664\":false,\"5665\":false,\"5666\":false,\"5667\":false,\"5668\":false,\"5669\":false,\"5670\":false,\"5671\":false,\"5672\":false,\"5673\":false,\"5674\":false,\"5675\":false,\"5676\":false,\"5677\":false,\"5678\":false,\"5679\":false,\"5680\":false,\"5681\":false,\"5682\":false,\"5683\":false,\"5684\":false,\"5685\":false,\"5686\":false,\"5687\":false,\"5688\":false,\"5689\":false,\"5690\":false,\"5691\":false,\"5692\":false,\"5693\":false,\"5694\":false,\"5695\":false,\"5696\":false,\"5697\":false,\"5698\":false,\"5699\":false,\"5700\":false,\"5701\":false,\"5702\":false,\"5703\":false,\"5704\":false,\"5705\":false,\"5706\":false,\"5707\":false,\"5708\":false,\"5709\":false,\"5710\":false,\"5711\":false,\"5712\":false,\"5713\":false,\"5714\":false,\"5715\":false,\"5716\":false,\"5717\":false,\"5718\":false,\"5719\":false,\"5720\":false,\"5721\":false,\"5722\":false,\"5723\":false,\"5724\":false,\"5725\":false,\"5726\":false,\"5727\":false,\"5728\":false,\"5729\":false,\"5730\":false,\"5731\":false,\"5732\":false,\"5733\":false,\"5734\":false,\"5735\":false,\"5736\":false,\"5737\":false,\"5738\":false,\"5739\":false,\"5740\":false,\"5741\":false,\"5742\":false,\"5743\":false,\"5744\":false,\"5745\":false,\"5746\":false,\"5747\":false,\"5748\":false,\"5749\":false,\"5750\":false,\"5751\":false,\"5752\":false,\"5753\":false,\"5754\":false,\"5755\":false,\"5756\":false,\"5757\":false,\"5758\":false,\"5759\":false,\"5760\":false,\"5761\":false,\"5762\":false,\"5763\":false,\"5764\":false,\"5765\":false,\"5766\":false,\"5767\":false,\"5768\":false,\"5769\":false,\"5770\":false,\"5771\":false,\"5772\":false,\"5773\":false,\"5774\":false,\"5775\":false,\"5776\":false,\"5777\":false,\"5778\":false,\"5779\":false,\"5780\":false,\"5781\":false,\"5782\":false,\"5783\":false,\"5784\":false,\"5785\":false,\"5786\":false,\"5787\":false,\"5788\":false,\"5789\":false,\"5790\":false,\"5791\":false,\"5792\":false,\"5793\":false,\"5794\":false,\"5795\":false,\"5796\":false,\"5797\":false,\"5798\":false,\"5799\":false,\"5800\":false,\"5801\":false,\"5802\":false,\"5803\":false,\"5804\":false,\"5805\":false,\"5806\":false,\"5807\":false,\"5808\":false,\"5809\":false,\"5810\":false,\"5811\":false,\"5812\":false,\"5813\":false,\"5814\":false,\"5815\":false,\"5816\":false,\"5817\":false,\"5818\":false,\"5819\":false,\"5820\":false,\"5821\":false,\"5822\":false,\"5823\":false,\"5824\":false,\"5825\":false,\"5826\":false,\"5827\":false,\"5828\":false,\"5829\":false,\"5830\":false,\"5831\":false,\"5832\":false,\"5833\":false,\"5834\":false,\"5835\":false,\"5836\":false,\"5837\":false,\"5838\":false,\"5839\":false,\"5840\":false,\"5841\":false,\"5842\":false,\"5843\":false,\"5844\":false,\"5845\":false,\"5846\":false,\"5847\":false,\"5848\":false,\"5849\":false,\"5850\":false,\"5851\":false,\"5852\":false,\"5853\":false,\"5854\":false,\"5855\":false,\"5856\":false,\"5857\":false,\"5858\":false,\"5859\":false,\"5860\":false,\"5861\":false,\"5862\":false,\"5863\":false,\"5864\":false,\"5865\":false,\"5866\":false,\"5867\":false,\"5868\":false,\"5869\":false,\"5870\":false,\"5871\":false,\"5872\":false,\"5873\":false,\"5874\":false,\"5875\":false,\"5876\":false,\"5877\":false,\"5878\":false,\"5879\":false,\"5880\":false,\"5881\":false,\"5882\":false,\"5883\":false,\"5884\":false,\"5885\":false,\"5886\":false,\"5887\":false,\"5888\":false,\"5889\":false,\"5890\":false,\"5891\":false,\"5892\":false,\"5893\":false,\"5894\":false,\"5895\":false,\"5896\":false,\"5897\":false,\"5898\":false,\"5899\":false,\"5900\":false,\"5901\":false,\"5902\":false,\"5903\":false,\"5904\":false,\"5905\":false,\"5906\":false,\"5907\":false,\"5908\":false,\"5909\":false,\"5910\":false,\"5911\":false,\"5912\":false,\"5913\":false,\"5914\":false,\"5915\":false,\"5916\":false,\"5917\":false,\"5918\":false,\"5919\":false,\"5920\":false,\"5921\":false,\"5922\":false,\"5923\":false,\"5924\":false,\"5925\":false,\"5926\":false,\"5927\":false,\"5928\":false,\"5929\":false,\"5930\":false,\"5931\":false,\"5932\":false,\"5933\":false,\"5934\":false,\"5935\":false,\"5936\":false,\"5938\":false,\"5939\":false,\"5940\":false,\"5941\":false,\"5942\":false,\"5943\":false,\"5944\":false,\"5945\":false,\"5946\":false,\"5947\":false,\"5948\":false,\"5949\":false,\"5950\":false,\"5951\":false,\"5952\":false,\"5953\":false,\"5954\":false,\"5955\":false,\"5956\":false,\"5957\":false,\"5958\":false,\"5959\":false,\"5960\":false,\"5961\":false,\"5962\":false,\"5963\":false,\"5964\":false,\"5965\":false,\"5966\":false,\"5967\":false,\"5968\":false,\"5969\":false,\"5970\":false,\"5971\":false,\"5972\":false,\"5973\":false,\"5974\":false,\"5975\":false,\"5976\":false,\"5977\":false,\"5978\":false,\"5979\":false,\"5980\":false,\"5981\":false,\"5982\":false,\"5983\":false,\"5984\":false,\"5985\":false,\"5986\":false,\"5987\":false,\"5988\":false,\"5989\":false,\"5990\":false,\"5991\":false,\"5992\":false,\"5995\":false,\"5996\":false,\"5997\":false,\"5998\":false,\"5999\":false,\"6000\":false,\"6001\":false,\"6002\":false,\"6003\":false,\"6004\":false,\"6005\":false,\"6006\":false,\"6007\":false,\"6008\":false,\"6009\":false,\"6010\":false,\"6011\":false,\"6012\":false,\"6013\":false,\"6014\":false,\"6015\":false,\"6016\":false,\"6017\":false,\"6018\":false,\"6019\":false,\"6020\":false,\"6021\":false,\"6022\":false,\"6023\":false,\"6024\":false,\"6025\":false,\"6026\":false,\"6027\":false,\"6028\":false,\"6029\":false,\"6030\":false,\"6031\":false,\"6032\":false,\"6033\":false,\"6034\":false,\"6035\":false,\"6036\":false,\"6037\":false,\"6038\":false,\"6039\":false,\"6040\":false,\"6041\":false,\"6042\":false,\"6043\":false,\"6044\":false,\"6045\":false,\"6046\":false,\"6047\":false,\"6048\":false,\"6049\":false,\"6050\":false,\"6051\":false,\"6052\":false,\"6053\":false,\"6054\":false,\"6055\":false,\"6056\":false,\"6057\":false,\"6058\":false,\"6059\":false,\"6060\":false,\"6061\":false,\"6062\":false,\"6063\":false,\"6064\":false,\"6065\":false,\"6066\":false,\"6067\":false,\"6068\":false,\"6069\":false,\"6070\":false,\"6071\":false,\"6072\":false,\"6073\":false,\"6074\":false,\"6075\":false,\"6076\":false,\"6077\":false,\"6078\":false,\"6079\":false,\"6080\":false,\"6081\":false,\"6082\":false,\"6083\":false,\"6084\":false,\"6085\":false,\"6086\":false,\"6087\":false,\"6088\":false,\"6089\":false,\"6090\":false,\"6091\":false,\"6092\":false,\"6093\":false,\"6094\":false,\"6095\":false,\"6096\":false,\"6097\":false,\"6098\":false,\"6099\":false,\"6100\":false,\"6101\":false,\"6102\":false,\"6103\":false,\"6104\":false,\"6106\":false,\"6107\":false,\"6108\":false,\"6109\":false,\"6110\":false,\"6111\":false,\"6112\":false,\"6113\":false,\"6114\":false,\"6115\":false,\"6116\":false,\"6117\":false,\"6118\":false,\"6119\":false,\"6120\":false,\"6121\":false,\"6122\":false,\"6123\":false,\"6124\":false,\"6125\":false,\"6126\":false,\"6127\":false,\"6128\":false,\"6129\":false,\"6130\":false,\"6131\":false,\"6132\":false,\"6133\":false,\"6134\":false,\"6135\":false,\"6136\":false,\"6137\":false,\"6138\":false,\"6139\":false,\"6140\":false,\"6141\":false,\"6142\":false,\"6143\":false,\"6144\":false,\"6145\":false,\"6146\":false,\"6147\":false,\"6148\":false,\"6149\":false,\"6150\":false,\"6151\":false,\"6152\":false,\"6153\":false,\"6154\":false,\"6155\":false,\"6156\":false,\"6157\":false,\"6158\":false,\"6159\":false,\"6160\":false,\"6161\":false,\"6162\":false,\"6163\":false,\"6164\":false,\"6165\":false,\"6166\":false,\"6167\":false,\"6168\":false,\"6169\":false,\"6170\":false,\"6171\":false,\"6172\":false,\"6173\":false,\"6174\":false,\"6175\":false,\"6176\":false,\"6177\":false,\"6178\":false,\"6179\":false,\"6180\":false}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (844,'fusion_dynamic_css_ids','{{SHIPPER_JSON_START}}{\"78\":\"e7924c071b5c271f23568bf4324b3fd4\",\"204\":false,\"205\":false,\"global\":\"fb1bd6857539aa50b06986cc6355181b\",\"206\":false,\"207\":false,\"208\":false,\"209\":false,\"210\":false,\"211\":false,\"212\":false,\"213\":false,\"214\":false,\"215\":false,\"216\":false,\"158\":\"3999fc7bbc462a932a9aa2b1dc00d5da\",\"217\":false,\"218\":false,\"219\":false,\"220\":false,\"221\":false,\"222\":false,\"223\":false,\"224\":false,\"225\":false,\"226\":false,\"227\":false,\"228\":false,\"229\":false,\"230\":false,\"231\":false,\"232\":false,\"233\":false,\"234\":false,\"235\":false,\"236\":false,\"237\":false,\"238\":false,\"239\":false,\"240\":false,\"241\":false,\"242\":false,\"243\":false,\"244\":false,\"245\":false,\"246\":false,\"247\":false,\"248\":false,\"250\":false,\"252\":false,\"255\":false,\"257\":false,\"259\":false,\"261\":false,\"263\":false,\"266\":false,\"268\":false,\"269\":false,\"271\":false,\"273\":false,\"275\":false,\"278\":false,\"279\":false,\"283\":false,\"286\":false,\"289\":false,\"290\":false,\"292\":false,\"295\":false,\"296\":false,\"298\":false,\"301\":false,\"302\":false,\"305\":false,\"306\":false,\"308\":false,\"310\":false,\"312\":false,\"314\":false,\"316\":false,\"317\":false,\"319\":false,\"321\":false,\"323\":false,\"326\":false,\"328\":false,\"331\":false,\"333\":false,\"335\":false,\"336\":false,\"338\":false,\"340\":false,\"342\":false,\"345\":false,\"347\":false,\"348\":false,\"351\":false,\"353\":false,\"354\":false,\"357\":false,\"359\":false,\"361\":false,\"362\":false,\"364\":false,\"365\":false,\"367\":false,\"369\":false,\"371\":false,\"373\":false,\"376\":false,\"378\":false,\"381\":false,\"383\":false,\"384\":false,\"385\":false,\"387\":false,\"389\":false,\"392\":false,\"394\":false,\"395\":false,\"396\":false,\"397\":false,\"398\":false,\"399\":false,\"401\":false,\"402\":false,\"404\":false,\"406\":false,\"407\":false,\"410\":false,\"412\":false,\"414\":false,\"415\":false,\"418\":false,\"419\":false,\"420\":false,\"423\":false,\"424\":false,\"426\":false,\"428\":false,\"430\":false,\"432\":false,\"433\":false,\"436\":false,\"438\":false,\"440\":false,\"441\":false,\"443\":false,\"446\":false,\"447\":false,\"450\":false,\"452\":false,\"454\":false,\"457\":false,\"459\":false,\"460\":false,\"462\":false,\"464\":false,\"466\":false,\"468\":false,\"470\":false,\"472\":false,\"474\":false,\"476\":false,\"479\":false,\"480\":false,\"482\":false,\"484\":false,\"486\":false,\"487\":false,\"489\":false,\"491\":false,\"493\":false,\"495\":false,\"496\":false,\"498\":false,\"500\":false,\"501\":false,\"502\":false,\"504\":false,\"505\":false,\"508\":false,\"510\":false,\"512\":false,\"513\":false,\"515\":false,\"517\":false,\"520\":false,\"522\":false,\"524\":false,\"526\":false,\"527\":false,\"530\":false,\"532\":false,\"533\":false,\"536\":false,\"538\":false,\"539\":false,\"542\":false,\"543\":false,\"545\":false,\"547\":false,\"548\":false,\"550\":false,\"552\":false,\"554\":false,\"556\":false,\"558\":false,\"560\":false,\"563\":false,\"565\":false,\"567\":false,\"569\":false,\"571\":false,\"573\":false,\"575\":false,\"577\":false,\"579\":false,\"581\":false,\"583\":false,\"585\":false,\"587\":false,\"590\":false,\"592\":false,\"594\":false,\"596\":false,\"597\":false,\"598\":false,\"600\":false,\"601\":false,\"604\":false,\"606\":false,\"607\":false,\"611\":false,\"613\":false,\"615\":false,\"616\":false,\"617\":false,\"620\":false,\"621\":false,\"623\":false,\"626\":false,\"627\":false,\"629\":false,\"632\":false,\"633\":false,\"636\":false,\"637\":false,\"640\":false,\"641\":false,\"643\":false,\"644\":false,\"647\":false,\"648\":false,\"651\":false,\"652\":false,\"655\":false,\"657\":false,\"659\":false,\"660\":false,\"662\":false,\"665\":false,\"666\":false,\"669\":false,\"671\":false,\"672\":false,\"675\":false,\"676\":false,\"679\":false,\"682\":false,\"683\":false,\"685\":false,\"687\":false,\"688\":false,\"691\":false,\"693\":false,\"695\":false,\"696\":false,\"699\":false,\"701\":false,\"702\":false,\"704\":false,\"707\":false,\"710\":false,\"713\":false,\"715\":false,\"717\":false,\"719\":false,\"721\":false,\"722\":false,\"725\":false,\"726\":false,\"729\":false,\"731\":false,\"732\":false,\"733\":false,\"734\":false,\"735\":false,\"736\":false,\"737\":false,\"738\":false,\"739\":false,\"740\":false,\"741\":false,\"742\":false,\"743\":false,\"744\":false,\"745\":false,\"746\":false,\"747\":false,\"748\":false,\"749\":false,\"750\":false,\"751\":false,\"752\":false,\"753\":false,\"754\":false,\"755\":false,\"756\":false,\"757\":false,\"758\":false,\"759\":false,\"760\":false,\"761\":false,\"762\":false,\"763\":false,\"764\":false,\"765\":false,\"766\":false,\"767\":false,\"768\":false,\"769\":false,\"770\":false,\"771\":false,\"772\":false,\"773\":false,\"774\":false,\"775\":false,\"776\":false,\"777\":false,\"778\":false,\"779\":false,\"780\":false,\"781\":false,\"782\":false,\"783\":false,\"784\":false,\"785\":false,\"786\":false,\"787\":false,\"788\":false,\"789\":false,\"790\":false,\"791\":false,\"792\":false,\"793\":false,\"794\":false,\"795\":false,\"796\":false,\"797\":false,\"798\":false,\"799\":false,\"800\":false,\"801\":false,\"802\":false,\"803\":false,\"804\":false,\"805\":false,\"806\":false,\"807\":false,\"808\":false,\"809\":false,\"810\":false,\"811\":false,\"812\":false,\"813\":false,\"814\":false,\"815\":false,\"816\":false,\"817\":false,\"818\":false,\"819\":false,\"820\":false,\"821\":false,\"822\":false,\"823\":false,\"824\":false,\"825\":false,\"826\":false,\"827\":false,\"828\":false,\"829\":false,\"830\":false,\"831\":false,\"832\":false,\"833\":false,\"834\":false,\"835\":false,\"836\":false,\"837\":false,\"838\":false,\"839\":false,\"840\":false,\"841\":false,\"842\":false,\"843\":false,\"844\":false,\"845\":false,\"846\":false,\"847\":false,\"848\":false,\"849\":false,\"850\":false,\"851\":false,\"852\":false,\"853\":false,\"854\":false,\"855\":false,\"856\":false,\"857\":false,\"858\":false,\"859\":false,\"860\":false,\"861\":false,\"862\":false,\"863\":false,\"864\":false,\"865\":false,\"866\":false,\"867\":false,\"868\":false,\"869\":false,\"870\":false,\"871\":false,\"872\":false,\"873\":false,\"874\":false,\"875\":false,\"876\":false,\"877\":false,\"878\":false,\"879\":false,\"880\":false,\"881\":false,\"882\":false,\"883\":false,\"884\":false,\"885\":false,\"886\":false,\"887\":false,\"888\":false,\"889\":false,\"890\":false,\"891\":false,\"892\":false,\"893\":false,\"894\":false,\"895\":false,\"896\":false,\"897\":false,\"898\":false,\"899\":false,\"900\":false,\"901\":false,\"902\":false,\"903\":false,\"904\":false,\"905\":false,\"906\":false,\"907\":false,\"908\":false,\"909\":false,\"910\":false,\"911\":false,\"912\":false,\"913\":false,\"914\":false,\"915\":false,\"916\":false,\"917\":false,\"918\":false,\"919\":false,\"920\":false,\"921\":false,\"922\":false,\"923\":false,\"924\":false,\"925\":false,\"926\":false,\"927\":false,\"928\":false,\"929\":false,\"930\":false,\"931\":false,\"932\":false,\"933\":false,\"934\":false,\"935\":false,\"936\":false,\"937\":false,\"938\":false,\"939\":false,\"940\":false,\"941\":false,\"942\":false,\"943\":false,\"944\":false,\"945\":false,\"946\":false,\"947\":false,\"948\":false,\"949\":false,\"950\":false,\"951\":false,\"952\":false,\"953\":false,\"954\":false,\"955\":false,\"956\":false,\"957\":false,\"958\":false,\"959\":false,\"960\":false,\"961\":false,\"962\":false,\"963\":false,\"964\":false,\"965\":false,\"966\":false,\"967\":false,\"968\":false,\"969\":false,\"970\":false,\"971\":false,\"972\":false,\"973\":false,\"974\":false,\"975\":false,\"976\":false,\"977\":false,\"978\":false,\"979\":false,\"980\":false,\"981\":false,\"982\":false,\"983\":false,\"984\":false,\"985\":false,\"986\":false,\"987\":false,\"988\":false,\"989\":false,\"990\":false,\"991\":false,\"992\":false,\"993\":false,\"994\":false,\"995\":false,\"996\":false,\"997\":false,\"998\":false,\"999\":false,\"1000\":false,\"1001\":false,\"1002\":false,\"1003\":false,\"1004\":false,\"1005\":false,\"1006\":false,\"1007\":false,\"1008\":false,\"1009\":false,\"1010\":false,\"1011\":false,\"1012\":false,\"1013\":false,\"1014\":false,\"1015\":false,\"1016\":false,\"1017\":false,\"1018\":false,\"1019\":false,\"1020\":false,\"1021\":false,\"1022\":false,\"1023\":false,\"1024\":false,\"1025\":false,\"1026\":false,\"1027\":false,\"1028\":false,\"1029\":false,\"1030\":false,\"1031\":false,\"1032\":false,\"1033\":false,\"1034\":false,\"1035\":false,\"1036\":false,\"1037\":false,\"1038\":false,\"1039\":false,\"1040\":false,\"1041\":false,\"1042\":false,\"1043\":false,\"1044\":false,\"1045\":false,\"1046\":false,\"1047\":false,\"1048\":false,\"1049\":false,\"1050\":false,\"1051\":false,\"1052\":false,\"1053\":false,\"1054\":false,\"1055\":false,\"1056\":false,\"1057\":false,\"1058\":false,\"1059\":false,\"1060\":false,\"1061\":false,\"1062\":false,\"1063\":false,\"1064\":false,\"1065\":false,\"1066\":false,\"1067\":false,\"1068\":false,\"1069\":false,\"1070\":false,\"1071\":false,\"1072\":false,\"1073\":false,\"1074\":false,\"1075\":false,\"1076\":false,\"1077\":false,\"1078\":false,\"1079\":false,\"1080\":false,\"1081\":false,\"1082\":false,\"1083\":false,\"1084\":false,\"1085\":false,\"1086\":false,\"1087\":false,\"1088\":false,\"1089\":false,\"1090\":false,\"1091\":false,\"1092\":false,\"1093\":false,\"1094\":false,\"1095\":false,\"1096\":false,\"1097\":false,\"1098\":false,\"1099\":false,\"1100\":false,\"1101\":false,\"1102\":false,\"1103\":false,\"1104\":false,\"1105\":false,\"1106\":false,\"1107\":false,\"1108\":false,\"1109\":false,\"1110\":false,\"1111\":false,\"1112\":false,\"1113\":false,\"1114\":false,\"1115\":false,\"1116\":false,\"1117\":false,\"1118\":false,\"1119\":false,\"1120\":false,\"1121\":false,\"1122\":false,\"1123\":false,\"1124\":false,\"1125\":false,\"1126\":false,\"1127\":false,\"1128\":false,\"1129\":false,\"1130\":false,\"1131\":false,\"1132\":false,\"1133\":false,\"1134\":false,\"1135\":false,\"1136\":false,\"1137\":false,\"1138\":false,\"1139\":false,\"1140\":false,\"1141\":false,\"1142\":false,\"1143\":false,\"1145\":false,\"1147\":false,\"1149\":false,\"1152\":false,\"1154\":false,\"1155\":false,\"1157\":false,\"1159\":false,\"1160\":false,\"1163\":false,\"1164\":false,\"1167\":false,\"1169\":false,\"1170\":false,\"1173\":false,\"1175\":false,\"1176\":false,\"1179\":false,\"1181\":false,\"1184\":false,\"1185\":false,\"1188\":false,\"1190\":false,\"1191\":false,\"1194\":false,\"1196\":false,\"1197\":false,\"1200\":false,\"1202\":false,\"1203\":false,\"1205\":false,\"1207\":false,\"1210\":false,\"1211\":false,\"1214\":false,\"1215\":false,\"1217\":false,\"1218\":false,\"1221\":false,\"1223\":false,\"1225\":false,\"1226\":false,\"1227\":false,\"1229\":false,\"1231\":false,\"1232\":false,\"1235\":false,\"1237\":false,\"1239\":false,\"1241\":false,\"1243\":false,\"1244\":false,\"1246\":false,\"1248\":false,\"1250\":false,\"1253\":false,\"1256\":false,\"1258\":false,\"1261\":false,\"1262\":false,\"1264\":false,\"1267\":false,\"1268\":false,\"1270\":false,\"1273\":false,\"1274\":false,\"1277\":false,\"1279\":false,\"1280\":false,\"1281\":false,\"1283\":false,\"1285\":false,\"1288\":false,\"1290\":false,\"1291\":false,\"1292\":false,\"1294\":false,\"1296\":false,\"1297\":false,\"1298\":false,\"1299\":false,\"1302\":false,\"1304\":false,\"1306\":false,\"1308\":false,\"1310\":false,\"1313\":false,\"1314\":false,\"1316\":false,\"1319\":false,\"1320\":false,\"1322\":false,\"1325\":false,\"1326\":false,\"1329\":false,\"1330\":false,\"1333\":false,\"1335\":false,\"1336\":false,\"1339\":false,\"1341\":false,\"1342\":false,\"1343\":false,\"1346\":false,\"1347\":false,\"1350\":false,\"1352\":false,\"1355\":false,\"1356\":false,\"1359\":false,\"1360\":false,\"1361\":false,\"1364\":false,\"1367\":false,\"1368\":false,\"1371\":false,\"1373\":false,\"1375\":false,\"1378\":false,\"1379\":false,\"1382\":false,\"1383\":false,\"1386\":false,\"1388\":false,\"1390\":false,\"1391\":false,\"1393\":false,\"1396\":false,\"1397\":false,\"1398\":false,\"1400\":false,\"1403\":false,\"1406\":false,\"1408\":false,\"1409\":false,\"1412\":false,\"1414\":false,\"1415\":false,\"1418\":false,\"1420\":false,\"1421\":false,\"1424\":false,\"1427\":false,\"1428\":false,\"1431\":false,\"1433\":false,\"1435\":false,\"1436\":false,\"1437\":false,\"1438\":false,\"1440\":false,\"1442\":false,\"1445\":false,\"1448\":false,\"1451\":false,\"1453\":false,\"1456\":false,\"1458\":false,\"1460\":false,\"1461\":false,\"1463\":false,\"1466\":false,\"1467\":false,\"1470\":false,\"1471\":false,\"1474\":false,\"1476\":false,\"1478\":false,\"1479\":false,\"1480\":false,\"1482\":false,\"1484\":false,\"1485\":false,\"1486\":false,\"1487\":false,\"1488\":false,\"1489\":false,\"1490\":false,\"1491\":false,\"1492\":false,\"1493\":false,\"1494\":false,\"1495\":false,\"1496\":false,\"1497\":false,\"1498\":false,\"1499\":false,\"1500\":false,\"1501\":false,\"1502\":false,\"1503\":false,\"1505\":false,\"1506\":false,\"1508\":false,\"1510\":false,\"1511\":false,\"1512\":false,\"1514\":false,\"1516\":false,\"1518\":false,\"1520\":false,\"1524\":false,\"1526\":false,\"1529\":false,\"1531\":false,\"1532\":false,\"1533\":false,\"1534\":false,\"1536\":false,\"1537\":false,\"1539\":false,\"1541\":false,\"1543\":false,\"1545\":false,\"1547\":false,\"1549\":false,\"1551\":false,\"1554\":false,\"1555\":false,\"1557\":false,\"1559\":false,\"1560\":false,\"1562\":false,\"1564\":false,\"1566\":false,\"1568\":false,\"1570\":false,\"1572\":false,\"1574\":false,\"1576\":false,\"1577\":false,\"1580\":false,\"1582\":false,\"1584\":false,\"1585\":false,\"1588\":false,\"1590\":false,\"1592\":false,\"1595\":false,\"1596\":false,\"1598\":false,\"1600\":false,\"1602\":false,\"1605\":false,\"1607\":false,\"1608\":false,\"1610\":false,\"1613\":false,\"1614\":false,\"1617\":false,\"1618\":false,\"1621\":false,\"1623\":false,\"1625\":false,\"1626\":false,\"1629\":false,\"1631\":false,\"1634\":false,\"1636\":false,\"1637\":false,\"1639\":false,\"1643\":false,\"1644\":false,\"1647\":false,\"1649\":false,\"1650\":false,\"1652\":false,\"1654\":false,\"1656\":false,\"1657\":false,\"1660\":false,\"1662\":false,\"1664\":false,\"1666\":false,\"1667\":false,\"1670\":false,\"1672\":false,\"1673\":false,\"1675\":false,\"1678\":false,\"1679\":false,\"1681\":false,\"1683\":false,\"1685\":false,\"1688\":false,\"1690\":false,\"1691\":false,\"1693\":false,\"1695\":false,\"1697\":false,\"1698\":false,\"1700\":false,\"1702\":false,\"1704\":false,\"1706\":false,\"1708\":false,\"1710\":false,\"1712\":false,\"1714\":false,\"1716\":false,\"1718\":false,\"1720\":false,\"1721\":false,\"1724\":false,\"1726\":false,\"1730\":false,\"1732\":false,\"1735\":false,\"1737\":false,\"1739\":false,\"1741\":false,\"1743\":false,\"1744\":false,\"1745\":false,\"1747\":false,\"1749\":false,\"1750\":false,\"1751\":false,\"1752\":false,\"1754\":false,\"1756\":false,\"1758\":false,\"1759\":false,\"1760\":false,\"1763\":false,\"1766\":false,\"1767\":false,\"1768\":false,\"1772\":false,\"1774\":false,\"1776\":false,\"1779\":false,\"1781\":false,\"1782\":false,\"1784\":false,\"1786\":false,\"1789\":false,\"1790\":false,\"1793\":false,\"1795\":false,\"1796\":false,\"1798\":false,\"1801\":false,\"1802\":false,\"1804\":false,\"1807\":false,\"1809\":false,\"1812\":false,\"1814\":false,\"1815\":false,\"1817\":false,\"1819\":false,\"1822\":false,\"1824\":false,\"1826\":false,\"1827\":false,\"1830\":false,\"1832\":false,\"1833\":false,\"1836\":false,\"1838\":false,\"1840\":false,\"1843\":false,\"1845\":false,\"1847\":false,\"1850\":false,\"1852\":false,\"1854\":false,\"1856\":false,\"1858\":false,\"1859\":false,\"1862\":false,\"1863\":false,\"1865\":false,\"1867\":false,\"1869\":false,\"1870\":false,\"1873\":false,\"1875\":false,\"1878\":false,\"1881\":false,\"1883\":false,\"1884\":false,\"1885\":false,\"1886\":false,\"1887\":false,\"1888\":false,\"1889\":false,\"1890\":false,\"1891\":false,\"1892\":false,\"1893\":false,\"1894\":false,\"1895\":false,\"1896\":false,\"1897\":false,\"1898\":false,\"1901\":false,\"1903\":false,\"1906\":false,\"1907\":false,\"1908\":false,\"1909\":false,\"1910\":false,\"1913\":false,\"1916\":false,\"1918\":false,\"1919\":false,\"1922\":false,\"1924\":false,\"1925\":false,\"1927\":false,\"1930\":false,\"1931\":false,\"1934\":false,\"1935\":false,\"1938\":false,\"1940\":false,\"1941\":false,\"1943\":false,\"1945\":false,\"1948\":false,\"1950\":false,\"1952\":false,\"1954\":false,\"1956\":false,\"1957\":false,\"1960\":false,\"1961\":false,\"1963\":false,\"1966\":false,\"1967\":false,\"1970\":false,\"1973\":false,\"1975\":false,\"1978\":false,\"1980\":false,\"1981\":false,\"1984\":false,\"1987\":false,\"1988\":false,\"1991\":false,\"1992\":false,\"1995\":false,\"1998\":false,\"2000\":false,\"2002\":false,\"2005\":false,\"2006\":false,\"2008\":false,\"2011\":false,\"2012\":false,\"2015\":false,\"2017\":false,\"2019\":false,\"2021\":false,\"2023\":false,\"2025\":false,\"2027\":false,\"2029\":false,\"2032\":false,\"2035\":false,\"2037\":false,\"2038\":false,\"2041\":false,\"2044\":false,\"2045\":false,\"2048\":false,\"2049\":false,\"2051\":false,\"2053\":false,\"2056\":false,\"2059\":false,\"2062\":false,\"2063\":false,\"2066\":false,\"2068\":false,\"2069\":false,\"2072\":false,\"2073\":false,\"2074\":false,\"2077\":false,\"2079\":false,\"2081\":false,\"2083\":false,\"2086\":false,\"2089\":false,\"2092\":false,\"2094\":false,\"2097\":false,\"2099\":false,\"2101\":false,\"2103\":false,\"2105\":false,\"2107\":false,\"2109\":false,\"2111\":false,\"2113\":false,\"2115\":false,\"2118\":false,\"2120\":false,\"2122\":false,\"2124\":false,\"2126\":false,\"2128\":false,\"2130\":false,\"2132\":false,\"2134\":false,\"2136\":false,\"2138\":false,\"2141\":false,\"2142\":false,\"2144\":false,\"2146\":false,\"2148\":false,\"2150\":false,\"2152\":false,\"2154\":false,\"2156\":false,\"2158\":false,\"2160\":false,\"2162\":false,\"2164\":false,\"2166\":false,\"2168\":false,\"2170\":false,\"2172\":false,\"2174\":false,\"2176\":false,\"2178\":false,\"2179\":false,\"2182\":false,\"2184\":false,\"2187\":false,\"2190\":false,\"2192\":false,\"2195\":false,\"2198\":false,\"2200\":false,\"2203\":false,\"2204\":false,\"2206\":false,\"2209\":false,\"2210\":false,\"2213\":false,\"2215\":false,\"2217\":false,\"2219\":false,\"2221\":false,\"2222\":false,\"2225\":false,\"2228\":false,\"2230\":false,\"2232\":false,\"2234\":false,\"2236\":false,\"2238\":false,\"2240\":false,\"2241\":false,\"2244\":false,\"2245\":false,\"2247\":false,\"2250\":false,\"2252\":false,\"2254\":false,\"2255\":false,\"2258\":false,\"2260\":false,\"2261\":false,\"2264\":false,\"2265\":false,\"2268\":false,\"2270\":false,\"2272\":false,\"2274\":false,\"2276\":false,\"2278\":false,\"2279\":false,\"2281\":false,\"2283\":false,\"2286\":false,\"2288\":false,\"2290\":false,\"2292\":false,\"2293\":false,\"2297\":false,\"2299\":false,\"2301\":false,\"2302\":false,\"2305\":false,\"2308\":false,\"2310\":false,\"2312\":false,\"2314\":false,\"2316\":false,\"2318\":false,\"2321\":false,\"2322\":false,\"2324\":false,\"2326\":false,\"2328\":false,\"2331\":false,\"2332\":false,\"2335\":false,\"2337\":false,\"2338\":false,\"2341\":false,\"2343\":false,\"2345\":false,\"2346\":false,\"2349\":false,\"2351\":false,\"2352\":false,\"2355\":false,\"2356\":false,\"2359\":false,\"2361\":false,\"2363\":false,\"2365\":false,\"2367\":false,\"2369\":false,\"2370\":false,\"2373\":false,\"2375\":false,\"2376\":false,\"2379\":false,\"2381\":false,\"2382\":false,\"2384\":false,\"2386\":false,\"2388\":false,\"2390\":false,\"2392\":false,\"2394\":false,\"2397\":false,\"2398\":false,\"2401\":false,\"2403\":false,\"2405\":false,\"2406\":false,\"2408\":false,\"2409\":false,\"2410\":false,\"2411\":false,\"2412\":false,\"2413\":false,\"2414\":false,\"2415\":false,\"2416\":false,\"2417\":false,\"2418\":false,\"2419\":false,\"2420\":false,\"2421\":false,\"2422\":false,\"2423\":false,\"2424\":false,\"2425\":false,\"2426\":false,\"2427\":false,\"2428\":false,\"2429\":false,\"2430\":false,\"2431\":false,\"2432\":false,\"2433\":false,\"2434\":false,\"2435\":false,\"2436\":false,\"2437\":false,\"2438\":false,\"2439\":false,\"2440\":false,\"2441\":false,\"2442\":false,\"2443\":false,\"2444\":false,\"2445\":false,\"2446\":false,\"2447\":false,\"2448\":false,\"2449\":false,\"2450\":false,\"2451\":false,\"2452\":false,\"2453\":false,\"2454\":false,\"2455\":false,\"2456\":false,\"2457\":false,\"2458\":false,\"2459\":false,\"2460\":false,\"2461\":false,\"2462\":false,\"2463\":false,\"2464\":false,\"2465\":false,\"2466\":false,\"2467\":false,\"2468\":false,\"2469\":false,\"2470\":false,\"2471\":false,\"2472\":false,\"2473\":false,\"2474\":false,\"2475\":false,\"2476\":false,\"2477\":false,\"2478\":false,\"2479\":false,\"2480\":false,\"2481\":false,\"2482\":false,\"2483\":false,\"2484\":false,\"2485\":false,\"2486\":false,\"2487\":false,\"2488\":false,\"2489\":false,\"2490\":false,\"2491\":false,\"2492\":false,\"2493\":false,\"2494\":false,\"2495\":false,\"2496\":false,\"2497\":false,\"2498\":false,\"2499\":false,\"2500\":false,\"2501\":false,\"2502\":false,\"2503\":false,\"2504\":false,\"2505\":false,\"2506\":false,\"2507\":false,\"2508\":false,\"2509\":false,\"2510\":false,\"2511\":false,\"2512\":false,\"2513\":false,\"2514\":false,\"2515\":false,\"2516\":false,\"2517\":false,\"2518\":false,\"2519\":false,\"2520\":false,\"2521\":false,\"2522\":false,\"2523\":false,\"2524\":false,\"2525\":false,\"2526\":false,\"2527\":false,\"2528\":false,\"2529\":false,\"2530\":false,\"2531\":false,\"2532\":false,\"2533\":false,\"2534\":false,\"2535\":false,\"2536\":false,\"2537\":false,\"2538\":false,\"2539\":false,\"2540\":false,\"2541\":false,\"2542\":false,\"2543\":false,\"2544\":false,\"2545\":false,\"2546\":false,\"2547\":false,\"2548\":false,\"2549\":false,\"2550\":false,\"2551\":false,\"2552\":false,\"2553\":false,\"2554\":false,\"2555\":false,\"2556\":false,\"2557\":false,\"2558\":false,\"2559\":false,\"2560\":false,\"2561\":false,\"2562\":false,\"2563\":false,\"2564\":false,\"2565\":false,\"2566\":false,\"2567\":false,\"2568\":false,\"2569\":false,\"2570\":false,\"2571\":false,\"2572\":false,\"2573\":false,\"2574\":false,\"2575\":false,\"2576\":false,\"2577\":false,\"2578\":false,\"2579\":false,\"2580\":false,\"2581\":false,\"2582\":false,\"2583\":false,\"2584\":false,\"2585\":false,\"2586\":false,\"2587\":false,\"2588\":false,\"2589\":false,\"2590\":false,\"2591\":false,\"2592\":false,\"2593\":false,\"2594\":false,\"2595\":false,\"2596\":false,\"2597\":false,\"2598\":false,\"2599\":false,\"2600\":false,\"2601\":false,\"2602\":false,\"2603\":false,\"2604\":false,\"2605\":false,\"2606\":false,\"2607\":false,\"2608\":false,\"2609\":false,\"2610\":false,\"2611\":false,\"2612\":false,\"2613\":false,\"2614\":false,\"2615\":false,\"2616\":false,\"2617\":false,\"2618\":false,\"2619\":false,\"2620\":false,\"2621\":false,\"2622\":false,\"2623\":false,\"2624\":false,\"2625\":false,\"2626\":false,\"2627\":false,\"2628\":false,\"2629\":false,\"2630\":false,\"2631\":false,\"2632\":false,\"2633\":false,\"2634\":false,\"2635\":false,\"2636\":false,\"2637\":false,\"2638\":false,\"2639\":false,\"2640\":false,\"2641\":false,\"2642\":false,\"2643\":false,\"2644\":false,\"2645\":false,\"2646\":false,\"2647\":false,\"2648\":false,\"2649\":false,\"2650\":false,\"2651\":false,\"2652\":false,\"2653\":false,\"2654\":false,\"2655\":false,\"2656\":false,\"2657\":false,\"2658\":false,\"2659\":false,\"2660\":false,\"2661\":false,\"2662\":false,\"2663\":false,\"2664\":false,\"2665\":false,\"2666\":false,\"2667\":false,\"2668\":false,\"2669\":false,\"2670\":false,\"2671\":false,\"2672\":false,\"2673\":false,\"2674\":false,\"2675\":false,\"2676\":false,\"2677\":false,\"2678\":false,\"2679\":false,\"2680\":false,\"2681\":false,\"2682\":false,\"2683\":false,\"2684\":false,\"2685\":false,\"2686\":false,\"2687\":false,\"2688\":false,\"2689\":false,\"2690\":false,\"2691\":false,\"2692\":false,\"2693\":false,\"2694\":false,\"2695\":false,\"2696\":false,\"2697\":false,\"2698\":false,\"2699\":false,\"2700\":false,\"2701\":false,\"2702\":false,\"2703\":false,\"2704\":false,\"2705\":false,\"2706\":false,\"2707\":false,\"2708\":false,\"2709\":false,\"2710\":false,\"2711\":false,\"2712\":false,\"2713\":false,\"2714\":false,\"2715\":false,\"2716\":false,\"2717\":false,\"2718\":false,\"2719\":false,\"2720\":false,\"2721\":false,\"2722\":false,\"2723\":false,\"2724\":false,\"2725\":false,\"2726\":false,\"2727\":false,\"2728\":false,\"2729\":false,\"2730\":false,\"2731\":false,\"2732\":false,\"2733\":false,\"2734\":false,\"2735\":false,\"2736\":false,\"2737\":false,\"2738\":false,\"2739\":false,\"2740\":false,\"2741\":false,\"2742\":false,\"2743\":false,\"2744\":false,\"2745\":false,\"2746\":false,\"2747\":false,\"2748\":false,\"2749\":false,\"2750\":false,\"2751\":false,\"2752\":false,\"2753\":false,\"2754\":false,\"2755\":false,\"2756\":false,\"2757\":false,\"2758\":false,\"2759\":false,\"2760\":false,\"2761\":false,\"2762\":false,\"2763\":false,\"2764\":false,\"2765\":false,\"2766\":false,\"2767\":false,\"2768\":false,\"2769\":false,\"2770\":false,\"2771\":false,\"2772\":false,\"2773\":false,\"2774\":false,\"2775\":false,\"2776\":false,\"2777\":false,\"2778\":false,\"2779\":false,\"2780\":false,\"2781\":false,\"2782\":false,\"2783\":false,\"2784\":false,\"2785\":false,\"2786\":false,\"2787\":false,\"2788\":false,\"2789\":false,\"2790\":false,\"2791\":false,\"2792\":false,\"2793\":false,\"2794\":false,\"2795\":false,\"2796\":false,\"2797\":false,\"2798\":false,\"2799\":false,\"2800\":false,\"2801\":false,\"2802\":false,\"2803\":false,\"2804\":false,\"2805\":false,\"2806\":false,\"2807\":false,\"2808\":false,\"2809\":false,\"2810\":false,\"2811\":false,\"2812\":false,\"2813\":false,\"2814\":false,\"2815\":false,\"2816\":false,\"2817\":false,\"2818\":false,\"2819\":false,\"2820\":false,\"2821\":false,\"2822\":false,\"2823\":false,\"2824\":false,\"2825\":false,\"2826\":false,\"2827\":false,\"2828\":false,\"2829\":false,\"2830\":false,\"2831\":false,\"2832\":false,\"2833\":false,\"2834\":false,\"2835\":false,\"2836\":false,\"2837\":false,\"2838\":false,\"2839\":false,\"2840\":false,\"2841\":false,\"2842\":false,\"2843\":false,\"2844\":false,\"2845\":false,\"2846\":false,\"2847\":false,\"2848\":false,\"2849\":false,\"2850\":false,\"2851\":false,\"2852\":false,\"2853\":false,\"2854\":false,\"2855\":false,\"2856\":false,\"2857\":false,\"2858\":false,\"2859\":false,\"2860\":false,\"2861\":false,\"2862\":false,\"2863\":false,\"2864\":false,\"2865\":false,\"2866\":false,\"2867\":false,\"2868\":false,\"2869\":false,\"2870\":false,\"2871\":false,\"2872\":false,\"2873\":false,\"2874\":false,\"2875\":false,\"2876\":false,\"2877\":false,\"2878\":false,\"2879\":false,\"2880\":false,\"2881\":false,\"2882\":false,\"2883\":false,\"2884\":false,\"2885\":false,\"2886\":false,\"2887\":false,\"2888\":false,\"2889\":false,\"2890\":false,\"2891\":false,\"2892\":false,\"2893\":false,\"2894\":false,\"2895\":false,\"2896\":false,\"2897\":false,\"2898\":false,\"2899\":false,\"2900\":false,\"2901\":false,\"2902\":false,\"2903\":false,\"2904\":false,\"2905\":false,\"2906\":false,\"2907\":false,\"2908\":false,\"2909\":false,\"2910\":false,\"2911\":false,\"2912\":false,\"2913\":false,\"2914\":false,\"2915\":false,\"2916\":false,\"2917\":false,\"2918\":false,\"2919\":false,\"2920\":false,\"2921\":false,\"2922\":false,\"2923\":false,\"2924\":false,\"2925\":false,\"2926\":false,\"2927\":false,\"2928\":false,\"2929\":false,\"2930\":false,\"2931\":false,\"2932\":false,\"2933\":false,\"2934\":false,\"2935\":false,\"2936\":false,\"2937\":false,\"2938\":false,\"2939\":false,\"2940\":false,\"2941\":false,\"2942\":false,\"2943\":false,\"2944\":false,\"2945\":false,\"2946\":false,\"2947\":false,\"2948\":false,\"2949\":false,\"2950\":false,\"2951\":false,\"2952\":false,\"2953\":false,\"2954\":false,\"2955\":false,\"2956\":false,\"2957\":false,\"2958\":false,\"2959\":false,\"2960\":false,\"2961\":false,\"2962\":false,\"2963\":false,\"2964\":false,\"2965\":false,\"2966\":false,\"2967\":false,\"2968\":false,\"2969\":false,\"2970\":false,\"2971\":false,\"2972\":false,\"2973\":false,\"2974\":false,\"2975\":false,\"2976\":false,\"2977\":false,\"2978\":false,\"2979\":false,\"2980\":false,\"2981\":false,\"2982\":false,\"2983\":false,\"2984\":false,\"2985\":false,\"2986\":false,\"2987\":false,\"2988\":false,\"2989\":false,\"2990\":false,\"2991\":false,\"2992\":false,\"2993\":false,\"2994\":false,\"2995\":false,\"2996\":false,\"2997\":false,\"2998\":false,\"2999\":false,\"3000\":false,\"3001\":false,\"3002\":false,\"3003\":false,\"3004\":false,\"3005\":false,\"3006\":false,\"3007\":false,\"3008\":false,\"3009\":false,\"3010\":false,\"3011\":false,\"3012\":false,\"3013\":false,\"3014\":false,\"3015\":false,\"3016\":false,\"3017\":false,\"3018\":false,\"3019\":false,\"3020\":false,\"3021\":false,\"3022\":false,\"3023\":false,\"3024\":false,\"3025\":false,\"3026\":false,\"3027\":false,\"3028\":false,\"3029\":false,\"3030\":false,\"3031\":false,\"3032\":false,\"3033\":false,\"3034\":false,\"3035\":false,\"3036\":false,\"3037\":false,\"3038\":false,\"3039\":false,\"3040\":false,\"3041\":false,\"3042\":false,\"3043\":false,\"3044\":false,\"3045\":false,\"3046\":false,\"3047\":false,\"3048\":false,\"3049\":false,\"3050\":false,\"3051\":false,\"3052\":false,\"3053\":false,\"3054\":false,\"3055\":false,\"3056\":false,\"3057\":false,\"3058\":false,\"3059\":false,\"3060\":false,\"3061\":false,\"3062\":false,\"3063\":false,\"3064\":false,\"3065\":false,\"3066\":false,\"3067\":false,\"3068\":false,\"3069\":false,\"3070\":false,\"3071\":false,\"3072\":false,\"3073\":false,\"3074\":false,\"3075\":false,\"3076\":false,\"3077\":false,\"3078\":false,\"3079\":false,\"3080\":false,\"3081\":false,\"3082\":false,\"3083\":false,\"3084\":false,\"3085\":false,\"3086\":false,\"3087\":false,\"3088\":false,\"3089\":false,\"3090\":false,\"3091\":false,\"3092\":false,\"3093\":false,\"3094\":false,\"3095\":false,\"3096\":false,\"3097\":false,\"3098\":false,\"3099\":false,\"3100\":false,\"3101\":false,\"3102\":false,\"3103\":false,\"3104\":false,\"3105\":false,\"3106\":false,\"3107\":false,\"3108\":false,\"3109\":false,\"3110\":false,\"3111\":false,\"3112\":false,\"3113\":false,\"3114\":false,\"3115\":false,\"3116\":false,\"3117\":false,\"3118\":false,\"3119\":false,\"3120\":false,\"3121\":false,\"3122\":false,\"3123\":false,\"3124\":false,\"3125\":false,\"3126\":false,\"3127\":false,\"3128\":false,\"3129\":false,\"3130\":false,\"3131\":false,\"3132\":false,\"3133\":false,\"3134\":false,\"3135\":false,\"3136\":false,\"3137\":false,\"3138\":false,\"3139\":false,\"3140\":false,\"3141\":false,\"3142\":false,\"3143\":false,\"3144\":false,\"3145\":false,\"3146\":false,\"3147\":false,\"3148\":false,\"3149\":false,\"3150\":false,\"3151\":false,\"3152\":false,\"3153\":false,\"3154\":false,\"3155\":false,\"3156\":false,\"3157\":false,\"3158\":false,\"3159\":false,\"3160\":false,\"3161\":false,\"3162\":false,\"3163\":false,\"3164\":false,\"3165\":false,\"3166\":false,\"3167\":false,\"3168\":false,\"3169\":false,\"3170\":false,\"3171\":false,\"3172\":false,\"3173\":false,\"3174\":false,\"3175\":false,\"3176\":false,\"3177\":false,\"3178\":false,\"3179\":false,\"3180\":false,\"3181\":false,\"3182\":false,\"3183\":false,\"3184\":false,\"3185\":false,\"3186\":false,\"3187\":false,\"3188\":false,\"3189\":false,\"3190\":false,\"3191\":false,\"3192\":false,\"3193\":false,\"3194\":false,\"3195\":false,\"3196\":false,\"3197\":false,\"3198\":false,\"3199\":false,\"3200\":false,\"3201\":false,\"3202\":false,\"3203\":false,\"3204\":false,\"3205\":false,\"3206\":false,\"3207\":false,\"3208\":false,\"3209\":false,\"3210\":false,\"3211\":false,\"3212\":false,\"3213\":false,\"3214\":false,\"3215\":false,\"3216\":false,\"3217\":false,\"3218\":false,\"3219\":false,\"3220\":false,\"3221\":false,\"3222\":false,\"3223\":false,\"3224\":false,\"3225\":false,\"3226\":false,\"3227\":false,\"3228\":false,\"3229\":false,\"3230\":false,\"3231\":false,\"3232\":false,\"3233\":false,\"3234\":false,\"3235\":false,\"3236\":false,\"3237\":false,\"3238\":false,\"3239\":false,\"3240\":false,\"3241\":false,\"3242\":false,\"3243\":false,\"3244\":false,\"3245\":false,\"3246\":false,\"3247\":false,\"3248\":false,\"3249\":false,\"3250\":false,\"3251\":false,\"3252\":false,\"3253\":false,\"3254\":false,\"3256\":false,\"3257\":false,\"3259\":false,\"3261\":false,\"3262\":false,\"3265\":false,\"3267\":false,\"3269\":false,\"3271\":false,\"3273\":false,\"3275\":false,\"3277\":false,\"3279\":false,\"3281\":false,\"3282\":false,\"3285\":false,\"3286\":false,\"3289\":false,\"3291\":false,\"3292\":false,\"3296\":false,\"3298\":false,\"3299\":false,\"3300\":false,\"3301\":false,\"3302\":false,\"3305\":false,\"3307\":false,\"3309\":false,\"3312\":false,\"3313\":false,\"3316\":false,\"3319\":false,\"3321\":false,\"3324\":false,\"3326\":false,\"3327\":false,\"3329\":false,\"3331\":false,\"3332\":false,\"3334\":false,\"3335\":false,\"3338\":false,\"3341\":false,\"3343\":false,\"3345\":false,\"3347\":false,\"3349\":false,\"3352\":false,\"3353\":false,\"3357\":false,\"3359\":false,\"3361\":false,\"3363\":false,\"3365\":false,\"3366\":false,\"3367\":false,\"3368\":false,\"3369\":false,\"3372\":false,\"3375\":false,\"3377\":false,\"3380\":false,\"3382\":false,\"3384\":false,\"3386\":false,\"3388\":false,\"3389\":false,\"3392\":false,\"3394\":false,\"3396\":false,\"3398\":false,\"3400\":false,\"3403\":false,\"3405\":false,\"3407\":false,\"3410\":false,\"3412\":false,\"3415\":false,\"3416\":false,\"3419\":false,\"3421\":false,\"3422\":false,\"3425\":false,\"3427\":false,\"3428\":false,\"3431\":false,\"3433\":false,\"3435\":false,\"3436\":false,\"3437\":false,\"3439\":false,\"3441\":false,\"3442\":false,\"3445\":false,\"3446\":false,\"3449\":false,\"3452\":false,\"3453\":false,\"3455\":false,\"3457\":false,\"3458\":false,\"3461\":false,\"3463\":false,\"3465\":false,\"3466\":false,\"3469\":false,\"3471\":false,\"3472\":false,\"3475\":false,\"3477\":false,\"3478\":false,\"3479\":false,\"3481\":false,\"3482\":false,\"3486\":false,\"3489\":false,\"3490\":false,\"3492\":false,\"3495\":false,\"3496\":false,\"3498\":false,\"3501\":false,\"3502\":false,\"3505\":false,\"3506\":false,\"3508\":false,\"3510\":false,\"3512\":false,\"3514\":false,\"3516\":false,\"3517\":false,\"3520\":false,\"3521\":false,\"3524\":false,\"3526\":false,\"3528\":false,\"3529\":false,\"3530\":false,\"3531\":false,\"3532\":false,\"3533\":false,\"3534\":false,\"3535\":false,\"3536\":false,\"3537\":false,\"3538\":false,\"3539\":false,\"3540\":false,\"3541\":false,\"3542\":false,\"3543\":false,\"3544\":false,\"3545\":false,\"3546\":false,\"3547\":false,\"3548\":false,\"3549\":false,\"3550\":false,\"3551\":false,\"3552\":false,\"3553\":false,\"3554\":false,\"3555\":false,\"3556\":false,\"3557\":false,\"3558\":false,\"3559\":false,\"3560\":false,\"3561\":false,\"3562\":false,\"3563\":false,\"3564\":false,\"3565\":false,\"3566\":false,\"3567\":false,\"3568\":false,\"3569\":false,\"3570\":false,\"3571\":false,\"3572\":false,\"3573\":false,\"3574\":false,\"3575\":false,\"3576\":false,\"3577\":false,\"3578\":false,\"3579\":false,\"3580\":false,\"3581\":false,\"3582\":false,\"3583\":false,\"3584\":false,\"3585\":false,\"3586\":false,\"3587\":false,\"3588\":false,\"3589\":false,\"3590\":false,\"3591\":false,\"3592\":false,\"3593\":false,\"3594\":false,\"3595\":false,\"3596\":false,\"3597\":false,\"3598\":false,\"3599\":false,\"3600\":false,\"3601\":false,\"3602\":false,\"3603\":false,\"3604\":false,\"3605\":false,\"3606\":false,\"3607\":false,\"3608\":false,\"3609\":false,\"3610\":false,\"3611\":false,\"3612\":false,\"3613\":false,\"3614\":false,\"3615\":false,\"3616\":false,\"3617\":false,\"3618\":false,\"3619\":false,\"3620\":false,\"3621\":false,\"3622\":false,\"3623\":false,\"3624\":false,\"3625\":false,\"3626\":false,\"3627\":false,\"3628\":false,\"3629\":false,\"3630\":false,\"3631\":false,\"3632\":false,\"3633\":false,\"3634\":false,\"3635\":false,\"3636\":false,\"3637\":false,\"3638\":false,\"3639\":false,\"3640\":false,\"3641\":false,\"3642\":false,\"3643\":false,\"3644\":false,\"3645\":false,\"3646\":false,\"3647\":false,\"3648\":false,\"3649\":false,\"3650\":false,\"3651\":false,\"3652\":false,\"3653\":false,\"3654\":false,\"3655\":false,\"3656\":false,\"3657\":false,\"3658\":false,\"3659\":false,\"3660\":false,\"3661\":false,\"3662\":false,\"3663\":false,\"3664\":false,\"3665\":false,\"3666\":false,\"3667\":false,\"3668\":false,\"3669\":false,\"3670\":false,\"3671\":false,\"3672\":false,\"3673\":false,\"3674\":false,\"3675\":false,\"3676\":false,\"3677\":false,\"3678\":false,\"3679\":false,\"3680\":false,\"3681\":false,\"3682\":false,\"3683\":false,\"3684\":false,\"3685\":false,\"3686\":false,\"3687\":false,\"3688\":false,\"3689\":false,\"3690\":false,\"3691\":false,\"3692\":false,\"3693\":false,\"3694\":false,\"3695\":false,\"3696\":false,\"3697\":false,\"3698\":false,\"3699\":false,\"3700\":false,\"3701\":false,\"3702\":false,\"3703\":false,\"3704\":false,\"3705\":false,\"3706\":false,\"3707\":false,\"3708\":false,\"3709\":false,\"3710\":false,\"3711\":false,\"3712\":false,\"3713\":false,\"3714\":false,\"3715\":false,\"3716\":false,\"3717\":false,\"3718\":false,\"3719\":false,\"3720\":false,\"3721\":false,\"3722\":false,\"3723\":false,\"3724\":false,\"3725\":false,\"3726\":false,\"3727\":false,\"3728\":false,\"3729\":false,\"3730\":false,\"3731\":false,\"3732\":false,\"3733\":false,\"3734\":false,\"3735\":false,\"3736\":false,\"3737\":false,\"3738\":false,\"3739\":false,\"3740\":false,\"3741\":false,\"3742\":false,\"3743\":false,\"3744\":false,\"3745\":false,\"3746\":false,\"3747\":false,\"3748\":false,\"3749\":false,\"3750\":false,\"3751\":false,\"3752\":false,\"3753\":false,\"3754\":false,\"3755\":false,\"3756\":false,\"3757\":false,\"3758\":false,\"3759\":false,\"3760\":false,\"3761\":false,\"3762\":false,\"3763\":false,\"3764\":false,\"3765\":false,\"3766\":false,\"3767\":false,\"3768\":false,\"3769\":false,\"3770\":false,\"3771\":false,\"3772\":false,\"3773\":false,\"3774\":false,\"3775\":false,\"3776\":false,\"3777\":false,\"3778\":false,\"3779\":false,\"3780\":false,\"3781\":false,\"3782\":false,\"3783\":false,\"3784\":false,\"3785\":false,\"3786\":false,\"3787\":false,\"3788\":false,\"3789\":false,\"3790\":false,\"3791\":false,\"3792\":false,\"3793\":false,\"3794\":false,\"3795\":false,\"3796\":false,\"3797\":false,\"3798\":false,\"3799\":false,\"3800\":false,\"3801\":false,\"3802\":false,\"3803\":false,\"3804\":false,\"3805\":false,\"3806\":false,\"3807\":false,\"3808\":false,\"3809\":false,\"3810\":false,\"3811\":false,\"3812\":false,\"3813\":false,\"3814\":false,\"3815\":false,\"3816\":false,\"3817\":false,\"3818\":false,\"3819\":false,\"3820\":false,\"3821\":false,\"3822\":false,\"3823\":false,\"3824\":false,\"3825\":false,\"3826\":false,\"3827\":false,\"3828\":false,\"3829\":false,\"3830\":false,\"3831\":false,\"3833\":false,\"3834\":false,\"3835\":false,\"3836\":false,\"3837\":false,\"3838\":false,\"3839\":false,\"3840\":false,\"3841\":false,\"3842\":false,\"3843\":false,\"3844\":false,\"3845\":false,\"3846\":false,\"3847\":false,\"3848\":false,\"3849\":false,\"3850\":false,\"3851\":false,\"3852\":false,\"3853\":false,\"3854\":false,\"3855\":false,\"3856\":false,\"3857\":false,\"3858\":false,\"3859\":false,\"3860\":false,\"3861\":false,\"3862\":false,\"3863\":false,\"3864\":false,\"3865\":false,\"3866\":false,\"3867\":false,\"3868\":false,\"3869\":false,\"3870\":false,\"3871\":false,\"3872\":false,\"3873\":false,\"3874\":false,\"3876\":false,\"3879\":false,\"3882\":false,\"3885\":false,\"3887\":false,\"3888\":false,\"3889\":false,\"3891\":false,\"3892\":false,\"3896\":false,\"3898\":false,\"3900\":false,\"3901\":false,\"3903\":false,\"3904\":false,\"3909\":false,\"3910\":false,\"3915\":false,\"3916\":false,\"3919\":false,\"3921\":false,\"3922\":false,\"3927\":false,\"3929\":false,\"3930\":false,\"3933\":false,\"3934\":false,\"3936\":false,\"3937\":false,\"3940\":false,\"3942\":false,\"3944\":false,\"3945\":false,\"3947\":false,\"3950\":false,\"3951\":false,\"3952\":false,\"3954\":false,\"3955\":false,\"3959\":false,\"3962\":false,\"3963\":false,\"3967\":false,\"3969\":false,\"3971\":false,\"3972\":false,\"3974\":false,\"3978\":false,\"3980\":false,\"3981\":false,\"3983\":false,\"3984\":false,\"3985\":false,\"3986\":false,\"3987\":false,\"3988\":false,\"3989\":false,\"3990\":false,\"3991\":false,\"3992\":false,\"3993\":false,\"3994\":false,\"3995\":false,\"3996\":false,\"3997\":false,\"3998\":false,\"3999\":false,\"4000\":false,\"4001\":false,\"4002\":false,\"4003\":false,\"4004\":false,\"4005\":false,\"4006\":false,\"4007\":false,\"4008\":false,\"4009\":false,\"4010\":false,\"4011\":false,\"4012\":false,\"4013\":false,\"4014\":false,\"4015\":false,\"4016\":false,\"4017\":false,\"4018\":false,\"4019\":false,\"4020\":false,\"4021\":false,\"4022\":false,\"4023\":false,\"4024\":false,\"4025\":false,\"4026\":false,\"4027\":false,\"4028\":false,\"4029\":false,\"4030\":false,\"4031\":false,\"4032\":false,\"4033\":false,\"4034\":false,\"4035\":false,\"4036\":false,\"4037\":false,\"4038\":false,\"4039\":false,\"4040\":false,\"4041\":false,\"4042\":false,\"4043\":false,\"4044\":false,\"4045\":false,\"4046\":false,\"4047\":false,\"4048\":false,\"4049\":false,\"4050\":false,\"4051\":false,\"4052\":false,\"4053\":false,\"4054\":false,\"4056\":false,\"4057\":false,\"4058\":false,\"4059\":false,\"4060\":false,\"4061\":false,\"4062\":false,\"4063\":false,\"4064\":false,\"4065\":false,\"4066\":false,\"4067\":false,\"4068\":false,\"4069\":false,\"4070\":false,\"4071\":false,\"4072\":false,\"4073\":false,\"4074\":false,\"4075\":false,\"4076\":false,\"4077\":false,\"4078\":false,\"4079\":false,\"4080\":false,\"4081\":false,\"4082\":false,\"4083\":false,\"4084\":false,\"4085\":false,\"4086\":false,\"4087\":false,\"4088\":false,\"4089\":false,\"4090\":false,\"4091\":false,\"4092\":false,\"4093\":false,\"4094\":false,\"4095\":false,\"4096\":false,\"4097\":false,\"4098\":false,\"4099\":false,\"4100\":false,\"4101\":false,\"4102\":false,\"4103\":false,\"4104\":false,\"4105\":false,\"4106\":false,\"4107\":false,\"4108\":false,\"4109\":false,\"4110\":false,\"4111\":false,\"4112\":false,\"4113\":false,\"4114\":false,\"4115\":false,\"4116\":false,\"4117\":false,\"4118\":false,\"4119\":false,\"4120\":false,\"4121\":false,\"4122\":false,\"4123\":false,\"4124\":false,\"4125\":false,\"4126\":false,\"4127\":false,\"4128\":false,\"4129\":false,\"4130\":false,\"4131\":false,\"4132\":false,\"4133\":false,\"4134\":false,\"4135\":false,\"4136\":false,\"4137\":false,\"4138\":false,\"4139\":false,\"4140\":false,\"4141\":false,\"4142\":false,\"4143\":false,\"4144\":false,\"4145\":false,\"4146\":false,\"4147\":false,\"4148\":false,\"4149\":false,\"4150\":false,\"4151\":false,\"4152\":false,\"4153\":false,\"4154\":false,\"4155\":false,\"4156\":false,\"4157\":false,\"4158\":false,\"4159\":false,\"4160\":false,\"4161\":false,\"4162\":false,\"4163\":false,\"4164\":false,\"4165\":false,\"4166\":false,\"4167\":false,\"4168\":false,\"4169\":false,\"4170\":false,\"4171\":false,\"4172\":false,\"4173\":false,\"4174\":false,\"4175\":false,\"4176\":false,\"4177\":false,\"4178\":false,\"4179\":false,\"4180\":false,\"4181\":false,\"4182\":false,\"4183\":false,\"4184\":false,\"4185\":false,\"4186\":false,\"4187\":false,\"4188\":false,\"4189\":false,\"4190\":false,\"4191\":false,\"4192\":false,\"4194\":false,\"4195\":false,\"4196\":false,\"4197\":false,\"4198\":false,\"4199\":false,\"4200\":false,\"4201\":false,\"4202\":false,\"4203\":false,\"4204\":false,\"4205\":false,\"4206\":false,\"4207\":false,\"4208\":false,\"4209\":false,\"4210\":false,\"4211\":false,\"4212\":false,\"4213\":false,\"4214\":false,\"4215\":false,\"4216\":false,\"4217\":false,\"4218\":false,\"4219\":false,\"4220\":false,\"4221\":false,\"4222\":false,\"4223\":false,\"4224\":false,\"4225\":false,\"4226\":false,\"4227\":false,\"4228\":false,\"4229\":false,\"4230\":false,\"4231\":false,\"4232\":false,\"4233\":false,\"4234\":false,\"4235\":false,\"4236\":false,\"4237\":false,\"4238\":false,\"4239\":false,\"4240\":false,\"4241\":false,\"4242\":false,\"4243\":false,\"4244\":false,\"4245\":false,\"4246\":false,\"4247\":false,\"4248\":false,\"4249\":false,\"4250\":false,\"4251\":false,\"4252\":false,\"4253\":false,\"4254\":false,\"4255\":false,\"4256\":false,\"4257\":false,\"4258\":false,\"4259\":false,\"4260\":false,\"4261\":false,\"4262\":false,\"4263\":false,\"4264\":false,\"4265\":false,\"4266\":false,\"4267\":false,\"4268\":false,\"4269\":false,\"4270\":false,\"4271\":false,\"4272\":false,\"4273\":false,\"4274\":false,\"4275\":false,\"4276\":false,\"4277\":false,\"4278\":false,\"4279\":false,\"4280\":false,\"4281\":false,\"4282\":false,\"4283\":false,\"4284\":false,\"4285\":false,\"4286\":false,\"4287\":false,\"4288\":false,\"4289\":false,\"4290\":false,\"4291\":false,\"4292\":false,\"4293\":false,\"4294\":false,\"4295\":false,\"4296\":false,\"4297\":false,\"4298\":false,\"4299\":false,\"4300\":false,\"4301\":false,\"4302\":false,\"4303\":false,\"4304\":false,\"4305\":false,\"4306\":false,\"4307\":false,\"4308\":false,\"4309\":false,\"4310\":false,\"4311\":false,\"4312\":false,\"4313\":false,\"4314\":false,\"4315\":false,\"4316\":false,\"4317\":false,\"4318\":false,\"4319\":false,\"4320\":false,\"4321\":false,\"4322\":false,\"4323\":false,\"4324\":false,\"4325\":false,\"4326\":false,\"4327\":false,\"4328\":false,\"4329\":false,\"4330\":false,\"4331\":false,\"4332\":false,\"4333\":false,\"4334\":false,\"4335\":false,\"4336\":false,\"4337\":false,\"4338\":false,\"4339\":false,\"4340\":false,\"4341\":false,\"4342\":false,\"4343\":false,\"4344\":false,\"4345\":false,\"4346\":false,\"4347\":false,\"4348\":false,\"4349\":false,\"4350\":false,\"4351\":false,\"4352\":false,\"4353\":false,\"4354\":false,\"4355\":false,\"4356\":false,\"4357\":false,\"4358\":false,\"4359\":false,\"4360\":false,\"4361\":false,\"4362\":false,\"4363\":false,\"4364\":false,\"4365\":false,\"4366\":false,\"4367\":false,\"4368\":false,\"4369\":false,\"4370\":false,\"4371\":false,\"4372\":false,\"4373\":false,\"4374\":false,\"4375\":false,\"4376\":false,\"4377\":false,\"4378\":false,\"4379\":false,\"4380\":false,\"4381\":false,\"4382\":false,\"4383\":false,\"4384\":false,\"4385\":false,\"4386\":false,\"4387\":false,\"4388\":false,\"4389\":false,\"4390\":false,\"4391\":false,\"4392\":false,\"4393\":false,\"4394\":false,\"4395\":false,\"4396\":false,\"4397\":false,\"4398\":false,\"4399\":false,\"4400\":false,\"4401\":false,\"4402\":false,\"4403\":false,\"4404\":false,\"4405\":false,\"4406\":false,\"4407\":false,\"4408\":false,\"4409\":false,\"4410\":false,\"4411\":false,\"4412\":false,\"4413\":false,\"4414\":false,\"4415\":false,\"4416\":false,\"4417\":false,\"4418\":false,\"4419\":false,\"4420\":false,\"4421\":false,\"4422\":false,\"4423\":false,\"4424\":false,\"4425\":false,\"4426\":false,\"4427\":false,\"4428\":false,\"4429\":false,\"4430\":false,\"4431\":false,\"4432\":false,\"4433\":false,\"4434\":false,\"4435\":false,\"4436\":false,\"4437\":false,\"4438\":false,\"4439\":false,\"4440\":false,\"4441\":false,\"4445\":false,\"4448\":false,\"4450\":false,\"4451\":false,\"4454\":false,\"4455\":false,\"4458\":false,\"4459\":false,\"4460\":false,\"4462\":false,\"4465\":false,\"4466\":false,\"4468\":false,\"4471\":false,\"4472\":false,\"4474\":false,\"4477\":false,\"4478\":false,\"4480\":false,\"4481\":false,\"4482\":false,\"4483\":false,\"4484\":false,\"4485\":false,\"4486\":false,\"4487\":false,\"4488\":false,\"4489\":false,\"4490\":false,\"4491\":false,\"4492\":false,\"4493\":false,\"4494\":false,\"4495\":false,\"4496\":false,\"4497\":false,\"4498\":false,\"4499\":false,\"4500\":false,\"4501\":false,\"4502\":false,\"4503\":false,\"4504\":false,\"4505\":false,\"4506\":false,\"4507\":false,\"4508\":false,\"4509\":false,\"4510\":false,\"4511\":false,\"4512\":false,\"4513\":false,\"4514\":false,\"4515\":false,\"4516\":false,\"4517\":false,\"4518\":false,\"4519\":false,\"4520\":false,\"4521\":false,\"4522\":false,\"4523\":false,\"4524\":false,\"4525\":false,\"4526\":false,\"4527\":false,\"4528\":false,\"4529\":false,\"4530\":false,\"4531\":false,\"4532\":false,\"4533\":false,\"4534\":false,\"4535\":false,\"4536\":false,\"4537\":false,\"4538\":false,\"4539\":false,\"4540\":false,\"4541\":false,\"4542\":false,\"4543\":false,\"4544\":false,\"4545\":false,\"4546\":false,\"4547\":false,\"4548\":false,\"4549\":false,\"4550\":false,\"4551\":false,\"4552\":false,\"4553\":false,\"4554\":false,\"4555\":false,\"4556\":false,\"4557\":false,\"4558\":false,\"4559\":false,\"4560\":false,\"4561\":false,\"4562\":false,\"4563\":false,\"4564\":false,\"4565\":false,\"4566\":false,\"4567\":false,\"4568\":false,\"4569\":false,\"4570\":false,\"4571\":false,\"4572\":false,\"4573\":false,\"4574\":false,\"4575\":false,\"4576\":false,\"4577\":false,\"4578\":false,\"4579\":false,\"4580\":false,\"4581\":false,\"4582\":false,\"4583\":false,\"4584\":false,\"4585\":false,\"4586\":false,\"4587\":false,\"4588\":false,\"4589\":false,\"4590\":false,\"4591\":false,\"4592\":false,\"4593\":false,\"4594\":false,\"4595\":false,\"4596\":false,\"4597\":false,\"4598\":false,\"4599\":false,\"4600\":false,\"4601\":false,\"4602\":false,\"4603\":false,\"4604\":false,\"4605\":false,\"4606\":false,\"4607\":false,\"4608\":false,\"4609\":false,\"4610\":false,\"4611\":false,\"4612\":false,\"4613\":false,\"4614\":false,\"4615\":false,\"4616\":false,\"4617\":false,\"4618\":false,\"4619\":false,\"4620\":false,\"4621\":false,\"4622\":false,\"4623\":false,\"4624\":false,\"4625\":false,\"4626\":false,\"4627\":false,\"4628\":false,\"4629\":false,\"4630\":false,\"4631\":false,\"4632\":false,\"4633\":false,\"4634\":false,\"4635\":false,\"4636\":false,\"4637\":false,\"4638\":false,\"4639\":false,\"4640\":false,\"4641\":false,\"4642\":false,\"4643\":false,\"4644\":false,\"4645\":false,\"4646\":false,\"4647\":false,\"4648\":false,\"4649\":false,\"4650\":false,\"4651\":false,\"4652\":false,\"4653\":false,\"4654\":false,\"4655\":false,\"4656\":false,\"4657\":false,\"4658\":false,\"4659\":false,\"4660\":false,\"4661\":false,\"4662\":false,\"4663\":false,\"4664\":false,\"4665\":false,\"4666\":false,\"4667\":false,\"4668\":false,\"4669\":false,\"4670\":false,\"4671\":false,\"4672\":false,\"4673\":false,\"4674\":false,\"4675\":false,\"4676\":false,\"4677\":false,\"4678\":false,\"4679\":false,\"4680\":false,\"4681\":false,\"4682\":false,\"4683\":false,\"4684\":false,\"4685\":false,\"4686\":false,\"4687\":false,\"4688\":false,\"4689\":false,\"4690\":false,\"4691\":false,\"4692\":false,\"4693\":false,\"4694\":false,\"4695\":false,\"4696\":false,\"4697\":false,\"4698\":false,\"4699\":false,\"4700\":false,\"4701\":false,\"4702\":false,\"4703\":false,\"4704\":false,\"4705\":false,\"4706\":false,\"4707\":false,\"4708\":false,\"4709\":false,\"4710\":false,\"4711\":false,\"4712\":false,\"4713\":false,\"4714\":false,\"4715\":false,\"4716\":false,\"4717\":false,\"4718\":false,\"4719\":false,\"4720\":false,\"4721\":false,\"4722\":false,\"4723\":false,\"4724\":false,\"4725\":false,\"4726\":false,\"4727\":false,\"4728\":false,\"4729\":false,\"4730\":false,\"4731\":false,\"4732\":false,\"4733\":false,\"4734\":false,\"4735\":false,\"4736\":false,\"4737\":false,\"4738\":false,\"4739\":false,\"4740\":false,\"4741\":false,\"4742\":false,\"4743\":false,\"4744\":false,\"4745\":false,\"4746\":false,\"4747\":false,\"4748\":false,\"4749\":false,\"4750\":false,\"4751\":false,\"4752\":false,\"4753\":false,\"4754\":false,\"4755\":false,\"4756\":false,\"4757\":false,\"4758\":false,\"4759\":false,\"4760\":false,\"4761\":false,\"4762\":false,\"4763\":false,\"4764\":false,\"4765\":false,\"4766\":false,\"4767\":false,\"4768\":false,\"4769\":false,\"4770\":false,\"4771\":false,\"4772\":false,\"4773\":false,\"4774\":false,\"4775\":false,\"4776\":false,\"4777\":false,\"4778\":false,\"4779\":false,\"4780\":false,\"4781\":false,\"4782\":false,\"4783\":false,\"4784\":false,\"4785\":false,\"4786\":false,\"4787\":false,\"4788\":false,\"4789\":false,\"4790\":false,\"4791\":false,\"4792\":false,\"4793\":false,\"4794\":false,\"4795\":false,\"4796\":false,\"4797\":false,\"4798\":false,\"4799\":false,\"4800\":false,\"4801\":false,\"4802\":false,\"4803\":false,\"4804\":false,\"4805\":false,\"4806\":false,\"4807\":false,\"4808\":false,\"4811\":false,\"4814\":false,\"4816\":false,\"4817\":false,\"4819\":false,\"4821\":false,\"4822\":false,\"4824\":false,\"4826\":false,\"4828\":false,\"4829\":false,\"4833\":false,\"4835\":false,\"4837\":false,\"4838\":false,\"4841\":false,\"4842\":false,\"4845\":false,\"4847\":false,\"4848\":false,\"4851\":false,\"4853\":false,\"4854\":false,\"4857\":false,\"4859\":false,\"4860\":false,\"4863\":false,\"4866\":false,\"4867\":false,\"4869\":false,\"4872\":false,\"4873\":false,\"4874\":false,\"4875\":false,\"4876\":false,\"4877\":false,\"4878\":false,\"4881\":false,\"4883\":false,\"4887\":false,\"4888\":false,\"4890\":false,\"4892\":false,\"4895\":false,\"4897\":false,\"4899\":false,\"4901\":false,\"4904\":false,\"4905\":false,\"4908\":false,\"4909\":false,\"4911\":false,\"4913\":false,\"4915\":false,\"4917\":false,\"4919\":false,\"4920\":false,\"4923\":false,\"4924\":false,\"4927\":false,\"4929\":false,\"4930\":false,\"4935\":false,\"4937\":false,\"4938\":false,\"4939\":false,\"4942\":false,\"4943\":false,\"4944\":false,\"4946\":false,\"4948\":false,\"4949\":false,\"4950\":false,\"4952\":false,\"4954\":false,\"4957\":false,\"4958\":false,\"4961\":false,\"4963\":false,\"4965\":false,\"4966\":false,\"4968\":false,\"4970\":false,\"4971\":false,\"4972\":false,\"4974\":false,\"4975\":false,\"4978\":false,\"4980\":false,\"4981\":false,\"4984\":false,\"4986\":false,\"4988\":false,\"4989\":false,\"4992\":false,\"4995\":false,\"4996\":false,\"4997\":false,\"5000\":false,\"5003\":false,\"5004\":false,\"5007\":false,\"5008\":false,\"5010\":false,\"5011\":false,\"5013\":false,\"5015\":false,\"5016\":false,\"5019\":false,\"5020\":false,\"5022\":false,\"5024\":false,\"5025\":false,\"5028\":false,\"5029\":false,\"5031\":false,\"5032\":false,\"5035\":false,\"5037\":false,\"5038\":false,\"5039\":false,\"5042\":false,\"5045\":false,\"5046\":false,\"5048\":false,\"5052\":false,\"5054\":false,\"5057\":false,\"5058\":false,\"5061\":false,\"5062\":false,\"5063\":false,\"5066\":false,\"5069\":false,\"5071\":false,\"5073\":false,\"5074\":false,\"5076\":false,\"5077\":false,\"5080\":false,\"5083\":false,\"5084\":false,\"5085\":false,\"5086\":false,\"5087\":false,\"5088\":false,\"5089\":false,\"5090\":false,\"5091\":false,\"5092\":false,\"5093\":false,\"5094\":false,\"5095\":false,\"5096\":false,\"5097\":false,\"5098\":false,\"5099\":false,\"5100\":false,\"5101\":false,\"5102\":false,\"5103\":false,\"5104\":false,\"5105\":false,\"5106\":false,\"5107\":false,\"5108\":false,\"5109\":false,\"5110\":false,\"5111\":false,\"5112\":false,\"5113\":false,\"5114\":false,\"5115\":false,\"5116\":false,\"5117\":false,\"5118\":false,\"5119\":false,\"5120\":false,\"5121\":false,\"5122\":false,\"5123\":false,\"5124\":false,\"5125\":false,\"5126\":false,\"5127\":false,\"5128\":false,\"5129\":false,\"5130\":false,\"5131\":false,\"5132\":false,\"5133\":false,\"5134\":false,\"5135\":false,\"5136\":false,\"5137\":false,\"5138\":false,\"5139\":false,\"5140\":false,\"5141\":false,\"5142\":false,\"5143\":false,\"5144\":false,\"5145\":false,\"5146\":false,\"5147\":false,\"5148\":false,\"5149\":false,\"5150\":false,\"5151\":false,\"5152\":false,\"5153\":false,\"5154\":false,\"5155\":false,\"5156\":false,\"5157\":false,\"5158\":false,\"5159\":false,\"5160\":false,\"5161\":false,\"5162\":false,\"5163\":false,\"5164\":false,\"5165\":false,\"5166\":false,\"5167\":false,\"5168\":false,\"5172\":false,\"5175\":false,\"5178\":false,\"5180\":false,\"5179\":false,\"5181\":false,\"5182\":false,\"5183\":false,\"5184\":false,\"5185\":false,\"5186\":false,\"5187\":false,\"5188\":false,\"5189\":false,\"5190\":false,\"5191\":false,\"5192\":false,\"5193\":false,\"5194\":false,\"5195\":false,\"5196\":false,\"5197\":false,\"5198\":false,\"5199\":false,\"5200\":false,\"5201\":false,\"5202\":false,\"5203\":false,\"5204\":false,\"5205\":false,\"5206\":false,\"5207\":false,\"5208\":false,\"5209\":false,\"5210\":false,\"5211\":false,\"5212\":false,\"5213\":false,\"5214\":false,\"5215\":false,\"5216\":false,\"5217\":false,\"5218\":false,\"5219\":false,\"5220\":false,\"5221\":false,\"5222\":false,\"5223\":false,\"5224\":false,\"5225\":false,\"5226\":false,\"5227\":false,\"5228\":false,\"5229\":false,\"5230\":false,\"5231\":false,\"5232\":false,\"5233\":false,\"5234\":false,\"5235\":false,\"5236\":false,\"5237\":false,\"5238\":false,\"5239\":false,\"5240\":false,\"5241\":false,\"5242\":false,\"5243\":false,\"5244\":false,\"5245\":false,\"5246\":false,\"5247\":false,\"5248\":false,\"5249\":false,\"5250\":false,\"5251\":false,\"5252\":false,\"5253\":false,\"5254\":false,\"5255\":false,\"5256\":false,\"5257\":false,\"5258\":false,\"5259\":false,\"5260\":false,\"5261\":false,\"5262\":false,\"5263\":false,\"5264\":false,\"5265\":false,\"5266\":false,\"5267\":false,\"5268\":false,\"5269\":false,\"5270\":false,\"5271\":false,\"5272\":false,\"5273\":false,\"5274\":false,\"5275\":false,\"5276\":false,\"5277\":false,\"5278\":false,\"5279\":false,\"5280\":false,\"5281\":false,\"5282\":false,\"5283\":false,\"5284\":false,\"5285\":false,\"5286\":false,\"5287\":false,\"5288\":false,\"5289\":false,\"5290\":false,\"5291\":false,\"5292\":false,\"5293\":false,\"5294\":false,\"5295\":false,\"5296\":false,\"5297\":false,\"5298\":false,\"5299\":false,\"5300\":false,\"5301\":false,\"5302\":false,\"5303\":false,\"5304\":false,\"5305\":false,\"5306\":false,\"5307\":false,\"5308\":false,\"5309\":false,\"5310\":false,\"5311\":false,\"5312\":false,\"5313\":false,\"5314\":false,\"5315\":false,\"5316\":false,\"5317\":false,\"5318\":false,\"5319\":false,\"5320\":false,\"5321\":false,\"5322\":false,\"5323\":false,\"5324\":false,\"5325\":false,\"5326\":false,\"5327\":false,\"5328\":false,\"5329\":false,\"5330\":false,\"5331\":false,\"5332\":false,\"5333\":false,\"5334\":false,\"5335\":false,\"5336\":false,\"5337\":false,\"5338\":false,\"5339\":false,\"5340\":false,\"5341\":false,\"5342\":false,\"5343\":false,\"5344\":false,\"5345\":false,\"5346\":false,\"5347\":false,\"5348\":false,\"5349\":false,\"5350\":false,\"5351\":false,\"5352\":false,\"5353\":false,\"5354\":false,\"5355\":false,\"5356\":false,\"5357\":false,\"5358\":false,\"5359\":false,\"5360\":false,\"5361\":false,\"5362\":false,\"5363\":false,\"5364\":false,\"5365\":false,\"5366\":false,\"5367\":false,\"5368\":false,\"5369\":false,\"5370\":false,\"5371\":false,\"5372\":false,\"5373\":false,\"5374\":false,\"5375\":false,\"5376\":false,\"5377\":false,\"5378\":false,\"5379\":false,\"5380\":false,\"5381\":false,\"5382\":false,\"5383\":false,\"5384\":false,\"5385\":false,\"5386\":false,\"5387\":false,\"5388\":false,\"5389\":false,\"5390\":false,\"5391\":false,\"5392\":false,\"5393\":false,\"5394\":false,\"5395\":false,\"5396\":false,\"5397\":false,\"5398\":false,\"5399\":false,\"5400\":false,\"5401\":false,\"5402\":false,\"5403\":false,\"5404\":false,\"5405\":false,\"5406\":false,\"5407\":false,\"5408\":false,\"5409\":false,\"5410\":false,\"5411\":false,\"5412\":false,\"5413\":false,\"5414\":false,\"5415\":false,\"5416\":false,\"5417\":false,\"5418\":false,\"5419\":false,\"5420\":false,\"5421\":false,\"5422\":false,\"5423\":false,\"5424\":false,\"5425\":false,\"5426\":false,\"5427\":false,\"5428\":false,\"5429\":false,\"5430\":false,\"5431\":false,\"5432\":false,\"5433\":false,\"5434\":false,\"5435\":false,\"5436\":false,\"5437\":false,\"5438\":false,\"5439\":false,\"5440\":false,\"5441\":false,\"5442\":false,\"5443\":false,\"5444\":false,\"5445\":false,\"5446\":false,\"5447\":false,\"5448\":false,\"5449\":false,\"5450\":false,\"5451\":false,\"5452\":false,\"5453\":false,\"5454\":false,\"5455\":false,\"5456\":false,\"5457\":false,\"5458\":false,\"5459\":false,\"5460\":false,\"5461\":false,\"5462\":false,\"5463\":false,\"5464\":false,\"5465\":false,\"5466\":false,\"5467\":false,\"5468\":false,\"5469\":false,\"5470\":false,\"5471\":false,\"5472\":false,\"5473\":false,\"5474\":false,\"5475\":false,\"5476\":false,\"5477\":false,\"5478\":false,\"5479\":false,\"5480\":false,\"5481\":false,\"5482\":false,\"5483\":false,\"5484\":false,\"5485\":false,\"5486\":false,\"5487\":false,\"5488\":false,\"5489\":false,\"5490\":false,\"5491\":false,\"5492\":false,\"5493\":false,\"5494\":false,\"5495\":false,\"5496\":false,\"5497\":false,\"5498\":false,\"5499\":false,\"5500\":false,\"5501\":false,\"5502\":false,\"5503\":false,\"5504\":false,\"5505\":false,\"5506\":false,\"5507\":false,\"5508\":false,\"5509\":false,\"5510\":false,\"5511\":false,\"5512\":false,\"5513\":false,\"5514\":false,\"5515\":false,\"5516\":false,\"5517\":false,\"5518\":false,\"5519\":false,\"5520\":false,\"5521\":false,\"5522\":false,\"5523\":false,\"5524\":false,\"5525\":false,\"5526\":false,\"5527\":false,\"5528\":false,\"5529\":false,\"5530\":false,\"5531\":false,\"5532\":false,\"5533\":false,\"5534\":false,\"5535\":false,\"5536\":false,\"5537\":false,\"5538\":false,\"5539\":false,\"5540\":false,\"5541\":false,\"5542\":false,\"5543\":false,\"5544\":false,\"5545\":false,\"5546\":false,\"5547\":false,\"5548\":false,\"5549\":false,\"5550\":false,\"5551\":false,\"5552\":false,\"5553\":false,\"5554\":false,\"5555\":false,\"5556\":false,\"5557\":false,\"5558\":false,\"5559\":false,\"5560\":false,\"5561\":false,\"5562\":false,\"5563\":false,\"5564\":false,\"5565\":false,\"5566\":false,\"5567\":false,\"5568\":false,\"5569\":false,\"5570\":false,\"5571\":false,\"5572\":false,\"5573\":false,\"5574\":false,\"5575\":false,\"5576\":false,\"5577\":false,\"5578\":false,\"5579\":false,\"5580\":false,\"5581\":false,\"5582\":false,\"5583\":false,\"5584\":false,\"5585\":false,\"5586\":false,\"5587\":false,\"5588\":false,\"5589\":false,\"5590\":false,\"5591\":false,\"5592\":false,\"5593\":false,\"5594\":false,\"5595\":false,\"5596\":false,\"5597\":false,\"5598\":false,\"5599\":false,\"5600\":false,\"5601\":false,\"5602\":false,\"5603\":false,\"5604\":false,\"5605\":false,\"5606\":false,\"5607\":false,\"5608\":false,\"5609\":false,\"5610\":false,\"5611\":false,\"5612\":false,\"5613\":false,\"5614\":false,\"5615\":false,\"5616\":false,\"5617\":false,\"5618\":false,\"5619\":false,\"5620\":false,\"5621\":false,\"5622\":false,\"5623\":false,\"5624\":false,\"5625\":false,\"5626\":false,\"5627\":false,\"5628\":false,\"5629\":false,\"5630\":false,\"5631\":false,\"5632\":false,\"5633\":false,\"5634\":false,\"5635\":false,\"5636\":false,\"5637\":false,\"5638\":false,\"5639\":false,\"5640\":false,\"5641\":false,\"5642\":false,\"5643\":false,\"5644\":false,\"5645\":false,\"5646\":false,\"5647\":false,\"5648\":false,\"5649\":false,\"5650\":false,\"5651\":false,\"5652\":false,\"5653\":false,\"5654\":false,\"5655\":false,\"5656\":false,\"5657\":false,\"5658\":false,\"5659\":false,\"5660\":false,\"5661\":false,\"5662\":false,\"5663\":false,\"5664\":false,\"5665\":false,\"5666\":false,\"5667\":false,\"5668\":false,\"5669\":false,\"5670\":false,\"5671\":false,\"5672\":false,\"5673\":false,\"5674\":false,\"5675\":false,\"5676\":false,\"5677\":false,\"5678\":false,\"5679\":false,\"5680\":false,\"5681\":false,\"5682\":false,\"5683\":false,\"5684\":false,\"5685\":false,\"5686\":false,\"5687\":false,\"5688\":false,\"5689\":false,\"5690\":false,\"5691\":false,\"5692\":false,\"5693\":false,\"5694\":false,\"5695\":false,\"5696\":false,\"5697\":false,\"5698\":false,\"5699\":false,\"5700\":false,\"5701\":false,\"5702\":false,\"5703\":false,\"5704\":false,\"5705\":false,\"5706\":false,\"5707\":false,\"5708\":false,\"5709\":false,\"5710\":false,\"5711\":false,\"5712\":false,\"5713\":false,\"5714\":false,\"5715\":false,\"5716\":false,\"5717\":false,\"5718\":false,\"5719\":false,\"5720\":false,\"5721\":false,\"5722\":false,\"5723\":false,\"5724\":false,\"5725\":false,\"5726\":false,\"5727\":false,\"5728\":false,\"5729\":false,\"5730\":false,\"5731\":false,\"5732\":false,\"5733\":false,\"5734\":false,\"5735\":false,\"5736\":false,\"5737\":false,\"5738\":false,\"5739\":false,\"5740\":false,\"5741\":false,\"5742\":false,\"5743\":false,\"5744\":false,\"5745\":false,\"5746\":false,\"5747\":false,\"5748\":false,\"5749\":false,\"5750\":false,\"5751\":false,\"5752\":false,\"5753\":false,\"5754\":false,\"5755\":false,\"5756\":false,\"5757\":false,\"5758\":false,\"5759\":false,\"5760\":false,\"5761\":false,\"5762\":false,\"5763\":false,\"5764\":false,\"5765\":false,\"5766\":false,\"5767\":false,\"5768\":false,\"5769\":false,\"5770\":false,\"5771\":false,\"5772\":false,\"5773\":false,\"5774\":false,\"5775\":false,\"5776\":false,\"5777\":false,\"5778\":false,\"5779\":false,\"5780\":false,\"5781\":false,\"5782\":false,\"5783\":false,\"5784\":false,\"5785\":false,\"5786\":false,\"5787\":false,\"5788\":false,\"5789\":false,\"5790\":false,\"5791\":false,\"5792\":false,\"5793\":false,\"5794\":false,\"5795\":false,\"5796\":false,\"5797\":false,\"5798\":false,\"5799\":false,\"5800\":false,\"5801\":false,\"5802\":false,\"5803\":false,\"5804\":false,\"5805\":false,\"5806\":false,\"5807\":false,\"5808\":false,\"5809\":false,\"5810\":false,\"5811\":false,\"5812\":false,\"5813\":false,\"5814\":false,\"5815\":false,\"5816\":false,\"5817\":false,\"5818\":false,\"5819\":false,\"5820\":false,\"5821\":false,\"5822\":false,\"5823\":false,\"5824\":false,\"5825\":false,\"5826\":false,\"5827\":false,\"5828\":false,\"5829\":false,\"5830\":false,\"5831\":false,\"5832\":false,\"5833\":false,\"5834\":false,\"5835\":false,\"5836\":false,\"5837\":false,\"5838\":false,\"5839\":false,\"5840\":false,\"5841\":false,\"5842\":false,\"5843\":false,\"5844\":false,\"5845\":false,\"5846\":false,\"5847\":false,\"5848\":false,\"5849\":false,\"5850\":false,\"5851\":false,\"5852\":false,\"5853\":false,\"5854\":false,\"5855\":false,\"5856\":false,\"5857\":false,\"5858\":false,\"5859\":false,\"5860\":false,\"5861\":false,\"5862\":false,\"5863\":false,\"5864\":false,\"5865\":false,\"5866\":false,\"5867\":false,\"5868\":false,\"5869\":false,\"5870\":false,\"5871\":false,\"5872\":false,\"5873\":false,\"5874\":false,\"5875\":false,\"5876\":false,\"5877\":false,\"5878\":false,\"5879\":false,\"5880\":false,\"5881\":false,\"5882\":false,\"5883\":false,\"5884\":false,\"5885\":false,\"5886\":false,\"5887\":false,\"5888\":false,\"5889\":false,\"5890\":false,\"5891\":false,\"5892\":false,\"5893\":false,\"5894\":false,\"5895\":false,\"5896\":false,\"5897\":false,\"5898\":false,\"5899\":false,\"5900\":false,\"5901\":false,\"5902\":false,\"5903\":false,\"5904\":false,\"5905\":false,\"5906\":false,\"5907\":false,\"5908\":false,\"5909\":false,\"5910\":false,\"5911\":false,\"5912\":false,\"5913\":false,\"5914\":false,\"5915\":false,\"5916\":false,\"5917\":false,\"5918\":false,\"5919\":false,\"5920\":false,\"5921\":false,\"5922\":false,\"5923\":false,\"5924\":false,\"5925\":false,\"5926\":false,\"5927\":false,\"5928\":false,\"5929\":false,\"5930\":false,\"5931\":false,\"5932\":false,\"5933\":false,\"5934\":false,\"5935\":false,\"5936\":false,\"5938\":false,\"5939\":false,\"5940\":false,\"5941\":false,\"5942\":false,\"5943\":false,\"5944\":false,\"5945\":false,\"5946\":false,\"5947\":false,\"5948\":false,\"5949\":false,\"5950\":false,\"5951\":false,\"5952\":false,\"5953\":false,\"5954\":false,\"5955\":false,\"5956\":false,\"5957\":false,\"5958\":false,\"5959\":false,\"5960\":false,\"5961\":false,\"5962\":false,\"5963\":false,\"5964\":false,\"5965\":false,\"5966\":false,\"5967\":false,\"5968\":false,\"5969\":false,\"5970\":false,\"5971\":false,\"5972\":false,\"5973\":false,\"5974\":false,\"5975\":false,\"5976\":false,\"5977\":false,\"5978\":false,\"5979\":false,\"5980\":false,\"5981\":false,\"5982\":false,\"5983\":false,\"5984\":false,\"5985\":false,\"5986\":false,\"5987\":false,\"5988\":false,\"5989\":false,\"5990\":false,\"5991\":false,\"5992\":false,\"5995\":false,\"5996\":false,\"5997\":false,\"5998\":false,\"5999\":false,\"6000\":false,\"6001\":false,\"6002\":false,\"6003\":false,\"6004\":false,\"6005\":false,\"6006\":false,\"6007\":false,\"6008\":false,\"6009\":false,\"6010\":false,\"6011\":false,\"6012\":false,\"6013\":false,\"6014\":false,\"6015\":false,\"6016\":false,\"6017\":false,\"6018\":false,\"6019\":false,\"6020\":false,\"6021\":false,\"6022\":false,\"6023\":false,\"6024\":false,\"6025\":false,\"6026\":false,\"6027\":false,\"6028\":false,\"6029\":false,\"6030\":false,\"6031\":false,\"6032\":false,\"6033\":false,\"6034\":false,\"6035\":false,\"6036\":false,\"6037\":false,\"6038\":false,\"6039\":false,\"6040\":false,\"6041\":false,\"6042\":false,\"6043\":false,\"6044\":false,\"6045\":false,\"6046\":false,\"6047\":false,\"6048\":false,\"6049\":false,\"6050\":false,\"6051\":false,\"6052\":false,\"6053\":false,\"6054\":false,\"6055\":false,\"6056\":false,\"6057\":false,\"6058\":false,\"6059\":false,\"6060\":false,\"6061\":false,\"6062\":false,\"6063\":false,\"6064\":false,\"6065\":false,\"6066\":false,\"6067\":false,\"6068\":false,\"6069\":false,\"6070\":false,\"6071\":false,\"6072\":false,\"6073\":false,\"6074\":false,\"6075\":false,\"6076\":false,\"6077\":false,\"6078\":false,\"6079\":false,\"6080\":false,\"6081\":false,\"6082\":false,\"6083\":false,\"6084\":false,\"6085\":false,\"6086\":false,\"6087\":false,\"6088\":false,\"6089\":false,\"6090\":false,\"6091\":false,\"6092\":false,\"6093\":false,\"6094\":false,\"6095\":false,\"6096\":false,\"6097\":false,\"6098\":false,\"6099\":false,\"6100\":false,\"6101\":false,\"6102\":false,\"6103\":false,\"6104\":false,\"6106\":false,\"6107\":false,\"6108\":false,\"6109\":false,\"6110\":false,\"6111\":false,\"6112\":false,\"6113\":false,\"6114\":false,\"6115\":false,\"6116\":false,\"6117\":false,\"6118\":false,\"6119\":false,\"6120\":false,\"6121\":false,\"6122\":false,\"6123\":false,\"6124\":false,\"6125\":false,\"6126\":false,\"6127\":false,\"6128\":false,\"6129\":false,\"6130\":false,\"6131\":false,\"6132\":false,\"6133\":false,\"6134\":false,\"6135\":false,\"6136\":false,\"6137\":false,\"6138\":false,\"6139\":false,\"6140\":false,\"6141\":false,\"6142\":false,\"6143\":false,\"6144\":false,\"6145\":false,\"6146\":false,\"6147\":false,\"6148\":false,\"6149\":false,\"6150\":false,\"6151\":false,\"6152\":false,\"6153\":false,\"6154\":false,\"6155\":false,\"6156\":false,\"6157\":false,\"6158\":false,\"6159\":false,\"6160\":false,\"6161\":false,\"6162\":false,\"6163\":false,\"6164\":false,\"6165\":false,\"6166\":false,\"6167\":false,\"6168\":false,\"6169\":false,\"6170\":false,\"6171\":false,\"6172\":false,\"6173\":false,\"6174\":false,\"6175\":false,\"6176\":false,\"6177\":false,\"6178\":false,\"6179\":false,\"6180\":false}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26132,'_transient_fusion_subsets_preload_tags','<link rel=\"preload\" href=\"//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff2\" as=\"font\" type=\"font/woff2\" crossorigin><link rel=\"preload\" href=\"//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff2\" as=\"font\" type=\"font/woff2\" crossorigin><link rel=\"preload\" href=\"//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff2\" as=\"font\" type=\"font/woff2\" crossorigin>','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26133,'_transient_fusion_custom_icons_preload_tags','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26136,'_transient_fusion_dynamic_js_readable','1','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26137,'wphb_styles_collection','{{SHIPPER_JSON_START}}{\"dashicons\":{\"handle\":\"dashicons\",\"src\":\"\\/wp-includes\\/css\\/dashicons.min.css\",\"deps\":[],\"ver\":false,\"args\":null,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"admin-bar\":{\"handle\":\"admin-bar\",\"src\":\"\\/wp-includes\\/css\\/admin-bar.min.css\",\"deps\":[\"dashicons\"],\"ver\":false,\"args\":null,\"extra\":{\"rtl\":\"replace\",\"suffix\":\".min\",\"after\":[\"\\n\\t\\t@media screen { html { margin-top: 32px !important; } }\\n\\t\\t@media screen and ( max-width: 782px ) { html { margin-top: 46px !important; } }\\n\\t\",\"@media print { #wpadminbar { display:none; } }\"]},\"textdomain\":null,\"translations_path\":null},\"wp-block-library\":{\"handle\":\"wp-block-library\",\"src\":\"\\/wp-includes\\/css\\/dist\\/block-library\\/style.min.css\",\"deps\":[],\"ver\":false,\"args\":null,\"extra\":{\"path\":\"\\/home\\/rinsea5\\/{{SHIPPER_DOMAIN}}\\/\\/wp-includes\\/css\\/dist\\/block-library\\/style.min.css\",\"rtl\":\"replace\",\"suffix\":\".min\"},\"textdomain\":null,\"translations_path\":null},\"child-style\":{\"handle\":\"child-style\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/themes\\/Avada-Child-Theme\\/style.css\",\"deps\":[],\"ver\":false,\"args\":\"all\",\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"fusion-dynamic-css\":{\"handle\":\"fusion-dynamic-css\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/uploads\\/fusion-styles\\/fb1bd6857539aa50b06986cc6355181b.min.css\",\"deps\":[],\"ver\":\"3.11.13\",\"args\":\"all\",\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"wc-blocks-style\":{\"handle\":\"wc-blocks-style\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.css\",\"deps\":[],\"ver\":\"wc-9.8.5\",\"args\":\"all\",\"extra\":{\"rtl\":\"replace\"},\"textdomain\":null,\"translations_path\":null},\"brands-styles\":{\"handle\":\"brands-styles\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/css\\/brands.css\",\"deps\":[],\"ver\":\"9.8.5\",\"args\":\"all\",\"extra\":[],\"textdomain\":null,\"translations_path\":null}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26138,'wphb_scripts_collection','{{SHIPPER_JSON_START}}{\"hoverintent-js\":{\"handle\":\"hoverintent-js\",\"src\":\"\\/wp-includes\\/js\\/hoverintent-js.min.js\",\"deps\":[],\"ver\":\"2.2.1\",\"args\":1,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"admin-bar\":{\"handle\":\"admin-bar\",\"src\":\"\\/wp-includes\\/js\\/admin-bar.min.js\",\"deps\":[\"hoverintent-js\"],\"ver\":false,\"args\":1,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"jquery-core\":{\"handle\":\"jquery-core\",\"src\":\"\\/wp-includes\\/js\\/jquery\\/jquery.min.js\",\"deps\":[],\"ver\":\"3.7.1\",\"args\":null,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"jquery-migrate\":{\"handle\":\"jquery-migrate\",\"src\":\"\\/wp-includes\\/js\\/jquery\\/jquery-migrate.min.js\",\"deps\":[],\"ver\":\"3.4.1\",\"args\":null,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"jquery-blockui\":{\"handle\":\"jquery-blockui\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/jquery-blockui\\/jquery.blockUI.min.js\",\"deps\":[\"jquery\"],\"ver\":\"2.7.0-wc.9.8.5\",\"args\":null,\"extra\":{\"strategy\":\"defer\"},\"textdomain\":null,\"translations_path\":null},\"wc-add-to-cart\":{\"handle\":\"wc-add-to-cart\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/frontend\\/add-to-cart.min.js\",\"deps\":[\"jquery\",\"jquery-blockui\"],\"ver\":\"9.8.5\",\"args\":null,\"extra\":{\"strategy\":\"defer\",\"data\":\"var wc_add_to_cart_params = {\\\"ajax_url\\\":\\\"\\\\\\/wp-admin\\\\\\/admin-ajax.php\\\",\\\"wc_ajax_url\\\":\\\"\\\\\\/?wc-ajax=%%endpoint%%\\\",\\\"i18n_view_cart\\\":\\\"View cart\\\",\\\"cart_url\\\":\\\"https:\\\\\\/\\\\\\/{{SHIPPER_DOMAIN}}\\\\\\/cart\\\\\\/\\\",\\\"is_cart\\\":\\\"\\\",\\\"cart_redirect_after_add\\\":\\\"no\\\"};\"},\"textdomain\":null,\"translations_path\":null},\"js-cookie\":{\"handle\":\"js-cookie\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/js-cookie\\/js.cookie.min.js\",\"deps\":[],\"ver\":\"2.1.4-wc.9.8.5\",\"args\":null,\"extra\":{\"strategy\":\"defer\"},\"textdomain\":null,\"translations_path\":null},\"woocommerce\":{\"handle\":\"woocommerce\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/frontend\\/woocommerce.min.js\",\"deps\":[\"jquery\",\"jquery-blockui\",\"js-cookie\"],\"ver\":\"9.8.5\",\"args\":null,\"extra\":{\"strategy\":\"defer\",\"data\":\"var woocommerce_params = {\\\"ajax_url\\\":\\\"\\\\\\/wp-admin\\\\\\/admin-ajax.php\\\",\\\"wc_ajax_url\\\":\\\"\\\\\\/?wc-ajax=%%endpoint%%\\\",\\\"i18n_password_show\\\":\\\"Show password\\\",\\\"i18n_password_hide\\\":\\\"Hide password\\\"};\"},\"textdomain\":null,\"translations_path\":null},\"underscore\":{\"handle\":\"underscore\",\"src\":\"\\/wp-includes\\/js\\/underscore.min.js\",\"deps\":[],\"ver\":\"1.13.7\",\"args\":1,\"extra\":[],\"textdomain\":null,\"translations_path\":null},\"wphb-global\":{\"handle\":\"wphb-global\",\"src\":\"https:\\/\\/thrillrebels.com\\/wp-content\\/plugins\\/wp-hummingbird\\/admin\\/assets\\/js\\/wphb-global.min.js\",\"deps\":[\"underscore\",\"jquery\"],\"ver\":\"3.12.0\",\"args\":null,\"extra\":{\"group\":1,\"data\":\"var wphbGlobal = {\\\"ajaxurl\\\":\\\"https:\\\\\\/\\\\\\/thrillrebels.com\\\\\\/wp-admin\\\\\\/admin-ajax.php\\\",\\\"nonce\\\":\\\"7fcd59c4da\\\",\\\"minify_url\\\":\\\"https:\\\\\\/\\\\\\/thrillrebels.com\\\\\\/wp-admin\\\\\\/admin.php?page=wphb-minification\\\",\\\"is_hb_page\\\":\\\"\\\"};\"},\"textdomain\":null,\"translations_path\":null},\"sourcebuster-js\":{\"handle\":\"sourcebuster-js\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/sourcebuster\\/sourcebuster.min.js\",\"deps\":[],\"ver\":\"9.8.5\",\"args\":null,\"extra\":{\"group\":1},\"textdomain\":null,\"translations_path\":null},\"wc-order-attribution\":{\"handle\":\"wc-order-attribution\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/js\\/frontend\\/order-attribution.min.js\",\"deps\":[\"sourcebuster-js\"],\"ver\":\"9.8.5\",\"args\":null,\"extra\":{\"group\":1,\"data\":\"var wc_order_attribution = {\\\"params\\\":{\\\"lifetime\\\":1.0000000000000000818030539140313095458623138256371021270751953125e-5,\\\"session\\\":30,\\\"base64\\\":false,\\\"ajaxurl\\\":\\\"https:\\\\\\/\\\\\\/{{SHIPPER_DOMAIN}}\\\\\\/wp-admin\\\\\\/admin-ajax.php\\\",\\\"prefix\\\":\\\"wc_order_attribution_\\\",\\\"allowTracking\\\":true},\\\"fields\\\":{\\\"source_type\\\":\\\"current.typ\\\",\\\"referrer\\\":\\\"current_add.rf\\\",\\\"utm_campaign\\\":\\\"current.cmp\\\",\\\"utm_source\\\":\\\"current.src\\\",\\\"utm_medium\\\":\\\"current.mdm\\\",\\\"utm_content\\\":\\\"current.cnt\\\",\\\"utm_id\\\":\\\"current.id\\\",\\\"utm_term\\\":\\\"current.trm\\\",\\\"utm_source_platform\\\":\\\"current.plt\\\",\\\"utm_creative_format\\\":\\\"current.fmt\\\",\\\"utm_marketing_tactic\\\":\\\"current.tct\\\",\\\"session_entry\\\":\\\"current_add.ep\\\",\\\"session_start_time\\\":\\\"current_add.fd\\\",\\\"session_pages\\\":\\\"session.pgs\\\",\\\"session_count\\\":\\\"udata.vst\\\",\\\"user_agent\\\":\\\"udata.uag\\\"}};\"},\"textdomain\":null,\"translations_path\":null},\"fusion-scripts\":{\"handle\":\"fusion-scripts\",\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/uploads\\/fusion-scripts\\/bb2944262d4d7aa3fc76e983b2ed33e7.min.js\",\"deps\":[],\"ver\":\"3.11.13\",\"args\":null,\"extra\":{\"group\":1},\"textdomain\":null,\"translations_path\":null}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (847,'woocommerce_maybe_regenerate_images_hash','5e01c6981f1484c3a3df8e2b61481edf','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (28956,'wphb-gzip-data','{{SHIPPER_JSON_START}}{\"HTML\":false,\"JavaScript\":true,\"CSS\":true}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (49874,'wpdef_firewall_whitelist_server_public_ip','192.145.233.213','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44636,'woocommerce_checkout_phone_field','optional','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44637,'woocommerce_checkout_company_field','hidden','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44638,'woocommerce_checkout_address_2_field','optional','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (343,'_transient_woocommerce_shipping_task_zone_count_transient','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (344,'woocommerce_task_list_tracked_completed_tasks','{{SHIPPER_JSON_START}}[\"launch-your-store\"]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (14596,'woocommerce_feature_site_visibility_badge_enabled','yes','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (431,'ub_permissions_users','{{SHIPPER_JSON_START}}[1]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (454,'wp-smush-install-type','existing','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (455,'wp-smush-last_run_sync','{{SHIPPER_JSON_START}}{\"time\":1748065856,\"fails\":0}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (456,'wp_smush_api_auth','{{SHIPPER_JSON_START}}{\"e9f2d585c294d8263c0ee1df1b2ac21339a7f9ff\":{\"validity\":\"valid\",\"timestamp\":1748065856}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (457,'wp-smush-cdn_status','O:8:\"stdClass\":11:{s:5:\"limit\";i:32;s:11:\"cdn_enabled\";b:0;s:12:\"cdn_enabling\";b:0;s:7:\"site_id\";i:3321406;s:12:\"endpoint_url\";s:0:\"\";s:14:\"bandwidth_plan\";i:50;s:23:\"bandwidth_plan_in_bytes\";i:53687091200;s:23:\"user_bandwidth_in_bytes\";i:0;s:9:\"bandwidth\";i:0;s:4:\"hits\";i:0;s:12:\"cache_misses\";i:0;}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (458,'wp-smush-version','3.19.0','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (492,'wphb_version','3.14.1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (493,'wphb-notice-uptime-info-show','yes','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (494,'wphb_run_onboarding','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (491,'wphb_plugin_timestamps','{{SHIPPER_JSON_START}}{\"plugin_installed\":1729663497,\"plugin_upgraded\":1748067084}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (452,'wp_smush_event_times','{{SHIPPER_JSON_START}}{\"plugin_installed\":1729663485,\"plugin_upgraded\":1748067084}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (453,'wp-smush-settings','{{SHIPPER_JSON_START}}{\"auto\":true,\"lossy\":0,\"strip_exif\":true,\"resize\":false,\"detection\":false,\"original\":false,\"backup\":false,\"no_scale\":false,\"png_to_jpg\":false,\"nextgen\":false,\"s3\":false,\"gutenberg\":false,\"js_builder\":false,\"gform\":false,\"cdn\":false,\"auto_resize\":false,\"webp\":true,\"usage\":false,\"accessible_colors\":false,\"keep_data\":true,\"lazy_load\":false,\"background_images\":true,\"rest_api_support\":false,\"webp_mod\":false,\"background_email\":false,\"webp_direct_conversion\":false,\"webp_fallback\":false}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (382,'wdp_un_flags','{{SHIPPER_JSON_START}}{\"first_setup\":false,\"refresh_remote\":false,\"refresh_profile\":false,\"redirected_v4\":true,\"highlights_dismissed\":true,\"autoupdate_dashboard\":true,\"enable_auto_translation\":false,\"uninstall_preserve_settings\":true,\"uninstall_keep_data\":true}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (383,'wdp_un_remote_access','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (384,'wdp_un_updates_data','{{SHIPPER_JSON_START}}{\"projects\":{\"119\":{\"id\":119,\"paid\":\"free\",\"type\":\"plugin\",\"name\":\"WPMU DEV Dashboard\",\"released\":1261092923,\"updated\":1732533651,\"downloads\":\"11354661\",\"popularity\":\"556672\",\"short_description\":\"Instant access to brilliant support and one-click plugin and theme installation.\",\"long_description\":\"Instant access to expert support and one-click plugin\\/theme installation. Unlock better security, backups, performance optimization, one-click installations, automated updates and reports.\",\"features\":[\"One-click installations\",\"Hub and Hosting Single Sign-On (SSO)\",\"Unbranded analytics\",\"Dashboard plugin browse and install\",\"Dashboard theme browse and install\",\"Simply login to setup\",\"Instant Google account login (COMING SOON)\",\"Integrated badge notifications\",\"One-click updates\",\"Enable automatic WPMU DEV Dashboard plugin updates\",\"WPMU DEV dashboard news feed\",\"Dashboard widget quick links\",\"New release notifications\",\"Update notifications\",\"Membership manager\",\"Hide\\/Remove WPMU DEV hero branding\",\"Background updates\",\"Hide notifications\",\"Limit to Multisite Super Admin\",\"See reputation points\",\"Built-in conflict avoidance\",\"Occasional special membership discounts\",\"Participate in WPMU DEV community\",\"Access forum search\",\"Fast access to Q&amp;A\",\"Grant temporary access to support staff\",\"Direct links to usage instructions\",\"Installed theme version information\",\"Installed plugin version information\",\"Post support questions\",\"System information quick view\",\"PHP configuration information\",\"MySQL information\",\"Server information\",\"White label plugin titles and icons\"],\"version\":\"4.11.28\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/wpmu-dev-dashboard\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/12\\/Dashboard-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/12\\/Dashboard-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/12\\/Dashboard.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/12\\/Dashboard-1.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/WPMUDEV.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/WPMUDEV@2x.png\",\"video\":\"\\/\\/fast.wistia.net\\/embed\\/iframe\\/irz1r2ze9m\",\"wp_config_url\":\"admin.php?page=wpmudev-settings\",\"ms_config_url\":\"admin.php?page=wpmudev-settings\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/119\\/screenshots\\/dashboard-support.png\",\"desc\":\"Secure support access\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/119\\/screenshots\\/dashboard-access.png\",\"desc\":\"Quick access from the WordPress dashboard\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/119\\/screenshots\\/96343734_analitics.png\",\"desc\":\"Unbranded Analytics\"}],\"_order\":1},\"4276231\":{\"id\":4276231,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Forminator Geolocation Add-on\",\"released\":1693921360,\"updated\":1744114135,\"downloads\":\"20414\",\"popularity\":\"4104\",\"short_description\":\"Collect your form submitters\' location information, and provide address auto-completion using Google Maps API.\",\"long_description\":\"\",\"features\":[\"Collect and store your users\' geolocation information.\",\"Add address auto-suggestion to your forms\' address field(s).\",\"See your users\' geolocation on Google Maps.\"],\"version\":\"1.4.3\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/forminator-geolocation\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Geolocation-logo.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Geolocation-logo.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Geolocation-logo.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2024\\/05\\/geolocation-logo.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Geolocation-banner.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Geolocation-banner@2x.png\",\"video\":false,\"wp_config_url\":\"\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":true,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location1@2x.png\",\"desc\":\"Forminator Geolocation add-on screenshot 1\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location2@2x.png\",\"desc\":\"Forminator Geolocation add-on screenshot 2\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/09\\/Geo-location3@2x.png\",\"desc\":\"Forminator Geolocation add-on screenshot 3\"}],\"_order\":2},\"4262971\":{\"id\":4262971,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Forminator PDF Generator Add-on\",\"released\":1691653002,\"updated\":1746034393,\"downloads\":\"39592\",\"popularity\":\"7638\",\"short_description\":\"Generate and send PDF files (e.g., form entries, receipts, invoices, quotations) to users after form submission.\",\"long_description\":\"\",\"features\":[\"No limit on the number of PDFs you can generate for your forms.\",\"Generate PDF files in seconds with our easy-to-use pre-designed templates.\",\"Send customized email Notifications to admins and visitors with PDF attachments.\",\"Download the PDFs of the form submissions on the Submissions page.\",\"Generate payment receipts and invoices.\"],\"version\":\"1.8.1\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/forminator-pdf-generator\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Project-pdf-logo.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Project-pdf-logo.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/Project-pdf-logo.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2024\\/05\\/pdf-logo.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/07\\/banner-1.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/07\\/banner@2x.png\",\"video\":false,\"wp_config_url\":\"\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":true,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF1@2x.png\",\"desc\":\"Forminator PDF Generator add-on screenshot 1\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF2@2x.png\",\"desc\":\"Forminator PDF Generator add-on screenshot 2\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2023\\/08\\/PDF3@2x.png\",\"desc\":\"Forminator PDF Generator add-on screenshot 3\"}],\"_order\":3},\"3953609\":{\"id\":3953609,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Forminator Stripe Subscriptions Add-on\",\"released\":1628782736,\"updated\":1738059665,\"downloads\":\"31303\",\"popularity\":\"4007\",\"short_description\":\"The Stripe subscription add-on lets you collect recurring\\/subscription payments with Forminator Pro on your WordPress sites.\",\"long_description\":\"Add the ability to collect recurring\\/subscription payments with Forminator. Create Stripe subscription plans directly from your Forminator dashboard and use conditional logic to process any of your payment fields based on form field values.\",\"features\":[\"Create and manage one-time and recurring Stripe payments in Forminator.\",\"Setup products in Forminator within minutes.\",\"Offer users a trial period for your product before they start paying.\",\"Use conditional logic to process payments based on form input field values.\"],\"version\":\"1.4\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/forminator-stripe\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/forminator-stripe-logo.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/forminator-stripe-logo-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/forminator-stripe-logo.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/Stripe.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/ForminatorAddOn.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/ForminatorAddOn@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=forminator-settings&section=payments\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":true,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/Stripe1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/Stripe1@2x.png\",\"desc\":\"Forminator Stripe subscription add-on screenshot 1\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/Stripe2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2021\\/08\\/Stripe2@2x.png\",\"desc\":\"Forminator Stripe subscription add-on screenshot 2\"}],\"_order\":4},\"3779636\":{\"id\":3779636,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"The Hub Client\",\"released\":1597667386,\"updated\":1733144782,\"downloads\":\"57532\",\"popularity\":\"9525\",\"short_description\":\"White label WPMU DEV and give your clients their own Hub experience on your site, with your branding. \",\"long_description\":\"Provide your clients with a completely white label WPMU DEV experience on your own domain. Including everything we offer for you to rebrand and resell, with your own hosting or ours.\",\"features\":[\"Completely white label The Hub\",\"Run entirely on your own domain\",\"Control all user access levels\",\"Free with your WPMU DEV membership\",\"Easy to set up, just install the plugin\",\"Use any host (or us)\",\"Sell your clients different levels of subscriptions\"],\"version\":\"2.2.2\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/the-hub-client\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/08\\/gfx-project-thumb-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/08\\/gfx-project-thumb-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/08\\/gfx-project-thumb.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/08\\/TheHubClient.png\",\"banner_1x\":\"\",\"banner_2x\":\"\",\"video\":false,\"wp_config_url\":\"admin.php?page=wpmudev-hub\",\"ms_config_url\":\"admin.php?page=wpmudev-hub\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/3779636\\/screenshots\\/gfx-hero.png\",\"desc\":\"\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/3779636\\/screenshots\\/gfx-styled.png\",\"desc\":\"\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/3779636\\/screenshots\\/gfx-user-access.png\",\"desc\":\"\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/3779636\\/screenshots\\/gfx-roles.png\",\"desc\":\"\"}],\"_order\":5},\"912164\":{\"id\":912164,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Smush Pro\",\"released\":1416874433,\"updated\":1747153816,\"downloads\":\"3246424\",\"popularity\":\"400891\",\"short_description\":\"User\'s choice, award-winning, and benchmark tested \\u2013 The best image optimizer plugin for WordPress.\",\"long_description\":\"The most installed, and number one image optimization plugin for WordPress. Optimize unlimited images, lazy load, resize, compress, and resolve Google PageSpeed recommendations - all from one simple and intuitive dashboard.\",\"features\":[\"Double savings with Super-Smush\",\"Automatic optimize on upload\",\"Smush Pro global CDN\",\"Compress huge photos up to 32MB\",\"Perfect-fit auto image resize\",\"Lazy Loading for offscreen images\",\"WebP next-gen file conversion\",\"PNG to lossy JPEG smart convert\",\"One-click compress existing images\",\"Retain rights to every file forever\",\"Optimize images in any folder\",\"Smush or save original image files\",\"Multisite global and subsite settings\",\"Lossy compression with little quality loss\",\"Amazon S3 plugin integration\",\"NextGEN Gallery compatible\",\"Preserve EXIF data\",\"WP Retina 2x plugin support\",\"Envira Gallery Support\",\"Avada Fusion Builder Support\",\"Dedicated smushing servers\",\"HTTPS encrypted browsing compatible\",\"WPML media compatible\",\"Lossless compression\",\"Strip unused colors from indexed images\",\"Progress and savings reporting\",\"Compress individual images\",\"Instant asynchronous compression\"],\"version\":\"3.19\",\"free_version_slug\":\"wp-smushit\\/wp-smush.php\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/wp-smush-pro\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush_2016_02-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush_2016_02-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush_2016_02.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush-2.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush-1.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush@2x-1.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=smush\",\"ms_config_url\":\"admin.php?page=smush\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-bulk-smush-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-bulk-smush-x2.png\",\"desc\":\"The Bulk Smush feature allows you to apply all your enabled features to any uncompressed images with a single click.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-dash-100-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-dash-100-x2.png\",\"desc\":\"Smush Dashboard preview. \"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-bulk-smush-process-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-bulk-smush-process-x2.png\",\"desc\":\"Bulk Smush an unlimited number of images at a time.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush_4.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/Smush_4@2x.png\",\"desc\":\"Super-Smush advanced multi-pass lossy compression increases savings by more than 2x on average without any visible loss in quality.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-lazy-load-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2014\\/11\\/smush-lazy-load-x2.png\",\"desc\":\"Lazy Load stops offscreen images from loading until a visitor scrolls to them. \"}],\"_order\":6},\"1081721\":{\"id\":1081721,\"paid\":\"full\",\"type\":\"plugin\",\"name\":\"Hummingbird Pro\",\"released\":1456236462,\"updated\":1748008642,\"downloads\":\"2033745\",\"popularity\":\"136567\",\"short_description\":\"Everything you need to get your site running super fast.\",\"long_description\":\"The all-in-one performance plugin for all users - whether you\\u2019re looking for simple, one-click solutions, or to fine-tune your site performance down to the last CSS file.\",\"features\":[\"Generate performance reports\",\"Recommended speed improvements\",\"Browser caching\",\"Full-page caching\",\"Gravatar caching\",\"RSS caching\",\"Minify files\",\"Combine files\",\"Set load position\",\"Included output graph\",\"Simple GZIP configuration\",\"Advanced Minification controls\",\"Bonus: Sync with Uptime monitor\",\"Down and slow load notifications\",\"Track average pagespeed\",\"Better search engine positioning\"],\"version\":\"3.14.1\",\"free_version_slug\":\"hummingbird-performance\\/wp-hummingbird.php\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/wp-hummingbird\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/HummingBird-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/HummingBird-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/HummingBird.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Hummingbird.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Hummingbird.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Hummingbird@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=wphb\",\"ms_config_url\":\"admin.php?page=wphb\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-asset-opt-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-asset-opt-x2.png\",\"desc\":\"Automatically optimize your site with \\u201cSpeedy\\u201d or \\u201cBasic\\u201d optimization. \"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Hummingbird_2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Hummingbird_2@2x.png\",\"desc\":\"Uptime monitors your server response time and lets you know when your website is down or too slow for your visitors.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-performance-test-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-performance-test-x2.png\",\"desc\":\"See how well your website currently performs and what can be improved with Hummingbird\\u2019s Performance Test.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-dashboard-x2.png\",\"desc\":\"Hummingbird Dashboard preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-caching-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/hummingbird-caching-x2.png\",\"desc\":\"Enhance your site performance with Hummingbird Caching (Browser, Page, RSS, Gravatar).\"}],\"_order\":7},\"1081723\":{\"id\":1081723,\"paid\":\"full\",\"type\":\"plugin\",\"name\":\"Defender Pro\",\"released\":1456855142,\"updated\":1744029907,\"downloads\":\"1936636\",\"popularity\":\"220300\",\"short_description\":\"Regular security scans, vulnerability reports, safety recommendations and security tweaks for WordPress.\",\"long_description\":\"The one-stop security plugin that keeps your websites safe in a few clicks. Scan, secure, and monitor your sites for hacks from one easy-to-use interface.\",\"features\":[\"Analyze site security\",\"Security tweak recommendations\",\"Resolve issues with a click\",\"Manual and automatic IP lockout\",\"Filterable IP logs\",\"Scan core files for changes\",\"2-Factor Authentification\",\"Customize 2-factor email\",\"Vulnerability scans\",\"Schedule scans\",\"Repair\\/restore changed files\",\"Choose file types to scan\",\"Skip files based on file size\",\"Receive email reports\",\"Set report recipients\",\"Google blocklist monitoring\",\"Automated backups\",\"Full website backups\",\"Cloud backups\",\"Site interactions with logging\"],\"version\":\"5.2\",\"free_version_slug\":\"defender-security\\/wp-defender.php\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/wp-defender\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Defender-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Defender-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/02\\/Defender.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/Defender.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Defender.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Defender@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=wp-defender\",\"ms_config_url\":\"admin.php?page=wp-defender\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-dashboard-x2.png\",\"desc\":\"Defender Dashboard preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-audit-logging-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-audit-logging-x2.png\",\"desc\":\"See your latest event logs that showed what has been happening behind the scenes\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-antibot-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-antibot-x2.png\",\"desc\":\"Proactively protect your site from malicious IPs with AntiBot.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-malware-scan-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-malware-scan-x2.png\",\"desc\":\"Catch and remove any suspicious and potentially harmful files with Defender Malware Scanning. \"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-sec-recomendations-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/03\\/defender-sec-recomendations-x2.png\",\"desc\":\"Harden your site\'s security and fix common vulnerabilities with a single click.\"}],\"_order\":8},\"1107020\":{\"id\":1107020,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Hustle Pro\",\"released\":1471315160,\"updated\":1745599106,\"downloads\":\"515498\",\"popularity\":\"27550\",\"short_description\":\"Grow your business and audience with this super easy, super slick email opt-in and marketing plugin.\",\"long_description\":\"\",\"features\":[\"Pop-ups, slide-ins, widgets, embeds, and after post opt-ins\",\"All the social share icons you need\",\"Easily customize designs with in built editing\",\"Color match your brand, like magic\",\"Show your stuff in style with smooth built-in display animations\",\"Integrate with your favorite providers including: Aweber, MailChimp, Constant Contacts, Sendy, ActiveCampaign, Brevo, Hubspot, Keap, Mad Mimi, ConvertKit, MailerLite, iContact, GetResponse, and Campaign Monitor\",\"Manage who sees your hustle with super powerful conditions\",\"Track how many times your material is displayed\",\"See submissions straight through WordPress\",\"Conversion rates overview to make your clients ecstatic\",\"Great default layouts to choose from\",\"Easy management dashboard\"],\"version\":\"7.8.7\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/hustle\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/hustle-01-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/hustle-01-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/hustle-01.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Hustle.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Hustle@2x.png\",\"video\":false,\"wp_config_url\":\"\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_1@2x.png\",\"desc\":\"Choose from our pre-designed pop-up templates.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/hustle-pop-ups-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/hustle-pop-ups-x2.png\",\"desc\":\"Track pop-up views and conversion rates.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_3@2x.png\",\"desc\":\"Connect and send leads to over 1000 third party applications.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_4.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_4@2x.png\",\"desc\":\"Use different triggers to activate your pop-ups.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_5.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2016\\/08\\/Hustle_5@2x.png\",\"desc\":\"Drive seasonal sales with Black Friday, Valentine, Christmas and New Year templates.\"}],\"_order\":9},\"2097296\":{\"id\":2097296,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Forminator Pro\",\"released\":1519137568,\"updated\":1747132669,\"downloads\":\"940030\",\"popularity\":\"84994\",\"short_description\":\"Drag and drop WordPress form builder plugin with interactive polls and quizzes for increasing user engagement and building a following.\",\"long_description\":\"Interactive forms, polls, and quizzes to increase user engagement. Create new campaigns in minutes with the easy-to-use, drag-and-drop form builder.\",\"features\":[\"Responsive fit for every screen\",\"Developer API\",\"Stripe Payments\",\"PayPal integration\",\"SCA Compliant Payments\",\"Calculations\",\"Google ReCAPTCHA\",\"Drag-and-drop form builder\",\"Forms  for every situation\",\"+15 Form blocks\",\"Email routing and conditional emails\",\"Form pre-populate\",\"Toggle styling options\",\"Campaign Monitor\",\"HubSpot\",\"ActiveCampaign\",\"Google Sheets\",\"Zapier (connects to +1000 apps)\",\"Trello Integration\",\"MailChimp\",\"AWeber\",\"Interactive polls\",\"Pagination options\",\"Collect and track stats\",\"No wrong answer quizzes\",\"Submissions dashboard\",\"Knowledge tests\",\"Live preview\",\"Knowledge tests\",\"Gutenberg block included\",\"GDPR ready\",\"Hidden fields\",\"Customized submission forms\",\"Schedule form submission reports\",\"Privacy settings\",\"Advanced email configurations\",\"Custom login and registration forms\",\"Instant migration from Contact Form 7\",\"Pass form data (variables) to another page\",\"Add E-signature form field\",\"Multiple file, drag and drop upload\",\"Advanced Datepicker field settings\"],\"version\":\"1.44\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/forminator-pro\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-feature-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-feature-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-feature.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/Forminator.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Forminator.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Forminator@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=forminator\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-templates-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-templates-x2.png\",\"desc\":\"Build a form from scratch or select from our pre-made templates.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-fields-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-fields-x2.png\",\"desc\":\"Customize forms with a rich variety of fields for every need.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/Forminator_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/Forminator_3@2x.png\",\"desc\":\"Capture leads in quizzes.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-integrations-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/forminator-integrations-x2.png\",\"desc\":\"Connect and send form data to third party applications.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/Forminator_5.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2018\\/02\\/Forminator_5@2x.png\",\"desc\":\"Preview, sort, filter and export form submissions.\"}],\"_order\":10},\"167\":{\"id\":167,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"SmartCrawl Pro\",\"released\":1298584937,\"updated\":1745492533,\"downloads\":\"1145948\",\"popularity\":\"113111\",\"short_description\":\"Boost your PageRank and drive more traffic to your site with little effort and simple configuration.\",\"long_description\":\"Take the guesswork out of SEO. With SmartCrawl\\u2019s automated SEO scanning, detailed audits\\/reports, and one-click recommendations, you\\u2019ll be on the fast-track to optimizing your sites for search and ranking higher.\",\"features\":[\"Simple guided settings\",\"Offer SEO options by user role\",\"Direct interaction with Google and Bing\",\"Send sitemap updates automatic to search engines\",\"Custom post titles and meta descriptions (per custom post type)\",\"Title and meta data optimization\",\"Automatic sitewide linking\",\"Complete Moz integration\",\"Multisite and BuddyPress compatibility\",\"Process posts and pages individually\",\"Process RSS feeds\",\"Conduct case sensitive matching\",\"Prevent duplicate links\",\"Open links in new tab\\/window\",\"Exclude posts or pages from sitemap\",\"Exclude custom post types and taxonomies\",\"Exclude categories and tags\",\"Include or exclude images and stylesheets\",\"Include or remove the sitemap dashboard widget\",\"Disable automatic sitemap updates\",\"Post categories, tags and custom taxonomy title and meta defaults\",\"Custom home title\",\"Home meta description\",\"Keywords\",\"Import\\/export to quickly add SmartCrawl to any site\",\"Yoast SEO settings and content importer\",\"All in One SEO settings and content importer\",\"Main blog archive meta robots options\",\"Post and media title defaults\",\"Post and media meta description defaults\",\"Post categories, tags and custom taxonomy robots tags\",\"Author and date archives\",\"404 page title and description defaults\"],\"version\":\"3.13.1\",\"free_version_slug\":\"smartcrawl-seo\\/wpmu-dev-seo.php\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/smartcrawl-wordpress-seo\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SEO_Webcrawler_1470_SEO_Webcrawler_1470-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SEO_Webcrawler_1470_SEO_Webcrawler_1470-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SEO_Webcrawler_1470_SEO_Webcrawler_1470.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SmartCrawl.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/SmartCrawl.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/SmartCrawl@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=wds_wizard\",\"ms_config_url\":\"admin.php?page=wds_network_settings\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-dashboard-x2.png\",\"desc\":\"SmartCrawl Dashboard.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-SEO-health-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-SEO-health-x2.png\",\"desc\":\"SEO Health - See issues that affect your site\\u2019s search engine optimizations.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SmartCrawl_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/SmartCrawl_3@2x.png\",\"desc\":\"Customize your page titles, descriptions, and meta options.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-advanced-tools-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-advanced-tools-x2.png\",\"desc\":\"URL Redirect - Temporarily or permanently redirect broken page links to new ones while retaining site traffic.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-schema-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/02\\/smartcrawl-schema-x2.png\",\"desc\":\"Add Schema types you want to enable for your site.\"}],\"_order\":11},\"3760011\":{\"id\":3760011,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Snapshot Pro\",\"released\":1592204194,\"updated\":1745914084,\"downloads\":\"562881\",\"popularity\":\"72800\",\"short_description\":\"Make and schedule incremental backups of your WordPress websites and store them on secure cloud storage.\",\"long_description\":\"Automated and space-efficient backups with secure off-site storage. Schedule automated backups to suit your preference, restore with a click, keep backups for 50 days, and back up to reliable third-party storage.\",\"features\":[\"10GB of WPMU DEV cloud storage\",\"Manage your backups from The Hub\",\"Redundant backups\",\"Multisite Global file exclusions\",\"Scheduled backups\",\"Set backup interval\",\"Manual backup\",\"Multisite compatible\",\"Backup entire site\",\"Exclude specific files and folders\",\"Downloadable log files\",\"Simple one-click restore\",\"30 backups automatically stored\",\"Dynamic scaling\",\"Backup zipstreaming\"],\"version\":\"4.33\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/snapshot\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/Snapshot.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Snapshot.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Snapshot@2x.png\",\"video\":false,\"wp_config_url\":\"\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-schedule-backup-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-schedule-backup-x2.png\",\"desc\":\"Schedule automatic backups to your preferred frequency.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-dashbaord-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-dashboard-x2.png\",\"desc\":\"Snapshot Dashboard preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-backups-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-backups-x2.png\",\"desc\":\"Get back up and running quickly with one-click restore through Snapshot Backup feature.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-destinations-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/snapshot-destinations-x2.png\",\"desc\":\"Automatically send a copy of every backup to 3rd-party destinations for ultimate peace of mind.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/Snapshot_5.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2020\\/06\\/Snapshot_5@2x.png\",\"desc\":\"Set up the number of backups and choose which data center you want to use to store your backups.\"}],\"_order\":12},\"257\":{\"id\":257,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Snapshot Pro\",\"released\":1328745252,\"updated\":1642062869,\"downloads\":\"748671\",\"popularity\":\"8755\",\"short_description\":\"The automated, on-demand time-traveler that snaps and stores backups for one-click restoration. \",\"long_description\":\"It\\u2019s time to call for backup! But who do you call?! Introducing Snapshot, the smart, automated, ready on-demand time-traveler from WPMU DEV.\\r\\n<br><br>\\r\\nHe\\u2019ll snap and securely store all of your WordPress and Multisite backups in his private cloud vault. The backup protection you need with simple one-click restoration. Snapshot\\u2019s got your back...every time.\",\"features\":[\"10GB of WPMU DEV cloud storage\",\"The Hub backup manager\",\"Redundant backups\",\"Server info quick view\",\"Manage memory usage\",\"Multisite Global file exclusions\",\"ZipArchive\",\"PclZip\",\"Size segmenting eliminates timeouts\",\"Scheduled backups\",\"Set backup interval\",\"Manual backup\",\"Multisite compatible\",\"Backup entire site\",\"Include media files\",\"Exclude specific files\",\"Annotate snapshots\",\"Set custom backup folders\",\"Downloadable log files\",\"Simple one-click restore\",\"Utilize standard WP tables\",\"Mirror sync\",\"Set number of backups to store\",\"Automatically remove oldest backup\",\"Dropbox integration\",\"Amazon S3 integration\",\"FTP and SFTP integration\",\"Google Drive integration\"],\"version\":\"3.3.2\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"5.6\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/snapshot-v3\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/02\\/Snapshot_plugin.png\",\"icon\":false,\"banner_1x\":\"\",\"banner_2x\":\"\",\"video\":\"\\/\\/fast.wistia.net\\/embed\\/iframe\\/7x4kcv4j15\",\"wp_config_url\":\"admin.php?page=snapshot_pro_dashboard\",\"ms_config_url\":\"admin.php?page=snapshot_pro_dashboard\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/257\\/screenshots\\/1315522110_schedule-backup.jpg\",\"desc\":\"Schedule backups with Snapshot\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/257\\/screenshots\\/882714582_destinations-backup.jpg\",\"desc\":\"Choose a destination\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/257\\/screenshots\\/905771522_snapshot-dash.jpg\",\"desc\":\"Snapshot Dashboard\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/projects\\/257\\/screenshots\\/1953204640_managed-backups.jpg\",\"desc\":\"Managed Backups\"}],\"_order\":13},\"2175128\":{\"id\":2175128,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Shipper Pro\",\"released\":1548285368,\"updated\":1726833028,\"downloads\":\"212535\",\"popularity\":\"12585\",\"short_description\":\"Shipper Pro moves WordPress websites with one-click, from host to host, local to production, development to live, top to bottom without using FTP.\",\"long_description\":\"Site and multisite migration made easy and convenient. Shipper Pro is the super-transporter that securely moves your entire site (or multisite) to any location. It only takes a few clicks and everything is handled for you.\",\"features\":[\"Import and export\",\"No FTP\\/SFTP needed\",\"Secure dedicated server\",\"Pre-flight check\",\"Zip package migration\",\"File find and replace\",\"Files-by-file porting\",\"Large file detection\",\"Move from host to host\",\"Push from local to live\",\"Detailed Shipper Logs\",\"Display system Information\",\"Runs in the background\",\"Destination server configuration check\",\"Package size check\",\"Source check\",\"Location check\",\"Package check\",\"Migration Filters\",\"\"],\"version\":\"1.2.16\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/shipper-pro\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper-Feature-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper-Feature-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper-Feature.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Shipper.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Shipper@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=shipper\",\"ms_config_url\":\"admin.php?page=shipper\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/shipper-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/shipper-dashboard-x2.png\",\"desc\":\"Shipper Dashboard preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper_2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper_2@2x.png\",\"desc\":\"Use Shipper\\u2019s latest logs to debug any issues you are having.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/Shipper_3@2x.png\",\"desc\":\"Use the up-to-date system information if you are having issues with Shipper and server setup.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/sippher-api-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/sippher-api-x2.png\",\"desc\":\"Export your site to another server or import another site.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/shipper-create-package-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/01\\/shipper-create-package-x2.png\",\"desc\":\"Cut lengthy migration times down to size, with Package Migration.\"}],\"_order\":14},\"9135\":{\"id\":9135,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Branda Pro\",\"released\":1339280384,\"updated\":1745919293,\"downloads\":\"911151\",\"popularity\":\"65626\",\"short_description\":\"White label WordPress branding for both the front and back end of your site or network.\",\"long_description\":\"Rebrand the front and back-end of your site with ease. Transform your dashboard, customize system emails, change every aspect of your login screen, remove or replace logos, create color schemes, and much more.\",\"features\":[\"Remove WordPress branding\",\"Highlight your design\",\"Add custom logo to the Admin Bar\",\"Simple WordPress logo replacement\",\"Create custom login screen\",\"Replace the word \\\"WordPress\\\"\",\"Simple brand matching\",\"Import\\/Export setting\",\"Reorganize Admin Bar menus\",\"Set custom Admin Bar menus\",\"Add a direct link to support\",\"Add help buttons\",\"Send system emails using SMTP\",\"Remove core Dashboard widgets\",\"Hide 3rd-party dashboard widgets\",\"Replace the WordPress \'Howdy\'\",\"Coming Soon\\/Maintenance Mode\",\"Customize \'Admin Help Content\'\",\"Increase site security and speed\",\"One plugin for all settings\",\"Create a custom admin bar\",\"Set \\\"From\\\" Email address\",\"Multisite ready\",\"Customize\\/add help content\",\"Custom global footer\",\"Custom global header\",\"Custom dashboard footer\",\"Rebrand the meta widget\",\"Protect site structure\",\"Custom DB error landing page\",\"Hide \'Permalinks\' menu item\",\"Replace WordPress in HTML\",\"Replace any word or phrase\",\"Set a custom Favicon\",\"Easily insert tracking codes\",\"Custom Multisite Favicons\",\"Customize admin CSS\",\"Uses CSS child fields\",\"Hide WordPress welcome\",\"Add custom dashboard color schemes\",\"Display custom admin messages\",\"Add Author Boxes to your posts\",\"Fully customize your admin menu\"],\"version\":\"3.4.24\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4, Upfront 1.9.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/ultimate-branding\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/branda-large-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/branda-large-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/branda-large.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Branda.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Branda@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=branding\",\"ms_config_url\":\"admin.php?page=branding\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_1@2x.png\",\"desc\":\"Set admin color schemes.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_2@2x.png\",\"desc\":\"Customize admin menu.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_3@2x.png\",\"desc\":\"Customize login screen with pre-designed templates.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_4.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_4@2x.png\",\"desc\":\"Add tracking code to pages.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_5.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2012\\/06\\/Branda_5@2x.png\",\"desc\":\"Customize emails with pre-designed email templates.\"}],\"_order\":15},\"51\":{\"id\":51,\"paid\":\"paid\",\"type\":\"plugin\",\"name\":\"Beehive Pro\",\"released\":1235347220,\"updated\":1745601880,\"downloads\":\"758943\",\"popularity\":\"40249\",\"short_description\":\"Customizable Google Analytics dashboards, statistics, and reports for WordPress and Multisite.\",\"long_description\":\"The quickest and easiest way to integrate Google Analytics with your WordPress sites. Beehive Pro adds a customizable GA dashboard to WordPress so you can track user behavior from one convenient location.\",\"features\":[\"Simple one-click setup wizard\",\"Powerful Multisite integration\",\"One tracking code for an entire network\",\"Individual post\\/page statistics viewer\",\"Customize reports\",\"Anonymize IP masking\",\"Analytics dashboard widget\",\"Google Display Advertising integration\",\"Statistics overview screen\",\"Limit access based on user role\",\"Toggle statistics date range\",\"Track visits, page views and trends\",\"See visit duration and bounce rate\",\"Track top post, pages and referring links\",\"World map with visitors by country\",\"Graphs for fast visual reference\",\"Collect sub-domain data\",\"Tracks mapped domains\"],\"version\":\"3.4.17\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/beehive-analytics-pro\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/10\\/beehive-featured-placeholder-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/10\\/beehive-featured-placeholder-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2019\\/10\\/beehive-featured-placeholder.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Beehaive.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/Beehaive@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=beehive\",\"ms_config_url\":\"admin.php?page=beehive\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_1@2x.png\",\"desc\":\"Google Analytics preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_2.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_2@2x.png\",\"desc\":\"Google Analytics with Top Countries and Social Media information.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_3.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_3@2x.png\",\"desc\":\"Google Tag Manager integration.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/beehive-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/beehive-dashboard-x2.png\",\"desc\":\"Dashboard Preview.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_5.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2009\\/02\\/Beehive_5@2x.png\",\"desc\":\"Visitors widget in the Dashboard.\"}],\"_order\":16},\"248\":{\"id\":248,\"paid\":\"full\",\"type\":\"plugin\",\"name\":\"Integrated Video Tutorials\",\"released\":1318459013,\"updated\":1721665083,\"downloads\":\"206141\",\"popularity\":\"8111\",\"short_description\":\"Complete, quality, always up-to-date list of unbranded WordPress training videos.\",\"long_description\":\"45+ white label WordPress training videos for your clients. Add these videos to your WordPress dashboard via tooltips, help drop-downs, top-level menus, the content editor, and more.\",\"features\":[\"Register your domain\",\"+45 included WordPress tutorials\",\"Automatically add videos to help\",\"Verify connection\",\"Hide menu item\",\"Customize menu name\",\"Give setup permission to users\",\"Hide access to individual videos\",\"Add custom videos\",\"Wistia support\",\"YouTube support\",\"Vimeo support\",\"Shortcode embed codes\",\"Customizable playlists\",\"Group embed\",\"Front end embed\",\"Quality production\",\"Automatic content updates\",\"White label branding\",\"Unlimited bandwidth\",\"Unlimited plays\",\"SSL compatible\",\"Multisite integration\"],\"version\":\"1.8.15\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1, BuddyPress 14.3.4\",\"requires\":\"wp\",\"requires_min_php\":\"7.4\",\"url\":\"https:\\/\\/wpmudev.com\\/project\\/unbranded-video-tutorials\\/\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/Integration-Video-Tutorials-280x158.png\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/Integration-Video-Tutorials-90x90.png\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/Integration-Video-Tutorials.png\",\"icon\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/IntegratedVideoTututorials.png\",\"banner_1x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/IVT.png\",\"banner_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2022\\/04\\/IVT@2x.png\",\"video\":false,\"wp_config_url\":\"admin.php?page=wpmudev-videos\",\"ms_config_url\":\"admin.php?page=wpmudev-videos\",\"package\":0,\"is_plugin_addon\":false,\"screenshots\":[{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-dashboard-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-dashboard-x2.png\",\"desc\":\"Integrated Video Tutorials Dashboard.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-add-video-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-add-video-x2.png\",\"desc\":\"Add custom video Modal.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-playlist-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-playlist-x2.png\",\"desc\":\"All videos list page.\"},{\"url\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-settings-x1.png\",\"url_2x\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2011\\/10\\/ivt-settings-x2.png\",\"desc\":\"Video Tutorials Page.\"}],\"_order\":17},\"938297\":{\"id\":938297,\"paid\":\"paid\",\"type\":\"theme\",\"name\":\"Upfront\",\"released\":1421124646,\"updated\":1524768151,\"downloads\":\"121721\",\"popularity\":\"966\",\"short_description\":\"A versatile and infinitely customizable drag-and-drop WordPress theme platform for use with any child theme in the growing Upfront theme library.\",\"long_description\":\"a User-friendly, extremely versatile and infinitely customizable drag-and-drop WordPress theme platform.\",\"features\":[],\"version\":\"1.9.4\",\"free_version_slug\":\"\",\"autoupdate\":\"1\",\"active\":true,\"compatible\":\"WordPress 6.8.1, Multisite 6.8.1\",\"requires\":\"wp\",\"requires_min_php\":\"5.6\",\"url\":\"https:\\/\\/wpmudev.com\\/?post_type=project&p=938297\",\"thumbnail\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2015\\/01\\/upfront-280x158.jpg\",\"thumbnail_square\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2015\\/01\\/upfront-90x90.jpg\",\"thumbnail_large\":\"https:\\/\\/wpmudev.com\\/wp-content\\/uploads\\/2015\\/01\\/upfront.jpg\",\"icon\":null,\"banner_1x\":\"\",\"banner_2x\":\"\",\"video\":false,\"wp_config_url\":\"\",\"ms_config_url\":\"\",\"package\":0,\"is_plugin_addon\":false,\"_order\":18}},\"plugin_tags\":{\"489\":{\"name\":\"BuddyPress Plugins &amp; Themes\",\"count\":5,\"pids\":[\"167\",\"9135\",\"257\",\"51\",\"248\"]},\"32\":{\"name\":\"WordPress Business Plugins\",\"count\":5,\"pids\":[\"1107020\",\"167\",\"9135\",\"248\",\"2097296\"]},\"498\":{\"name\":\"WordPress Marketing Plugins\",\"count\":3,\"pids\":[\"1107020\",\"167\",\"2097296\"]},\"16\":{\"name\":\"WordPress Multisite Plugins\",\"count\":9,\"pids\":[\"912164\",\"1081721\",\"1081723\",\"167\",\"257\",\"1107020\",\"9135\",\"51\",\"248\"]},\"31\":{\"name\":\"WordPress Publishing Plugins\",\"count\":3,\"pids\":[\"912164\",\"167\",\"257\"]},\"50\":{\"name\":\"WordPress SEO Plugins\",\"count\":5,\"pids\":[\"1107020\",\"167\",\"1081721\",\"9135\",\"51\"]}},\"free_notice\":null,\"single_notice\":null,\"full_notice\":{\"time\":1509947375,\"msg\":\"<strong>We\'ve pushed all-new updates to The Hub!<\\/strong><br \\/>What\'s The Hub? Only the best way to manage all your sites in one place! Login to your WPMU DEV account to check out the new features. <a href=\\\"https:\\/\\/wpmudev.com\\/hub\\/my-websites\\/\\\">Go to The Hub<\\/a>\",\"author\":164650}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (385,'wdp_un_profile_data','{{SHIPPER_JSON_START}}{\"profile\":{\"id\":1225062,\"name\":\"Maria\",\"user_name\":\"hahafarther@gmail.com\",\"member_since\":1731969341,\"avatar\":\"https:\\/\\/wpmudev.com\\/avatar\\/d03a470a3bca2311eee1fe3e207ff02f?s=150&d=https%3A%2F%2Fwpmudev.com%2Fwp-content%2Fthemes%2Fwpmudev-2015-1%2Fassets%2Fimg%2Favatars%2Fd.png&r=pg\",\"title\":\"Free\"},\"points\":{\"rep_points\":0,\"history\":[{\"id\":\"2281112\",\"type\":\"hero\",\"timestamp\":\"1731969499\",\"points\":\"50\",\"reason_code\":\"account_signup\",\"reason\":\"You\'ve got Hero Points just for signing up. You\\u2019re on your way to greatness!\",\"object_id\":null,\"from_user\":null}],\"hero_points\":50,\"rep_level\":{\"base\":0,\"level\":0,\"name\":\"\",\"title\":\"New Recruit\"}}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (386,'wdp_un_whitelabel','{{SHIPPER_JSON_START}}{\"enabled\":false,\"branding_enabled\":false,\"branding_enabled_subsite\":false,\"branding_type\":\"default\",\"branding_image\":\"\",\"branding_image_id\":0,\"branding_image_link\":\"\",\"footer_enabled\":false,\"footer_text\":\"\",\"labels_enabled\":false,\"labels_config\":false,\"labels_config_selected\":\"\",\"labels_networkwide\":true,\"labels_subsites\":[],\"doc_links_enabled\":false}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (387,'wdp_un_analytics','{{SHIPPER_JSON_START}}{\"enabled\":false,\"tracker\":\"\",\"site_id\":\"\",\"metrics\":[\"pageviews\",\"unique_pageviews\",\"page_time\",\"visits\",\"bounce_rate\",\"exit_rate\"],\"role\":\"administrator\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (388,'wdp_un_sso','{{SHIPPER_JSON_START}}{\"enabled\":1,\"userid\":1,\"previous_token\":1748065994.7695000171661376953125,\"active_token\":\"68315ecfe2cf4\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (389,'wdp_un_data','{{SHIPPER_JSON_START}}{\"preserve_settings\":true,\"keep_data\":true}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (390,'wdp_un_general','{{SHIPPER_JSON_START}}{\"last_run_updates\":1748067358,\"last_run_profile\":1748069599,\"last_run_sync\":{\"time\":1748069709,\"hash\":\"fa9db6c9b39c13372a1752fb036545f2\",\"fails\":0},\"last_run_translation\":1748024112,\"staff_notes\":\"\",\"translation_locale\":\"en_US\",\"version\":\"4.11.28\",\"limit_to_user\":[1],\"auth_user\":\"hahafarther@gmail.com\",\"hub_nonce\":1745891126.1696999073028564453125,\"connected_admin\":1,\"site_info\":{\"wp_version\":\"6.8.1\",\"php_version\":\"8.3.20\",\"wp_debug\":false,\"php_memory\":\"768M\",\"is_multisite\":false,\"good_issues_count\":20,\"recommended_issues_count\":2,\"critical_issues_count\":1,\"issues_total\":3}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (399,'jetpack_connection_active_plugins','{{SHIPPER_JSON_START}}{\"woocommerce\":{\"name\":\"WooCommerce\"}}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (424,'ub_version','3.4.20','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (429,'branda_first_installed_version','3.4.20','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (396,'wdp_un_membership_data','{{SHIPPER_JSON_START}}{\"is_tickets_hidden\":false,\"membership_access_type\":\"paid\",\"membership\":\"full\",\"membership_full_level\":\"agency\",\"membership_excluded_projects\":[],\"membership_access\":true,\"services\":{\"uptime\":0,\"automate\":0,\"reports\":0},\"hub_site_id\":\"4046553\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (348,'woocommerce_onboarding_profile','{{SHIPPER_JSON_START}}{\"skipped\":true}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (351,'woocommerce_store_pages_only','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (352,'woocommerce_private_link','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (353,'woocommerce_share_key','xLSs4oHWnxd1JiTcaldDsUtZcFvHtr3U','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (362,'_site_transient_wp_plugin_dependencies_plugin_data','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (363,'recently_activated','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (366,'action_scheduler_migration_status','complete','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (14469,'db_upgraded','','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (397,'wdp_un_updates_available','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115671,'_transient_timeout__woocommerce_upload_directory_status','1748153483','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115672,'_transient__woocommerce_upload_directory_status','protected','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (398,'wdp_un_translation_updates_available','{{SHIPPER_JSON_START}}[{\"type\":\"plugin\",\"slug\":\"shipper\",\"language\":\"en_US\",\"version\":\"1.2.16\",\"updated\":\"2024-05-05 04:11:19\",\"package\":\"https:\\/\\/wpmudev.com\\/api\\/translations\\/v1\\/projects\\/377\\/sets\\/en\\/download\\/e9f2d585c294d8263c0ee1df1b2ac21339a7f9ff?site_id=4046553&format=pomo_zip\",\"autoupdate\":false,\"name\":\"Shipper Pro\"}]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (402,'wpmudev_apikey','e9f2d585c294d8263c0ee1df1b2ac21339a7f9ff','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115346,'_site_transient_timeout_wdp_un_translations_all_en_US','1748628912','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115347,'_site_transient_wdp_un_translations_all_en_US','{{SHIPPER_JSON_START}}[{\"id\":377,\"slug\":\"shipper\",\"name\":\"Shipper\",\"description\":\"Shipper Pro moves WordPress Websites from host to host, local to production, development to live, top to bottom without using FTP or SFTP \\u2013 WordPress migration has never been this easy. Shipper Pro is the super transporter that securely moves your entire site to any location with a click. Simple WordPress website migration. Ahoy!\",\"dev_project_id\":2175128,\"sets\":[{\"id\":3592,\"name\":\"English\",\"locale\":\"en\",\"last_modified\":\"2024-05-05 04:11:19\",\"last_modified_utc\":\"2024-05-05 04:11:19\",\"download_url\":\"https:\\/\\/wpmudev.com\\/api\\/translations\\/v1\\/projects\\/377\\/sets\\/en\\/download\",\"strings_count\":954,\"translated_count\":10,\"fuzzy_count\":0,\"waiting_count\":0}],\"sub_projects\":[]}]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (430,'branda_db_version','20190205','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (523,'wd_db_version','5.2.0','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (551,'hustle_version','7.8.7','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (695,'snapshot4_region_migration_attempt','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (467,'wp_smush_pre_3_12_6_site','0','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (468,'wp_smush_global_stats','{{SHIPPER_JSON_START}}{\"rescan_required_timestamp\":1729670789,\"optimized_images_count\":25,\"image_attachment_count\":10}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (469,'wp_smush_image_sizes_state','{{SHIPPER_JSON_START}}{\"sizes\":{\"thumbnail\":{\"width\":\"150\",\"height\":\"150\",\"crop\":true},\"medium\":{\"width\":\"300\",\"height\":\"300\",\"crop\":false},\"large\":{\"width\":\"1024\",\"height\":\"1024\",\"crop\":false},\"1536x1536\":{\"width\":1536,\"height\":1536,\"crop\":false},\"2048x2048\":{\"width\":2048,\"height\":2048,\"crop\":false},\"blog-large\":{\"width\":669,\"height\":272,\"crop\":true},\"blog-medium\":{\"width\":320,\"height\":202,\"crop\":true},\"recent-posts\":{\"width\":700,\"height\":441,\"crop\":true},\"recent-works-thumbnail\":{\"width\":66,\"height\":66,\"crop\":true},\"fusion-200\":{\"width\":200,\"height\":0,\"crop\":false},\"fusion-400\":{\"width\":400,\"height\":0,\"crop\":false},\"fusion-600\":{\"width\":600,\"height\":0,\"crop\":false},\"fusion-1200\":{\"width\":1200,\"height\":0,\"crop\":false},\"portfolio-full\":{\"width\":940,\"height\":400,\"crop\":true},\"portfolio-one\":{\"width\":540,\"height\":272,\"crop\":true},\"portfolio-two\":{\"width\":460,\"height\":295,\"crop\":true},\"portfolio-three\":{\"width\":300,\"height\":214,\"crop\":true},\"portfolio-five\":{\"width\":177,\"height\":142,\"crop\":true},\"woocommerce_thumbnail\":{\"width\":500,\"height\":0,\"crop\":0},\"woocommerce_single\":{\"width\":700,\"height\":0,\"crop\":0},\"woocommerce_gallery_thumbnail\":{\"width\":200,\"height\":200,\"crop\":1},\"medium_large\":{\"width\":768,\"height\":0}},\"hash\":150784835971}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115393,'_transient_timeout_avada_premium_plugins_info','1748116284','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115394,'_transient_avada_premium_plugins_info','{{SHIPPER_JSON_START}}{\"fusion-core\":{\"name\":\"Fusion Core\",\"plugin_name\":\"Avada Core\",\"slug\":\"fusion-core\",\"plugin_author\":\"ThemeFusion\",\"plugin_author_url\":\"https:\\/\\/avada.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-core-thumbnail.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-core-thumbnail.jpg\",\"external_url\":\"https:\\/\\/avada.theme-fusion.com\",\"premium\":true,\"latest_version\":\"5.11.13\",\"required\":true,\"icon\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-icon-transparent.png\",\"banner\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada_banner.jpg\",\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-core-companysite.jpg\",\"has_package\":true,\"version\":\"5.11.13\",\"Author\":\"ThemeFusion\",\"AuthorURI\":\"https:\\/\\/avada.com\"},\"fusion-builder\":{\"name\":\"Fusion Builder\",\"plugin_name\":\"Avada Builder\",\"slug\":\"fusion-builder\",\"plugin_author\":\"ThemeFusion\",\"plugin_author_url\":\"https:\\/\\/avada.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-builder-thumbnail.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-builder-thumbnail.jpg\",\"external_url\":\"https:\\/\\/avada.theme-fusion.com\",\"premium\":true,\"latest_version\":\"3.11.13\",\"required\":true,\"icon\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-icon-transparent.png\",\"banner\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada_banner.jpg\",\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-builder-companysite.jpg\",\"has_package\":true,\"version\":\"3.11.13\",\"Author\":\"ThemeFusion\",\"AuthorURI\":\"https:\\/\\/avada.com\"},\"fusion-white-label-branding\":{\"name\":\"Fusion White Label Branding\",\"plugin_name\":\"Avada Custom Branding\",\"slug\":\"fusion-white-label-branding\",\"plugin_author\":\"ThemeFusion\",\"plugin_author_url\":\"https:\\/\\/avada.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/avada-custom-branding-thumbnail.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/avada-custom-branding-thumbnail.jpg\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"1.2\",\"required\":false,\"icon\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/01\\/avada-icon-transparent.png\",\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/avada-custombranding-companysite.jpg\",\"has_package\":true,\"version\":\"1.2\",\"Author\":\"ThemeFusion\",\"AuthorURI\":\"https:\\/\\/avada.com\"},\"revslider\":{\"name\":\"Slider Revolution\",\"plugin_name\":\"Slider Revolution\",\"slug\":\"revslider\",\"plugin_author\":\"ThemePunch\",\"plugin_author_url\":\"http:\\/\\/themepunch.com\\/\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/08\\/slider_revolution-1.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/08\\/slider_revolution-1.png\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"6.7.34\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/08\\/slider_revolution_cs.png\",\"has_package\":true,\"version\":\"6.7.34\",\"Author\":\"ThemePunch\",\"AuthorURI\":\"http:\\/\\/themepunch.com\\/\"},\"LayerSlider\":{\"name\":\"LayerSlider WP\",\"plugin_name\":\"LayerSlider WP\",\"slug\":\"LayerSlider\",\"plugin_author\":\"Kreatura Media\",\"plugin_author_url\":\"https:\\/\\/layerslider.kreaturamedia.com\\/\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/layer_slider_plugin_thumb.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/layer_slider_plugin_thumb.png\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"7.14.4\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2016\\/08\\/layerslider_company_site.jpg\",\"has_package\":true,\"version\":\"7.14.4\",\"Author\":\"Kreatura Media\",\"AuthorURI\":\"https:\\/\\/layerslider.kreaturamedia.com\\/\"},\"advanced-custom-fields-pro\":{\"name\":\"Advanced Custom Fields PRO\",\"plugin_name\":\"Advanced Custom Fields PRO\",\"slug\":\"advanced-custom-fields-pro\",\"plugin_author\":\"Elliot Condon\",\"plugin_author_url\":\"https:\\/\\/www.advancedcustomfields.com\\/\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/acf_pro.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/acf_pro.png\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"6.4.2\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/acf_pro_company_site.jpg\",\"has_package\":true,\"version\":\"6.4.2\",\"Author\":\"Elliot Condon\",\"AuthorURI\":\"https:\\/\\/www.advancedcustomfields.com\\/\"},\"convertplug\":{\"name\":\"Convert Plus\",\"plugin_name\":\"Convert Plus\",\"slug\":\"convertplug\",\"plugin_author\":\"Brainstorm Force\",\"plugin_author_url\":\"https:\\/\\/www.brainstormforce.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/convertplus_thumbnail.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/convertplus_thumbnail.jpg\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"3.6.1\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/convertplus_thumbnail_company_site.jpg\",\"has_package\":true,\"version\":\"3.6.1\",\"Author\":\"Brainstorm Force\",\"AuthorURI\":\"https:\\/\\/www.brainstormforce.com\"},\"filebird-pro\":{\"name\":\"FileBird\",\"plugin_name\":\"FileBird\",\"slug\":\"filebird-pro\",\"plugin_author\":\"Ninja Team\",\"plugin_author_url\":\"https:\\/\\/ninjateam.org\\/wordpress-media-library-folders\\/\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2020\\/11\\/99966046-a7930180-2d8d-11eb-9695-a4e6bd9c870e.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2020\\/11\\/99966046-a7930180-2d8d-11eb-9695-a4e6bd9c870e.jpg\",\"external_url\":\"\",\"premium\":true,\"latest_version\":\"6.4.8\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2020\\/11\\/99966169-d3ae8280-2d8d-11eb-895e-0191ae051d45.jpg\",\"has_package\":true,\"version\":\"6.4.8\",\"Author\":\"Ninja Team\",\"AuthorURI\":\"https:\\/\\/ninjateam.org\\/wordpress-media-library-folders\\/\"},\"leadin\":{\"name\":\"HubSpot\",\"plugin_name\":\"HubSpot\",\"slug\":\"leadin\",\"plugin_author\":\"HubSpot\",\"plugin_author_url\":\"https:\\/\\/www.hubspot.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/10\\/hubspot_plugin_thumb.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/10\\/hubspot_plugin_thumb.jpg\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/woocommerce.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/10\\/hubspot_plugin_thumb.jpg\",\"has_package\":false},\"woocommerce\":{\"name\":\"WooCommerce\",\"plugin_name\":\"WooCommerce\",\"slug\":\"woocommerce\",\"plugin_author\":\"Automattic\",\"plugin_author_url\":\"https:\\/\\/woocommerce.com\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/woocommerce_plugin_thumb.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/woocommerce_plugin_thumb.png\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/woocommerce.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/woocommerce_plugin_thumb.png\",\"has_package\":false},\"the-events-calendar\":{\"name\":\"The Events Calendar\",\"plugin_name\":\"The Events Calendar\",\"slug\":\"the-events-calendar\",\"plugin_author\":\"Modern Tribe, Inc.\",\"plugin_author_url\":\"http:\\/\\/m.tri.be\\/1x\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/events_calendar_plugin_thumb.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/events_calendar_plugin_thumb.png\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/the-events-calendar.4.6.7.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":null,\"banner\":null,\"tf_cs_image\":null,\"has_package\":false},\"wordpress-seo\":{\"name\":\"Yoast SEO\",\"plugin_name\":\"Yoast SEO\",\"slug\":\"wordpress-seo\",\"plugin_author\":\"Team Yoast\",\"plugin_author_url\":\"https:\\/\\/yoast.com\\/\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/03\\/yoast.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/03\\/yoast.png\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":false,\"banner\":false,\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2018\\/03\\/yoast.png\",\"has_package\":false},\"bbpress\":{\"name\":\"bbPress\",\"plugin_name\":\"bbPress\",\"slug\":\"bbpress\",\"plugin_author\":\"The bbPress Community\",\"plugin_author_url\":\"https:\\/\\/bbpress.org\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/bbpress.png\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2017\\/12\\/bbpress.png\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/bbpress.2.5.14.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":null,\"banner\":null,\"tf_cs_image\":null,\"has_package\":false},\"pwa\":{\"name\":\"PWA\",\"plugin_name\":\"PWA\",\"slug\":\"pwa\",\"plugin_author\":\"PWA Plugin Contributors\",\"plugin_author_url\":\"https:\\/\\/github.com\\/xwp\\/pwa-wp\\/graphs\\/contributors\",\"image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/01\\/pwa_880_660.jpg\",\"image_url\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/01\\/pwa_880_660.jpg\",\"external_url\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/pwa.zip\",\"premium\":false,\"latest_version\":\"\",\"required\":false,\"icon\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/01\\/pwa_256_256.jpg\",\"banner\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/01\\/pwa_1544_500.jpg\",\"tf_cs_image\":\"https:\\/\\/updates.theme-fusion.com\\/wp-content\\/uploads\\/2019\\/01\\/pwa_840_438.jpg\",\"has_package\":false}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115724,'_transient_avada_dashboard_data','{{SHIPPER_JSON_START}}{\"on_sale\":false,\"price\":\"$69\",\"video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=b_HWpHZJDU8\",\"avada_version\":\"7.12.1\",\"bypass_active\":false}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115725,'_transient_timeout_avada_dashboard_data','1748073152','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115726,'_site_transient_timeout_defender_current_server','1748073266','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115727,'_site_transient_defender_current_server','{{SHIPPER_JSON_START}}{\"https:\\/\\/thrillrebels.com\":\"apache\",\"https:\\/\\/{{SHIPPER_DOMAIN}}\":\"apache\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115108,'_site_transient_timeout_snapshot_retention_job','1748080486','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115109,'_site_transient_snapshot_retention_job','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (557,'hustle_430_modules_to_migrate','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (555,'hustle_notice_stop_support_m2','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (556,'hustle_migrations','{{SHIPPER_JSON_START}}[\"hustle_40_migrated\",\"hustle_430_migrated\"]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (583,'forminator_action_scheduler_db_updated','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (584,'forminator_default_report_entry','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (585,'forminator_version','1.44.0','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (586,'widget_forminator_widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (607,'snapshot_v4_installed','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (608,'snapshot_v4_cleaned_up','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (552,'widget_hustle_module_widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (553,'widget_inc_opt_widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (545,'hustle_activated_flag','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (546,'hustle_database_version','4.8.2','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (663,'forminator_pdf_addon_version','1.36.1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (612,'snapshot_backups_version','4.33.0','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (113736,'_site_transient_timeout_wp-defender-org-slugs','1748431452','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (113737,'_site_transient_wp-defender-org-slugs','{{SHIPPER_JSON_START}}{\"fusion-builder\":true}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (698,'hardener_settings','{\"issues\":[],\"fixed\":[\"disable-xml-rpc\",\"wp-version\",\"hide-error\",\"php-version\",\"replace-admin-username\",\"security-key\",\"login-duration\",\"disable-trackback\",\"prevent-enum-users\",\"disable-file-editor\",\"prevent-php-executed\"],\"ignore\":[\"protect-information\"],\"data\":[],\"last_seen\":\"\",\"last_sent\":\"\",\"automate\":false}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (699,'wp_defender_shown_activator','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (700,'wd_audit_settings','{\"enabled\":true,\"storage_days\":\"6 months\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (701,'wd_login_lockout_settings','{\"enabled\":true,\"attempt\":3,\"timeframe\":300,\"duration\":300,\"duration_unit\":\"seconds\",\"lockout_type\":\"permanent\",\"lockout_message\":\"You have been locked out due to too many invalid login attempts.\",\"username_blacklist\":\"admin\\nadministrator\\nthrillrebels\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (702,'wd_notfound_lockout_settings','{\"enabled\":true,\"attempt\":10,\"timeframe\":300,\"duration\":300,\"duration_unit\":\"seconds\",\"lockout_type\":\"permanent\",\"blacklist\":\"\",\"whitelist\":\".css\\n.js\\n.map\",\"lockout_message\":\"You have been locked out due to too many attempts to access a file that doesn`t exist.\",\"detect_logged\":false}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (703,'wd_user_agent_settings','{\"enabled\":true,\"blacklist\":\"MJ12Bot\\nDotBot\",\"whitelist\":\"a6-indexer\\nadsbot-google\\naolbuild\\napis-google\\nbaidu\\nbingbot\\nbingpreview\\nbutterfly\\ncloudflare\\nchrome\\nduckduckbot\\nembedly\\nfacebookexternalhit\\nfacebot\\ngoogle page speed\\ngooglebot\\nia_archiver\\nlinkedinbot\\nmediapartners-google\\nmsnbot\\nnetcraftsurvey\\noutbrain\\npinterest\\nquora\\nslackbot\\nslurp\\ntweetmemebot\\ntwitterbot\\nuptimerobot\\nurlresolver\\nvkshare\\nw3c_validator\\nwordpress\\nwp rocket\\nyandex\",\"message\":\"You have been blocked from accessing this website.\",\"empty_headers\":false}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (704,'disable-xml-rpc','ON','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (705,'defender_security_tweeks_login-duration','7','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (706,'wd_scan_settings','{\"integrity_check\":true,\"check_core\":true,\"check_plugins\":false,\"scan_malware\":true,\"check_known_vuln\":true,\"filesize\":10,\"scheduled_scanning\":true,\"frequency\":\"weekly\",\"day\":\"wednesday\",\"day_n\":\"1\",\"time\":\"4:00\",\"quarantine_expire_schedule\":\"thirty_days\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (707,'wd_main_settings','{\"translate\":\"English\",\"usage_tracking\":true,\"uninstall_data\":\"keep\",\"uninstall_settings\":\"preserve\",\"high_contrast_mode\":false,\"uninstall_quarantine\":\"keep\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (708,'wpmudev_analytics_defender_data','{{SHIPPER_JSON_START}}{\"timestamp\":1741176910,\"event_count\":2}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (709,'wd_audit_fetch_checkpoint','1729036800','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (712,'wp_defender_config_default1729663690','{{SHIPPER_JSON_START}}{\"configs\":{\"scan\":{\"integrity_check\":true,\"check_core\":true,\"check_plugins\":false,\"check_known_vuln\":true,\"scan_malware\":false,\"filesize\":3,\"report\":\"enabled\",\"always_send\":false,\"report_subscribers\":[],\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"4:00\",\"frequency\":\"weekly\",\"dry_run\":false,\"notification\":\"enabled\",\"always_send_notification\":false,\"error_send\":false,\"notification_subscribers\":[],\"email_subject_issue_found\":\"Malware Scan of {SITE_URL} is complete. {ISSUES_COUNT} issue(s) found.\",\"email_subject_issue_not_found\":\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\",\"email_subject_error\":\"Couldn\\u2019t scan {SITE_URL} for vulnerabilities. \",\"email_content_issue_found\":\"Hi {USER_NAME},\\r\\n\\r\\nMalware Scan identified {ISSUES_COUNT} issue(s) on {SITE_URL}. The identified issue(s) is\\/are listed below.\\r\\n\\r\\n{ISSUES_LIST}\",\"email_content_issue_not_found\":\"Hi {USER_NAME},\\r\\n\\r\\nNo vulnerabilities have been found for {SITE_URL}.\",\"email_content_error\":\"Hi {USER_NAME},\\r\\n\\r\\nWe couldn\\u2019t scan {SITE_URL} for vulnerabilities. Please visit your site and run a manual scan.\",\"scheduled_scanning\":true},\"iplockout\":{\"login_protection\":true,\"login_protection_login_attempt\":\"5\",\"login_protection_lockout_timeframe\":\"300\",\"login_protection_lockout_ban\":\"timeframe\",\"login_protection_lockout_duration\":\"4\",\"login_protection_lockout_duration_unit\":\"hours\",\"login_protection_lockout_message\":\"You have been locked out due to too many invalid login attempts.\",\"username_blacklist\":\"adm\\nadmin\\nadmin1\\nhostname\\nmanager\\nqwerty\\nroot\\nsupport\\nsysadmin\\ntest\\nuser\\nadministrator\",\"detect_404\":true,\"detect_404_threshold\":\"20\",\"detect_404_timeframe\":\"300\",\"detect_404_lockout_ban\":\"timeframe\",\"detect_404_lockout_duration\":\"4\",\"detect_404_lockout_duration_unit\":\"hours\",\"detect_404_lockout_message\":\"You have been locked out due to too many attempts to access a file that doesn`t exist.\",\"detect_404_blacklist\":\"\",\"detect_404_whitelist\":\".css\\n.js\\n.jpg\\n.png\\n.gif\\n.map\",\"detect_404_logged\":true,\"ip_blacklist\":\"\",\"ip_whitelist\":\"\",\"country_blacklist\":\"\",\"country_whitelist\":\"\",\"ip_lockout_message\":\"The administrator has blocked your IP from accessing this website.\",\"login_lockout_notification\":true,\"ip_lockout_notification\":true,\"notification\":\"enabled\",\"notification_subscribers\":[],\"cooldown_enabled\":false,\"cooldown_number_lockout\":\"3\",\"cooldown_period\":\"24\",\"report\":\"enabled\",\"report_subscribers\":[],\"report_frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"report_time\":\"4:00\",\"dry_run\":false,\"storage_days\":\"180\",\"geoIP_db\":\"\",\"ip_blocklist_cleanup_interval\":\"never\",\"ua_banning_enabled\":false,\"ua_banning_message\":\"You have been blocked from accessing this website.\",\"ua_banning_blacklist\":\"MJ12Bot\\nAhrefsBot\\nSEMrushBot\\nDotBot\",\"ua_banning_whitelist\":\"a6-indexer\\nadsbot-google\\naolbuild\\napis-google\\nbaidu\\nbingbot\\nbingpreview\\nbutterfly\\ncloudflare\\nchrome\\nduckduckbot\\nembedly\\nfacebookexternalhit\\nfacebot\\ngoogle page speed\\ngooglebot\\nia_archiver\\nlinkedinbot\\nmediapartners-google\\nmsnbot\\nnetcraftsurvey\\noutbrain\\npinterest\\nquora\\nslackbot\\nslurp\\ntweetmemebot\\ntwitterbot\\nuptimerobot\\nurlresolver\\nvkshare\\nw3c_validator\\nwordpress\\nwp rocket\\nyandex\",\"ua_banning_empty_headers\":false,\"maxmind_license_key\":\"\",\"global_ip_list\":false,\"global_ip_list_blocklist_autosync\":false},\"two_factor\":{\"enabled\":false,\"lost_phone\":true,\"force_auth\":false,\"force_auth_mess\":\"You are required to setup two-factor authentication to use this site.\",\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\",\"customer\",\"shop_manager\"],\"force_auth_roles\":[],\"custom_graphic\":false,\"custom_graphic_type\":\"upload\",\"custom_graphic_url\":\"\",\"custom_graphic_link\":\"\",\"email_subject\":\"Your OTP code\",\"email_sender\":\"admin\",\"email_body\":\"Hi {{display_name}},\\r\\n\\r\\nYour temporary password is {{passcode}}\\r\\nTo complete your login, copy and paste the temporary password into the Password field on the login screen.\",\"app_title\":\"\"},\"mask_login\":{\"enabled\":false,\"mask_url\":\"\",\"redirect_traffic\":\"off\",\"redirect_traffic_url\":\"\",\"redirect_traffic_page_id\":0},\"security_headers\":{\"sh_xframe\":true,\"sh_xframe_mode\":\"sameorigin\",\"sh_xframe_urls\":\"\",\"sh_xss_protection\":true,\"sh_xss_protection_mode\":\"sanitize\",\"sh_content_type_options\":true,\"sh_content_type_options_mode\":\"nosniff\",\"sh_strict_transport\":true,\"hsts_preload\":false,\"include_subdomain\":false,\"hsts_cache_duration\":\"30 days\",\"sh_referrer_policy\":true,\"sh_referrer_policy_mode\":\"origin-when-cross-origin\",\"sh_feature_policy\":true,\"sh_feature_policy_mode\":\"self\",\"sh_feature_policy_urls\":\"\"},\"settings\":{\"uninstall_data\":\"keep\",\"uninstall_settings\":\"preserve\",\"translate\":\"\",\"usage_tracking\":false,\"high_contrast_mode\":false},\"pwned_passwords\":{\"enabled\":false,\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\",\"customer\",\"shop_manager\"],\"custom_message\":\"You are required to change your password because the password you are using exists on database breach records.\"},\"audit\":{\"enabled\":true,\"report\":\"enabled\",\"subscribers\":[],\"frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"4:00\",\"dry_run\":false,\"storage_days\":\"6 months\"},\"blocklist_monitor\":{\"enabled\":true,\"status\":\"1\"},\"security_tweaks\":{\"notification_repeat\":\"weekly\",\"subscribers\":[],\"notification\":\"enabled\",\"automate\":true,\"data\":[],\"fixed\":[\"disable-xml-rpc\",\"login-duration\",\"disable-trackback\",\"prevent-enum-users\"],\"issues\":[\"php-version\",\"wp-version\",\"prevent-php-executed\",\"protect-information\",\"replace-admin-username\",\"security-key\",\"disable-file-editor\",\"hide-error\"],\"ignore\":[]}},\"strings\":{\"scan\":[\"Active\",\"Email notifications active\",\"Email reports sending weekly\"],\"iplockout\":[\"Login Protection active\",\"404 Detection active\",\"Global IP Blocker inactive\",\"User Agent Banning inactive\",\"Email notifications active\",\"Email reports sending weekly\"],\"two_factor\":[\"Inactive\"],\"mask_login\":[\"Inactive\"],\"security_headers\":[\"Active\"],\"pwned_passwords\":[\"Inactive\"],\"audit\":[\"Active\",\"Email reports sending weekly\"],\"blocklist_monitor\":[\"Active\"],\"security_tweaks\":[\"4\\/12 recommendations activated\",\"Email notifications active\"]},\"name\":\"Basic Config\",\"description\":\"Recommended default protection for every site\",\"immortal\":true,\"is_removable\":true,\"is_active\":false}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (713,'defender_config_indexer','{{SHIPPER_JSON_START}}{\"wp_defender_config_default1729663690\":\"wp_defender_config_default1729663690\",\"wp_defender_config_hub_11633\":\"wp_defender_config_hub_11633\"}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (716,'wpdefender_preset_configs_transient_time','1729673189','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (717,'wp_defender_config_hub_11633','{{SHIPPER_JSON_START}}{\"configs\":{\"security_tweaks\":{\"notification_repeat\":\"weekly\",\"subscribers\":[],\"notification\":\"enabled\",\"automate\":true,\"data\":[],\"fixed\":[\"disable-xml-rpc\",\"login-duration\",\"disable-trackback\",\"prevent-enum-users\"],\"issues\":[\"php-version\",\"wp-version\",\"prevent-php-executed\",\"protect-information\",\"replace-admin-username\",\"security-key\",\"disable-file-editor\",\"hide-error\"],\"ignore\":[],\"enabled_user_enums\":null,\"security_key\":null},\"scan\":{\"integrity_check\":true,\"check_core\":true,\"check_themes\":false,\"check_plugins\":false,\"check_known_vuln\":true,\"scan_malware\":false,\"filesize\":3,\"report\":\"enabled\",\"always_send\":false,\"report_subscribers\":[],\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"4:00\",\"frequency\":\"weekly\",\"dry_run\":false,\"notification\":\"enabled\",\"always_send_notification\":false,\"error_send\":false,\"notification_subscribers\":[],\"email_subject_issue_found\":\"Malware Scan of {SITE_URL} is complete. {ISSUES_COUNT} issue(s) found.\",\"email_subject_issue_not_found\":\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\",\"email_subject_error\":\"Couldn\\u2019t scan {SITE_URL} for vulnerabilities.\",\"email_content_issue_found\":\"Hi {USER_NAME},\\n\\nMalware Scan identified {ISSUES_COUNT} issue(s) on {SITE_URL}. The identified issue(s) is\\/are listed below.\\n\\n{ISSUES_LIST}\",\"email_content_issue_not_found\":\"Hi {USER_NAME},\\n\\nNo vulnerabilities have been found for {SITE_URL}.\",\"email_content_error\":\"Hi {USER_NAME},\\n\\nWe couldn\\u2019t scan {SITE_URL} for vulnerabilities. Please visit your site and run a manual scan.\",\"scheduled_scanning\":true},\"iplockout\":{\"login_protection\":true,\"login_protection_login_attempt\":5,\"login_protection_lockout_timeframe\":300,\"login_protection_lockout_ban\":\"timeframe\",\"login_protection_lockout_duration\":4,\"login_protection_lockout_duration_unit\":\"hours\",\"login_protection_lockout_message\":\"You have been locked out due to too many invalid login attempts.\",\"username_blacklist\":\"adm\\nadmin\\nadmin1\\nhostname\\nmanager\\nqwerty\\nroot\\nsupport\\nsysadmin\\ntest\\nuser\\nadministrator\",\"detect_404\":true,\"detect_404_threshold\":20,\"detect_404_timeframe\":300,\"detect_404_lockout_ban\":\"timeframe\",\"detect_404_lockout_duration\":4,\"detect_404_lockout_duration_unit\":\"hours\",\"detect_404_lockout_message\":\"You have been locked out due to too many attempts to access a file that doesn\'t exist.\",\"detect_404_blacklist\":\"\",\"detect_404_whitelist\":\".css\\n.js\\n.jpg\\n.png\\n.gif\\n.map\",\"detect_404_logged\":true,\"ip_blacklist\":\"\",\"ip_whitelist\":\"\",\"country_blacklist\":\"\",\"country_whitelist\":\"\",\"ip_lockout_message\":\"The administrator has blocked your IP from accessing this website.\",\"login_lockout_notification\":true,\"ip_lockout_notification\":true,\"notification\":\"enabled\",\"notification_subscribers\":[],\"cooldown_enabled\":false,\"cooldown_number_lockout\":\"3\",\"cooldown_period\":\"24\",\"report\":\"enabled\",\"report_subscribers\":[],\"report_frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"report_time\":\"4:00\",\"dry_run\":false,\"storage_days\":\"180\",\"geoIP_db\":\"\",\"ip_blocklist_cleanup_interval\":\"never\",\"ua_banning_enabled\":false,\"ua_banning_message\":\"You have been blocked from accessing this website.\",\"ua_banning_blacklist\":\"MJ12Bot\\nAhrefsBot\\nSEMrushBot\\nDotBot\",\"ua_banning_whitelist\":\"a6-indexer\\nadsbot-google\\naolbuild\\napis-google\\nbaidu\\nbingbot\\nbingpreview\\nbutterfly\\ncloudflare\\nchrome\\nduckduckbot\\nembedly\\nfacebookexternalhit\\nfacebot\\ngoogle page speed\\ngooglebot\\nia_archiver\\nlinkedinbot\\nmediapartners-google\\nmsnbot\\nnetcraftsurvey\\noutbrain\\npinterest\\nquora\\nslackbot\\nslurp\\ntweetmemebot\\ntwitterbot\\nuptimerobot\\nurlresolver\\nvkshare\\nw3c_validator\\nwordpress\\nwp rocket\\nyandex\",\"ua_banning_empty_headers\":false,\"maxmind_license_key\":\"\",\"global_ip_list\":false},\"two_factor\":{\"enabled\":false,\"lost_phone\":true,\"force_auth\":false,\"force_auth_mess\":\"You are required to setup two-factor authentication to use this site.\",\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\"],\"force_auth_roles\":[],\"custom_graphic\":false,\"custom_graphic_url\":\"\",\"email_subject\":\"Your OTP code\",\"email_sender\":\"admin\",\"email_body\":\"Hi {{display_name}},\\r\\n\\r\\nYour temporary login passcode is {{passcode}}.\\r\\n\\r\\nCopy and paste the passcode into the input field on the login screen to complete logging in.\\r\\n\\r\\nRegards,\\r\\nAdministrator\",\"app_title\":\"\",\"custom_graphic_type\":\"upload\",\"custom_graphic_link\":\"\",\"detect_woo\":null},\"mask_login\":{\"enabled\":false,\"mask_url\":\"\",\"redirect_traffic\":\"off\",\"redirect_traffic_url\":\"\",\"redirect_traffic_page_id\":0},\"security_headers\":{\"sh_xframe\":true,\"sh_xframe_mode\":\"sameorigin\",\"sh_xframe_urls\":\"\",\"sh_xss_protection\":true,\"sh_xss_protection_mode\":\"sanitize\",\"sh_content_type_options\":true,\"sh_content_type_options_mode\":\"nosniff\",\"sh_strict_transport\":true,\"hsts_preload\":false,\"include_subdomain\":false,\"hsts_cache_duration\":\"30 days\",\"sh_referrer_policy\":true,\"sh_referrer_policy_mode\":\"origin-when-cross-origin\",\"sh_feature_policy\":true,\"sh_feature_policy_mode\":\"self\",\"sh_feature_policy_urls\":\"\"},\"settings\":{\"uninstall_data\":\"keep\",\"uninstall_settings\":\"preserve\",\"translate\":\"\",\"usage_tracking\":false,\"high_contrast_mode\":false},\"pwned_passwords\":{\"enabled\":false,\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\"],\"custom_message\":\"You are required to change your password because the password you are using exists on database breach records.\"},\"audit\":{\"enabled\":true,\"report\":\"enabled\",\"subscribers\":[],\"frequency\":\"weekly\",\"day\":\"sunday\",\"day_n\":\"1\",\"time\":\"4:00\",\"dry_run\":false,\"storage_days\":\"6 months\"},\"blocklist_monitor\":{\"enabled\":true,\"status\":\"1\"}},\"strings\":{\"security_tweaks\":[\"4\\/12 recommendations activated\",\"Email notifications active\"],\"scan\":[\"Active\",\"Email notifications active\",\"Email reports sending weekly\"],\"audit\":[\"Active\",\"Email reports sending weekly\"],\"iplockout\":[\"Login Protection active\",\"404 Detection active\",\"Global IP Blocker inactive\",\"User Agent Banning inactive\",\"Email notifications active\",\"Email reports sending weekly\"],\"two_factor\":[\"Inactive\"],\"mask_login\":[\"Inactive\"],\"security_headers\":[\"Active\"],\"blocklist_monitor\":[\"Active\"],\"pwned_passwords\":[\"Inactive\"]},\"hub_id\":11633,\"name\":\"Default Security Config\",\"description\":\"The default Security config. Great to get started with, remember to add notifications.\",\"immortal\":false,\"is_removable\":false,\"is_active\":false}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (1703,'wd_malware_scanning_report','{\"title\":\"Malware Scanning - Reporting\",\"slug\":\"malware-report\",\"description\":\"Automatically run regular scans of your website and email you reports.\",\"status\":\"disabled\",\"type\":\"report\",\"frequency\":\"weekly\",\"day\":\"wednesday\",\"day_n\":\"1\",\"time\":\"4:00\",\"in_house_recipients\":[{\"name\":\"Thrill Rebels CEO\",\"id\":\"1\",\"email\":\"hello@bryant.design\",\"role\":\"Administrator\",\"avatar\":\"http:\\/\\/thrillrebels.com\\/wp-content\\/wphb-cache\\/gravatar\\/d93\\/d93a7754f4bcfea39033cc4ee41a3291x96.jpg\",\"status\":\"subscribed\"}],\"out_house_recipients\":[],\"dry_run\":false,\"configs\":{\"always_send\":false,\"error_send\":false,\"template\":{\"found\":{\"subject\":\"Malware Scan of {SITE_URL} is complete. {ISSUES_COUNT} issue(s) found.\",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nMalware Scan identified {ISSUES_COUNT} issue(s) on {SITE_URL}. The identified issue(s) is\\/are listed below.\\r\\n\\r\\n{ISSUES_LIST}\"},\"not_found\":{\"subject\":\"Scan of {SITE_URL} complete. {ISSUES_COUNT} issues found.\",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nNo vulnerabilities have been found for {SITE_URL}.\"},\"error\":{\"subject\":\"Couldn\\u2019t scan {SITE_URL} for vulnerabilities. \",\"body\":\"Hi {USER_NAME},\\r\\n\\r\\nWe couldn\\u2019t scan {SITE_URL} for vulnerabilities. Please visit your site and run a manual scan.\"}}},\"last_sent\":1747825200,\"est_timestamp\":1748430000,\"next_run\":\"May 28, 2025 4:00 am\",\"all_subscribers\":[{\"name\":\"Thrill Rebels CEO\",\"id\":\"1\",\"email\":\"hello@bryant.design\",\"role\":\"Administrator\",\"avatar\":\"http:\\/\\/thrillrebels.com\\/wp-content\\/wphb-cache\\/gravatar\\/d93\\/d93a7754f4bcfea39033cc4ee41a3291x96.jpg\",\"status\":\"subscribed\"}]}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (971,'fusion_options-transients','{{SHIPPER_JSON_START}}{\"changed_values\":{\"recaptcha_public\":\"\",\"recaptcha_private\":\"\"},\"last_save\":1737056655}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (112748,'_transient_timeout_wc_term_counts','1750290854','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (112749,'_transient_wc_term_counts','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (65240,'wp-smush-show_upgrade_modal','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (28957,'wphb-caching-data','{{SHIPPER_JSON_START}}{\"JavaScript\":false,\"CSS\":false,\"Media\":false,\"Images\":false}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (27263,'defender_security_tweaks_security-key','{{SHIPPER_JSON_START}}{\"last_modified\":1745216112}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (81155,'_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl','1750661700','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (81156,'_transient_woocommerce_blocks_asset_api_script_data_ssl','{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"4d43a4bcb41a5a6336c2\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"df3cbcae422855d48387\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"0d3321630119e50d175f\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"94f6fdb24497762c3877\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"13ca26913ccb282c047e\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"6d08dccfb4bf1a392a0d\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"4d3dbff32a4959449c1d\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"ce9125bf472706dea11a\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"a3e67bb0b09f566d5bdf\",\"dependencies\":[\"wc-settings\",\"wp-html-entities\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"a5f075e4ff6dd6090875\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"a16e7eb12f5267371fe0\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"2def9412eeabab2071b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"0ea5d4718f1bb3c42ede\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"c163716dbc1e3cc6748c\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"e4169377f115faded81a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"daf82f32ab7ca75c7285\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"a06716cace69cf0ce81f\",\"dependencies\":[\"react\",\"react-dom\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"92dea44f259a5d3cc1aa\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.8.5\",\"dependencies\":[]}},\"version\":\"wc-9.8.5\",\"hash\":\"34c231d8d375014bc046a8f4f626968f\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115732,'_site_transient_timeout_wp_theme_files_patterns-324d0681937c0855f69f555a6a135acf','1748071465','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115733,'_site_transient_wp_theme_files_patterns-324d0681937c0855f69f555a6a135acf','{{SHIPPER_JSON_START}}{\"version\":false,\"patterns\":[]}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115710,'_transient_doing_cron','1748067306.1785030364990234375000','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115714,'_transient_timeout_woocommerce_admin_remote_free_extensions_specs','1748672107','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115715,'_transient_woocommerce_admin_remote_free_extensions_specs','a:1:{s:5:\"en_US\";a:5:{s:10:\"obw/basics\";O:8:\"stdClass\":3:{s:3:\"key\";s:10:\"obw/basics\";s:5:\"title\";s:14:\"Get the basics\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:154:\"Accept credit cards and other popular payment methods with <a href=\"https://woocommerce.com/products/woocommerce-payments\" target=\"_blank\">WooPayments</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:39:{i:0;s:2:\"US\";i:1;s:2:\"PR\";i:2;s:2:\"AU\";i:3;s:2:\"CA\";i:4;s:2:\"DE\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"GB\";i:8;s:2:\"IE\";i:9;s:2:\"IT\";i:10;s:2:\"NZ\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"NL\";i:14;s:2:\"PL\";i:15;s:2:\"PT\";i:16;s:2:\"CH\";i:17;s:2:\"HK\";i:18;s:2:\"SG\";i:19;s:2:\"CY\";i:20;s:2:\"DK\";i:21;s:2:\"EE\";i:22;s:2:\"FI\";i:23;s:2:\"GR\";i:24;s:2:\"LU\";i:25;s:2:\"LT\";i:26;s:2:\"LV\";i:27;s:2:\"NO\";i:28;s:2:\"MT\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"BG\";i:32;s:2:\"CZ\";i:33;s:2:\"HR\";i:34;s:2:\"HU\";i:35;s:2:\"RO\";i:36;s:2:\"SE\";i:37;s:2:\"JP\";i:38;s:2:\"AE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Shipping\";s:11:\"description\";s:119:\"Print shipping labels with <a href=\"https://woocommerce.com/products/shipping\" target=\"_blank\">WooCommerce Shipping</a>\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:1:{i:0;s:2:\"US\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-shipping\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:13:\"product_types\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:5:\"count\";}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";i:1;s:7:\"default\";a:0:{}s:9:\"operation\";s:2:\"!=\";}}i:1;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"product_types.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:9:\"downloads\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:2:\"!=\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:20:\"woocommerce-shipping\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"WooCommerce Tax\";s:11:\"description\";s:111:\"Get automated sales tax with <a href=\"https://woocommerce.com/products/tax\" target=\"_blank\">WooCommerce Tax</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:11:{i:0;s:2:\"US\";i:1;s:2:\"FR\";i:2;s:2:\"GB\";i:3;s:2:\"DE\";i:4;s:2:\"CA\";i:5;s:2:\"AU\";i:6;s:2:\"GR\";i:7;s:2:\"BE\";i:8;s:2:\"PT\";i:9;s:2:\"DK\";i:10;s:2:\"SE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Jetpack\";s:11:\"description\";s:110:\"Enhance speed and security with <a href=\"https://woocommerce.com/products/jetpack\" target=\"_blank\">Jetpack</a>\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:7:\"jetpack\";}}}}}s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";}}}s:8:\"obw/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:8:\"obw/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:115:\"Level up your email marketing with <a href=\"https://woocommerce.com/products/mailpoet\" target=\"_blank\">MailPoet</a>\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:60;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";}i:1;O:8:\"stdClass\":8:{s:4:\"name\";s:22:\"Google for WooCommerce\";s:11:\"description\";s:126:\"Drive sales with <a href=\"https://woocommerce.com/products/google-listings-and-ads\" target=\"_blank\">Google for WooCommerce</a>\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";}i:2;O:8:\"stdClass\":8:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:76:\"Get your products in front of Pinners searching for ideas and things to buy.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:60;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:24:\"Facebook for WooCommerce\";s:11:\"description\";s:141:\"List products and create ads on Facebook and Instagram with <a href=\"https://woocommerce.com/products/facebook/\">Facebook for WooCommerce</a>\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:24:\"facebook-for-woocommerce\";}}}s:15:\"task-list/reach\";O:8:\"stdClass\":3:{s:3:\"key\";s:15:\"task-list/reach\";s:5:\"title\";s:22:\"Reach out to customers\";s:7:\"plugins\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:111:\"Create and send purchase follow-up emails, newsletters, and promotional campaigns straight from your dashboard.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailpoet.svg\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:12:\"mailpoet:alt\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:138:\"Grow and retain customers with intelligent, impactful email and SMS marketing automation and a consolidated view of customer interactions.\";s:9:\"image_url\";s:95:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:11:\"klaviyo:alt\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:78:\"Send targeted campaigns, recover abandoned carts and much more with Mailchimp.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:29:\"mailchimp-for-woocommerce:alt\";}}}s:14:\"task-list/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:14:\"task-list/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:6:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"Google for WooCommerce\";s:11:\"description\";s:134:\"Reach more shoppers and drive sales for your store. Integrate with Google to list your products for free and launch paid ad campaigns.\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:27:\"google-listings-and-ads:alt\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:22:\"TikTok for WooCommerce\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/tiktok.svg\";s:11:\"description\";s:118:\"Grow your online sales by promoting your products on TikTok to over one billion monthly active users around the world.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CZ\";i:6;s:2:\"DK\";i:7;s:2:\"FI\";i:8;s:2:\"FR\";i:9;s:2:\"DE\";i:10;s:2:\"GR\";i:11;s:2:\"HU\";i:12;s:2:\"IE\";i:13;s:2:\"IT\";i:14;s:2:\"NL\";i:15;s:2:\"PL\";i:16;s:2:\"PT\";i:17;s:2:\"RO\";i:18;s:2:\"ES\";i:19;s:2:\"SE\";i:20;s:2:\"GB\";i:21;s:2:\"CH\";i:22;s:2:\"NO\";i:23;s:2:\"AU\";i:24;s:2:\"NZ\";i:25;s:2:\"SG\";i:26;s:2:\"MY\";i:27;s:2:\"PH\";i:28;s:2:\"ID\";i:29;s:2:\"VN\";i:30;s:2:\"TH\";i:31;s:2:\"KR\";i:32;s:2:\"IL\";i:33;s:2:\"AE\";i:34;s:2:\"RU\";i:35;s:2:\"UA\";i:36;s:2:\"TR\";i:37;s:2:\"SA\";i:38;s:2:\"BR\";i:39;s:2:\"JP\";}s:9:\"operation\";s:2:\"in\";}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:159:\"Get your products in front of Pinterest users searching for ideas and things to buy. Get started with Pinterest and make your entire product catalog browsable.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"pinterest-for-woocommerce:alt\";}i:3;O:8:\"stdClass\":8:{s:4:\"name\";s:26:\"Meta Ads & Pixel by Kliken\";s:11:\"description\";s:150:\"Automate Facebook & Instagram marketing with Kliken. Launch ads and schedule a month of posts in 5 minutes—first 5 free! Plans start at just $20/mo.\";s:9:\"image_url\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/kliken-kraken-icon.webp\";s:10:\"manage_url\";s:40:\"admin.php?page=kliken-ads-pixel-for-meta\";s:14:\"is_built_by_wc\";b:0;s:16:\"install_external\";b:0;s:10:\"is_visible\";b:1;s:3:\"key\";s:29:\"kliken-ads-pixel-for-meta:alt\";}i:4;O:8:\"stdClass\":7:{s:4:\"name\";s:24:\"Facebook for WooCommerce\";s:11:\"description\";s:55:\"List products and create ads on Facebook and Instagram.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:28:\"facebook-for-woocommerce:alt\";}i:5;O:8:\"stdClass\":10:{s:4:\"name\";s:28:\"Multichannel for WooCommerce\";s:11:\"description\";s:85:\"Sync your sales data across platforms and manage everything from a unified dashboard.\";s:9:\"image_url\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/multichannel.webp\";s:10:\"manage_url\";s:28:\"admin.php?page=sales_channel\";s:14:\"is_built_by_wc\";b:0;s:16:\"install_external\";b:1;s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.8.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:15:\"learn_more_link\";s:143:\"https://woocommerce.com/products/multichannel-by-cedcommerce-ebay-amazon-walmart-etsy-integration/?utm_source=marketing_task&utm_medium=product\";s:4:\"tags\";a:1:{i:0;s:11:\"marketplace\";}s:3:\"key\";s:27:\"multichannel-by-cedcommerce\";}}}s:17:\"obw/core-profiler\";O:8:\"stdClass\":3:{s:3:\"key\";s:17:\"obw/core-profiler\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:13:{i:0;O:8:\"stdClass\":11:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:54:\"Offer safe and convenient ways to pay with WooPayments\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:39:{i:0;s:2:\"US\";i:1;s:2:\"PR\";i:2;s:2:\"AU\";i:3;s:2:\"CA\";i:4;s:2:\"DE\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"GB\";i:8;s:2:\"IE\";i:9;s:2:\"IT\";i:10;s:2:\"NZ\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"NL\";i:14;s:2:\"PL\";i:15;s:2:\"PT\";i:16;s:2:\"CH\";i:17;s:2:\"HK\";i:18;s:2:\"SG\";i:19;s:2:\"CY\";i:20;s:2:\"DK\";i:21;s:2:\"EE\";i:22;s:2:\"FI\";i:23;s:2:\"GR\";i:24;s:2:\"LU\";i:25;s:2:\"LT\";i:26;s:2:\"LV\";i:27;s:2:\"NO\";i:28;s:2:\"MT\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"BG\";i:32;s:2:\"CZ\";i:33;s:2:\"HR\";i:34;s:2:\"HU\";i:35;s:2:\"RO\";i:36;s:2:\"SE\";i:37;s:2:\"JP\";i:38;s:2:\"AE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";s:5:\"label\";s:25:\"Get paid with WooPayments\";s:9:\"image_url\";s:120:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo-rebrand-2.svg\";s:15:\"learn_more_link\";s:123:\"https://woocommerce.com/products/woocommerce-payments?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:5;s:12:\"requires_jpc\";b:1;}i:1;O:8:\"stdClass\":9:{s:4:\"name\";s:20:\"WooCommerce Shipping\";s:11:\"description\";s:41:\"Print discounted USPS, UPS and DHL labels\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:20:\"woocommerce-shipping\";s:5:\"label\";s:42:\"Save on shipping with WooCommerce Shipping\";s:9:\"image_url\";s:120:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo-rebrand-2.svg\";s:15:\"learn_more_link\";s:114:\"https://woocommerce.com/woocommerce-shipping?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:3;}i:2;O:8:\"stdClass\":10:{s:4:\"name\";s:31:\"PayPal Payments for WooCommerce\";s:11:\"description\";s:61:\"Offer more ways to pay with this all-in-one checkout solution\";s:14:\"is_built_by_wc\";b:0;s:15:\"install_options\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"name\";s:26:\"woocommerce_paypal_branded\";s:5:\"value\";s:8:\"profiler\";}}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:39:{i:0;s:2:\"US\";i:1;s:2:\"PR\";i:2;s:2:\"AU\";i:3;s:2:\"CA\";i:4;s:2:\"DE\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"GB\";i:8;s:2:\"IE\";i:9;s:2:\"IT\";i:10;s:2:\"NZ\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"NL\";i:14;s:2:\"PL\";i:15;s:2:\"PT\";i:16;s:2:\"CH\";i:17;s:2:\"HK\";i:18;s:2:\"SG\";i:19;s:2:\"CY\";i:20;s:2:\"DK\";i:21;s:2:\"EE\";i:22;s:2:\"FI\";i:23;s:2:\"GR\";i:24;s:2:\"LU\";i:25;s:2:\"LT\";i:26;s:2:\"LV\";i:27;s:2:\"NO\";i:28;s:2:\"MT\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"BG\";i:32;s:2:\"CZ\";i:33;s:2:\"HR\";i:34;s:2:\"HU\";i:35;s:2:\"RO\";i:36;s:2:\"SE\";i:37;s:2:\"JP\";i:38;s:2:\"AE\";}s:9:\"operation\";s:3:\"!in\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"9.8.0-rc.1\";s:8:\"operator\";s:2:\">=\";}}s:3:\"key\";s:27:\"woocommerce-paypal-payments\";s:5:\"label\";s:41:\"Maximize conversions with PayPal Payments\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-paypal.svg\";s:15:\"learn_more_link\";s:130:\"https://woocommerce.com/products/woocommerce-paypal-payments?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:5;}i:3;O:8:\"stdClass\":9:{s:4:\"name\";s:31:\"PayPal Payments for WooCommerce\";s:11:\"description\";s:60:\"Offer additional flexible payment options with PayPal Wallet\";s:14:\"is_built_by_wc\";b:0;s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:39:{i:0;s:2:\"US\";i:1;s:2:\"PR\";i:2;s:2:\"AU\";i:3;s:2:\"CA\";i:4;s:2:\"DE\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"GB\";i:8;s:2:\"IE\";i:9;s:2:\"IT\";i:10;s:2:\"NZ\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"NL\";i:14;s:2:\"PL\";i:15;s:2:\"PT\";i:16;s:2:\"CH\";i:17;s:2:\"HK\";i:18;s:2:\"SG\";i:19;s:2:\"CY\";i:20;s:2:\"DK\";i:21;s:2:\"EE\";i:22;s:2:\"FI\";i:23;s:2:\"GR\";i:24;s:2:\"LU\";i:25;s:2:\"LT\";i:26;s:2:\"LV\";i:27;s:2:\"NO\";i:28;s:2:\"MT\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"BG\";i:32;s:2:\"CZ\";i:33;s:2:\"HR\";i:34;s:2:\"HU\";i:35;s:2:\"RO\";i:36;s:2:\"SE\";i:37;s:2:\"JP\";i:38;s:2:\"AE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"9.8.0-rc.1\";s:8:\"operator\";s:2:\">=\";}}s:3:\"key\";s:39:\"woocommerce-paypal-payments:wallet-only\";s:5:\"label\";s:38:\"Give shoppers a variety of ways to pay\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-paypal.svg\";s:15:\"learn_more_link\";s:130:\"https://woocommerce.com/products/woocommerce-paypal-payments?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:5;}i:4;O:8:\"stdClass\":11:{s:4:\"name\";s:7:\"Jetpack\";s:11:\"description\";s:53:\"Keep your store online with full security and backups\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";s:5:\"label\";s:48:\"Boost content creation with Jetpack AI Assistant\";s:9:\"image_url\";s:114:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-jetpack.svg\";s:15:\"learn_more_link\";s:110:\"https://woocommerce.com/products/jetpack?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:8;s:12:\"requires_jpc\";b:1;}i:5;O:8:\"stdClass\":11:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:55:\"Get your products in front of a highly engaged audience\";s:9:\"image_url\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-pinterest.svg\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:60;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";s:5:\"label\";s:37:\"Showcase your products with Pinterest\";s:15:\"learn_more_link\";s:128:\"https://woocommerce.com/products/pinterest-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:2;}i:6;O:8:\"stdClass\":9:{s:4:\"name\";s:32:\"Meta Ads & Pixel for WooCommerce\";s:11:\"description\";s:56:\"Build personalized email and SMS campaigns using Klaviyo\";s:9:\"image_url\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/kliken-kraken-icon.webp\";s:10:\"manage_url\";s:40:\"admin.php?page=kliken-ads-pixel-for-meta\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:61;i:1;i:120;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:3:\"key\";s:25:\"kliken-ads-pixel-for-meta\";s:5:\"label\";s:46:\"Grow your business with Facebook and Instagram\";s:15:\"learn_more_link\";s:121:\"https://woocommerce.com/products/meta-ads-and-pixel?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:2;}i:7;O:8:\"stdClass\":10:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:58:\"Attract and retain shoppers with email marketing campaigns\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:60;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";s:5:\"label\";s:34:\"Reach your customers with MailPoet\";s:9:\"image_url\";s:115:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-mailpoet.svg\";s:15:\"learn_more_link\";s:111:\"https://woocommerce.com/products/mailpoet?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:7;}i:8;O:8:\"stdClass\":10:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:56:\"Build personalized email and SMS campaigns using Klaviyo\";s:9:\"image_url\";s:95:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:61;i:1;i:120;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:7:\"klaviyo\";s:5:\"label\";s:7:\"Klaviyo\";s:15:\"learn_more_link\";s:126:\"https://woocommerce.com/products/klaviyo-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:7;}i:9;O:8:\"stdClass\":11:{s:4:\"name\";s:22:\"Google for WooCommerce\";s:11:\"description\";s:57:\"Create ads for your products straight from your dashboard\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";s:5:\"label\";s:39:\"Drive sales with Google for WooCommerce\";s:15:\"learn_more_link\";s:126:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:6;}i:10;O:8:\"stdClass\":9:{s:4:\"name\";s:15:\"WooCommerce Tax\";s:11:\"description\";s:62:\"Automatically calculate how much sales tax should be collected\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:11:{i:0;s:2:\"US\";i:1;s:2:\"FR\";i:2;s:2:\"GB\";i:3;s:2:\"DE\";i:4;s:2:\"CA\";i:5;s:2:\"AU\";i:6;s:2:\"GR\";i:7;s:2:\"BE\";i:8;s:2:\"PT\";i:9;s:2:\"DK\";i:10;s:2:\"SE\";}s:9:\"operation\";s:2:\"in\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";s:5:\"label\";s:44:\"Get automated tax rates with WooCommerce Tax\";s:9:\"image_url\";s:120:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo-rebrand-2.svg\";s:15:\"learn_more_link\";s:106:\"https://woocommerce.com/products/tax?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:4;}i:11;O:8:\"stdClass\":10:{s:4:\"name\";s:22:\"TikTok for WooCommerce\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-tiktok.svg\";s:11:\"description\";s:59:\"Sync your store with TikTok to create engaging ad campaigns\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CZ\";i:6;s:2:\"DK\";i:7;s:2:\"FI\";i:8;s:2:\"FR\";i:9;s:2:\"DE\";i:10;s:2:\"GR\";i:11;s:2:\"HU\";i:12;s:2:\"IE\";i:13;s:2:\"IT\";i:14;s:2:\"NL\";i:15;s:2:\"PL\";i:16;s:2:\"PT\";i:17;s:2:\"RO\";i:18;s:2:\"ES\";i:19;s:2:\"SE\";i:20;s:2:\"GB\";i:21;s:2:\"CH\";i:22;s:2:\"NO\";i:23;s:2:\"AU\";i:24;s:2:\"NZ\";i:25;s:2:\"SG\";i:26;s:2:\"MY\";i:27;s:2:\"PH\";i:28;s:2:\"ID\";i:29;s:2:\"VN\";i:30;s:2:\"TH\";i:31;s:2:\"KR\";i:32;s:2:\"IL\";i:33;s:2:\"AE\";i:34;s:2:\"RU\";i:35;s:2:\"UA\";i:36;s:2:\"TR\";i:37;s:2:\"SA\";i:38;s:2:\"BR\";i:39;s:2:\"JP\";}s:9:\"operation\";s:2:\"in\";}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";s:5:\"label\";s:31:\"Create ad campaigns with TikTok\";s:15:\"learn_more_link\";s:125:\"https://woocommerce.com/products/tiktok-for-woocommerce?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:1;}i:12;O:8:\"stdClass\":10:{s:4:\"name\";s:29:\"Print on Demand with Printful\";s:9:\"image_url\";s:115:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-printful.png\";s:11:\"description\";s:65:\"Design and easily sell custom print products online with Printful\";s:10:\"manage_url\";s:0:\"\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:9:{i:0;s:2:\"AU\";i:1;s:2:\"GB\";i:2;s:2:\"CA\";i:3;s:2:\"ES\";i:4;s:2:\"DE\";i:5;s:2:\"FR\";i:6;s:2:\"NL\";i:7;s:2:\"BE\";i:8;s:2:\"LU\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:10:\"industry.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:24:\"clothing_and_accessories\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:33:\"printful-shipping-for-woocommerce\";s:5:\"label\";s:29:\"Print on Demand with Printful\";s:15:\"learn_more_link\";s:111:\"https://woocommerce.com/products/printful?utm_source=storeprofiler&utm_medium=product&utm_campaign=freefeatures\";s:16:\"install_priority\";i:9;}}}}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (99899,'_site_transient_update_core','O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.1\";s:7:\"version\";s:5:\"6.8.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1748069691;s:15:\"version_checked\";s:5:\"6.8.1\";s:12:\"translations\";a:0:{}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (89279,'woocommerce_feature_reactify-classic-payments-settings_enabled','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (89283,'woocommerce_email_auto_sync_with_theme','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (828,'fusion_supported_plugins_active','{{SHIPPER_JSON_START}}[\"WooCommerce\"]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (829,'avada_version','7.11.13','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (831,'avada_disable_builder','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (832,'avada_disable_encoding','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (823,'current_theme','Avada Child','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (824,'theme_mods_Avada-Child-Theme','{{SHIPPER_JSON_START}}{\"0\":false,\"nav_menu_locations\":[],\"custom_css_post_id\":-1}{{SHIPPER_JSON_END}}','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (825,'theme_switched','','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (869,'revslider-valid-notice','false','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (945,'fusion_builder_version','3.11.13','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (878,'wp_smush_expected_public_nonces','{{SHIPPER_JSON_START}}{\"a1c2cd6868a2944788dc0598f9cc84cd-1729673008\":{\"time\":1729673008,\"nonce\":\"a1c2cd6868a2944788dc0598f9cc84cd\"},\"4cb2c1fbc00039620d08518fb33f2a91-1729673008\":{\"time\":1729673008,\"nonce\":\"4cb2c1fbc00039620d08518fb33f2a91\"},\"3555000052b5be2916ea3ba36daee023-1729673008\":{\"time\":1729673008,\"nonce\":\"3555000052b5be2916ea3ba36daee023\"},\"87c438ed52028bbe783ce3e7c50e325b-1729673008\":{\"time\":1729673008,\"nonce\":\"87c438ed52028bbe783ce3e7c50e325b\"},\"38c736ffea68a29a8fb0ba212800b13d-1729673008\":{\"time\":1729673008,\"nonce\":\"38c736ffea68a29a8fb0ba212800b13d\"},\"14d57a8cb625fc70bf8e084d9f055f61-1729673008\":{\"time\":1729673008,\"nonce\":\"14d57a8cb625fc70bf8e084d9f055f61\"},\"080f8bd11a62d566616104a25c15f01f-1729673008\":{\"time\":1729673008,\"nonce\":\"080f8bd11a62d566616104a25c15f01f\"},\"dc1c3bb4f75259ac1c59715d61d6c794-1729673008\":{\"time\":1729673008,\"nonce\":\"dc1c3bb4f75259ac1c59715d61d6c794\"},\"dc53feaf94c7bc9304fe97ab3e9ce967-1729673008\":{\"time\":1729673008,\"nonce\":\"dc53feaf94c7bc9304fe97ab3e9ce967\"},\"e0f89eef2a580a697ba310caf4c34965-1729673008\":{\"time\":1729673008,\"nonce\":\"e0f89eef2a580a697ba310caf4c34965\"},\"f892b1af0edae974a2bca38b349f70a5-1729673008\":{\"time\":1729673008,\"nonce\":\"f892b1af0edae974a2bca38b349f70a5\"},\"9a0640f5b0422a49dcfc610d73ade61c-1729673008\":{\"time\":1729673008,\"nonce\":\"9a0640f5b0422a49dcfc610d73ade61c\"},\"a2b9e82a7054c918d8d275724c90a216-1729673008\":{\"time\":1729673008,\"nonce\":\"a2b9e82a7054c918d8d275724c90a216\"},\"a014b71adbbe34cdf1283740c398f9e0-1729673008\":{\"time\":1729673008,\"nonce\":\"a014b71adbbe34cdf1283740c398f9e0\"},\"2fbf70a835f3a500ce37598f0a846c88-1729673008\":{\"time\":1729673008,\"nonce\":\"2fbf70a835f3a500ce37598f0a846c88\"},\"eb3f065b2f2fd3fc74e19cf64fcded60-1729673008\":{\"time\":1729673008,\"nonce\":\"eb3f065b2f2fd3fc74e19cf64fcded60\"},\"56de19aeaedf0d642360e5210557fb20-1729673008\":{\"time\":1729673008,\"nonce\":\"56de19aeaedf0d642360e5210557fb20\"},\"803fd015f6b5ded54d84c1d91b780235-1729673008\":{\"time\":1729673008,\"nonce\":\"803fd015f6b5ded54d84c1d91b780235\"},\"bcfd7181416d8d042c910eb022b1dd9d-1729673008\":{\"time\":1729673008,\"nonce\":\"bcfd7181416d8d042c910eb022b1dd9d\"}}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (879,'wp-smush-optimize-list','55,58,59,61,67,69,70,71','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (880,'wp-smush-reoptimize-list','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (881,'wp-smush-error-items-list','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (882,'wp-smush-ignored-items-list','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (883,'wp-smush-animated-items-list','','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (884,'wp-smush-optimization-global-stats','{{SHIPPER_JSON_START}}{\"time\":20.99000000000000198951966012828052043914794921875,\"bytes\":222008,\"percent\":38.090000000000003410605131648480892181396484375,\"size_before\":582926,\"size_after\":360918,\"count\":2,\"attachment_ids\":\"4,166\",\"lossy_count\":0}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (917,'fusion_core_version','5.11.13','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (918,'widget_ad_125_125-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (919,'widget_fusion_author-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (920,'widget_contact_info-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (921,'widget_pyre_tabs-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (922,'widget_recent_works-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (923,'widget_tweets-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (924,'widget_flickr-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (925,'widget_social_links-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (926,'widget_facebook-like-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (927,'widget_menu-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (928,'widget_avada-vertical-menu-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (929,'widget_form-widget','{{SHIPPER_JSON_START}}{\"_multiwidget\":1}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (1449,'_transient_timeout_avada-builder-demo-theme-options','1730276101','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (976,'_transient_woocommerce_product_task_product_count_transient','0','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (724,'wpdefender_config_clear_active_tag','clear','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (81343,'_transient_timeout_woocommerce_blocks_asset_api_script_data','1750662651','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (81344,'_transient_woocommerce_blocks_asset_api_script_data','{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"4d43a4bcb41a5a6336c2\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"df3cbcae422855d48387\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"0d3321630119e50d175f\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"94f6fdb24497762c3877\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"13ca26913ccb282c047e\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"6d08dccfb4bf1a392a0d\",\"dependencies\":[\"react\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"4d3dbff32a4959449c1d\",\"dependencies\":[\"react\",\"wc-types\",\"wp-block-editor\",\"wp-blocks\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-dom-ready\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"ce9125bf472706dea11a\",\"dependencies\":[\"react\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"cba59eca47d9101980bf\",\"dependencies\":[\"react\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"a3e67bb0b09f566d5bdf\",\"dependencies\":[\"wc-settings\",\"wp-html-entities\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"a5f075e4ff6dd6090875\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"a16e7eb12f5267371fe0\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"2def9412eeabab2071b2\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"0ea5d4718f1bb3c42ede\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"c163716dbc1e3cc6748c\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"e4169377f115faded81a\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"http:\\/\\/{{SHIPPER_DOMAIN}}\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"daf82f32ab7ca75c7285\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]}},\"version\":\"wc-9.8.5\",\"hash\":\"34c231d8d375014bc046a8f4f626968f\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115722,'_site_transient_timeout_wp_theme_files_patterns-723f536f438952c1f447734ddf6fa71d','1748069283','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115723,'_site_transient_wp_theme_files_patterns-723f536f438952c1f447734ddf6fa71d','{{SHIPPER_JSON_START}}{\"version\":false,\"patterns\":[]}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115738,'_site_transient_timeout_php_check_9c9455a4a3a9b8b637e3ca09603c559b','1748674468','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115739,'_site_transient_php_check_9c9455a4a3a9b8b637e3ca09603c559b','{{SHIPPER_JSON_START}}{\"recommended_version\":\"7.4\",\"minimum_version\":\"7.2.24\",\"is_supported\":true,\"is_secure\":true,\"is_acceptable\":true}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115749,'_site_transient_timeout_wdp_un_changelog_2175128','1748674484','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115750,'_site_transient_wdp_un_changelog_2175128','{{SHIPPER_JSON_START}}{\"0\":{\"time\":\"1707290702\",\"version\":\"1.2.16\",\"log\":\"<p>Enhance: Visual Improvements<br \\/>\\nEnhance: Update Twitter Logo<br \\/>\\nEnhance: Adjust Summary Box Logo<br \\/>\\nEnhance: Redirect to dashboard instead of settings<\\/p>\\n\"},\"1\":{\"time\":\"1691418890\",\"version\":\"1.2.15\",\"log\":\"<p>-Fix: Issue with unrecognized database host<br \\/>\\n-Fix: Compatibility with PHP version 8.0 and up tested<\\/p>\\n\"},\"2\":{\"time\":\"1678956234\",\"version\":\"1.2.14\",\"log\":\"<p>- New: Updated plugin admin icon<br \\/>\\n- Improvement: Security issues<\\/p>\\n\"},\"3\":{\"time\":\"1664366150\",\"version\":\"1.2.13\",\"log\":\"<p>- Improvement: Enhanced membership detection<\\/p>\\n\"},\"4\":{\"time\":\"1649061099\",\"version\":\"1.2.12\",\"log\":\"<p>- New: Google login support<\\/p>\\n\"},\"5\":{\"time\":\"1635946818\",\"version\":\"1.2.11\",\"log\":\"<p>- Improvement: White labeling support<\\/p>\\n\"},\"6\":{\"time\":\"1635752098\",\"version\":\"1.2.10\",\"log\":\"<p>- Improvement: Academy links removed<\\/p>\\n\"},\"7\":{\"time\":\"1621328654\",\"version\":\"1.2.9\",\"log\":\"<p>- New: Documentation links tracking<br \\/>\\n- Fix: jQuery compatibility with WP 5.8<br \\/>\\n- Fix: Fatal Error on Windows host<br \\/>\\n- Fix: Cross sign added before email ID while adding new user<br \\/>\\n- Fix: Missing placeholder in File Exclusions Filter<\\/p>\\n\"},\"8\":{\"time\":\"1616665176\",\"version\":\"1.2.8\",\"log\":\"<p>- New: Show Shipper logs on package building modal.<br \\/>\\n- New: Implement AJAX search functionality for sub-sites selection.<br \\/>\\n- New: Add option to exclude WordPress core files on migration.<br \\/>\\n- New: Add option to exclude email addresses from being replaced after migration.<br \\/>\\n- New: Add the Go Back button to the Pre-flight modal for better usability.<br \\/>\\n- Fix: Compatibility issue with Beaver Page Builder.<br \\/>\\n- Fix: Remove all multisite constant for sub-site to single-site migration.<br \\/>\\n- Fix: Do not migrate wp-config.php for API migration option doesn\\\\\'t work properly.<br \\/>\\n- Fix: Network settings get lost on sub-site to single-site migration.<br \\/>\\n- Improvement: Network migration description copy.<br \\/>\\n- Improvement: Migrate all the premium.wpmudev.org links to wpmudev.com<\\/p>\\n\"},\"9\":{\"time\":\"1615178149\",\"version\":\"1.2.7\",\"log\":\"<p>- Fix: Choose destination arrow button moves up when the button is clicked.<br \\/>\\n- Fix: Restore doesn\\\\\'t process when fetch database credentials from the config file is selected.<\\/p>\\n\"},\"10\":{\"time\":\"1614756257\",\"version\":\"1.2.6\",\"log\":\"<p>- New: Add Shipper tutorials.<br \\/>\\n- New: Add HTML template for email notification.<br \\/>\\n- New: Add detailed file exclusion rules on the file exclusion modal.<br \\/>\\n- New: Suggest Package migration once the API migration preflight check is stuck.<br \\/>\\n- New: Add a notification not to rename package files.<br \\/>\\n- New: Show suggestion on pre-flight check regarding safe mode.<br \\/>\\n- Fix: Shipper is not working on the flywheel live site.<br \\/>\\n- Fix: Update Shared UI to the latest version.<br \\/>\\n- Fix: Shipper doesn\\\\\'t work well with WPML enabled site.<br \\/>\\n- Fix: Blank screen is showing after canceling the API migration.<br \\/>\\n- Fix: API migration doesn\\\\\'t migrate any content when the existing prefix is chosen.<br \\/>\\n- Fix: Wildcard file exclusion is not working for package migration.<br \\/>\\n- Fix: Shipper version doesn\\\\\'t match with HUB when the shipper is updated or installed without removing the existing plugin.<br \\/>\\n- Improvement: Rewrote the description for network migration.<br \\/>\\n- Improvement: Change X to Cancel button to make it more clear to the user.<\\/p>\\n\"},\"11\":{\"time\":\"1611555494\",\"version\":\"1.2.5\",\"log\":\"<p>- Fix: Shipper package can\\\\\'t be restored on localhost such as MAMP, WAMP, etc.<br \\/>\\n- Fix: Responsive issue on the package download screen.<br \\/>\\n- Fix: Package migration doesn\\\\\'t work on password-protected sites.<br \\/>\\n- Fix: While downloading a package, the site goes down or timeout if the package is large.<br \\/>\\n- Fix: Some typos in error messages.<br \\/>\\n- Fix: Installer.php file size is static instead of dynamic.<br \\/>\\n- Fix: Character encoding issue after migration on some site.<br \\/>\\n- Fix: Package migration is not replacing the custom menu URL when some URL has SSL and some are not.<br \\/>\\n- Fix: Dashboard shows `Creating Package` even if there is no package creation in progress.<br \\/>\\n- Fix: Subsite media files are missing on the whole network package migration.<br \\/>\\n- Fix: Format logs for package migration installer.<\\/p>\\n\"},\"12\":{\"time\":\"1610524788\",\"version\":\"1.2.4\",\"log\":\"<p>- Feat: Add safe mode for package migration, so that Shipper can work well on low-budget hosts.<br \\/>\\n- Improvement: Speed up the API migration process.<br \\/>\\n- Improvement: Add which file is successfully added to the zip archive and which doesn\\\\\'t in the shipper log.<br \\/>\\n- Fix: On sub-site migration, all the media of other subsites are also getting exported.<br \\/>\\n- Fix: Shipper eating up the whole server storage, and crashing the site.<br \\/>\\n- Fix: After migration, the parent theme is getting activated instead of the child theme.<br \\/>\\n- Fix: WPMU DEV user is unable to add new users in Shipper.<br \\/>\\n- Fix: Fatal error on running installer.php on PHP 5.6 sites in some edge cases.<br \\/>\\n- Fix: If the domain mapping plugin is activated on the source site, the destination site gets down after migrating a subsite through package migration.<br \\/>\\n- Fix: The error message is not styled properly on the package migration settings page.<\\/p>\\n\"},\"13\":{\"time\":\"1606714677\",\"version\":\"1.2.3\",\"log\":\"<p>Fix: Make Shipper compatible with PHP 8.0<\\/p>\\n\"},\"14\":{\"time\":\"1606147751\",\"version\":\"1.2.2\",\"log\":\"<p>- Improvement: Speedup package migration process.<br \\/>\\n- Feat: Add logs to detect which table is exporting.<br \\/>\\n- Fix: Exclude shipper-working dir by default on running installer.php on destination site.<br \\/>\\n- Fix: If there are negative values in pagination settings then Large files are not showing on the Preflight screen.<br \\/>\\n- Fix: Pagination result count is not correct when the filter is applied on the preflight check.<br \\/>\\n- Fix: Both Shipper and Whitelabel logo are showing up on the preflight check of API migration.<br \\/>\\n- Fix: Package migration fails on local by flywheel sites.<br \\/>\\n- Fix: Skip WordPress default meta_key transformation on Package Migration.<\\/p>\\n\"},\"15\":{\"time\":\"1603339232\",\"version\":\"1.2.1\",\"log\":\"<p>- Improvement: Speed up database task for package migration.<br \\/>\\n- Improvement: Change API Migration connect to WPMU DEV experience.<br \\/>\\n- Fix: Shipper doesn\\\\\'t show all the sub-sites to choose from and search field doesn\\\\\'t work.<br \\/>\\n- Fix: Back button is not working on the Ready to Ship page.<br \\/>\\n- Fix: Package migration fails when the source site has duplicator plugin installed.<br \\/>\\n- Fix: The migration date-time on the dashboard doesn\\\\\'t match with the current timezone.<br \\/>\\n- Fix: Typo in export and import succession email.<br \\/>\\n- Fix: Some text is not visible in high contrast mode on the Permission page.<br \\/>\\n- Fix: Cancellation on pre-flight issues screen, bring back pre-flight check to 99%.<br \\/>\\n- Fix: Documentation link is missing in package migration and settings Page.<\\/p>\\n\"},\"16\":{\"time\":\"1599547413\",\"version\":\"1.2\",\"log\":\"<p>- Add: Migrate a subsite from a multisite network to a single site<br \\/>\\n- Add: Highlight new features in the welcome modal<br \\/>\\n- Improvement: Update SUI to the latest version (2.9.6)<br \\/>\\n- Fix: Shipper is loading itself on every page load in wp-admin and on the frontend<br \\/>\\n- Fix: Shipper using up all the disk space<br \\/>\\n- Fix: Deleted admin user is able to access Shipper plugin<br \\/>\\n- Fix: Some sites are not showing up on the site selection modal when the user has more than 20 websites<br \\/>\\n- Fix: Package migration fails due to MySQL can not compare float like value<br \\/>\\n- Fix: Exclude large file doesn\\\\\'t work on flywheel site<\\/p>\\n\"},\"17\":{\"time\":\"1597913642\",\"version\":\"1.1.6\",\"log\":\"<p>- Improvement: shinst_is_multisite function regex so that it ignores commented outlines<br \\/>\\n- Fix: Shipper white label image is not working in the dashboard page<br \\/>\\n- Fix: Escape {{ character with a double backslash to be used in MySQL 8.0<br \\/>\\n- Fix: WordPress 5.5 compatibility issues<br \\/>\\n- Fix: Package migration fails if there are extra tables (unknown DB prefix) in the source site<br \\/>\\n- Fix: Sometimes null value replaced with 0 in MySQL resulting duplicate entry issue<\\/p>\\n\"},\"18\":{\"time\":\"1595240385\",\"version\":\"1.1.5\",\"log\":\"<p>- Fix: Shipper password verification fails on some hosts<\\/p>\\n\"},\"19\":{\"time\":\"1594707881\",\"version\":\"1.1.4\",\"log\":\"<p>- Add: Shipper Dashboard to quickly run the migration and see migration states.<br \\/>\\n- Add: Ask for the WPMU DEV password before fetching the connected sites in the API migration.<br \\/>\\n- Improvement: Improve the estimated time of arrival (ETA) for API migration.<br \\/>\\n- Improvement: Some UI improvements in various places.<br \\/>\\n- Fix: Some users still seeing old Shipper character.<br \\/>\\n- Fix: Package Migration > View Logs link doesn\\\\\'t work on multisite.<br \\/>\\n- Fix: High contrast mode doesn\\\\\'t apply properly to some of the plugin elements.<br \\/>\\n- Fix: Remove PHP warning when API migration import is in progress.<br \\/>\\n- Fix: All the media items aren\\\\\'t transferred well with API migration.<br \\/>\\n- Fix: Migration Filters (files, database, and advanced) are not working properly.<br \\/>\\n- Fix: Destination Database Prefix doesn\\\\\'t change even if the user wants to.<br \\/>\\n- Fix: Plugins and media exclusion doesn\\\\\'t work properly.<br \\/>\\n- Fix: Remove Storage Directory and Exclude from package build options from Package migration settings.<\\/p>\\n\"},\"20\":{\"time\":\"1581490385\",\"version\":\"1.1.3\",\"log\":\"<p>- Fix: Fatal error issues on certain setups while creating a package<\\/p>\\n\"},\"21\":{\"time\":\"1577086451\",\"version\":\"1.1.2\",\"log\":\"<p>- Fix: Installer.php doesn\\\\\'t work properly on some hosts because of missing the function mysqli_fetch_all<\\/p>\\n\"},\"22\":{\"time\":\"1575373909\",\"version\":\"1.1.1\",\"log\":\"<p>- Fix: the \\\\\\\"My sites\\\\\\\" link points to the source site when a multisite is imported from a package.<\\/p>\\n\"},\"23\":{\"time\":\"1575357386\",\"version\":\"1.1\",\"log\":\"<p>- Add: Introducing a new non-API based migration method called Package Migration. You can now create a package (.zip) of your website that you can upload to your server and follow an installation wizard to complete the migration.<br \\/>\\n- Add: Advanced filters added to API Migrations method and Package migration method.<br \\/>\\n- Add: Ability to use a custom database prefix while migrating your websites.<br \\/>\\n- Improvement: The speed and stability of API migrations. API method has become a lot faster when resources are available on a host but fall back to the slower but reliable migration algorithm when resources are not available on a host.<br \\/>\\n- Fix: Some plugin\\\\\'s settings were not being migrated properly.<\\/p>\\n\"},\"24\":{\"time\":\"1560920713\",\"version\":\"1.0.3\",\"log\":\"<p>- Feature: Restrict Shipper access to Dash user and add a Permissions tab in Shipper settings<br \\/>\\n- Improvement: Improve Import\\/Export workflow, also we remove the Add Destination because it is not needed anymore<br \\/>\\n- Improvement: UI\\/UX for Preflight check<br \\/>\\n- Fix: Conflict with some heart-beat manager like Heartbeat Control, which prevent the preflight and migration progresses get updated<br \\/>\\n- Fix: In some cases, migration will be fail if a DB table larger than 5MB<br \\/>\\n- Fix: Migration failed but success message was sent<br \\/>\\n- Fix: Show correct size of the remote install when running import task.<br \\/>\\n- Fix: Better notification message for not approved users<\\/p>\\n\"},\"25\":{\"time\":\"1557804825\",\"version\":\"1.0.2\",\"log\":\"<p>- Add: Add a method to rerun pre-flight check in every tab<br \\/>\\n- Add: Auto-remove site from the Shipper API on plugin removal<br \\/>\\n- Add: Automatically fetch latest API for new sites on install<br \\/>\\n- Add: Support Whitelabel in Shipper<br \\/>\\n- Add: Additional dashboard login check messages<br \\/>\\n- Fix: Improve restore reliability by solving conflict with plugins<br \\/>\\n- Fix: Fix multiple S3 object instantiations<br \\/>\\n- Fix: Deprecate Add Destination modals<br \\/>\\n- Fix: Improve the error states in pre-flight check<br \\/>\\n- Fix: Notice content aligment in the Welcome to Shipper popup<br \\/>\\n- Fix: Improved Export -> Ready to Migrate screen layout<br \\/>\\n- Fix: Update the Ready to Sail status on issues addressed<br \\/>\\n- Fix: Deprecate Continue Anyway button in the Requirement Failed modal<br \\/>\\n- Fix: Update the Shipper character<br \\/>\\n- Fix: Placement of Back buttons<br \\/>\\n- Fix: Update copy of Package Size pre-flight check<br \\/>\\n- Fix: Remove Greeting modal if it\'s not the users first website<br \\/>\\n- Fix: Update the package size on excluding the large files <\\/p>\\n\"},\"26\":{\"time\":\"1553223512\",\"version\":\"1.0.1.1\",\"log\":\"<p>- Fix: add cooldown time for credentials negotiation.<br \\/>\\n- Fix: add exponential backoff times for API communication failures.<\\/p>\\n\"},\"27\":{\"time\":\"1551755734\",\"version\":\"1.0.1\",\"log\":\"<p>- Add: password protection detection<br \\/>\\n- Add: migration health check notifications<br \\/>\\n- Add: a way to remove a site that from the list<br \\/>\\n- Add: support for including\\/excluding wp-config<br \\/>\\n- Add: support for not replacing source domains in emails<br \\/>\\n- Fix: treat themes as active content, like plugins<br \\/>\\n- Fix: conflict with Amazon Web Services<br \\/>\\n- Fix: migrations involving object cache<br \\/>\\n- Fix: conflict with Mollie Payments for WooCommerce<br \\/>\\n- Fix: default config deployments<\\/p>\\n\"},\"28\":{\"time\":\"1548299734\",\"version\":\"1\",\"log\":\"<p>Initial release<\\/p>\\n\"},\"timestamp\":1748069684}{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44587,'wpdef_show_antibot_global_firewall_notice','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44588,'wd_show_feature_antibot','1','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115617,'_transient_timeout_woocommerce_admin_pes_incentive_woopayments_store_has_orders','1748087604','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (115618,'_transient_woocommerce_admin_pes_incentive_woopayments_store_has_orders','no','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (44591,'woocommerce_admin_pes_incentive_woopayments_store_had_woopayments','no','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (727,'wd_2auth_settings','{\"enabled\":true,\"lost_phone\":true,\"force_auth\":true,\"force_auth_mess\":\"You are required to setup two-factor authentication to use this site.\",\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\",\"customer\",\"shop_manager\"],\"force_auth_roles\":[],\"custom_graphic\":false,\"custom_graphic_type\":\"upload\",\"custom_graphic_url\":\"https:\\/\\/thrillrebels.com\\/wp-content\\/plugins\\/wp-defender\\/assets\\/img\\/2factor-disabled.svg\",\"custom_graphic_link\":\"\",\"email_subject\":\"Your OTP code\",\"email_sender\":\"admin\",\"email_body\":\"Hi {{display_name}},\\r\\n\\r\\nYour temporary password is {{passcode}}\\r\\nTo complete your login, copy and paste the temporary password into the Password field on the login screen.\",\"app_title\":\"Thrill Rebels\",\"detect_woo\":true}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (732,'wd_masking_login_settings','{\"mask_url\":\"manager\",\"redirect_traffic\":\"off\",\"redirect_traffic_url\":\"\",\"redirect_traffic_page_id\":0,\"enabled\":true}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (734,'jetpack_options','{{SHIPPER_JSON_START}}{\"last_heartbeat\":1748067307}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (735,'_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs','1748672107','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (736,'_transient_woocommerce_admin_payment_gateway_suggestions_specs','a:1:{s:5:\"en_US\";a:24:{s:6:\"affirm\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"affirm\";s:5:\"title\";s:6:\"Affirm\";s:7:\"content\";s:169:\"Affirm’s tailored Buy Now Pay Later programs remove price as a barrier, turning browsers into buyers, increasing average order value, and expanding your customer base.\";s:5:\"image\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:7:\"plugins\";a:0:{}s:13:\"external_link\";s:59:\"https://woocommerce.com/products/woocommerce-gateway-affirm\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}s:23:\"recommendation_priority\";i:7;}s:8:\"afterpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"afterpay\";s:5:\"title\";s:8:\"Afterpay\";s:7:\"content\";s:125:\"Afterpay allows customers to receive products immediately and pay for purchases over four installments, always interest-free.\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:3:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";}s:23:\"recommendation_priority\";i:8;}s:14:\"airwallex_main\";O:8:\"stdClass\":11:{s:2:\"id\";s:14:\"airwallex_main\";s:5:\"title\";s:18:\"Airwallex Payments\";s:7:\"content\";s:115:\"Boost international sales and save on FX fees. Accept 60+ local payment methods including Apple Pay and Google Pay.\";s:5:\"image\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/airwallex.png\";s:12:\"square_image\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex-square.png\";s:7:\"plugins\";a:1:{i:0;s:33:\"airwallex-online-payments-gateway\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:17:{i:0;s:2:\"GB\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"EE\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"GR\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";i:11;s:2:\"PT\";i:12;s:2:\"AU\";i:13;s:2:\"NZ\";i:14;s:2:\"HK\";i:15;s:2:\"SG\";i:16;s:2:\"CN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:24:\"amazon_payments_advanced\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"amazon_payments_advanced\";s:5:\"title\";s:10:\"Amazon Pay\";s:7:\"content\";s:94:\"Enable a familiar, fast checkout for hundreds of millions of active Amazon customers globally.\";s:5:\"image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-amazon-payments-advanced\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:18:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CY\";i:4;s:2:\"DK\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"DE\";i:8;s:2:\"GB\";i:9;s:2:\"HU\";i:10;s:2:\"IE\";i:11;s:2:\"IT\";i:12;s:2:\"LU\";i:13;s:2:\"NL\";i:14;s:2:\"PT\";i:15;s:2:\"SL\";i:16;s:2:\"SE\";i:17;s:2:\"JP\";}s:23:\"recommendation_priority\";i:6;}s:4:\"bacs\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"bacs\";s:5:\"title\";s:20:\"Direct bank transfer\";s:7:\"content\";s:32:\"Take payments via bank transfer.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/bacs.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/bacs.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:10;}s:3:\"cod\";O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"cod\";s:5:\"title\";s:16:\"Cash on delivery\";s:7:\"content\";s:36:\"Take payments in cash upon delivery.\";s:5:\"image\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/cod.svg\";s:11:\"image_72x72\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/cod.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:10;}s:4:\"eway\";O:8:\"stdClass\":11:{s:2:\"id\";s:4:\"eway\";s:5:\"title\";s:4:\"Eway\";s:7:\"content\";s:171:\"The Eway extension for WooCommerce allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway.png\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/eway.png\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway-square.png\";s:7:\"plugins\";a:1:{i:0;s:24:\"woocommerce-gateway-eway\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:3:\"kco\";O:8:\"stdClass\":10:{s:2:\"id\";s:3:\"kco\";s:5:\"title\";s:15:\"Klarna Checkout\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-checkout-for-woocommerce\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"NO\";i:1;s:2:\"SE\";i:2;s:2:\"FI\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:15:\"klarna_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:15:\"klarna_payments\";s:5:\"title\";s:15:\"Klarna Payments\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:19:{i:0;s:2:\"MX\";i:1;s:2:\"US\";i:2;s:2:\"CA\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CH\";i:6;s:2:\"DK\";i:7;s:2:\"ES\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GB\";i:12;s:2:\"IT\";i:13;s:2:\"NL\";i:14;s:2:\"NO\";i:15;s:2:\"PL\";i:16;s:2:\"SE\";i:17;s:2:\"NZ\";i:18;s:2:\"AU\";}s:23:\"recommendation_priority\";i:9;}s:30:\"mollie_wc_gateway_banktransfer\";O:8:\"stdClass\":11:{s:2:\"id\";s:30:\"mollie_wc_gateway_banktransfer\";s:5:\"title\";s:6:\"Mollie\";s:7:\"content\";s:128:\"Effortless payments by Mollie: Offer global and local payment methods, get onboarded in minutes, and supported in your language.\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie.svg\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mollie.png\";s:12:\"square_image\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie-square.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"mollie-payments-for-woocommerce\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:11:{i:0;s:2:\"AT\";i:1;s:2:\"BE\";i:2;s:2:\"CH\";i:3;s:2:\"ES\";i:4;s:2:\"FI\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"GB\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:7:\"payfast\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payfast\";s:5:\"title\";s:7:\"Payfast\";s:7:\"content\";s:299:\"The Payfast extension for WooCommerce enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs. Selecting this extension will configure your store to use South African rands as the selected currency.\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/payfast.png\";s:11:\"image_72x72\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payfast.png\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-payfast-gateway\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"ZA\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:17:\"payoneer-checkout\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"payoneer-checkout\";s:5:\"title\";s:17:\"Payoneer Checkout\";s:7:\"content\";s:202:\"Payoneer Checkout is the next generation of payment processing platforms, giving merchants around the world the solutions and direction they need to succeed in today’s hyper-competitive global market.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payoneer.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payoneer.png\";s:7:\"plugins\";a:1:{i:0;s:17:\"payoneer-checkout\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"HK\";i:1;s:2:\"CN\";}s:23:\"recommendation_priority\";i:10;}s:8:\"paystack\";O:8:\"stdClass\":11:{s:2:\"id\";s:8:\"paystack\";s:5:\"title\";s:8:\"Paystack\";s:7:\"content\";s:127:\"Paystack helps African merchants accept one-time and recurring payments online with a modern, safe, and secure payment gateway.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack.png\";s:12:\"square_image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack-square.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paystack.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-paystack\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GH\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NG\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"ZA\";i:1;s:2:\"GH\";i:2;s:2:\"NG\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:7:\"payubiz\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payubiz\";s:5:\"title\";s:20:\"PayU for WooCommerce\";s:7:\"content\";s:169:\"Enable PayU’s exclusive plugin for WooCommerce to start accepting payments in 100+ payment methods available in India including credit cards, debit cards, UPI, & more!\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payu.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payu.png\";s:7:\"plugins\";a:1:{i:0;s:10:\"payu-india\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:12:\"ppcp-gateway\";O:8:\"stdClass\":11:{s:2:\"id\";s:12:\"ppcp-gateway\";s:5:\"title\";s:15:\"PayPal Payments\";s:7:\"content\";s:78:\"Safe and secure payments using credit cards or your customer\'s PayPal account.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/paypal.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paypal.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paypal.svg\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:49:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:48:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";}s:19:\"category_additional\";a:49:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";i:48;s:2:\"IN\";}s:23:\"recommendation_priority\";i:4;}s:8:\"razorpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"razorpay\";s:5:\"title\";s:8:\"Razorpay\";s:7:\"content\";s:133:\"The official Razorpay extension for WooCommerce allows you to accept credit cards, debit cards, netbanking, wallet, and UPI payments.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/razorpay.svg\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/razorpay.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-razorpay\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:18:\"square_credit_card\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"square_credit_card\";s:5:\"title\";s:6:\"Square\";s:7:\"content\";s:169:\"Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/square-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/square.png\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}i:1;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:12:\"brick-mortar\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:18:\"brick-mortar-other\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"no_im_selling_offline\";s:7:\"default\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:34:\"im_selling_both_online_and_offline\";s:7:\"default\";s:0:\"\";}}}}}}}}}s:14:\"category_other\";a:8:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"IE\";i:3;s:2:\"ES\";i:4;s:2:\"FR\";i:5;s:2:\"GB\";i:6;s:2:\"AU\";i:7;s:2:\"JP\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:5;}s:6:\"stripe\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"stripe\";s:5:\"title\";s:6:\"Stripe\";s:7:\"content\";s:112:\"Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/stripe.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/stripe.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/stripe.svg\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AT\";i:5;s:2:\"BE\";i:6;s:2:\"BG\";i:7;s:2:\"CH\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"EE\";i:12;s:2:\"ES\";i:13;s:2:\"FI\";i:14;s:2:\"FR\";i:15;s:2:\"DE\";i:16;s:2:\"GB\";i:17;s:2:\"GR\";i:18;s:2:\"HU\";i:19;s:2:\"IE\";i:20;s:2:\"IT\";i:21;s:2:\"LV\";i:22;s:2:\"LT\";i:23;s:2:\"LU\";i:24;s:2:\"MT\";i:25;s:2:\"NL\";i:26;s:2:\"NO\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"RO\";i:30;s:2:\"SK\";i:31;s:2:\"SL\";i:32;s:2:\"SE\";i:33;s:2:\"AU\";i:34;s:2:\"NZ\";i:35;s:2:\"HK\";i:36;s:2:\"JP\";i:37;s:2:\"SG\";i:38;s:2:\"ID\";i:39;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:3;}s:23:\"woo-mercado-pago-custom\";O:8:\"stdClass\":11:{s:2:\"id\";s:23:\"woo-mercado-pago-custom\";s:5:\"title\";s:12:\"Mercado Pago\";s:7:\"content\";s:198:\"Set up your payment methods and accept credit and debit cards, cash, bank transfers and money from your Mercado Pago account. Offer safe and secure payments with Latin America’s leading processor.\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mercadopago.png\";s:11:\"image_72x72\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mercadopago.png\";s:7:\"plugins\";a:1:{i:0;s:23:\"woocommerce-mercadopago\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}}}}s:16:\"is_local_partner\";b:1;s:14:\"category_other\";a:8:{i:0;s:2:\"AR\";i:1;s:2:\"CL\";i:2;s:2:\"CO\";i:3;s:2:\"EC\";i:4;s:2:\"PE\";i:5;s:2:\"UY\";i:6;s:2:\"MX\";i:7;s:2:\"BR\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}s:20:\"woocommerce_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:1:\"<\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:1:\"<\";}}}}s:23:\"recommendation_priority\";i:2;}s:47:\"woocommerce_payments:without-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:47:\"woocommerce_payments:without-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:37:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:44:\"woocommerce_payments:with-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:44:\"woocommerce_payments:with-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:212:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies – with no setup costs or monthly fees – and you can now accept in-person payments with the Woo mobile app.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:0;}s:25:\"woocommerce_payments:bnpl\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"woocommerce_payments:bnpl\";s:5:\"title\";s:38:\"Activate BNPL instantly on WooPayments\";s:7:\"content\";s:185:\"The world’s favorite buy now, pay later options and many more are right at your fingertips with WooPayments — all from one dashboard, without needing multiple extensions and logins.\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:2:\">=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}s:23:\"recommendation_priority\";i:10;}s:8:\"zipmoney\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"zipmoney\";s:5:\"title\";s:27:\"Zip Co - Buy Now, Pay Later\";s:7:\"content\";s:84:\"Give your customers the power to pay later, interest free and watch your sales grow.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/zipmoney.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/zipmoney.png\";s:7:\"plugins\";a:1:{i:0;s:29:\"zipmoney-payments-woocommerce\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:10;}}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (746,'wphb_settings','{{SHIPPER_JSON_START}}{\"minify\":{\"enabled\":true,\"use_cdn\":false,\"delay_js\":true,\"critical_css\":true,\"critical_css_type\":\"remove\",\"critical_css_remove_type\":\"user_interaction_with_remove\",\"critical_css_mode\":\"critical_css\",\"critical_page_types\":[\"frontpage\",\"page\",\"single\",\"archive\",\"category\",\"tag\"],\"critical_skipped_custom_post_types\":[],\"above_fold_load_stylesheet_method\":\"load_stylesheet_on_user_interaction\",\"critical_css_files_exclusion\":[],\"critical_css_post_urls_exclusion\":[],\"critical_css_plugins_themes_exclusion\":[],\"critical_css_keywords\":[],\"font_optimization\":false,\"preload_fonts\":\"\",\"font_swap\":true,\"font_display_value\":\"swap\",\"preload_fonts_mode\":\"automatic\",\"log\":false,\"file_path\":\"\",\"minify_blog\":false,\"view\":\"basic\",\"type\":\"speedy\",\"do_assets\":{\"styles\":true,\"scripts\":true,\"fonts\":true},\"block\":{\"scripts\":[],\"styles\":[]},\"dont_minify\":{\"scripts\":[\"jquery\"],\"styles\":[\"wp-block-library-theme\",\"classic-theme-styles\",\"global-styles\",\"woocommerce-inline\"]},\"dont_combine\":{\"scripts\":[\"jquery\"],\"styles\":[\"wp-block-library-theme\",\"classic-theme-styles\",\"global-styles\",\"woocommerce-inline\"]},\"position\":{\"scripts\":[],\"styles\":[]},\"defer\":{\"scripts\":[],\"styles\":[]},\"inline\":{\"scripts\":[],\"styles\":[]},\"nocdn\":{\"scripts\":[\"wphb-global\",\"fusion-scripts\",\"modernizr\",\"lottie-player\"],\"styles\":[]},\"delay_js_exclusions\":\"\",\"delay_js_exclusion_list\":[\"wphb-add-delay\",\"\\/wp-includes\\/js\\/wp-embed.min.js\",\"lazyLoadOptions\",\"lazyLoadThumb\",\"\\/assets\\/js\\/smush-lazy-load\",\"eio_lazy_vars\",\"\\\\\\/lazysizes(\\\\.min|-pre|-post)?\\\\.js\",\"avada-header.js\",\"et_core_page_resource_fallback\",\"window.\\\\$us === undefined\",\"js-extra\",\"modernizr.js\",\"fusionNavIsCollapsed\",\"et_animation_data\",\"wpforms_settings\",\"var nfForms\",\"\\/\\/stats.wp.com\",\"var billing_additional_field\",\"_stq.push\",\"avadaHeaderVars\",\"var gtm4wp\",\"var dataLayer_content\",\"cpLoadCSS\",\"ninja_column_\",\"var rbs_gallery_\",\"var lepopup_\",\"wprRemoveCPCSS\",\"document\\\\.body\\\\.classList\\\\.remove\\\\(\\\"no-js\\\"\\\\)\",\"document\\\\.documentElement\\\\.className\\\\.replace\\\\( \'no-js\', \'js\' \\\\)\",\"fluent_form_ff_form_instance_\",\"\\/ewww-image-optimizer\\/includes\\/load[_-]webp(\\\\.min)?.js\",\"\\/ewww-image-optimizer\\/includes\\/check-webp(\\\\.min)?.js\",\"ewww_webp_supported\",\"\\/Divi\\/js\\/scripts.min.js\",\"\\/jetpack-boost\\/vendor\\/automattic\\/jetpack-lazy-images\\/(.*)\",\"\\/dist\\/js\\/browser-redirect\\/app.js\",\"\\\\\\/perfmatters\\\\\\/js\\\\\\/lazyload.min.js\",\"lazyLoadInstance\",\"scripts.mediavine.com\\/tags\\/\",\"simpli.fi\",\"initCubePortfolio\",\"gforms_recaptcha_\",\"generateBlog\",\"var sc_project\",\"statcounter.com\\/counter\\/counter.js\",\"booking-suedtirol-js\",\"wpcp_css_disable_selection\",\"jetpack-lazy-images-js-enabled\",\"jetpack-boost-critical-css\",\"wpformsRecaptchaCallback\",\"\\/jetpack\\/jetpack_vendor\\/automattic\\/jetpack-lazy-images\\/(.*)\",\"\\/gravityforms\\/js\\/conditional_logic.min.js\",\"\\/themify-builder\\/themify\\/js\\/modules\\/fallback(\\\\.min)?.js\",\"handlePixMessage\",\"var corner_video\",\"cdn.pixfuture.com\\\\\\/hb_v2.js\",\"cdn.pixfuture.com\\\\\\/pbix.js\",\"served-by.pixfuture.com\\\\\\/www\\\\\\/delivery\\\\\\/ads.js\",\"served-by.pixfuture.com\\\\\\/www\\\\\\/delivery\\\\\\/headerbid_sticky_refresh.js\",\"serv-vdo.pixfuture.com\\\\\\/vpaid\\\\\\/ads.js\",\"window.jdgmSettings\",\"\\\\\\/photonic\\\\\\/include\\\\\\/js\\\\\\/front-end\\\\\\/nomodule\\\\\\/photonic-baguettebox.min.js\",\"\\\\\\/photonic\\\\\\/include\\\\\\/ext\\\\\\/baguettebox\\\\\\/baguettebox.min.js\",\"window.wsf_form_json_config\",\"et_link_options_data\",\"FuseboxPlayerAPIKey\",\"js.hscta.net\\\\\\/cta\\\\\\/current.js\",\"hbspt.cta.load\",\"consent.cookiebot.com\\\\\\/uc.js\",\"\\\\\\/woofilter-pro\\\\\\/woofilterpro\\\\\\/js\\\\\\/ion.rangeSlider.min.js\",\"barra.r7.com\\\\\\/barra.js\"],\"delay_js_timeout\":20,\"fonts\":[],\"delay_js_files_exclusion\":[],\"delay_js_post_types_exclusion\":[],\"delay_js_post_urls_exclusion\":[],\"delay_js_plugins_themes_exclusion\":[],\"delay_js_ads_tracker_exclusion\":[],\"delay_js_exclude_inline_js\":false,\"delay_js_keywords_advanced_view\":false,\"preload\":{\"scripts\":[],\"styles\":[]},\"async\":{\"scripts\":[],\"styles\":[]},\"ao_completed_time\":\"\"},\"uptime\":{\"enabled\":true,\"notifications\":{\"enabled\":false},\"reports\":{\"enabled\":false}},\"gravatar\":{\"enabled\":true},\"page_cache\":{\"enabled\":true,\"cache_blog\":true,\"detection\":\"auto\",\"pages_cached\":0,\"integrations\":{\"varnish\":false,\"opcache\":false},\"preload\":true,\"preload_type\":{\"home_page\":true,\"on_clear\":false}},\"caching\":{\"expiry_css\":\"1y\\/A31536000\",\"expiry_javascript\":\"1y\\/A31536000\",\"expiry_media\":\"1y\\/A31536000\",\"expiry_images\":\"1y\\/A31536000\"},\"cloudflare\":{\"enabled\":false,\"connected\":false,\"last_check\":1729666978,\"email\":\"\",\"api_key\":\"\",\"account_id\":\"\",\"zone\":\"\",\"zone_name\":\"\",\"plan\":false,\"page_rules\":[],\"cache_expiry\":31536000,\"apo_paid\":false,\"apo\":[]},\"performance\":{\"reports\":{\"enabled\":false},\"subsite_tests\":true,\"dismissed\":false},\"advanced\":{\"query_string\":true,\"query_strings_global\":false,\"emoji\":true,\"post_revisions\":false,\"viewport_meta\":true,\"emoji_global\":false,\"prefetch\":[],\"preconnect\":[],\"cart_fragments\":true,\"lazy_load\":{\"enabled\":false,\"method\":\"click\",\"button\":{\"dimensions\":{\"height\":0,\"width\":0,\"radius\":0},\"color\":{\"background\":\"\",\"border\":\"\",\"hover\":\"\"},\"alignment\":{\"align\":\"center\",\"full_width\":\"on\",\"left\":0,\"right\":0,\"top\":0,\"bottom\":0}},\"threshold\":10,\"preload\":false}},\"rss\":{\"enabled\":true,\"duration\":3600},\"settings\":{\"accessible_colors\":false,\"remove_settings\":false,\"remove_data\":false,\"tracking\":false,\"control\":true},\"redis\":{\"enabled\":false},\"database\":{\"reports\":{\"enabled\":false}}}{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (749,'wd_smart_ip_detection_header','HTTP_X_REAL_IP','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (750,'wpdef_ip_blocklist_sync_last_run_time','1747980915','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (753,'wd_recaptcha_settings','{\"enabled\":true,\"active_type\":\"v3_recaptcha\",\"data_v2_checkbox\":{\"key\":\"\",\"secret\":\"\",\"size\":\"normal\",\"style\":\"light\"},\"data_v2_invisible\":{\"key\":\"\",\"secret\":\"\"},\"data_v3_recaptcha\":{\"key\":\"6LeZjGkqAAAAAHox0NkdQksLBrRV4L7-rgsxh0B1\",\"secret\":\"6LeZjGkqAAAAAFR1ogl3Zs6-nJA01mcPKYzztxJD\",\"threshold\":\"0.5\"},\"language\":\"automatic\",\"message\":\"reCAPTCHA verification failed. Please try again.\",\"locations\":[\"login\",\"register\",\"lost_password\",\"comments\"],\"detect_woo\":true,\"woo_checked_locations\":[\"woo_login\",\"woo_lost_password\",\"woo_register\"],\"detect_buddypress\":false,\"buddypress_checked_locations\":[],\"disable_for_known_users\":true}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (754,'wd_security_headers_settings','{\"sh_xframe\":true,\"sh_xframe_mode\":\"sameorigin\",\"sh_xss_protection\":true,\"sh_xss_protection_mode\":\"sanitize\",\"sh_content_type_options\":true,\"sh_content_type_options_mode\":\"nosniff\",\"sh_strict_transport\":true,\"hsts_preload\":0,\"include_subdomain\":0,\"hsts_cache_duration\":\"30 days\",\"sh_referrer_policy\":true,\"sh_referrer_policy_mode\":\"origin-when-cross-origin\",\"sh_feature_policy\":true,\"sh_feature_policy_mode\":\"self\",\"sh_feature_policy_urls\":\"\"}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (757,'wd_password_protection_settings','{\"enabled\":true,\"user_roles\":[\"administrator\",\"editor\",\"author\",\"contributor\",\"subscriber\",\"customer\",\"shop_manager\"],\"pwned_actions\":{\"force_change_message\":\"You are required to change your password because the password you are using exists on database breach records.\"}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (767,'forminator_posts_map','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (768,'_transient_shipping-transient-version','1729665152','on');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (771,'wdp_un_notifications','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (740,'finished_updating_comment_type','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (723,'defender_scan_ignore_index','{{SHIPPER_JSON_START}}[]{{SHIPPER_JSON_END}}','off');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (1893,'forminator_version_upgraded','1','auto');
INSERT INTO {{SHIPPER_TABLE_PREFIX}}options VALUES (26131,'_transient_fusion_fontawesome_en','.fa,.fab,.fal,.far,.fas{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-style:normal;font-variant:normal;text-rendering:auto;line-height:1}.fa-lg{font-size:1.33333em;line-height:.75em;vertical-align:-.0667em}.fa-xs{font-size:.75em}.fa-sm{font-size:.875em}.fa-1x{font-size:1em}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-6x{font-size:6em}.fa-7x{font-size:7em}.fa-8x{font-size:8em}.fa-9x{font-size:9em}.fa-10x{font-size:10em}.fa-fw{text-align:center;width:1.25em}.fa-ul{list-style-type:none;margin-left:2.5em;padding-left:0}.fa-ul>li{position:relative}.fa-li{left:-2em;position:absolute;text-align:center;width:2em;line-height:inherit}.fa-border{border:solid .08em #eee;border-radius:.1em;padding:.2em .25em .15em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left,.fab.fa-pull-left,.fal.fa-pull-left,.far.fa-pull-left,.fas.fa-pull-left{margin-right:.3em}.fa.fa-pull-right,.fab.fa-pull-right,.fal.fa-pull-right,.far.fa-pull-right,.fas.fa-pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.fa-rotate-90{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-webkit-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-webkit-transform:scale(-1,1);transform:scale(-1,1)}.fa-flip-vertical{-webkit-transform:scale(1,-1);transform:scale(1,-1)}.fa-flip-horizontal.fa-flip-vertical{-webkit-transform:scale(-1,-1);transform:scale(-1,-1)}:root .fa-flip-horizontal,:root .fa-flip-vertical,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-rotate-90{-webkit-filter:none;filter:none}.fa-stack{display:inline-block;height:2em;line-height:2em;position:relative;vertical-align:middle;width:2.5em}.fa-stack-1x,.fa-stack-2x{left:0;position:absolute;text-align:center;width:100%}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}@font-face{font-family:\"Font Awesome 5 Brands\";font-style:normal;font-weight:normal;src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot);src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot?#iefix) format(\"embedded-opentype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff2) format(\"woff2\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff) format(\"woff\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.ttf) format(\"truetype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.svg#fontawesome) format(\"svg\");font-display: block;}.fab{font-family:\"Font Awesome 5 Brands\"}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:400;src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot);src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot?#iefix) format(\"embedded-opentype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff2) format(\"woff2\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff) format(\"woff\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.ttf) format(\"truetype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.svg#fontawesome) format(\"svg\");font-display: block;}.far{font-family:\"Font Awesome 5 Free\";font-weight:400;}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:900;src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot);src:url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot?#iefix) format(\"embedded-opentype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff2) format(\"woff2\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff) format(\"woff\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.ttf) format(\"truetype\"),url(//thrillrebels.com/wp-content/themes/Avada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.svg#fontawesome) format(\"svg\");font-display: block;}.fa,.fas{font-family:\"Font Awesome 5 Free\";font-weight:900}.fa-500px:before{content:\"\\f26e\"}.fa-accessible-icon:before{content:\"\\f368\"}.fa-accusoft:before{content:\"\\f369\"}.fa-acquisitions-incorporated:before{content:\"\\f6af\"}.fa-ad:before{content:\"\\f641\"}.fa-address-book:before{content:\"\\f2b9\"}.fa-address-card:before{content:\"\\f2bb\"}.fa-adjust:before{content:\"\\f042\"}.fa-adn:before{content:\"\\f170\"}.fa-adversal:before{content:\"\\f36a\"}.fa-affiliatetheme:before{content:\"\\f36b\"}.fa-air-freshener:before{content:\"\\f5d0\"}.fa-airbnb:before{content:\"\\f834\"}.fa-algolia:before{content:\"\\f36c\"}.fa-align-center:before{content:\"\\f037\"}.fa-align-justify:before{content:\"\\f039\"}.fa-align-left:before{content:\"\\f036\"}.fa-align-right:before{content:\"\\f038\"}.fa-alipay:before{content:\"\\f642\"}.fa-allergies:before{content:\"\\f461\"}.fa-amazon:before{content:\"\\f270\"}.fa-amazon-pay:before{content:\"\\f42c\"}.fa-ambulance:before{content:\"\\f0f9\"}.fa-american-sign-language-interpreting:before{content:\"\\f2a3\"}.fa-amilia:before{content:\"\\f36d\"}.fa-anchor:before{content:\"\\f13d\"}.fa-android:before{content:\"\\f17b\"}.fa-angellist:before{content:\"\\f209\"}.fa-angle-double-down:before{content:\"\\f103\"}.fa-angle-double-left:before{content:\"\\f100\"}.fa-angle-double-right:before{content:\"\\f101\"}.fa-angle-double-up:before{content:\"\\f102\"}.fa-angle-down:before{content:\"\\f107\"}.fa-angle-left:before{content:\"\\f104\"}.fa-angle-right:before{content:\"\\f105\"}.fa-angle-up:before{content:\"\\f106\"}.fa-angry:before{content:\"\\f556\"}.fa-angrycreative:before{content:\"\\f36e\"}.fa-angular:before{content:\"\\f420\"}.fa-ankh:before{content:\"\\f644\"}.fa-app-store:before{content:\"\\f36f\"}.fa-app-store-ios:before{content:\"\\f370\"}.fa-apper:before{content:\"\\f371\"}.fa-apple:before{content:\"\\f179\"}.fa-apple-alt:before{content:\"\\f5d1\"}.fa-apple-pay:before{content:\"\\f415\"}.fa-archive:before{content:\"\\f187\"}.fa-archway:before{content:\"\\f557\"}.fa-arrow-alt-circle-down:before{content:\"\\f358\"}.fa-arrow-alt-circle-left:before{content:\"\\f359\"}.fa-arrow-alt-circle-right:before{content:\"\\f35a\"}.fa-arrow-alt-circle-up:before{content:\"\\f35b\"}.fa-arrow-circle-down:before{content:\"\\f0ab\"}.fa-arrow-circle-left:before{content:\"\\f0a8\"}.fa-arrow-circle-right:before{content:\"\\f0a9\"}.fa-arrow-circle-up:before{content:\"\\f0aa\"}.fa-arrow-down:before{content:\"\\f063\"}.fa-arrow-left:before{content:\"\\f060\"}.fa-arrow-right:before{content:\"\\f061\"}.fa-arrow-up:before{content:\"\\f062\"}.fa-arrows-alt:before{content:\"\\f0b2\"}.fa-arrows-alt-h:before{content:\"\\f337\"}.fa-arrows-alt-v:before{content:\"\\f338\"}.fa-artstation:before{content:\"\\f77a\"}.fa-assistive-listening-systems:before{content:\"\\f2a2\"}.fa-asterisk:before{content:\"\\f069\"}.fa-asymmetrik:before{content:\"\\f372\"}.fa-at:before{content:\"\\f1fa\"}.fa-atlas:before{content:\"\\f558\"}.fa-atlassian:before{content:\"\\f77b\"}.fa-atom:before{content:\"\\f5d2\"}.fa-audible:before{content:\"\\f373\"}.fa-audio-description:before{content:\"\\f29e\"}.fa-autoprefixer:before{content:\"\\f41c\"}.fa-avianex:before{content:\"\\f374\"}.fa-aviato:before{content:\"\\f421\"}.fa-award:before{content:\"\\f559\"}.fa-aws:before{content:\"\\f375\"}.fa-baby:before{content:\"\\f77c\"}.fa-baby-carriage:before{content:\"\\f77d\"}.fa-backspace:before{content:\"\\f55a\"}.fa-backward:before{content:\"\\f04a\"}.fa-bacon:before{content:\"\\f7e5\"}.fa-bacteria:before{content:\"\\e059\"}.fa-bacterium:before{content:\"\\e05a\"}.fa-bahai:before{content:\"\\f666\"}.fa-balance-scale:before{content:\"\\f24e\"}.fa-balance-scale-left:before{content:\"\\f515\"}.fa-balance-scale-right:before{content:\"\\f516\"}.fa-ban:before{content:\"\\f05e\"}.fa-band-aid:before{content:\"\\f462\"}.fa-bandcamp:before{content:\"\\f2d5\"}.fa-barcode:before{content:\"\\f02a\"}.fa-bars:before{content:\"\\f0c9\"}.fa-baseball-ball:before{content:\"\\f433\"}.fa-basketball-ball:before{content:\"\\f434\"}.fa-bath:before{content:\"\\f2cd\"}.fa-battery-empty:before{content:\"\\f244\"}.fa-battery-full:before{content:\"\\f240\"}.fa-battery-half:before{content:\"\\f242\"}.fa-battery-quarter:before{content:\"\\f243\"}.fa-battery-three-quarters:before{content:\"\\f241\"}.fa-battle-net:before{content:\"\\f835\"}.fa-bed:before{content:\"\\f236\"}.fa-beer:before{content:\"\\f0fc\"}.fa-behance:before{content:\"\\f1b4\"}.fa-behance-square:before{content:\"\\f1b5\"}.fa-bell:before{content:\"\\f0f3\"}.fa-bell-slash:before{content:\"\\f1f6\"}.fa-bezier-curve:before{content:\"\\f55b\"}.fa-bible:before{content:\"\\f647\"}.fa-bicycle:before{content:\"\\f206\"}.fa-biking:before{content:\"\\f84a\"}.fa-bimobject:before{content:\"\\f378\"}.fa-binoculars:before{content:\"\\f1e5\"}.fa-biohazard:before{content:\"\\f780\"}.fa-birthday-cake:before{content:\"\\f1fd\"}.fa-bitbucket:before{content:\"\\f171\"}.fa-bitcoin:before{content:\"\\f379\"}.fa-bity:before{content:\"\\f37a\"}.fa-black-tie:before{content:\"\\f27e\"}.fa-blackberry:before{content:\"\\f37b\"}.fa-blender:before{content:\"\\f517\"}.fa-blender-phone:before{content:\"\\f6b6\"}.fa-blind:before{content:\"\\f29d\"}.fa-blog:before{content:\"\\f781\"}.fa-blogger:before{content:\"\\f37c\"}.fa-blogger-b:before{content:\"\\f37d\"}.fa-bluetooth:before{content:\"\\f293\"}.fa-bluetooth-b:before{content:\"\\f294\"}.fa-bold:before{content:\"\\f032\"}.fa-bolt:before{content:\"\\f0e7\"}.fa-bomb:before{content:\"\\f1e2\"}.fa-bone:before{content:\"\\f5d7\"}.fa-bong:before{content:\"\\f55c\"}.fa-book:before{content:\"\\f02d\"}.fa-book-dead:before{content:\"\\f6b7\"}.fa-book-medical:before{content:\"\\f7e6\"}.fa-book-open:before{content:\"\\f518\"}.fa-book-reader:before{content:\"\\f5da\"}.fa-bookmark:before{content:\"\\f02e\"}.fa-bootstrap:before{content:\"\\f836\"}.fa-border-all:before{content:\"\\f84c\"}.fa-border-none:before{content:\"\\f850\"}.fa-border-style:before{content:\"\\f853\"}.fa-bowling-ball:before{content:\"\\f436\"}.fa-box:before{content:\"\\f466\"}.fa-box-open:before{content:\"\\f49e\"}.fa-box-tissue:before{content:\"\\e05b\"}.fa-boxes:before{content:\"\\f468\"}.fa-braille:before{content:\"\\f2a1\"}.fa-brain:before{content:\"\\f5dc\"}.fa-bread-slice:before{content:\"\\f7ec\"}.fa-briefcase:before{content:\"\\f0b1\"}.fa-briefcase-medical:before{content:\"\\f469\"}.fa-broadcast-tower:before{content:\"\\f519\"}.fa-broom:before{content:\"\\f51a\"}.fa-brush:before{content:\"\\f55d\"}.fa-btc:before{content:\"\\f15a\"}.fa-buffer:before{content:\"\\f837\"}.fa-bug:before{content:\"\\f188\"}.fa-building:before{content:\"\\f1ad\"}.fa-bullhorn:before{content:\"\\f0a1\"}.fa-bullseye:before{content:\"\\f140\"}.fa-burn:before{content:\"\\f46a\"}.fa-buromobelexperte:before{content:\"\\f37f\"}.fa-bus:before{content:\"\\f207\"}.fa-bus-alt:before{content:\"\\f55e\"}.fa-business-time:before{content:\"\\f64a\"}.fa-buy-n-large:before{content:\"\\f8a6\"}.fa-buysellads:before{content:\"\\f20d\"}.fa-calculator:before{content:\"\\f1ec\"}.fa-calendar:before{content:\"\\f133\"}.fa-calendar-alt:before{content:\"\\f073\"}.fa-calendar-check:before{content:\"\\f274\"}.fa-calendar-day:before{content:\"\\f783\"}.fa-calendar-minus:before{content:\"\\f272\"}.fa-calendar-plus:before{content:\"\\f271\"}.fa-calendar-times:before{content:\"\\f273\"}.fa-calendar-week:before{content:\"\\f784\"}.fa-camera:before{content:\"\\f030\"}.fa-camera-retro:before{content:\"\\f083\"}.fa-campground:before{content:\"\\f6bb\"}.fa-canadian-maple-leaf:before{content:\"\\f785\"}.fa-candy-cane:before{content:\"\\f786\"}.fa-cannabis:before{content:\"\\f55f\"}.fa-capsules:before{content:\"\\f46b\"}.fa-car:before{content:\"\\f1b9\"}.fa-car-alt:before{content:\"\\f5de\"}.fa-car-battery:before{content:\"\\f5df\"}.fa-car-crash:before{content:\"\\f5e1\"}.fa-car-side:before{content:\"\\f5e4\"}.fa-caravan:before{content:\"\\f8ff\"}.fa-caret-down:before{content:\"\\f0d7\"}.fa-caret-left:before{content:\"\\f0d9\"}.fa-caret-right:before{content:\"\\f0da\"}.fa-caret-square-down:before{content:\"\\f150\"}.fa-caret-square-left:before{content:\"\\f191\"}.fa-caret-square-right:before{content:\"\\f152\"}.fa-caret-square-up:before{content:\"\\f151\"}.fa-caret-up:before{content:\"\\f0d8\"}.fa-carrot:before{content:\"\\f787\"}.fa-cart-arrow-down:before{content:\"\\f218\"}.fa-cart-plus:before{content:\"\\f217\"}.fa-cash-register:before{content:\"\\f788\"}.fa-cat:before{content:\"\\f6be\"}.fa-cc-amazon-pay:before{content:\"\\f42d\"}.fa-cc-amex:before{content:\"\\f1f3\"}.fa-cc-apple-pay:before{content:\"\\f416\"}.fa-cc-diners-club:before{content:\"\\f24c\"}.fa-cc-discover:before{content:\"\\f1f2\"}.fa-cc-jcb:before{content:\"\\f24b\"}.fa-cc-mastercard:before{content:\"\\f1f1\"}.fa-cc-paypal:before{content:\"\\f1f4\"}.fa-cc-stripe:before{content:\"\\f1f5\"}.fa-cc-visa:before{content:\"\\f1f0\"}.fa-centercode:before{content:\"\\f380\"}.fa-centos:before{content:\"\\f789\"}.fa-certificate:before{content:\"\\f0a3\"}.fa-chair:before{content:\"\\f6c0\"}.fa-chalkboard:before{content:\"\\f51b\"}.fa-chalkboard-teacher:before{content:\"\\f51c\"}.fa-charging-station:before{content:\"\\f5e7\"}.fa-chart-area:before{content:\"\\f1fe\"}.fa-chart-bar:before{content:\"\\f080\"}.fa-chart-line:before{content:\"\\f201\"}.fa-chart-pie:before{content:\"\\f200\"}.fa-check:before{content:\"\\f00c\"}.fa-check-circle:before{content:\"\\f058\"}.fa-check-double:before{content:\"\\f560\"}.fa-check-square:before{content:\"\\f14a\"}.fa-cheese:before{content:\"\\f7ef\"}.fa-chess:before{content:\"\\f439\"}.fa-chess-bishop:before{content:\"\\f43a\"}.fa-chess-board:before{content:\"\\f43c\"}.fa-chess-king:before{content:\"\\f43f\"}.fa-chess-knight:before{content:\"\\f441\"}.fa-chess-pawn:before{content:\"\\f443\"}.fa-chess-queen:before{content:\"\\f445\"}.fa-chess-rook:before{content:\"\\f447\"}.fa-chevron-circle-down:before{content:\"\\f13a\"}.fa-chevron-circle-left:before{content:\"\\f137\"}.fa-chevron-circle-right:before{content:\"\\f138\"}.fa-chevron-circle-up:before{content:\"\\f139\"}.fa-chevron-down:before{content:\"\\f078\"}.fa-chevron-left:before{content:\"\\f053\"}.fa-chevron-right:before{content:\"\\f054\"}.fa-chevron-up:before{content:\"\\f077\"}.fa-child:before{content:\"\\f1ae\"}.fa-chrome:before{content:\"\\f268\"}.fa-chromecast:before{content:\"\\f838\"}.fa-church:before{content:\"\\f51d\"}.fa-circle:before{content:\"\\f111\"}.fa-circle-notch:before{content:\"\\f1ce\"}.fa-city:before{content:\"\\f64f\"}.fa-clinic-medical:before{content:\"\\f7f2\"}.fa-clipboard:before{content:\"\\f328\"}.fa-clipboard-check:before{content:\"\\f46c\"}.fa-clipboard-list:before{content:\"\\f46d\"}.fa-clock:before{content:\"\\f017\"}.fa-clone:before{content:\"\\f24d\"}.fa-closed-captioning:before{content:\"\\f20a\"}.fa-cloud:before{content:\"\\f0c2\"}.fa-cloud-download-alt:before{content:\"\\f381\"}.fa-cloud-meatball:before{content:\"\\f73b\"}.fa-cloud-moon:before{content:\"\\f6c3\"}.fa-cloud-moon-rain:before{content:\"\\f73c\"}.fa-cloud-rain:before{content:\"\\f73d\"}.fa-cloud-showers-heavy:before{content:\"\\f740\"}.fa-cloud-sun:before{content:\"\\f6c4\"}.fa-cloud-sun-rain:before{content:\"\\f743\"}.fa-cloud-upload-alt:before{content:\"\\f382\"}.fa-cloudflare:before{content:\"\\e07d\"}.fa-cloudscale:before{content:\"\\f383\"}.fa-cloudsmith:before{content:\"\\f384\"}.fa-cloudversify:before{content:\"\\f385\"}.fa-cocktail:before{content:\"\\f561\"}.fa-code:before{content:\"\\f121\"}.fa-code-branch:before{content:\"\\f126\"}.fa-codepen:before{content:\"\\f1cb\"}.fa-codiepie:before{content:\"\\f284\"}.fa-coffee:before{content:\"\\f0f4\"}.fa-cog:before{content:\"\\f013\"}.fa-cogs:before{content:\"\\f085\"}.fa-coins:before{content:\"\\f51e\"}.fa-columns:before{content:\"\\f0db\"}.fa-comment:before{content:\"\\f075\"}.fa-comment-alt:before{content:\"\\f27a\"}.fa-comment-dollar:before{content:\"\\f651\"}.fa-comment-dots:before{content:\"\\f4ad\"}.fa-comment-medical:before{content:\"\\f7f5\"}.fa-comment-slash:before{content:\"\\f4b3\"}.fa-comments:before{content:\"\\f086\"}.fa-comments-dollar:before{content:\"\\f653\"}.fa-compact-disc:before{content:\"\\f51f\"}.fa-compass:before{content:\"\\f14e\"}.fa-compress:before{content:\"\\f066\"}.fa-compress-alt:before{content:\"\\f422\"}.fa-compress-arrows-alt:before{content:\"\\f78c\"}.fa-concierge-bell:before{content:\"\\f562\"}.fa-confluence:before{content:\"\\f78d\"}.fa-connectdevelop:before{content:\"\\f20e\"}.fa-contao:before{content:\"\\f26d\"}.fa-cookie:before{content:\"\\f563\"}.fa-cookie-bite:before{content:\"\\f564\"}.fa-copy:before{content:\"\\f0c5\"}.fa-copyright:before{content:\"\\f1f9\"}.fa-cotton-bureau:before{content:\"\\f89e\"}.fa-couch:before{content:\"\\f4b8\"}.fa-cpanel:before{content:\"\\f388\"}.fa-creative-commons:before{content:\"\\f25e\"}.fa-creative-commons-by:before{content:\"\\f4e7\"}.fa-creative-commons-nc:before{content:\"\\f4e8\"}.fa-creative-commons-nc-eu:before{content:\"\\f4e9\"}.fa-creative-commons-nc-jp:before{content:\"\\f4ea\"}.fa-creative-commons-nd:before{content:\"\\f4eb\"}.fa-creative-commons-pd:before{content:\"\\f4ec\"}.fa-creative-commons-pd-alt:before{content:\"\\f4ed\"}.fa-creative-commons-remix:before{content:\"\\f4ee\"}.fa-creative-commons-sa:before{content:\"\\f4ef\"}.fa-creative-commons-sampling:before{content:\"\\f4f0\"}.fa-creative-commons-sampling-plus:before{content:\"\\f4f1\"}.fa-creative-commons-share:before{content:\"\\f4f2\"}.fa-creative-commons-zero:before{content:\"\\f4f3\"}.fa-credit-card:before{content:\"\\f09d\"}.fa-critical-role:before{content:\"\\f6c9\"}.fa-crop:before{content:\"\\f125\"}.fa-crop-alt:before{content:\"\\f565\"}.fa-cross:before{content:\"\\f654\"}.fa-crosshairs:before{content:\"\\f05b\"}.fa-crow:before{content:\"\\f520\"}.fa-crown:before{content:\"\\f521\"}.fa-crutch:before{content:\"\\f7f7\"}.fa-css3:before{content:\"\\f13c\"}.fa-css3-alt:before{content:\"\\f38b\"}.fa-cube:before{content:\"\\f1b2\"}.fa-cubes:before{content:\"\\f1b3\"}.fa-cut:before{content:\"\\f0c4\"}.fa-cuttlefish:before{content:\"\\f38c\"}.fa-d-and-d:before{content:\"\\f38d\"}.fa-d-and-d-beyond:before{content:\"\\f6ca\"}.fa-dailymotion:before{content:\"\\e052\"}.fa-dashcube:before{content:\"\\f210\"}.fa-database:before{content:\"\\f1c0\"}.fa-deaf:before{content:\"\\f2a4\"}.fa-deezer:before{content:\"\\e077\"}.fa-delicious:before{content:\"\\f1a5\"}.fa-democrat:before{content:\"\\f747\"}.fa-deploydog:before{content:\"\\f38e\"}.fa-deskpro:before{content:\"\\f38f\"}.fa-desktop:before{content:\"\\f108\"}.fa-dev:before{content:\"\\f6cc\"}.fa-deviantart:before{content:\"\\f1bd\"}.fa-dharmachakra:before{content:\"\\f655\"}.fa-dhl:before{content:\"\\f790\"}.fa-diagnoses:before{content:\"\\f470\"}.fa-diaspora:before{content:\"\\f791\"}.fa-dice:before{content:\"\\f522\"}.fa-dice-d20:before{content:\"\\f6cf\"}.fa-dice-d6:before{content:\"\\f6d1\"}.fa-dice-five:before{content:\"\\f523\"}.fa-dice-four:before{content:\"\\f524\"}.fa-dice-one:before{content:\"\\f525\"}.fa-dice-six:before{content:\"\\f526\"}.fa-dice-three:before{content:\"\\f527\"}.fa-dice-two:before{content:\"\\f528\"}.fa-digg:before{content:\"\\f1a6\"}.fa-digital-ocean:before{content:\"\\f391\"}.fa-digital-tachograph:before{content:\"\\f566\"}.fa-directions:before{content:\"\\f5eb\"}.fa-discord:before{content:\"\\f392\"}.fa-discourse:before{content:\"\\f393\"}.fa-disease:before{content:\"\\f7fa\"}.fa-divide:before{content:\"\\f529\"}.fa-dizzy:before{content:\"\\f567\"}.fa-dna:before{content:\"\\f471\"}.fa-dochub:before{content:\"\\f394\"}.fa-docker:before{content:\"\\f395\"}.fa-dog:before{content:\"\\f6d3\"}.fa-dollar-sign:before{content:\"\\f155\"}.fa-dolly:before{content:\"\\f472\"}.fa-dolly-flatbed:before{content:\"\\f474\"}.fa-donate:before{content:\"\\f4b9\"}.fa-door-closed:before{content:\"\\f52a\"}.fa-door-open:before{content:\"\\f52b\"}.fa-dot-circle:before{content:\"\\f192\"}.fa-dove:before{content:\"\\f4ba\"}.fa-download:before{content:\"\\f019\"}.fa-draft2digital:before{content:\"\\f396\"}.fa-drafting-compass:before{content:\"\\f568\"}.fa-dragon:before{content:\"\\f6d5\"}.fa-draw-polygon:before{content:\"\\f5ee\"}.fa-dribbble:before{content:\"\\f17d\"}.fa-dribbble-square:before{content:\"\\f397\"}.fa-dropbox:before{content:\"\\f16b\"}.fa-drum:before{content:\"\\f569\"}.fa-drum-steelpan:before{content:\"\\f56a\"}.fa-drumstick-bite:before{content:\"\\f6d7\"}.fa-drupal:before{content:\"\\f1a9\"}.fa-dumbbell:before{content:\"\\f44b\"}.fa-dumpster:before{content:\"\\f793\"}.fa-dumpster-fire:before{content:\"\\f794\"}.fa-dungeon:before{content:\"\\f6d9\"}.fa-dyalog:before{content:\"\\f399\"}.fa-earlybirds:before{content:\"\\f39a\"}.fa-ebay:before{content:\"\\f4f4\"}.fa-edge:before{content:\"\\f282\"}.fa-edge-legacy:before{content:\"\\e078\"}.fa-edit:before{content:\"\\f044\"}.fa-egg:before{content:\"\\f7fb\"}.fa-eject:before{content:\"\\f052\"}.fa-elementor:before{content:\"\\f430\"}.fa-ellipsis-h:before{content:\"\\f141\"}.fa-ellipsis-v:before{content:\"\\f142\"}.fa-ello:before{content:\"\\f5f1\"}.fa-ember:before{content:\"\\f423\"}.fa-empire:before{content:\"\\f1d1\"}.fa-envelope:before{content:\"\\f0e0\"}.fa-envelope-open:before{content:\"\\f2b6\"}.fa-envelope-open-text:before{content:\"\\f658\"}.fa-envelope-square:before{content:\"\\f199\"}.fa-envira:before{content:\"\\f299\"}.fa-equals:before{content:\"\\f52c\"}.fa-eraser:before{content:\"\\f12d\"}.fa-erlang:before{content:\"\\f39d\"}.fa-ethereum:before{content:\"\\f42e\"}.fa-ethernet:before{content:\"\\f796\"}.fa-etsy:before{content:\"\\f2d7\"}.fa-euro-sign:before{content:\"\\f153\"}.fa-evernote:before{content:\"\\f839\"}.fa-exchange-alt:before{content:\"\\f362\"}.fa-exclamation:before{content:\"\\f12a\"}.fa-exclamation-circle:before{content:\"\\f06a\"}.fa-exclamation-triangle:before{content:\"\\f071\"}.fa-expand:before{content:\"\\f065\"}.fa-expand-alt:before{content:\"\\f424\"}.fa-expand-arrows-alt:before{content:\"\\f31e\"}.fa-expeditedssl:before{content:\"\\f23e\"}.fa-external-link-alt:before{content:\"\\f35d\"}.fa-external-link-square-alt:before{content:\"\\f360\"}.fa-eye:before{content:\"\\f06e\"}.fa-eye-dropper:before{content:\"\\f1fb\"}.fa-eye-slash:before{content:\"\\f070\"}.fa-facebook:before{content:\"\\f09a\"}.fa-facebook-f:before{content:\"\\f39e\"}.fa-facebook-messenger:before{content:\"\\f39f\"}.fa-facebook-square:before{content:\"\\f082\"}.fa-fan:before{content:\"\\f863\"}.fa-fantasy-flight-games:before{content:\"\\f6dc\"}.fa-fast-backward:before{content:\"\\f049\"}.fa-fast-forward:before{content:\"\\f050\"}.fa-faucet:before{content:\"\\e005\"}.fa-fax:before{content:\"\\f1ac\"}.fa-feather:before{content:\"\\f52d\"}.fa-feather-alt:before{content:\"\\f56b\"}.fa-fedex:before{content:\"\\f797\"}.fa-fedora:before{content:\"\\f798\"}.fa-female:before{content:\"\\f182\"}.fa-fighter-jet:before{content:\"\\f0fb\"}.fa-figma:before{content:\"\\f799\"}.fa-file:before{content:\"\\f15b\"}.fa-file-alt:before{content:\"\\f15c\"}.fa-file-archive:before{content:\"\\f1c6\"}.fa-file-audio:before{content:\"\\f1c7\"}.fa-file-code:before{content:\"\\f1c9\"}.fa-file-contract:before{content:\"\\f56c\"}.fa-file-csv:before{content:\"\\f6dd\"}.fa-file-download:before{content:\"\\f56d\"}.fa-file-excel:before{content:\"\\f1c3\"}.fa-file-export:before{content:\"\\f56e\"}.fa-file-image:before{content:\"\\f1c5\"}.fa-file-import:before{content:\"\\f56f\"}.fa-file-invoice:before{content:\"\\f570\"}.fa-file-invoice-dollar:before{content:\"\\f571\"}.fa-file-medical:before{content:\"\\f477\"}.fa-file-medical-alt:before{content:\"\\f478\"}.fa-file-pdf:before{content:\"\\f1c1\"}.fa-file-powerpoint:before{content:\"\\f1c4\"}.fa-file-prescription:before{content:\"\\f572\"}.fa-file-signature:before{content:\"\\f573\"}.fa-file-upload:before{content:\"\\f574\"}.fa-file-video:before{content:\"\\f1c8\"}.fa-file-word:before{content:\"\\f1c2\"}.fa-fill:before{content:\"\\f575\"}.fa-fill-drip:before{content:\"\\f576\"}.fa-film:before{content:\"\\f008\"}.fa-filter:before{content:\"\\f0b0\"}.fa-fingerprint:before{content:\"\\f577\"}.fa-fire:before{content:\"\\f06d\"}.fa-fire-alt:before{content:\"\\f7e4\"}.fa-fire-extinguisher:before{content:\"\\f134\"}.fa-firefox:before{content:\"\\f269\"}.fa-firefox-browser:before{content:\"\\e007\"}.fa-first-aid:before{content:\"\\f479\"}.fa-first-order:before{content:\"\\f2b0\"}.fa-first-order-alt:before{content:\"\\f50a\"}.fa-firstdraft:before{content:\"\\f3a1\"}.fa-fish:before{content:\"\\f578\"}.fa-fist-raised:before{content:\"\\f6de\"}.fa-flag:before{content:\"\\f024\"}.fa-flag-checkered:before{content:\"\\f11e\"}.fa-flag-usa:before{content:\"\\f74d\"}.fa-flask:before{content:\"\\f0c3\"}.fa-flickr:before{content:\"\\f16e\"}.fa-flipboard:before{content:\"\\f44d\"}.fa-flushed:before{content:\"\\f579\"}.fa-fly:before{content:\"\\f417\"}.fa-folder:before{content:\"\\f07b\"}.fa-folder-minus:before{content:\"\\f65d\"}.fa-folder-open:before{content:\"\\f07c\"}.fa-folder-plus:before{content:\"\\f65e\"}.fa-font:before{content:\"\\f031\"}.fa-font-awesome:before{content:\"\\f2b4\"}.fa-font-awesome-alt:before{content:\"\\f35c\"}.fa-font-awesome-flag:before{content:\"\\f425\"}.fa-fonticons:before{content:\"\\f280\"}.fa-fonticons-fi:before{content:\"\\f3a2\"}.fa-football-ball:before{content:\"\\f44e\"}.fa-fort-awesome:before{content:\"\\f286\"}.fa-fort-awesome-alt:before{content:\"\\f3a3\"}.fa-forumbee:before{content:\"\\f211\"}.fa-forward:before{content:\"\\f04e\"}.fa-foursquare:before{content:\"\\f180\"}.fa-free-code-camp:before{content:\"\\f2c5\"}.fa-freebsd:before{content:\"\\f3a4\"}.fa-frog:before{content:\"\\f52e\"}.fa-frown:before{content:\"\\f119\"}.fa-frown-open:before{content:\"\\f57a\"}.fa-fulcrum:before{content:\"\\f50b\"}.fa-funnel-dollar:before{content:\"\\f662\"}.fa-futbol:before{content:\"\\f1e3\"}.fa-galactic-republic:before{content:\"\\f50c\"}.fa-galactic-senate:before{content:\"\\f50d\"}.fa-gamepad:before{content:\"\\f11b\"}.fa-gas-pump:before{content:\"\\f52f\"}.fa-gavel:before{content:\"\\f0e3\"}.fa-gem:before{content:\"\\f3a5\"}.fa-genderless:before{content:\"\\f22d\"}.fa-get-pocket:before{content:\"\\f265\"}.fa-gg:before{content:\"\\f260\"}.fa-gg-circle:before{content:\"\\f261\"}.fa-ghost:before{content:\"\\f6e2\"}.fa-gift:before{content:\"\\f06b\"}.fa-gifts:before{content:\"\\f79c\"}.fa-git:before{content:\"\\f1d3\"}.fa-git-alt:before{content:\"\\f841\"}.fa-git-square:before{content:\"\\f1d2\"}.fa-github:before{content:\"\\f09b\"}.fa-github-alt:before{content:\"\\f113\"}.fa-github-square:before{content:\"\\f092\"}.fa-gitkraken:before{content:\"\\f3a6\"}.fa-gitlab:before{content:\"\\f296\"}.fa-gitter:before{content:\"\\f426\"}.fa-glass-cheers:before{content:\"\\f79f\"}.fa-glass-martini:before{content:\"\\f000\"}.fa-glass-martini-alt:before{content:\"\\f57b\"}.fa-glass-whiskey:before{content:\"\\f7a0\"}.fa-glasses:before{content:\"\\f530\"}.fa-glide:before{content:\"\\f2a5\"}.fa-glide-g:before{content:\"\\f2a6\"}.fa-globe:before{content:\"\\f0ac\"}.fa-globe-africa:before{content:\"\\f57c\"}.fa-globe-americas:before{content:\"\\f57d\"}.fa-globe-asia:before{content:\"\\f57e\"}.fa-globe-europe:before{content:\"\\f7a2\"}.fa-gofore:before{content:\"\\f3a7\"}.fa-golf-ball:before{content:\"\\f450\"}.fa-goodreads:before{content:\"\\f3a8\"}.fa-goodreads-g:before{content:\"\\f3a9\"}.fa-google:before{content:\"\\f1a0\"}.fa-google-drive:before{content:\"\\f3aa\"}.fa-google-pay:before{content:\"\\e079\"}.fa-google-play:before{content:\"\\f3ab\"}.fa-google-plus:before{content:\"\\f2b3\"}.fa-google-plus-g:before{content:\"\\f0d5\"}.fa-google-plus-square:before{content:\"\\f0d4\"}.fa-google-wallet:before{content:\"\\f1ee\"}.fa-gopuram:before{content:\"\\f664\"}.fa-graduation-cap:before{content:\"\\f19d\"}.fa-gratipay:before{content:\"\\f184\"}.fa-grav:before{content:\"\\f2d6\"}.fa-greater-than:before{content:\"\\f531\"}.fa-greater-than-equal:before{content:\"\\f532\"}.fa-grimace:before{content:\"\\f57f\"}.fa-grin:before{content:\"\\f580\"}.fa-grin-alt:before{content:\"\\f581\"}.fa-grin-beam:before{content:\"\\f582\"}.fa-grin-beam-sweat:before{content:\"\\f583\"}.fa-grin-hearts:before{content:\"\\f584\"}.fa-grin-squint:before{content:\"\\f585\"}.fa-grin-squint-tears:before{content:\"\\f586\"}.fa-grin-stars:before{content:\"\\f587\"}.fa-grin-tears:before{content:\"\\f588\"}.fa-grin-tongue:before{content:\"\\f589\"}.fa-grin-tongue-squint:before{content:\"\\f58a\"}.fa-grin-tongue-wink:before{content:\"\\f58b\"}.fa-grin-wink:before{content:\"\\f58c\"}.fa-grip-horizontal:before{content:\"\\f58d\"}.fa-grip-lines:before{content:\"\\f7a4\"}.fa-grip-lines-vertical:before{content:\"\\f7a5\"}.fa-grip-vertical:before{content:\"\\f58e\"}.fa-gripfire:before{content:\"\\f3ac\"}.fa-grunt:before{content:\"\\f3ad\"}.fa-guilded:before{content:\"\\e07e\"}.fa-guitar:before{content:\"\\f7a6\"}.fa-gulp:before{content:\"\\f3ae\"}.fa-h-square:before{content:\"\\f0fd\"}.fa-hacker-news:before{content:\"\\f1d4\"}.fa-hacker-news-square:before{content:\"\\f3af\"}.fa-hackerrank:before{content:\"\\f5f7\"}.fa-hamburger:before{content:\"\\f805\"}.fa-hammer:before{content:\"\\f6e3\"}.fa-hamsa:before{content:\"\\f665\"}.fa-hand-holding:before{content:\"\\f4bd\"}.fa-hand-holding-heart:before{content:\"\\f4be\"}.fa-hand-holding-medical:before{content:\"\\e05c\"}.fa-hand-holding-usd:before{content:\"\\f4c0\"}.fa-hand-holding-water:before{content:\"\\f4c1\"}.fa-hand-lizard:before{content:\"\\f258\"}.fa-hand-middle-finger:before{content:\"\\f806\"}.fa-hand-paper:before{content:\"\\f256\"}.fa-hand-peace:before{content:\"\\f25b\"}.fa-hand-point-down:before{content:\"\\f0a7\"}.fa-hand-point-left:before{content:\"\\f0a5\"}.fa-hand-point-right:before{content:\"\\f0a4\"}.fa-hand-point-up:before{content:\"\\f0a6\"}.fa-hand-pointer:before{content:\"\\f25a\"}.fa-hand-rock:before{content:\"\\f255\"}.fa-hand-scissors:before{content:\"\\f257\"}.fa-hand-sparkles:before{content:\"\\e05d\"}.fa-hand-spock:before{content:\"\\f259\"}.fa-hands:before{content:\"\\f4c2\"}.fa-hands-helping:before{content:\"\\f4c4\"}.fa-hands-wash:before{content:\"\\e05e\"}.fa-handshake:before{content:\"\\f2b5\"}.fa-handshake-alt-slash:before{content:\"\\e05f\"}.fa-handshake-slash:before{content:\"\\e060\"}.fa-hanukiah:before{content:\"\\f6e6\"}.fa-hard-hat:before{content:\"\\f807\"}.fa-hashtag:before{content:\"\\f292\"}.fa-hat-cowboy:before{content:\"\\f8c0\"}.fa-hat-cowboy-side:before{content:\"\\f8c1\"}.fa-hat-wizard:before{content:\"\\f6e8\"}.fa-hdd:before{content:\"\\f0a0\"}.fa-head-side-cough:before{content:\"\\e061\"}.fa-head-side-cough-slash:before{content:\"\\e062\"}.fa-head-side-mask:before{content:\"\\e063\"}.fa-head-side-virus:before{content:\"\\e064\"}.fa-heading:before{content:\"\\f1dc\"}.fa-headphones:before{content:\"\\f025\"}.fa-headphones-alt:before{content:\"\\f58f\"}.fa-headset:before{content:\"\\f590\"}.fa-heart:before{content:\"\\f004\"}.fa-heart-broken:before{content:\"\\f7a9\"}.fa-heartbeat:before{content:\"\\f21e\"}.fa-helicopter:before{content:\"\\f533\"}.fa-highlighter:before{content:\"\\f591\"}.fa-hiking:before{content:\"\\f6ec\"}.fa-hippo:before{content:\"\\f6ed\"}.fa-hips:before{content:\"\\f452\"}.fa-hire-a-helper:before{content:\"\\f3b0\"}.fa-history:before{content:\"\\f1da\"}.fa-hive:before{content:\"\\e07f\"}.fa-hockey-puck:before{content:\"\\f453\"}.fa-holly-berry:before{content:\"\\f7aa\"}.fa-home:before{content:\"\\f015\"}.fa-hooli:before{content:\"\\f427\"}.fa-hornbill:before{content:\"\\f592\"}.fa-horse:before{content:\"\\f6f0\"}.fa-horse-head:before{content:\"\\f7ab\"}.fa-hospital:before{content:\"\\f0f8\"}.fa-hospital-alt:before{content:\"\\f47d\"}.fa-hospital-symbol:before{content:\"\\f47e\"}.fa-hospital-user:before{content:\"\\f80d\"}.fa-hot-tub:before{content:\"\\f593\"}.fa-hotdog:before{content:\"\\f80f\"}.fa-hotel:before{content:\"\\f594\"}.fa-hotjar:before{content:\"\\f3b1\"}.fa-hourglass:before{content:\"\\f254\"}.fa-hourglass-end:before{content:\"\\f253\"}.fa-hourglass-half:before{content:\"\\f252\"}.fa-hourglass-start:before{content:\"\\f251\"}.fa-house-damage:before{content:\"\\f6f1\"}.fa-house-user:before{content:\"\\e065\"}.fa-houzz:before{content:\"\\f27c\"}.fa-hryvnia:before{content:\"\\f6f2\"}.fa-html5:before{content:\"\\f13b\"}.fa-hubspot:before{content:\"\\f3b2\"}.fa-i-cursor:before{content:\"\\f246\"}.fa-ice-cream:before{content:\"\\f810\"}.fa-icicles:before{content:\"\\f7ad\"}.fa-icons:before{content:\"\\f86d\"}.fa-id-badge:before{content:\"\\f2c1\"}.fa-id-card:before{content:\"\\f2c2\"}.fa-id-card-alt:before{content:\"\\f47f\"}.fa-ideal:before{content:\"\\e013\"}.fa-igloo:before{content:\"\\f7ae\"}.fa-image:before{content:\"\\f03e\"}.fa-images:before{content:\"\\f302\"}.fa-imdb:before{content:\"\\f2d8\"}.fa-inbox:before{content:\"\\f01c\"}.fa-indent:before{content:\"\\f03c\"}.fa-industry:before{content:\"\\f275\"}.fa-infinity:before{content:\"\\f534\"}.fa-info:before{content:\"\\f129\"}.fa-info-circle:before{content:\"\\f05a\"}.fa-innosoft:before{content:\"\\e080\"}.fa-instagram:before{content:\"\\f16d\"}.fa-instagram-square:before{content:\"\\e055\"}.fa-instalod:before{content:\"\\e081\"}.fa-intercom:before{content:\"\\f7af\"}.fa-internet-explorer:before{content:\"\\f26b\"}.fa-invision:before{content:\"\\f7b0\"}.fa-ioxhost:before{content:\"\\f208\"}.fa-italic:before{content:\"\\f033\"}.fa-itch-io:before{content:\"\\f83a\"}.fa-itunes:before{content:\"\\f3b4\"}.fa-itunes-note:before{content:\"\\f3b5\"}.fa-java:before{content:\"\\f4e4\"}.fa-jedi:before{content:\"\\f669\"}.fa-jedi-order:before{content:\"\\f50e\"}.fa-jenkins:before{content:\"\\f3b6\"}.fa-jira:before{content:\"\\f7b1\"}.fa-joget:before{content:\"\\f3b7\"}.fa-joint:before{content:\"\\f595\"}.fa-joomla:before{content:\"\\f1aa\"}.fa-journal-whills:before{content:\"\\f66a\"}.fa-js:before{content:\"\\f3b8\"}.fa-js-square:before{content:\"\\f3b9\"}.fa-jsfiddle:before{content:\"\\f1cc\"}.fa-kaaba:before{content:\"\\f66b\"}.fa-kaggle:before{content:\"\\f5fa\"}.fa-key:before{content:\"\\f084\"}.fa-keybase:before{content:\"\\f4f5\"}.fa-keyboard:before{content:\"\\f11c\"}.fa-keycdn:before{content:\"\\f3ba\"}.fa-khanda:before{content:\"\\f66d\"}.fa-kickstarter:before{content:\"\\f3bb\"}.fa-kickstarter-k:before{content:\"\\f3bc\"}.fa-kiss:before{content:\"\\f596\"}.fa-kiss-beam:before{content:\"\\f597\"}.fa-kiss-wink-heart:before{content:\"\\f598\"}.fa-kiwi-bird:before{content:\"\\f535\"}.fa-korvue:before{content:\"\\f42f\"}.fa-landmark:before{content:\"\\f66f\"}.fa-language:before{content:\"\\f1ab\"}.fa-laptop:before{content:\"\\f109\"}.fa-laptop-code:before{content:\"\\f5fc\"}.fa-laptop-house:before{content:\"\\e066\"}.fa-laptop-medical:before{content:\"\\f812\"}.fa-laravel:before{content:\"\\f3bd\"}.fa-lastfm:before{content:\"\\f202\"}.fa-lastfm-square:before{content:\"\\f203\"}.fa-laugh:before{content:\"\\f599\"}.fa-laugh-beam:before{content:\"\\f59a\"}.fa-laugh-squint:before{content:\"\\f59b\"}.fa-laugh-wink:before{content:\"\\f59c\"}.fa-layer-group:before{content:\"\\f5fd\"}.fa-leaf:before{content:\"\\f06c\"}.fa-leanpub:before{content:\"\\f212\"}.fa-lemon:before{content:\"\\f094\"}.fa-less:before{content:\"\\f41d\"}.fa-less-than:before{content:\"\\f536\"}.fa-less-than-equal:before{content:\"\\f537\"}.fa-level-down-alt:before{content:\"\\f3be\"}.fa-level-up-alt:before{content:\"\\f3bf\"}.fa-life-ring:before{content:\"\\f1cd\"}.fa-lightbulb:before{content:\"\\f0eb\"}.fa-line:before{content:\"\\f3c0\"}.fa-link:before{content:\"\\f0c1\"}.fa-linkedin:before{content:\"\\f08c\"}.fa-linkedin-in:before{content:\"\\f0e1\"}.fa-linode:before{content:\"\\f2b8\"}.fa-linux:before{content:\"\\f17c\"}.fa-lira-sign:before{content:\"\\f195\"}.fa-list:before{content:\"\\f03a\"}.fa-list-alt:before{content:\"\\f022\"}.fa-list-ol:before{content:\"\\f0cb\"}.fa-list-ul:before{content:\"\\f0ca\"}.fa-location-arrow:before{content:\"\\f124\"}.fa-lock:before{content:\"\\f023\"}.fa-lock-open:before{content:\"\\f3c1\"}.fa-long-arrow-alt-down:before{content:\"\\f309\"}.fa-long-arrow-alt-left:before{content:\"\\f30a\"}.fa-long-arrow-alt-right:before{content:\"\\f30b\"}.fa-long-arrow-alt-up:before{content:\"\\f30c\"}.fa-low-vision:before{content:\"\\f2a8\"}.fa-luggage-cart:before{content:\"\\f59d\"}.fa-lungs:before{content:\"\\f604\"}.fa-lungs-virus:before{content:\"\\e067\"}.fa-lyft:before{content:\"\\f3c3\"}.fa-magento:before{content:\"\\f3c4\"}.fa-magic:before{content:\"\\f0d0\"}.fa-magnet:before{content:\"\\f076\"}.fa-mail-bulk:before{content:\"\\f674\"}.fa-mailchimp:before{content:\"\\f59e\"}.fa-male:before{content:\"\\f183\"}.fa-mandalorian:before{content:\"\\f50f\"}.fa-map:before{content:\"\\f279\"}.fa-map-marked:before{content:\"\\f59f\"}.fa-map-marked-alt:before{content:\"\\f5a0\"}.fa-map-marker:before{content:\"\\f041\"}.fa-map-marker-alt:before{content:\"\\f3c5\"}.fa-map-pin:before{content:\"\\f276\"}.fa-map-signs:before{content:\"\\f277\"}.fa-markdown:before{content:\"\\f60f\"}.fa-marker:before{content:\"\\f5a1\"}.fa-mars:before{content:\"\\f222\"}.fa-mars-double:before{content:\"\\f227\"}.fa-mars-stroke:before{content:\"\\f229\"}.fa-mars-stroke-h:before{content:\"\\f22b\"}.fa-mars-stroke-v:before{content:\"\\f22a\"}.fa-mask:before{content:\"\\f6fa\"}.fa-mastodon:before{content:\"\\f4f6\"}.fa-maxcdn:before{content:\"\\f136\"}.fa-mdb:before{content:\"\\f8ca\"}.fa-medal:before{content:\"\\f5a2\"}.fa-medapps:before{content:\"\\f3c6\"}.fa-medium:before{content:\"\\f23a\"}.fa-medium-m:before{content:\"\\f3c7\"}.fa-medkit:before{content:\"\\f0fa\"}.fa-medrt:before{content:\"\\f3c8\"}.fa-meetup:before{content:\"\\f2e0\"}.fa-megaport:before{content:\"\\f5a3\"}.fa-meh:before{content:\"\\f11a\"}.fa-meh-blank:before{content:\"\\f5a4\"}.fa-meh-rolling-eyes:before{content:\"\\f5a5\"}.fa-memory:before{content:\"\\f538\"}.fa-mendeley:before{content:\"\\f7b3\"}.fa-menorah:before{content:\"\\f676\"}.fa-mercury:before{content:\"\\f223\"}.fa-meteor:before{content:\"\\f753\"}.fa-microblog:before{content:\"\\e01a\"}.fa-microchip:before{content:\"\\f2db\"}.fa-microphone:before{content:\"\\f130\"}.fa-microphone-alt:before{content:\"\\f3c9\"}.fa-microphone-alt-slash:before{content:\"\\f539\"}.fa-microphone-slash:before{content:\"\\f131\"}.fa-microscope:before{content:\"\\f610\"}.fa-microsoft:before{content:\"\\f3ca\"}.fa-minus:before{content:\"\\f068\"}.fa-minus-circle:before{content:\"\\f056\"}.fa-minus-square:before{content:\"\\f146\"}.fa-mitten:before{content:\"\\f7b5\"}.fa-mix:before{content:\"\\f3cb\"}.fa-mixcloud:before{content:\"\\f289\"}.fa-mixer:before{content:\"\\e056\"}.fa-mizuni:before{content:\"\\f3cc\"}.fa-mobile:before{content:\"\\f10b\"}.fa-mobile-alt:before{content:\"\\f3cd\"}.fa-modx:before{content:\"\\f285\"}.fa-monero:before{content:\"\\f3d0\"}.fa-money-bill:before{content:\"\\f0d6\"}.fa-money-bill-alt:before{content:\"\\f3d1\"}.fa-money-bill-wave:before{content:\"\\f53a\"}.fa-money-bill-wave-alt:before{content:\"\\f53b\"}.fa-money-check:before{content:\"\\f53c\"}.fa-money-check-alt:before{content:\"\\f53d\"}.fa-monument:before{content:\"\\f5a6\"}.fa-moon:before{content:\"\\f186\"}.fa-mortar-pestle:before{content:\"\\f5a7\"}.fa-mosque:before{content:\"\\f678\"}.fa-motorcycle:before{content:\"\\f21c\"}.fa-mountain:before{content:\"\\f6fc\"}.fa-mouse:before{content:\"\\f8cc\"}.fa-mouse-pointer:before{content:\"\\f245\"}.fa-mug-hot:before{content:\"\\f7b6\"}.fa-music:before{content:\"\\f001\"}.fa-napster:before{content:\"\\f3d2\"}.fa-neos:before{content:\"\\f612\"}.fa-network-wired:before{content:\"\\f6ff\"}.fa-neuter:before{content:\"\\f22c\"}.fa-newspaper:before{content:\"\\f1ea\"}.fa-nimblr:before{content:\"\\f5a8\"}.fa-node:before{content:\"\\f419\"}.fa-node-js:before{content:\"\\f3d3\"}.fa-not-equal:before{content:\"\\f53e\"}.fa-notes-medical:before{content:\"\\f481\"}.fa-npm:before{content:\"\\f3d4\"}.fa-ns8:before{content:\"\\f3d5\"}.fa-nutritionix:before{content:\"\\f3d6\"}.fa-object-group:before{content:\"\\f247\"}.fa-object-ungroup:before{content:\"\\f248\"}.fa-octopus-deploy:before{content:\"\\e082\"}.fa-odnoklassniki:before{content:\"\\f263\"}.fa-odnoklassniki-square:before{content:\"\\f264\"}.fa-oil-can:before{content:\"\\f613\"}.fa-old-republic:before{content:\"\\f510\"}.fa-om:before{content:\"\\f679\"}.fa-opencart:before{content:\"\\f23d\"}.fa-openid:before{content:\"\\f19b\"}.fa-opera:before{content:\"\\f26a\"}.fa-optin-monster:before{content:\"\\f23c\"}.fa-orcid:before{content:\"\\f8d2\"}.fa-osi:before{content:\"\\f41a\"}.fa-otter:before{content:\"\\f700\"}.fa-outdent:before{content:\"\\f03b\"}.fa-page4:before{content:\"\\f3d7\"}.fa-pagelines:before{content:\"\\f18c\"}.fa-pager:before{content:\"\\f815\"}.fa-paint-brush:before{content:\"\\f1fc\"}.fa-paint-roller:before{content:\"\\f5aa\"}.fa-palette:before{content:\"\\f53f\"}.fa-palfed:before{content:\"\\f3d8\"}.fa-pallet:before{content:\"\\f482\"}.fa-paper-plane:before{content:\"\\f1d8\"}.fa-paperclip:before{content:\"\\f0c6\"}.fa-parachute-box:before{content:\"\\f4cd\"}.fa-paragraph:before{content:\"\\f1dd\"}.fa-parking:before{content:\"\\f540\"}.fa-passport:before{content:\"\\f5ab\"}.fa-pastafarianism:before{content:\"\\f67b\"}.fa-paste:before{content:\"\\f0ea\"}.fa-patreon:before{content:\"\\f3d9\"}.fa-pause:before{content:\"\\f04c\"}.fa-pause-circle:before{content:\"\\f28b\"}.fa-paw:before{content:\"\\f1b0\"}.fa-paypal:before{content:\"\\f1ed\"}.fa-peace:before{content:\"\\f67c\"}.fa-pen:before{content:\"\\f304\"}.fa-pen-alt:before{content:\"\\f305\"}.fa-pen-fancy:before{content:\"\\f5ac\"}.fa-pen-nib:before{content:\"\\f5ad\"}.fa-pen-square:before{content:\"\\f14b\"}.fa-pencil-alt:before{content:\"\\f303\"}.fa-pencil-ruler:before{content:\"\\f5ae\"}.fa-penny-arcade:before{content:\"\\f704\"}.fa-people-arrows:before{content:\"\\e068\"}.fa-people-carry:before{content:\"\\f4ce\"}.fa-pepper-hot:before{content:\"\\f816\"}.fa-perbyte:before{content:\"\\e083\"}.fa-percent:before{content:\"\\f295\"}.fa-percentage:before{content:\"\\f541\"}.fa-periscope:before{content:\"\\f3da\"}.fa-person-booth:before{content:\"\\f756\"}.fa-phabricator:before{content:\"\\f3db\"}.fa-phoenix-framework:before{content:\"\\f3dc\"}.fa-phoenix-squadron:before{content:\"\\f511\"}.fa-phone:before{content:\"\\f095\"}.fa-phone-alt:before{content:\"\\f879\"}.fa-phone-slash:before{content:\"\\f3dd\"}.fa-phone-square:before{content:\"\\f098\"}.fa-phone-square-alt:before{content:\"\\f87b\"}.fa-phone-volume:before{content:\"\\f2a0\"}.fa-photo-video:before{content:\"\\f87c\"}.fa-php:before{content:\"\\f457\"}.fa-pied-piper:before{content:\"\\f2ae\"}.fa-pied-piper-alt:before{content:\"\\f1a8\"}.fa-pied-piper-hat:before{content:\"\\f4e5\"}.fa-pied-piper-pp:before{content:\"\\f1a7\"}.fa-pied-piper-square:before{content:\"\\e01e\"}.fa-piggy-bank:before{content:\"\\f4d3\"}.fa-pills:before{content:\"\\f484\"}.fa-pinterest:before{content:\"\\f0d2\"}.fa-pinterest-p:before{content:\"\\f231\"}.fa-pinterest-square:before{content:\"\\f0d3\"}.fa-pizza-slice:before{content:\"\\f818\"}.fa-place-of-worship:before{content:\"\\f67f\"}.fa-plane:before{content:\"\\f072\"}.fa-plane-arrival:before{content:\"\\f5af\"}.fa-plane-departure:before{content:\"\\f5b0\"}.fa-plane-slash:before{content:\"\\e069\"}.fa-play:before{content:\"\\f04b\"}.fa-play-circle:before{content:\"\\f144\"}.fa-playstation:before{content:\"\\f3df\"}.fa-plug:before{content:\"\\f1e6\"}.fa-plus:before{content:\"\\f067\"}.fa-plus-circle:before{content:\"\\f055\"}.fa-plus-square:before{content:\"\\f0fe\"}.fa-podcast:before{content:\"\\f2ce\"}.fa-poll:before{content:\"\\f681\"}.fa-poll-h:before{content:\"\\f682\"}.fa-poo:before{content:\"\\f2fe\"}.fa-poo-storm:before{content:\"\\f75a\"}.fa-poop:before{content:\"\\f619\"}.fa-portrait:before{content:\"\\f3e0\"}.fa-pound-sign:before{content:\"\\f154\"}.fa-power-off:before{content:\"\\f011\"}.fa-pray:before{content:\"\\f683\"}.fa-praying-hands:before{content:\"\\f684\"}.fa-prescription:before{content:\"\\f5b1\"}.fa-prescription-bottle:before{content:\"\\f485\"}.fa-prescription-bottle-alt:before{content:\"\\f486\"}.fa-print:before{content:\"\\f02f\"}.fa-procedures:before{content:\"\\f487\"}.fa-product-hunt:before{content:\"\\f288\"}.fa-project-diagram:before{content:\"\\f542\"}.fa-pump-medical:before{content:\"\\e06a\"}.fa-pump-soap:before{content:\"\\e06b\"}.fa-pushed:before{content:\"\\f3e1\"}.fa-puzzle-piece:before{content:\"\\f12e\"}.fa-python:before{content:\"\\f3e2\"}.fa-qq:before{content:\"\\f1d6\"}.fa-qrcode:before{content:\"\\f029\"}.fa-question:before{content:\"\\f128\"}.fa-question-circle:before{content:\"\\f059\"}.fa-quidditch:before{content:\"\\f458\"}.fa-quinscape:before{content:\"\\f459\"}.fa-quora:before{content:\"\\f2c4\"}.fa-quote-left:before{content:\"\\f10d\"}.fa-quote-right:before{content:\"\\f10e\"}.fa-quran:before{content:\"\\f687\"}.fa-r-project:before{content:\"\\f4f7\"}.fa-radiation:before{content:\"\\f7b9\"}.fa-radiation-alt:before{content:\"\\f7ba\"}.fa-rainbow:before{content:\"\\f75b\"}.fa-random:before{content:\"\\f074\"}.fa-raspberry-pi:before{content:\"\\f7bb\"}.fa-ravelry:before{content:\"\\f2d9\"}.fa-react:before{content:\"\\f41b\"}.fa-reacteurope:before{content:\"\\f75d\"}.fa-readme:before{content:\"\\f4d5\"}.fa-rebel:before{content:\"\\f1d0\"}.fa-receipt:before{content:\"\\f543\"}.fa-record-vinyl:before{content:\"\\f8d9\"}.fa-recycle:before{content:\"\\f1b8\"}.fa-red-river:before{content:\"\\f3e3\"}.fa-reddit:before{content:\"\\f1a1\"}.fa-reddit-alien:before{content:\"\\f281\"}.fa-reddit-square:before{content:\"\\f1a2\"}.fa-redhat:before{content:\"\\f7bc\"}.fa-redo:before{content:\"\\f01e\"}.fa-redo-alt:before{content:\"\\f2f9\"}.fa-registered:before{content:\"\\f25d\"}.fa-remove-format:before{content:\"\\f87d\"}.fa-renren:before{content:\"\\f18b\"}.fa-reply:before{content:\"\\f3e5\"}.fa-reply-all:before{content:\"\\f122\"}.fa-replyd:before{content:\"\\f3e6\"}.fa-republican:before{content:\"\\f75e\"}.fa-r