<?php
/**
 * Preload meta box.
 *
 * @package WP_Smush
 *
 * @var bool $lcp_preload_enabled LCP preload status.
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<p>
	<?php
	esc_html_e( "Preload helps to improve the Largest Contentful Paint (LCP) metric by optimizing images that often form the main viewport content. Since LCP measures the rendering time of the largest visible element, Smush helps to achieve Google's recommended 2.5-second benchmark for good user experience.", 'wp-smushit' );
	?>
</p>

<div class="sui-box-settings-row" id="preload-images-settings-row">
	<div class="sui-box-settings-col-1">
		<span class="sui-settings-label">
			<?php esc_html_e( 'Preload Critical Images', 'wp-smushit' ); ?>
		</span>
		<span class="sui-description">
			<?php esc_html_e( 'Get a faster initial load and optimize your LCP audit by automatically preloading your most critical image.', 'wp-smushit' ); ?>
		</span>
	</div>

	<div class="sui-box-settings-col-2">
		<div class="sui-form-field">
			<label for="preload-images" class="sui-toggle">
				<input
					type="checkbox"
					id="preload-images"
					name="preload_images"
					aria-labelledby="preload-images-label"
					aria-describedby="preload-images-description"
					<?php echo WP_Smush::is_pro() ? '' : 'disabled'; ?>
					<?php checked( $lcp_preload_enabled ); ?>
				/>
				<span class="sui-toggle-slider" aria-hidden="true"></span>
				<span id="noscript-label" class="sui-toggle-label">
					<?php esc_html_e( 'Enable Preloading Critical Images', 'wp-smushit' ); ?>
				</span>
			</label>
			<?php
			if ( ! WP_Smush::is_pro() ) :
				$discount    = WP_Smush::get_instance()->admin()->get_plugin_discount();
				$upgrade_url = $this->get_utm_link(
					array(
						'utm_campaign' => 'smush_lazyload-preload_preload-critical-images',
					)
				);
			?>
			<span id="preload-images-description" class="sui-description">
				<a style="margin-left:44px;" class="smush-upsell-link" href="<?php echo esc_url( $upgrade_url ); ?>" target="_blank">
				<strong>
					<?php
						/* translators: %s: Discount */
						printf( esc_html__( 'Get %s OFF when you upgrade to Pro️', 'wp-smushit' ), $discount );
					?>
				</strong>
				<span class="sui-icon-open-new-window" aria-hidden="true"></span>
			</a>
			</span>
			<?php endif; ?>
		</div>
	</div>
</div>